/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.opengles.GLES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class QCOMDriverControl {
    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    public static native void nglGetDriverControlsQCOM(long var0, int var2, long var3);

    public static void glGetDriverControlsQCOM(@Nullable @NativeType(value="GLint *") IntBuffer num, @Nullable @NativeType(value="GLuint *") IntBuffer driverControls) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num, 1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(num), Checks.remainingSafe(driverControls), MemoryUtil.memAddressSafe(driverControls));
    }

    public static native void nglGetDriverControlStringQCOM(int var0, int var1, long var2, long var4);

    public static void glGetDriverControlStringQCOM(@NativeType(value="GLuint") int driverControl, @Nullable @NativeType(value="GLsizei *") IntBuffer length, @Nullable @NativeType(value="GLchar *") ByteBuffer driverControlString) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, Checks.remainingSafe(driverControlString), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(driverControlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetDriverControlStringQCOM(@NativeType(value="GLuint") int driverControl, @NativeType(value="GLsizei") int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer driverControlString = stack.malloc(bufSize);
            QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(driverControlString));
            String string = MemoryUtil.memASCII(driverControlString, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glEnableDriverControlQCOM(@NativeType(value="GLuint") int var0);

    public static native void glDisableDriverControlQCOM(@NativeType(value="GLuint") int var0);

    public static void glGetDriverControlsQCOM(@Nullable @NativeType(value="GLint *") int[] num, @Nullable @NativeType(value="GLuint *") int[] driverControls) {
        long __functionAddress = GLES.getICD().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(num, 1);
        }
        JNI.callPPV(num, Checks.lengthSafe(driverControls), driverControls, __functionAddress);
    }

    public static void glGetDriverControlStringQCOM(@NativeType(value="GLuint") int driverControl, @Nullable @NativeType(value="GLsizei *") int[] length, @Nullable @NativeType(value="GLchar *") ByteBuffer driverControlString) {
        long __functionAddress = GLES.getICD().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(driverControl, Checks.remainingSafe(driverControlString), length, MemoryUtil.memAddressSafe(driverControlString), __functionAddress);
    }

    static {
        GLES.initialize();
    }
}

