/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisTable;
import com.torii.srs.Dialogs;
import com.torii.srs.Main;

public abstract class TopMenu {
    private VisTable table = new VisTable();
    private VisImageButton btnHome;
    private VisImageButton indicatorLeft;
    private VisImageButton indicatorRight;
    private VisImageButton.VisImageButtonStyle bsDownload;
    private VisImageButton.VisImageButtonStyle bsSound;
    private Actor dummyLeft;
    private Actor dummyRight;

    public TopMenu(boolean exitButton) {
        this(exitButton, " Dashboard ");
    }

    public TopMenu(boolean exitButton, String homeButtonTooltip) {
        this.table.align(2);
        Image imgHome = new Image((Texture)Main.getAsset(Main.HOME_BTN_PATH, Texture.class, true));
        Drawable home = imgHome.getDrawable();
        this.btnHome = new VisImageButton(home, homeButtonTooltip);
        this.btnHome.getStyle().up = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.btnHome.getStyle().over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        this.btnHome.getStyle().down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        Image imgDownload = new Image((Texture)Main.getAsset(Main.DOWNLOADING_PATH, Texture.class, true));
        Drawable dDownload = imgDownload.getDrawable();
        this.bsDownload = new VisImageButton.VisImageButtonStyle(new VisImageButton(dDownload).getStyle());
        this.bsDownload.disabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.bsDownload.imageDisabled = Main.uiSkin.newDrawable(dDownload, Main.OBJECT_PRESSED);
        Image imgSound = new Image((Texture)Main.getAsset(Main.PLAY_BTN_PATH, Texture.class, true));
        Drawable dSound = imgSound.getDrawable();
        this.bsSound = new VisImageButton.VisImageButtonStyle(new VisImageButton(dSound).getStyle());
        this.bsSound.disabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.bsSound.imageDisabled = Main.uiSkin.newDrawable(dSound, Main.OBJECT_PRESSED);
        this.indicatorLeft = new VisImageButton(dSound);
        this.indicatorRight = new VisImageButton(dDownload);
        this.indicatorLeft.setStyle(this.bsSound);
        this.indicatorRight.setStyle(this.bsDownload);
        this.indicatorLeft.setDisabled(true);
        this.indicatorRight.setDisabled(true);
        this.indicatorLeft.setVisible(false);
        this.indicatorRight.setVisible(false);
        Image imgSignOut = new Image((Texture)Main.getAsset(Main.SIGNOUT_BTN_PATH, Texture.class, true));
        Drawable signOut = imgSignOut.getDrawable();
        VisImageButton btnExit = new VisImageButton(signOut, " Exit ");
        btnExit.getStyle().up = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        btnExit.getStyle().over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        btnExit.getStyle().down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        this.btnHome.setFocusBorderEnabled(false);
        btnExit.setFocusBorderEnabled(false);
        VisTable tblMiddle = new VisTable(false);
        tblMiddle.add(this.indicatorLeft).size(1.5f * (float)Main.getPPUY()).expandX().fillX().align(8);
        tblMiddle.add(this.btnHome).size(2 * Main.getPPUY()).expandX().fillX().align(1);
        tblMiddle.add(this.indicatorRight).size(1.5f * (float)Main.getPPUY()).expandX().fillX().align(16);
        this.dummyLeft = new Actor();
        this.dummyRight = new Actor();
        this.table.align(2);
        this.table.add(this.dummyLeft).expandX().uniform().padLeft(Main.getPPUY());
        this.table.add(tblMiddle).height(2 * Main.getPPUY()).expandX().fillX().align(1);
        this.table.add(this.dummyRight).expandX().uniform().padRight(Main.getPPUY()).row();
        if (exitButton) {
            this.table.getCell(this.dummyLeft).setActor(btnExit).size(2 * Main.getPPUY()).expandX().uniform().align(8);
        }
        this.btnHome.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                TopMenu.this.homeButton();
            }
        });
        btnExit.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                TopMenu.this.clickExitButton();
            }
        });
        this.invalidateColorScheme();
    }

    public void invalidateColorScheme() {
        this.table.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
    }

    public VisTable getTable() {
        return this.table;
    }

    public VisImageButton getHomeButton() {
        return this.btnHome;
    }

    public void swapLeft(Actor a, int align) {
        this.swapLeft(a, align, 2 * Main.getPPUY());
    }

    public void swapLeft(Actor a, int align, float height) {
        this.table.getCell(this.dummyLeft).setActor(a).height(height).align(align);
    }

    public void swapRight(Actor a, int align) {
        this.swapRight(a, align, 2 * Main.getPPUY());
    }

    public void swapRight(Actor a, int align, float height) {
        this.table.getCell(this.dummyRight).setActor(a).height(height).align(align);
    }

    public void setIndicatorLeft(StatusIndicator indicator) {
        if (indicator == StatusIndicator.NONE) {
            this.indicatorLeft.setVisible(false);
        } else {
            switch (indicator.ordinal()) {
                case 1: {
                    this.indicatorLeft.setStyle(this.bsDownload);
                    break;
                }
                case 2: {
                    this.indicatorLeft.setStyle(this.bsSound);
                }
            }
            this.indicatorLeft.setVisible(true);
        }
    }

    public void setIndicatorRight(StatusIndicator indicator) {
        if (indicator == StatusIndicator.NONE) {
            this.indicatorRight.setVisible(false);
        } else {
            switch (indicator.ordinal()) {
                case 1: {
                    this.indicatorRight.setStyle(this.bsDownload);
                    break;
                }
                case 2: {
                    this.indicatorRight.setStyle(this.bsSound);
                }
            }
            this.indicatorRight.setVisible(true);
        }
    }

    public void clickExitButton() {
        Dialogs.showConfirmDialog(Main.getCurrentStage(), "Exit Torii", "Are you sure you want to quit Torii?", new Dialogs.ConfirmAdapter(){

            @Override
            public void yes() {
                Gdx.app.exit();
            }
        });
    }

    public abstract void homeButton();

    public static enum StatusIndicator {
        NONE,
        DOWNLOAD,
        SOUND;

    }
}

