/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs.widget;

import com.torii.srs.widget.TextField;

public class KanaConverter {
    public static boolean isHiragana(char c) {
        return '\u3041' <= c && c <= '\u309e';
    }

    public static boolean isKatakana(char c) {
        return KanaConverter.isHalfWidthKatakana(c) || KanaConverter.isFullWidthKatakana(c);
    }

    public static boolean isKanaWord(String word) {
        return KanaConverter.isHiraganaWord(word) || KanaConverter.isKatakanaWord(word);
    }

    private static boolean isHalfWidthKatakana(char c) {
        return '\uff66' <= c && c <= '\uff9d';
    }

    private static boolean isFullWidthKatakana(char c) {
        return '\u30a1' <= c && c <= '\u30fe';
    }

    private static boolean isHiraganaWord(String word) {
        for (int i = 0; i < word.length(); ++i) {
            if (KanaConverter.isHiragana(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isKatakanaWord(String word) {
        for (int i = 0; i < word.length(); ++i) {
            if (KanaConverter.isKatakana(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static char toHiragana(char c) {
        if (KanaConverter.isFullWidthKatakana(c)) {
            return (char)(c - 96);
        }
        if (KanaConverter.isHalfWidthKatakana(c)) {
            return (char)(c - 53029);
        }
        return c;
    }

    public static void replaceWithKana(TextField textField) {
        String content = textField.getText();
        int cursorPos = textField.getCursorPosition();
        int curLength = content.length();
        content = KanaConverter.replaceWithKana(content);
        int newLength = content.length();
        textField.setText(content);
        textField.setCursorPosition(cursorPos + (newLength - curLength));
    }

    public static String replaceWithKana(String source) {
        String result = source;
        if (result.length() > 1) {
            char[] temp;
            char beforeLast;
            char lastChar = result.charAt(result.length() - 1);
            if (lastChar == (beforeLast = result.charAt(result.length() - 2)) && Character.isLetter(lastChar) && lastChar != 'n' && lastChar != 'N') {
                temp = result.toCharArray();
                if (Character.isLowerCase(lastChar) && Character.isLowerCase(beforeLast)) {
                    temp[temp.length - 2] = 12387;
                } else if (Character.isUpperCase(lastChar) && Character.isUpperCase(beforeLast)) {
                    temp[temp.length - 2] = 12483;
                }
                result = String.valueOf(temp);
            }
            if (beforeLast == 'n' && "aiueoyn\u2019'".indexOf(lastChar) == -1) {
                temp = result.toCharArray();
                temp[temp.length - 2] = 12435;
                result = String.valueOf(temp);
            } else if (beforeLast == 'N' && "AIUEOYN\u2019'".indexOf(lastChar) == -1) {
                temp = result.toCharArray();
                temp[temp.length - 2] = 12531;
                result = String.valueOf(temp);
            }
        }
        result = result.replace("-", "\u30fc");
        result = result.replace(".", "\u3002");
        result = result.replace(",", "\u3001");
        result = result.replace("!", "\uff01");
        result = result.replace("ltsu", "\u3063");
        result = result.replace("xtsu", "\u3063");
        result = result.replace("whu", "\u3046");
        result = result.replace("xyi", "\u3043");
        result = result.replace("xye", "\u3047");
        result = result.replace("wha", "\u3046\u3041");
        result = result.replace("whi", "\u3046\u3043");
        result = result.replace("whe", "\u3046\u3047");
        result = result.replace("who", "\u3046\u3049");
        result = result.replace("vya", "\u3094\u3083");
        result = result.replace("vyi", "\u3094\u3043");
        result = result.replace("vyu", "\u3094\u3085");
        result = result.replace("vye", "\u3094\u3047");
        result = result.replace("vyo", "\u3094\u3087");
        result = result.replace("lka", "\u3095");
        result = result.replace("lke", "\u3096");
        result = result.replace("xka", "\u3095");
        result = result.replace("xke", "\u3096");
        result = result.replace("kya", "\u304d\u3083");
        result = result.replace("kyi", "\u304d\u3043");
        result = result.replace("kyu", "\u304d\u3085");
        result = result.replace("kye", "\u304d\u3047");
        result = result.replace("kyo", "\u304d\u3087");
        result = result.replace("qya", "\u304f\u3083");
        result = result.replace("qyu", "\u304f\u3085");
        result = result.replace("qyo", "\u304f\u3087");
        result = result.replace("qwa", "\u304f\u3041");
        result = result.replace("qwi", "\u304f\u3043");
        result = result.replace("qwu", "\u304f\u3045");
        result = result.replace("qwe", "\u304f\u3047");
        result = result.replace("qwo", "\u304f\u3049");
        result = result.replace("qyi", "\u304f\u3043");
        result = result.replace("qye", "\u304f\u3047");
        result = result.replace("kwa", "\u304f\u3041");
        result = result.replace("gya", "\u304e\u3083");
        result = result.replace("gyi", "\u304e\u3043");
        result = result.replace("gyu", "\u304e\u3085");
        result = result.replace("gye", "\u304e\u3047");
        result = result.replace("gyo", "\u304e\u3087");
        result = result.replace("gwa", "\u3050\u3041");
        result = result.replace("gwi", "\u3050\u3043");
        result = result.replace("gwu", "\u3050\u3045");
        result = result.replace("gwe", "\u3050\u3047");
        result = result.replace("gwo", "\u3050\u3049");
        result = result.replace("sya", "\u3057\u3083");
        result = result.replace("syi", "\u3057\u3043");
        result = result.replace("syu", "\u3057\u3085");
        result = result.replace("sye", "\u3057\u3047");
        result = result.replace("syo", "\u3057\u3087");
        result = result.replace("sha", "\u3057\u3083");
        result = result.replace("shu", "\u3057\u3085");
        result = result.replace("she", "\u3057\u3047");
        result = result.replace("sho", "\u3057\u3087");
        result = result.replace("swa", "\u3059\u3041");
        result = result.replace("swi", "\u3059\u3043");
        result = result.replace("swu", "\u3059\u3045");
        result = result.replace("swe", "\u3059\u3047");
        result = result.replace("swo", "\u3059\u3049");
        result = result.replace("zya", "\u3058\u3083");
        result = result.replace("zyi", "\u3058\u3043");
        result = result.replace("zyu", "\u3058\u3085");
        result = result.replace("zye", "\u3058\u3047");
        result = result.replace("zyo", "\u3058\u3087");
        result = result.replace("jya", "\u3058\u3083");
        result = result.replace("jyi", "\u3058\u3043");
        result = result.replace("jyu", "\u3058\u3085");
        result = result.replace("jye", "\u3058\u3047");
        result = result.replace("jyo", "\u3058\u3087");
        result = result.replace("chi", "\u3061");
        result = result.replace("tsu", "\u3064");
        result = result.replace("ltu", "\u3063");
        result = result.replace("xtu", "\u3063");
        result = result.replace("tya", "\u3061\u3083");
        result = result.replace("tyi", "\u3061\u3043");
        result = result.replace("tyu", "\u3061\u3085");
        result = result.replace("tye", "\u3061\u3047");
        result = result.replace("tyo", "\u3061\u3087");
        result = result.replace("cha", "\u3061\u3083");
        result = result.replace("chu", "\u3061\u3085");
        result = result.replace("che", "\u3061\u3047");
        result = result.replace("cho", "\u3061\u3087");
        result = result.replace("cya", "\u3061\u3083");
        result = result.replace("cyi", "\u3061\u3043");
        result = result.replace("cyu", "\u3061\u3085");
        result = result.replace("cye", "\u3061\u3047");
        result = result.replace("cyo", "\u3061\u3087");
        result = result.replace("tsa", "\u3064\u3041");
        result = result.replace("tsi", "\u3064\u3043");
        result = result.replace("tse", "\u3064\u3047");
        result = result.replace("tso", "\u3064\u3049");
        result = result.replace("tha", "\u3066\u3083");
        result = result.replace("thi", "\u3066\u3043");
        result = result.replace("thu", "\u3066\u3085");
        result = result.replace("the", "\u3066\u3047");
        result = result.replace("tho", "\u3066\u3087");
        result = result.replace("twa", "\u3068\u3041");
        result = result.replace("twi", "\u3068\u3043");
        result = result.replace("twu", "\u3068\u3045");
        result = result.replace("twe", "\u3068\u3047");
        result = result.replace("two", "\u3068\u3049");
        result = result.replace("shi", "\u3057");
        result = result.replace("dya", "\u3062\u3083");
        result = result.replace("dyi", "\u3062\u3043");
        result = result.replace("dyu", "\u3062\u3085");
        result = result.replace("dye", "\u3062\u3047");
        result = result.replace("dyo", "\u3062\u3087");
        result = result.replace("dha", "\u3067\u3083");
        result = result.replace("dhi", "\u3067\u3043");
        result = result.replace("dhu", "\u3067\u3085");
        result = result.replace("dhe", "\u3067\u3047");
        result = result.replace("dho", "\u3067\u3087");
        result = result.replace("dwa", "\u3069\u3041");
        result = result.replace("dwi", "\u3069\u3043");
        result = result.replace("dwu", "\u3069\u3045");
        result = result.replace("dwe", "\u3069\u3047");
        result = result.replace("dwo", "\u3069\u3049");
        result = result.replace("nya", "\u306b\u3083");
        result = result.replace("nyi", "\u306b\u3043");
        result = result.replace("nyu", "\u306b\u3085");
        result = result.replace("nye", "\u306b\u3047");
        result = result.replace("nyo", "\u306b\u3087");
        result = result.replace("hya", "\u3072\u3083");
        result = result.replace("hyi", "\u3072\u3043");
        result = result.replace("hyu", "\u3072\u3085");
        result = result.replace("hye", "\u3072\u3047");
        result = result.replace("hyo", "\u3072\u3087");
        result = result.replace("fya", "\u3075\u3083");
        result = result.replace("fyu", "\u3075\u3085");
        result = result.replace("fyo", "\u3075\u3087");
        result = result.replace("fwa", "\u3075\u3041");
        result = result.replace("fwi", "\u3075\u3043");
        result = result.replace("fwu", "\u3075\u3045");
        result = result.replace("fwe", "\u3075\u3047");
        result = result.replace("fwo", "\u3075\u3049");
        result = result.replace("fyi", "\u3075\u3043");
        result = result.replace("fye", "\u3075\u3047");
        result = result.replace("bya", "\u3073\u3083");
        result = result.replace("byi", "\u3073\u3043");
        result = result.replace("byu", "\u3073\u3085");
        result = result.replace("bye", "\u3073\u3047");
        result = result.replace("byo", "\u3073\u3087");
        result = result.replace("pya", "\u3074\u3083");
        result = result.replace("pyi", "\u3074\u3043");
        result = result.replace("pyu", "\u3074\u3085");
        result = result.replace("pye", "\u3074\u3047");
        result = result.replace("pyo", "\u3074\u3087");
        result = result.replace("mya", "\u307f\u3083");
        result = result.replace("myi", "\u307f\u3043");
        result = result.replace("myu", "\u307f\u3085");
        result = result.replace("mye", "\u307f\u3047");
        result = result.replace("myo", "\u307f\u3087");
        result = result.replace("xya", "\u3083");
        result = result.replace("xyu", "\u3085");
        result = result.replace("xyo", "\u3087");
        result = result.replace("rya", "\u308a\u3083");
        result = result.replace("ryi", "\u308a\u3043");
        result = result.replace("ryu", "\u308a\u3085");
        result = result.replace("rye", "\u308a\u3047");
        result = result.replace("ryo", "\u308a\u3087");
        result = result.replace("lya", "\u308a\u3083");
        result = result.replace("lyi", "\u308a\u3043");
        result = result.replace("lyu", "\u308a\u3085");
        result = result.replace("lye", "\u308a\u3047");
        result = result.replace("lyo", "\u308a\u3087");
        result = result.replace("lwe", "\u308e");
        result = result.replace("xwa", "\u308e");
        result = result.replace("yi", "\u3044");
        result = result.replace("wu", "\u3046");
        result = result.replace("xa", "\u3041");
        result = result.replace("xi", "\u3043");
        result = result.replace("xu", "\u3045");
        result = result.replace("xe", "\u3047");
        result = result.replace("xo", "\u3049");
        result = result.replace("ye", "\u3044\u3047");
        result = result.replace("wi", "\u3046\u3043");
        result = result.replace("we", "\u3046\u3047");
        result = result.replace("va", "\u3094\u3041");
        result = result.replace("vi", "\u3094\u3043");
        result = result.replace("vu", "\u3094");
        result = result.replace("ve", "\u3094\u3047");
        result = result.replace("vo", "\u3094\u3049");
        result = result.replace("ka", "\u304b");
        result = result.replace("ki", "\u304d");
        result = result.replace("ku", "\u304f");
        result = result.replace("ke", "\u3051");
        result = result.replace("ko", "\u3053");
        result = result.replace("qa", "\u304f\u3041");
        result = result.replace("qi", "\u304f\u3043");
        result = result.replace("qe", "\u304f\u3047");
        result = result.replace("qo", "\u304f\u3049");
        result = result.replace("ga", "\u304c");
        result = result.replace("gi", "\u304e");
        result = result.replace("gu", "\u3050");
        result = result.replace("ge", "\u3052");
        result = result.replace("go", "\u3054");
        result = result.replace("sa", "\u3055");
        result = result.replace("si", "\u3057");
        result = result.replace("su", "\u3059");
        result = result.replace("se", "\u305b");
        result = result.replace("so", "\u305d");
        result = result.replace("za", "\u3056");
        result = result.replace("zi", "\u3058");
        result = result.replace("zu", "\u305a");
        result = result.replace("ze", "\u305c");
        result = result.replace("zo", "\u305e");
        result = result.replace("ji", "\u3058");
        result = result.replace("ja", "\u3058\u3083");
        result = result.replace("ju", "\u3058\u3085");
        result = result.replace("je", "\u3058\u3047");
        result = result.replace("jo", "\u3058\u3087");
        result = result.replace("ta", "\u305f");
        result = result.replace("ti", "\u3061");
        result = result.replace("tu", "\u3064");
        result = result.replace("te", "\u3066");
        result = result.replace("to", "\u3068");
        result = result.replace("da", "\u3060");
        result = result.replace("di", "\u3062");
        result = result.replace("du", "\u3065");
        result = result.replace("de", "\u3067");
        result = result.replace("do", "\u3069");
        result = result.replace("na", "\u306a");
        result = result.replace("ni", "\u306b");
        result = result.replace("nu", "\u306c");
        result = result.replace("ne", "\u306d");
        result = result.replace("no", "\u306e");
        result = result.replace("ha", "\u306f");
        result = result.replace("hi", "\u3072");
        result = result.replace("hu", "\u3075");
        result = result.replace("he", "\u3078");
        result = result.replace("ho", "\u307b");
        result = result.replace("fu", "\u3075");
        result = result.replace("fa", "\u3075\u3041");
        result = result.replace("fi", "\u3075\u3043");
        result = result.replace("fe", "\u3075\u3047");
        result = result.replace("fo", "\u3075\u3049");
        result = result.replace("ba", "\u3070");
        result = result.replace("bi", "\u3073");
        result = result.replace("bu", "\u3076");
        result = result.replace("be", "\u3079");
        result = result.replace("bo", "\u307c");
        result = result.replace("pa", "\u3071");
        result = result.replace("pi", "\u3074");
        result = result.replace("pu", "\u3077");
        result = result.replace("pe", "\u307a");
        result = result.replace("po", "\u307d");
        result = result.replace("ma", "\u307e");
        result = result.replace("mi", "\u307f");
        result = result.replace("mu", "\u3080");
        result = result.replace("me", "\u3081");
        result = result.replace("mo", "\u3082");
        result = result.replace("ya", "\u3084");
        result = result.replace("yu", "\u3086");
        result = result.replace("yo", "\u3088");
        result = result.replace("ra", "\u3089");
        result = result.replace("ri", "\u308a");
        result = result.replace("ru", "\u308b");
        result = result.replace("re", "\u308c");
        result = result.replace("ro", "\u308d");
        result = result.replace("la", "\u3089");
        result = result.replace("li", "\u308a");
        result = result.replace("lu", "\u308b");
        result = result.replace("le", "\u308c");
        result = result.replace("lo", "\u308d");
        result = result.replace("wa", "\u308f");
        result = result.replace("wo", "\u3092");
        result = result.replace("nn", "\u3093");
        result = result.replace("xn", "\u3093");
        result = result.replace("n'", "\u3093");
        result = result.replace("n\u2019", "\u3093");
        result = result.replace("a", "\u3042");
        result = result.replace("i", "\u3044");
        result = result.replace("u", "\u3046");
        result = result.replace("e", "\u3048");
        result = result.replace("o", "\u304a");
        result = result.replace("LTSU", "\u30c3");
        result = result.replace("XTSU", "\u30c3");
        result = result.replace("WHU", "\u30a6");
        result = result.replace("XYI", "\u30a3");
        result = result.replace("XYE", "\u30a7");
        result = result.replace("WHA", "\u30a6\u30a1");
        result = result.replace("WHI", "\u30a6\u30a3");
        result = result.replace("WHE", "\u30a6\u30a7");
        result = result.replace("WHO", "\u30a6\u30a9");
        result = result.replace("VYA", "\u30f4\u30e3");
        result = result.replace("VYI", "\u30f4\u30a3");
        result = result.replace("VYU", "\u30f4\u30e5");
        result = result.replace("VYE", "\u30f4\u30a7");
        result = result.replace("VYO", "\u30f4\u30e7");
        result = result.replace("LKA", "\u30f5");
        result = result.replace("LKE", "\u30f6");
        result = result.replace("XKA", "\u30f5");
        result = result.replace("XKE", "\u30f6");
        result = result.replace("KYA", "\u30ad\u30e3");
        result = result.replace("KYI", "\u30ad\u30a3");
        result = result.replace("KYU", "\u30ad\u30e5");
        result = result.replace("KYE", "\u30ad\u30a7");
        result = result.replace("KYO", "\u30ad\u30e7");
        result = result.replace("QYA", "\u30af\u30e3");
        result = result.replace("QYU", "\u30af\u30e5");
        result = result.replace("QYO", "\u30af\u30e7");
        result = result.replace("QWA", "\u30af\u30a1");
        result = result.replace("QWI", "\u30af\u30a3");
        result = result.replace("QWU", "\u30af\u30a5");
        result = result.replace("QWE", "\u30af\u30a7");
        result = result.replace("QWO", "\u30af\u30a9");
        result = result.replace("QYI", "\u30af\u30a3");
        result = result.replace("QYE", "\u30af\u30a7");
        result = result.replace("KWA", "\u30af\u30a1");
        result = result.replace("GYA", "\u30ae\u30e3");
        result = result.replace("GYI", "\u30ae\u30a3");
        result = result.replace("GYU", "\u30ae\u30e5");
        result = result.replace("GYE", "\u30ae\u30a7");
        result = result.replace("GYO", "\u30ae\u30e7");
        result = result.replace("GWA", "\u30b0\u30a1");
        result = result.replace("GWI", "\u30b0\u30a3");
        result = result.replace("GWU", "\u30b0\u30a5");
        result = result.replace("GWE", "\u30b0\u30a7");
        result = result.replace("GWO", "\u30b0\u30a9");
        result = result.replace("SYA", "\u30b7\u30e3");
        result = result.replace("SYI", "\u30b7\u30a3");
        result = result.replace("SYU", "\u30b7\u30e5");
        result = result.replace("SYE", "\u30b7\u30a7");
        result = result.replace("SYO", "\u30b7\u30e7");
        result = result.replace("SHA", "\u30b7\u30e3");
        result = result.replace("SHU", "\u30b7\u30e5");
        result = result.replace("SHE", "\u30b7\u30a7");
        result = result.replace("SHO", "\u30b7\u30e7");
        result = result.replace("SWA", "\u30b9\u30a1");
        result = result.replace("SWI", "\u30b9\u30a3");
        result = result.replace("SWU", "\u30b9\u30a5");
        result = result.replace("SWE", "\u30b9\u30a7");
        result = result.replace("SWO", "\u30b9\u30a9");
        result = result.replace("ZYA", "\u30b8\u30e3");
        result = result.replace("ZYI", "\u30b8\u30a3");
        result = result.replace("ZYU", "\u30b8\u30e5");
        result = result.replace("ZYE", "\u30b8\u30a7");
        result = result.replace("ZYO", "\u30b8\u30e7");
        result = result.replace("JYA", "\u30b8\u30e3");
        result = result.replace("JYI", "\u30b8\u30a3");
        result = result.replace("JYU", "\u30b8\u30e5");
        result = result.replace("JYE", "\u30b8\u30a7");
        result = result.replace("JYO", "\u30b8\u30e7");
        result = result.replace("CHI", "\u30c1");
        result = result.replace("TSU", "\u30c4");
        result = result.replace("LTU", "\u30c3");
        result = result.replace("XTU", "\u30c3");
        result = result.replace("TYA", "\u30c1\u30e3");
        result = result.replace("TYI", "\u30c1\u30a3");
        result = result.replace("TYU", "\u30c1\u30e5");
        result = result.replace("TYE", "\u30c1\u30a7");
        result = result.replace("TYO", "\u30c1\u30e7");
        result = result.replace("CHA", "\u30c1\u30e3");
        result = result.replace("CHU", "\u30c1\u30e5");
        result = result.replace("CHE", "\u30c1\u30a7");
        result = result.replace("CHO", "\u30c1\u30e7");
        result = result.replace("CYA", "\u30c1\u30e3");
        result = result.replace("CYI", "\u30c1\u30a3");
        result = result.replace("CYU", "\u30c1\u30e5");
        result = result.replace("CYE", "\u30c1\u30a7");
        result = result.replace("CYO", "\u30c1\u30e7");
        result = result.replace("TSA", "\u30c4\u30a1");
        result = result.replace("TSI", "\u30c4\u30a3");
        result = result.replace("TSE", "\u30c4\u30a7");
        result = result.replace("TSO", "\u30c4\u30a9");
        result = result.replace("THA", "\u30c6\u30e3");
        result = result.replace("THI", "\u30c6\u30a3");
        result = result.replace("THU", "\u30c6\u30e5");
        result = result.replace("THE", "\u30c6\u30a7");
        result = result.replace("THO", "\u30c6\u30e7");
        result = result.replace("TWA", "\u30c8\u30a1");
        result = result.replace("TWI", "\u30c8\u30a3");
        result = result.replace("TWU", "\u30c8\u30a5");
        result = result.replace("TWE", "\u30c8\u30a7");
        result = result.replace("TWO", "\u30c8\u30a9");
        result = result.replace("SHI", "\u30b7");
        result = result.replace("DYA", "\u30c2\u30e3");
        result = result.replace("DYI", "\u30c2\u30a3");
        result = result.replace("DYU", "\u30c2\u30e5");
        result = result.replace("DYE", "\u30c2\u30a7");
        result = result.replace("DYO", "\u30c2\u30e7");
        result = result.replace("DHA", "\u30c7\u30e3");
        result = result.replace("DHI", "\u30c7\u30a3");
        result = result.replace("DHU", "\u30c7\u30e5");
        result = result.replace("DHE", "\u30c7\u30a7");
        result = result.replace("DHO", "\u30c7\u30e7");
        result = result.replace("DWA", "\u30c9\u30a1");
        result = result.replace("DWI", "\u30c9\u30a3");
        result = result.replace("DWU", "\u30c9\u30a5");
        result = result.replace("DWE", "\u30c9\u30a7");
        result = result.replace("DWO", "\u30c9\u30a9");
        result = result.replace("NYA", "\u30cb\u30e3");
        result = result.replace("NYI", "\u30cb\u30a3");
        result = result.replace("NYU", "\u30cb\u30e5");
        result = result.replace("NYE", "\u30cb\u30a7");
        result = result.replace("NYO", "\u30cb\u30e7");
        result = result.replace("HYA", "\u30d2\u30e3");
        result = result.replace("HYI", "\u30d2\u30a3");
        result = result.replace("HYU", "\u30d2\u30e5");
        result = result.replace("HYE", "\u30d2\u30a7");
        result = result.replace("HYO", "\u30d2\u30e7");
        result = result.replace("FYA", "\u30d5\u30e3");
        result = result.replace("FYU", "\u30d5\u30e5");
        result = result.replace("FYO", "\u30d5\u30e7");
        result = result.replace("FWA", "\u30d5\u30a1");
        result = result.replace("FWI", "\u30d5\u30a3");
        result = result.replace("FWU", "\u30d5\u30a5");
        result = result.replace("FWE", "\u30d5\u30a7");
        result = result.replace("FWO", "\u30d5\u30a9");
        result = result.replace("FYI", "\u30d5\u30a3");
        result = result.replace("FYE", "\u30d5\u30a7");
        result = result.replace("BYA", "\u30d3\u30e3");
        result = result.replace("BYI", "\u30d3\u30a3");
        result = result.replace("BYU", "\u30d3\u30e5");
        result = result.replace("BYE", "\u30d3\u30a7");
        result = result.replace("BYO", "\u30d3\u30e7");
        result = result.replace("PYA", "\u30d4\u30e3");
        result = result.replace("PYI", "\u30d4\u30a3");
        result = result.replace("PYU", "\u30d4\u30e5");
        result = result.replace("PYE", "\u30d4\u30a7");
        result = result.replace("PYO", "\u30d4\u30e7");
        result = result.replace("MYA", "\u30df\u30e3");
        result = result.replace("MYI", "\u30df\u30a3");
        result = result.replace("MYU", "\u30df\u30e5");
        result = result.replace("MYE", "\u30df\u30a7");
        result = result.replace("MYO", "\u30df\u30e7");
        result = result.replace("XYA", "\u30e3");
        result = result.replace("XYU", "\u30e5");
        result = result.replace("XYO", "\u30e7");
        result = result.replace("RYA", "\u30ea\u30e3");
        result = result.replace("RYI", "\u30ea\u30a3");
        result = result.replace("RYU", "\u30ea\u30e5");
        result = result.replace("RYE", "\u30ea\u30a7");
        result = result.replace("RYO", "\u30ea\u30e7");
        result = result.replace("LYA", "\u30ea\u30e3");
        result = result.replace("LYI", "\u30ea\u30a3");
        result = result.replace("LYU", "\u30ea\u30e5");
        result = result.replace("LYE", "\u30ea\u30a7");
        result = result.replace("LYO", "\u30ea\u30e7");
        result = result.replace("LWE", "\u30ee");
        result = result.replace("XWA", "\u30ee");
        result = result.replace("YI", "\u30a4");
        result = result.replace("WU", "\u30a6");
        result = result.replace("XA", "\u30a1");
        result = result.replace("XI", "\u30a3");
        result = result.replace("XU", "\u30a5");
        result = result.replace("XE", "\u30a7");
        result = result.replace("XO", "\u30a9");
        result = result.replace("YE", "\u30a4\u30a7");
        result = result.replace("WI", "\u30a6\u30a3");
        result = result.replace("WE", "\u30a6\u30a7");
        result = result.replace("VA", "\u30f4\u30a1");
        result = result.replace("VI", "\u30f4\u30a3");
        result = result.replace("VU", "\u30f4");
        result = result.replace("VE", "\u30f4\u30a7");
        result = result.replace("VO", "\u30f4\u30a9");
        result = result.replace("KA", "\u30ab");
        result = result.replace("KI", "\u30ad");
        result = result.replace("KU", "\u30af");
        result = result.replace("KE", "\u30b1");
        result = result.replace("KO", "\u30b3");
        result = result.replace("QA", "\u30af\u30a1");
        result = result.replace("QI", "\u30af\u30a3");
        result = result.replace("QE", "\u30af\u30a7");
        result = result.replace("QO", "\u30af\u30a9");
        result = result.replace("GA", "\u30ac");
        result = result.replace("GI", "\u30ae");
        result = result.replace("GU", "\u30b0");
        result = result.replace("GE", "\u30b2");
        result = result.replace("GO", "\u30b4");
        result = result.replace("SA", "\u30b5");
        result = result.replace("SI", "\u30b7");
        result = result.replace("SU", "\u30b9");
        result = result.replace("SE", "\u30bb");
        result = result.replace("SO", "\u30bd");
        result = result.replace("ZA", "\u30b6");
        result = result.replace("ZI", "\u30b8");
        result = result.replace("ZU", "\u30ba");
        result = result.replace("ZE", "\u30bc");
        result = result.replace("ZO", "\u30be");
        result = result.replace("JI", "\u30b8");
        result = result.replace("JA", "\u30b8\u30e3");
        result = result.replace("JU", "\u30b8\u30e5");
        result = result.replace("JE", "\u30b8\u30a7");
        result = result.replace("JO", "\u30b8\u30e7");
        result = result.replace("TA", "\u30bf");
        result = result.replace("TI", "\u30c1");
        result = result.replace("TU", "\u30c4");
        result = result.replace("TE", "\u30c6");
        result = result.replace("TO", "\u30c8");
        result = result.replace("DA", "\u30c0");
        result = result.replace("DI", "\u30c2");
        result = result.replace("DU", "\u30c5");
        result = result.replace("DE", "\u30c7");
        result = result.replace("DO", "\u30c9");
        result = result.replace("NA", "\u30ca");
        result = result.replace("NI", "\u30cb");
        result = result.replace("NU", "\u30cc");
        result = result.replace("NE", "\u30cd");
        result = result.replace("NO", "\u30ce");
        result = result.replace("HA", "\u30cf");
        result = result.replace("HI", "\u30d2");
        result = result.replace("HU", "\u30d5");
        result = result.replace("HE", "\u30d8");
        result = result.replace("HO", "\u30db");
        result = result.replace("FU", "\u30d5");
        result = result.replace("FA", "\u30d5\u30a1");
        result = result.replace("FI", "\u30d5\u30a3");
        result = result.replace("FE", "\u30d5\u30a7");
        result = result.replace("FO", "\u30d5\u30a9");
        result = result.replace("BA", "\u30d0");
        result = result.replace("BI", "\u30d3");
        result = result.replace("BU", "\u30d6");
        result = result.replace("BE", "\u30d9");
        result = result.replace("BO", "\u30dc");
        result = result.replace("PA", "\u30d1");
        result = result.replace("PI", "\u30d4");
        result = result.replace("PU", "\u30d7");
        result = result.replace("PE", "\u30da");
        result = result.replace("PO", "\u30dd");
        result = result.replace("MA", "\u30de");
        result = result.replace("MI", "\u30df");
        result = result.replace("MU", "\u30e0");
        result = result.replace("ME", "\u30e1");
        result = result.replace("MO", "\u30e2");
        result = result.replace("YA", "\u30e4");
        result = result.replace("YU", "\u30e6");
        result = result.replace("YO", "\u30e8");
        result = result.replace("RA", "\u30e9");
        result = result.replace("RI", "\u30ea");
        result = result.replace("RU", "\u30eb");
        result = result.replace("RE", "\u30ec");
        result = result.replace("RO", "\u30ed");
        result = result.replace("LA", "\u30e9");
        result = result.replace("LI", "\u30ea");
        result = result.replace("LU", "\u30eb");
        result = result.replace("LE", "\u30ec");
        result = result.replace("LO", "\u30ed");
        result = result.replace("WA", "\u30ef");
        result = result.replace("WO", "\u30f2");
        result = result.replace("NN", "\u30f3");
        result = result.replace("XN", "\u30f3");
        result = result.replace("N'", "\u30f3");
        result = result.replace("N\u2019", "\u30f3");
        result = result.replace("A", "\u30a2");
        result = result.replace("I", "\u30a4");
        result = result.replace("U", "\u30a6");
        result = result.replace("E", "\u30a8");
        result = result.replace("O", "\u30aa");
        return result;
    }
}

