/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.TimeUtils;
import com.torii.srs.Main;
import com.torii.srs.desktop.ALStateChecker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class DesktopLauncher {
    private static final String VERSION = "Torii SRS";

    public static void main(String[] arg) {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        Graphics.DisplayMode desktopMode = Lwjgl3ApplicationConfiguration.getDisplayMode();
        int desktopHeight = desktopMode.height;
        int desktopWidth = desktopMode.width;
        int appWindowSize = desktopHeight < desktopWidth ? desktopHeight / 4 * 3 : desktopWidth / 4 * 3;
        config.setTitle(VERSION);
        config.setWindowedMode(appWindowSize, appWindowSize);
        config.setHdpiMode(HdpiMode.Pixels);
        config.setResizable(false);
        config.setWindowIcon("icons/16.png", "icons/32.png", "icons/64.png", "icons/128.png", "icons/256.png");
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            Gdx.app.error("Uncaught error", "An error occurred:", throwable);
            FileHandle fh = new FileHandle(System.getProperty("user.dir") + "/torii_errlog.txt");
            StringWriter errors = new StringWriter();
            throwable.printStackTrace(new PrintWriter(errors));
            String stack = "---" + new Date(TimeUtils.millis()) + "---\n" + errors + "\n";
            fh.writeString(stack, true);
        });
        Main main = new Main();
        main.setDesktopWindowedSizeLogical(appWindowSize);
        main.setDesktopSoundStateChecker(new ALStateChecker());
        new Lwjgl3Application(main, config);
    }
}

