/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.torii.srs.Dialogs;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.StudyScreen;

public class WelcomeScreen
implements Screen {
    private static WelcomeScreen welcomeScreen;
    private final int noWKnoKana;
    private final int kanaOnly;
    private final int wkOnly;
    private final int jlpt5NoWKnoKana;
    private final int jlpt5KanaOnly;
    private final int jlpt5WKonly;
    private final int jlpt4NoWKnoKana;
    private final int jlpt4KanaOnly;
    private final int jlpt4WKonly;
    private final int jlpt3NoWKnoKana;
    private final int jlpt3KanaOnly;
    private final int jlpt3WKonly;
    private final int jlpt2NoWKnoKana;
    private final int jlpt2KanaOnly;
    private final int jlpt2WKonly;
    private final int jlpt1NoWKnoKana;
    private final int jlpt1KanaOnly;
    private final int jlpt1WKonly;
    private Stage stage;
    private VisTable tblWelcome;
    private VisTable tblStudyMode;
    private ScrollableTextArea studyModeInfo;
    private VisScrollPane spStudyModeInfo;
    private VisTextButton btnWelcome;
    private VisTextButton btnStudyMode;
    private VisTextButton btn10kMode;
    private VisTextButton btnWK;
    private VisTextButton btnJLPT5;
    private VisTextButton btnJLPT4;
    private VisTextButton btnJLPT3;
    private VisTextButton btnJLPT2;
    private VisTextButton btnJLPT1;
    private VisTextButton btnKanaOnly;
    private VisCheckBox cbIncludeWK;
    private VisCheckBox cbIncludeKanaOnly;
    private boolean isNewAccount;

    WelcomeScreen() {
        welcomeScreen = this;
        this.noWKnoKana = 4500;
        this.kanaOnly = 1200;
        this.wkOnly = 3800;
        this.jlpt5NoWKnoKana = 20;
        this.jlpt5KanaOnly = 110;
        this.jlpt5WKonly = 480;
        this.jlpt4NoWKnoKana = 60;
        this.jlpt4KanaOnly = 80;
        this.jlpt4WKonly = 410;
        this.jlpt3NoWKnoKana = 440;
        this.jlpt3KanaOnly = 160;
        this.jlpt3WKonly = 970;
        this.jlpt2NoWKnoKana = 680;
        this.jlpt2KanaOnly = 180;
        this.jlpt2WKonly = 540;
        this.jlpt1NoWKnoKana = 1150;
        this.jlpt1KanaOnly = 130;
        this.jlpt1WKonly = 720;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.setupWelcomeTable();
        this.setupStudyModeTable();
    }

    private void setupWelcomeTable() {
        this.tblWelcome = new VisTable();
        VisTable tbl = new VisTable();
        this.btnWelcome = new VisTextButton("Let's go!", Main.btnStyleX1p25);
        Label.LabelStyle lYoukosoStyle = new Label.LabelStyle(new VisLabel().getStyle());
        lYoukosoStyle.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X2, BitmapFont.class, true);
        lYoukosoStyle.fontColor = Main.FONT;
        VisLabel lWelcome = new VisLabel((CharSequence)"Welcome!", Main.labelStyleX1);
        VisLabel lYoukoso = new VisLabel((CharSequence)"\u3088\u3046\u3053\u305d\uff01", lYoukosoStyle);
        VisLabel lWelcomeMessage = new VisLabel((CharSequence)"Great to have you here!", Main.labelStyleX1);
        VisLabel lInfoMessage = new VisLabel((CharSequence)"Learning with Torii is super simple.", Main.labelStyleX1);
        VisLabel l1 = new VisLabel((CharSequence)"Step 1: Pick a Study Mode.", Main.labelStyleX1p25);
        VisLabel l2 = new VisLabel((CharSequence)"No worries - you can change it anytime.", Main.labelStyleX1);
        VisLabel l3 = new VisLabel((CharSequence)"Step 2: Start studying!", Main.labelStyleX1p25);
        VisLabel l4 = new VisLabel((CharSequence)"Learn up to 50 new words a day.", Main.labelStyleX1);
        VisLabel l5 = new VisLabel((CharSequence)"Step 3: Review!", Main.labelStyleX1p25);
        VisLabel l6 = new VisLabel((CharSequence)"Let our Spaced Repetition System (SRS) work its magic.", Main.labelStyleX1);
        lWelcome.setAlignment(1);
        lYoukoso.setAlignment(1);
        lWelcomeMessage.setAlignment(1);
        lInfoMessage.setAlignment(1);
        l1.setAlignment(1);
        l2.setAlignment(1);
        l3.setAlignment(1);
        l4.setAlignment(1);
        l5.setAlignment(1);
        l6.setAlignment(1);
        lWelcomeMessage.setWrap(true);
        lInfoMessage.setWrap(true);
        l1.setWrap(true);
        l2.setWrap(true);
        l3.setWrap(true);
        l4.setWrap(true);
        l5.setWrap(true);
        l6.setWrap(true);
        this.btnWelcome.focusGained();
        tbl.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        this.btnWelcome.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                WelcomeScreen.this.stage.clear();
                WelcomeScreen.this.stage.addActor(WelcomeScreen.this.tblStudyMode);
                WelcomeScreen.this.btnStudyMode.focusGained();
            }
        });
        tbl.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        tbl.add(l1).padTop(1 * Main.getPPUY()).row();
        tbl.add(l2).padBottom(1 * Main.getPPUY()).row();
        tbl.addSeparator();
        tbl.add(l3).padTop(1 * Main.getPPUY()).row();
        tbl.add(l4).padBottom(1 * Main.getPPUY()).row();
        tbl.addSeparator();
        tbl.add(l5).padTop(1 * Main.getPPUY()).row();
        tbl.add(l6).padBottom(1 * Main.getPPUY()).row();
        this.tblWelcome.setFillParent(true);
        this.tblWelcome.align(2);
        this.tblWelcome.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblWelcome.add(lWelcome).padTop(0.5f * (float)Main.getPPUY()).row();
        this.tblWelcome.add(lYoukoso).row();
        this.tblWelcome.add(lWelcomeMessage).padTop(1.5f * (float)Main.getPPUY()).padBottom(1 * Main.getPPUY()).row();
        this.tblWelcome.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblWelcome.add(lInfoMessage).padTop(1 * Main.getPPUY()).padBottom(1 * Main.getPPUY()).row();
        this.tblWelcome.add(tbl).row();
        this.tblWelcome.add(this.btnWelcome).expandY().align(4).padBottom(1 * Main.getPPUY());
    }

    private void setupStudyModeTable() {
        this.tblStudyMode = new VisTable();
        this.studyModeInfo = new ScrollableTextArea("", Main.taStyle);
        VisLabel lStudyMode = new VisLabel((CharSequence)"Study Mode", Main.labelStyleX2);
        this.btn10kMode = new VisTextButton("10k (Recommended)", "toggle");
        this.btnJLPT5 = new VisTextButton("JLPT N5", "toggle");
        this.btnJLPT4 = new VisTextButton("JLPT N4", "toggle");
        this.btnJLPT3 = new VisTextButton("JLPT N3", "toggle");
        this.btnJLPT2 = new VisTextButton("JLPT N2", "toggle");
        this.btnJLPT1 = new VisTextButton("JLPT N1", "toggle");
        this.btnWK = new VisTextButton("WaniKani", "toggle");
        this.btnKanaOnly = new VisTextButton("Kana-Only", "toggle");
        this.btnStudyMode = new VisTextButton("Confirm", Main.btnStyleX1p25);
        this.cbIncludeWK = new VisCheckBox("WaniKani.com vocabulary");
        this.cbIncludeKanaOnly = new VisCheckBox("Kana-only vocabulary");
        float checkboxSize = Main.getPPUY();
        this.cbIncludeWK.getImageStackCell().size(checkboxSize);
        this.cbIncludeWK.getLabelCell().padLeft(checkboxSize * 0.5f);
        this.cbIncludeKanaOnly.getImageStackCell().size(checkboxSize);
        this.cbIncludeKanaOnly.getLabelCell().padLeft(checkboxSize * 0.5f);
        this.studyModeInfo.setMessageText("Select a Study Mode to continue...");
        this.studyModeInfo.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        lStudyMode.setAlignment(1);
        this.btn10kMode.setFocusBorderEnabled(false);
        this.btnWK.setFocusBorderEnabled(false);
        this.btnJLPT5.setFocusBorderEnabled(false);
        this.btnJLPT4.setFocusBorderEnabled(false);
        this.btnJLPT3.setFocusBorderEnabled(false);
        this.btnJLPT2.setFocusBorderEnabled(false);
        this.btnJLPT1.setFocusBorderEnabled(false);
        this.cbIncludeWK.setFocusBorderEnabled(false);
        this.cbIncludeKanaOnly.setFocusBorderEnabled(false);
        this.btnKanaOnly.setFocusBorderEnabled(false);
        this.btn10kMode.setChecked(true);
        this.cbIncludeWK.setChecked(true);
        this.cbIncludeKanaOnly.setChecked(true);
        this.studyModeInfo.setDisabled(true);
        this.btnStudyMode.focusGained();
        this.btn10kMode.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btn10kMode.isChecked()) {
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.btnJLPT5.setChecked(false);
                    WelcomeScreen.this.btnJLPT4.setChecked(false);
                    WelcomeScreen.this.btnJLPT3.setChecked(false);
                    WelcomeScreen.this.btnJLPT2.setChecked(false);
                    WelcomeScreen.this.btnJLPT1.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnWK.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnWK.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.btnJLPT5.setChecked(false);
                    WelcomeScreen.this.btnJLPT4.setChecked(false);
                    WelcomeScreen.this.btnJLPT3.setChecked(false);
                    WelcomeScreen.this.btnJLPT2.setChecked(false);
                    WelcomeScreen.this.btnJLPT1.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnKanaOnly.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnKanaOnly.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnJLPT5.setChecked(false);
                    WelcomeScreen.this.btnJLPT4.setChecked(false);
                    WelcomeScreen.this.btnJLPT3.setChecked(false);
                    WelcomeScreen.this.btnJLPT2.setChecked(false);
                    WelcomeScreen.this.btnJLPT1.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(true);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnJLPT5.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnJLPT5.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnJLPT4.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnJLPT4.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnJLPT3.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnJLPT3.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnJLPT2.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnJLPT2.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnJLPT1.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (WelcomeScreen.this.btnJLPT1.isChecked()) {
                    WelcomeScreen.this.btn10kMode.setChecked(false);
                    WelcomeScreen.this.btnWK.setChecked(false);
                    WelcomeScreen.this.btnKanaOnly.setChecked(false);
                    WelcomeScreen.this.cbIncludeWK.setChecked(true);
                    WelcomeScreen.this.cbIncludeKanaOnly.setChecked(true);
                    WelcomeScreen.this.cbIncludeWK.setDisabled(false);
                    WelcomeScreen.this.cbIncludeKanaOnly.setDisabled(false);
                }
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.btnStudyMode.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!WelcomeScreen.this.btnStudyMode.isDisabled()) {
                    final int studyMode = WelcomeScreen.this.calculateStudyMode();
                    final boolean includeWK = WelcomeScreen.this.cbIncludeWK.isChecked();
                    final boolean includeKanaOnly = WelcomeScreen.this.cbIncludeKanaOnly.isChecked();
                    if (!WelcomeScreen.this.isNewAccount) {
                        Dialogs.showConfirmDialog(WelcomeScreen.this.stage, "Review Preferences", "You might've learned some words that aren't part of your current Study Mode. Do you still want to review those words regularly, or only review vocabulary from your selected Study Mode?", new String[]{"All", "Study Mode Only"}, new Dialogs.ConfirmAdapter(){

                            @Override
                            public void yes() {
                                RestClient.updateStudyMode(studyMode, includeWK, includeKanaOnly, true);
                            }

                            @Override
                            public void cancel() {
                                RestClient.updateStudyMode(studyMode, includeWK, includeKanaOnly, false);
                            }
                        }, true);
                    } else {
                        RestClient.updateStudyMode(studyMode, includeWK, includeKanaOnly, true);
                    }
                }
            }
        });
        this.cbIncludeWK.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        this.cbIncludeKanaOnly.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                WelcomeScreen.this.setInfoBoxText();
            }
        });
        VisLabel lAdditionalOptions = new VisLabel((CharSequence)"Optional", Main.labelStyleX1p25);
        lAdditionalOptions.setAlignment(1);
        this.spStudyModeInfo = (VisScrollPane)this.studyModeInfo.createCompatibleScrollPane();
        this.spStudyModeInfo.setFlickScroll(true);
        this.tblStudyMode.setFillParent(true);
        this.tblStudyMode.align(2);
        this.tblStudyMode.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblStudyMode.add(lStudyMode).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(this.btn10kMode).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(this.btnJLPT5).row();
        this.tblStudyMode.add(this.btnJLPT4).row();
        this.tblStudyMode.add(this.btnJLPT3).row();
        this.tblStudyMode.add(this.btnJLPT2).row();
        this.tblStudyMode.add(this.btnJLPT1).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(this.btnWK).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(this.btnKanaOnly).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(lAdditionalOptions).padTop(Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblStudyMode.add(this.cbIncludeWK).row();
        this.tblStudyMode.add(this.cbIncludeKanaOnly).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblStudyMode.addSeparator().width(this.stage.getViewport().getWorldWidth());
        this.tblStudyMode.add(this.spStudyModeInfo).height(0.0f).expand().fill().padTop(Main.getPPUY()).padBottom(Main.getPPUY()).row();
        this.tblStudyMode.add(this.btnStudyMode).align(4).padBottom(Main.getPPUY());
        this.setInfoBoxText();
    }

    private int calculateStudyMode() {
        int status = 0;
        if (this.btn10kMode.isChecked()) {
            status = 1;
        } else if (this.btnWK.isChecked()) {
            status = 2;
        } else if (this.btnKanaOnly.isChecked()) {
            status = 100;
        } else {
            if (this.btnJLPT5.isChecked()) {
                status += 3;
            }
            if (this.btnJLPT4.isChecked()) {
                status += 6;
            }
            if (this.btnJLPT3.isChecked()) {
                status += 12;
            }
            if (this.btnJLPT2.isChecked()) {
                status += 24;
            }
            if (this.btnJLPT1.isChecked()) {
                status += 48;
            }
        }
        return status;
    }

    private void setInfoBoxText() {
        String p3;
        String p2;
        String p1;
        this.btnStudyMode.setDisabled(false);
        int vocabCount = 0;
        if (this.btn10kMode.isChecked()) {
            vocabCount = this.noWKnoKana;
            if (this.cbIncludeWK.isChecked()) {
                vocabCount += this.wkOnly;
            }
            if (this.cbIncludeKanaOnly.isChecked()) {
                vocabCount += this.kanaOnly;
            }
            p1 = "The 10k Study Mode contains about 10,000 of the most common Japanese words. Ideal for most learners.\nLessons follow JLPT level order: N5 first, N1 last.";
        } else if (this.btnWK.isChecked()) {
            vocabCount = this.noWKnoKana;
            if (this.cbIncludeKanaOnly.isChecked()) {
                vocabCount += this.kanaOnly;
            }
            p1 = "WaniKani Mode skips any vocab already taught on WaniKani.com, so it's great for studying alongside WaniKani.\nLessons are arranged by WaniKani level, beginning with the earliest levels and moving upward.";
        } else if (this.btnKanaOnly.isChecked()) {
            vocabCount = this.kanaOnly;
            p1 = "No Kanji, just kana-only vocabulary.\nLessons follow JLPT level order: N5 first, N1 last.";
        } else if (this.btnJLPT5.isChecked() || this.btnJLPT4.isChecked() || this.btnJLPT3.isChecked() || this.btnJLPT2.isChecked() || this.btnJLPT1.isChecked()) {
            if (this.btnJLPT5.isChecked()) {
                vocabCount += this.jlpt5NoWKnoKana;
                if (this.cbIncludeWK.isChecked()) {
                    vocabCount += this.jlpt5WKonly;
                }
                if (this.cbIncludeKanaOnly.isChecked()) {
                    vocabCount += this.jlpt5KanaOnly;
                }
            }
            if (this.btnJLPT4.isChecked()) {
                vocabCount += this.jlpt4NoWKnoKana;
                if (this.cbIncludeWK.isChecked()) {
                    vocabCount += this.jlpt4WKonly;
                }
                if (this.cbIncludeKanaOnly.isChecked()) {
                    vocabCount += this.jlpt4KanaOnly;
                }
            }
            if (this.btnJLPT3.isChecked()) {
                vocabCount += this.jlpt3NoWKnoKana;
                if (this.cbIncludeWK.isChecked()) {
                    vocabCount += this.jlpt3WKonly;
                }
                if (this.cbIncludeKanaOnly.isChecked()) {
                    vocabCount += this.jlpt3KanaOnly;
                }
            }
            if (this.btnJLPT2.isChecked()) {
                vocabCount += this.jlpt2NoWKnoKana;
                if (this.cbIncludeWK.isChecked()) {
                    vocabCount += this.jlpt2WKonly;
                }
                if (this.cbIncludeKanaOnly.isChecked()) {
                    vocabCount += this.jlpt2KanaOnly;
                }
            }
            if (this.btnJLPT1.isChecked()) {
                vocabCount += this.jlpt1NoWKnoKana;
                if (this.cbIncludeWK.isChecked()) {
                    vocabCount += this.jlpt1WKonly;
                }
                if (this.cbIncludeKanaOnly.isChecked()) {
                    vocabCount += this.jlpt1KanaOnly;
                }
            }
            p1 = "If you want to prepare for the Japanese Language Proficiency Test, choose one or more of the JLPT modes.\nLessons appear in random order.";
        } else {
            this.btnStudyMode.setDisabled(true);
            p1 = "";
        }
        if (this.btn10kMode.isChecked() && this.cbIncludeWK.isChecked() && this.cbIncludeKanaOnly.isChecked()) {
            p2 = "";
            p3 = "";
        } else {
            p2 = "\n\nYou'll learn ~" + vocabCount + " words.";
            String string = p3 = this.isNewAccount ? "" : "\n(Notice: If you've completed lessons in the past, the actual number of new words you learn may be lower than the value shown. Check the 'Progress' page on the dashboard for details.)";
        }
        if (!p1.equals("")) {
            this.studyModeInfo.setText(p1 + p2 + p3);
        } else {
            this.studyModeInfo.clearText();
        }
        this.studyModeInfo.pack();
        this.studyModeInfo.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.spStudyModeInfo.setActor(this.studyModeInfo.createCompatibleScrollPane());
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.btn10kMode.setChecked(true);
        this.btnWK.setChecked(false);
        this.btnKanaOnly.setChecked(false);
        this.btnJLPT5.setChecked(false);
        this.btnJLPT4.setChecked(false);
        this.btnJLPT3.setChecked(false);
        this.btnJLPT2.setChecked(false);
        this.btnJLPT1.setChecked(false);
        this.cbIncludeWK.setChecked(true);
        this.cbIncludeKanaOnly.setChecked(true);
        this.cbIncludeWK.setDisabled(false);
        this.cbIncludeKanaOnly.setDisabled(false);
        this.setInfoBoxText();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    public static void showOnScreen(boolean skipWelcomeMessage) {
        WelcomeScreen.welcomeScreen.stage.clear();
        boolean bl = WelcomeScreen.welcomeScreen.isNewAccount = StudyScreen.getStudyMode().studyMode < 1;
        if (!skipWelcomeMessage) {
            welcomeScreen.setupWelcomeTable();
            welcomeScreen.setupStudyModeTable();
            WelcomeScreen.welcomeScreen.stage.addActor(WelcomeScreen.welcomeScreen.tblWelcome);
            WelcomeScreen.welcomeScreen.btnWelcome.focusGained();
        } else {
            welcomeScreen.setupStudyModeTable();
            WelcomeScreen.welcomeScreen.stage.addActor(WelcomeScreen.welcomeScreen.tblStudyMode);
            WelcomeScreen.welcomeScreen.btnStudyMode.focusGained();
        }
        Main.setNewScreen(welcomeScreen);
    }
}

