/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.util.ToastManager;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.toast.Toast;
import com.torii.srs.AudioHandler;
import com.torii.srs.BrowseScreen;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.Hints;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.RestClient;
import com.torii.srs.ReviewScreen;
import com.torii.srs.SettingsScreen;
import com.torii.srs.widget.KanaConverter;
import com.torii.srs.widget.List;
import com.torii.srs.widget.TopMenu;
import java.util.HashMap;
import java.util.Iterator;

public class StudyScreen
implements Screen {
    static StudyScreen lessonScreen;
    private StudyMode studyMode;
    private TopMenu topMenu;
    private PracticeScreen.PracticeListsTable plt;
    private final float kanjiFontSize;
    private final float kanaFontSize;
    private final float meaningFontSize;
    private int charLimitNotes;
    private ShapeRenderer renderer;
    private Stage stage;
    private VisTable table;
    private VisTable tblVocab;
    private VisTable tblTabs;
    private VisTable tblLinks;
    private VisTable tblButtons;
    private VisTable tblTabbedPane;
    private VisTable tblExamples;
    private VisTable tblCustom;
    private VisTable tblCustomSynonyms;
    private VisTable tblCustomReadings;
    private VisTable tblProblem;
    private VisScrollPane spMeaning;
    private VisScrollPane spExamples;
    private VisScrollPane spNotes;
    private ScrollableTextArea taExamples;
    private ScrollableTextArea taNotes;
    private ScrollableTextArea taMessage;
    private VisLabel lVocabKanji;
    private VisLabel lVocabKana;
    private VisLabel lVocabMeaning;
    private VisLabel lSentence;
    private VisLabel lSentenceMeaning;
    private VisLabel lPartOfSpeech;
    private VisLabel lJlptLevel;
    private VisLabel lLessonsCounter;
    private VisLabel lCharCounter;
    private LinkLabel llJisho;
    private LinkLabel llTatoeba;
    private LinkLabel llReportProblem;
    private VisImageButton btnArchiveVocab;
    private VisImageButton btnPlus;
    private VisImageButton btnKeybinds;
    private VisTextButton btnMeaning;
    private VisTextButton btnExamples;
    private VisTextButton btnCustom;
    private VisTextButton btnNext;
    private VisTextButton btnPrevious;
    private VisTextButton btnSynonymsAdd;
    private VisTextButton btnSynonymsRemove;
    private VisTextButton btnReadingsAdd;
    private VisTextButton btnReadingsRemove;
    private List listSynonyms;
    private List listReadings;
    private VisTextField.VisTextFieldStyle examplesStyle;
    private Label.LabelStyle styleKanji;
    private Label.LabelStyle styleKana;
    private Label.LabelStyle sentenceStyle;
    private String[] synonymsTemp;
    private String[] readingsTemp;
    private String placeholder = "*";
    private int dailyLimit = 20;
    private int dailyLimitLeft = 20;
    private int noOfLessons;
    private int lessonsCounter;
    private boolean allLessonsCleared = false;
    private boolean hideKana = false;
    private boolean hideSentenceMeaning = false;
    private boolean autoplayAudio = false;
    private boolean studySessionAutoContinue = false;
    private boolean studyFullscreen = false;
    private Lesson currentLesson;
    private HashMap<Integer, Lesson> lessonsList;
    private Timer.Task charCounterTimer;
    private boolean isViewingVocab = false;
    private Array<Integer> arrLoadedAssetIds;
    private boolean itemArchivedThisSession = false;

    StudyScreen() {
        lessonScreen = this;
        this.arrLoadedAssetIds = new Array();
        this.renderer = new ShapeRenderer();
        this.renderer.setAutoShapeType(true);
        this.kanjiFontSize = 4 * Main.getPPUY();
        this.kanaFontSize = 2 * Main.getPPUY();
        this.meaningFontSize = 2 * Main.getPPUY();
        this.charCounterTimer = new Timer.Task(){

            @Override
            public void run() {
                StudyScreen.this.lCharCounter.addAction(Actions.fadeOut(0.25f));
            }
        };
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.buildUI();
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        if (this.lessonsCounter == -1) {
            this.buildUI();
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    StudyScreen.this.nextLesson();
                }
            });
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG_LIGHTER.r, Main.UI_BG_LIGHTER.g, Main.UI_BG_LIGHTER.b, Main.UI_BG_LIGHTER.a);
        Gdx.gl.glClear(16384);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.setColor(Main.STUDY_OVER);
        if (this.tblTabs.getY() != 0.0f) {
            this.renderer.rect(0.0f, this.tblTabs.getY(), this.stage.getViewport().getWorldWidth(), this.stage.getViewport().getWorldHeight() - this.tblTabs.getY() - this.topMenu.getTable().getHeight());
        }
        this.renderer.end();
        if (AudioHandler.isDownloadingExampleAudio()) {
            this.topMenu.setIndicatorRight(TopMenu.StatusIndicator.DOWNLOAD);
        } else {
            this.topMenu.setIndicatorRight(TopMenu.StatusIndicator.NONE);
        }
        if (AudioHandler.isSoundPlaying()) {
            this.topMenu.setIndicatorLeft(TopMenu.StatusIndicator.SOUND);
        } else {
            this.topMenu.setIndicatorLeft(TopMenu.StatusIndicator.NONE);
        }
        if (!Main.updateAssetManager(true)) {
            if (!Main.isAssetLoaded("kanjiLesson" + this.lessonsList.get((Object)Integer.valueOf((int)(this.lessonsCounter + 1))).id + ".ttf", true) || !Main.isAssetLoaded("examplesLesson" + this.lessonsList.get((Object)Integer.valueOf((int)(this.lessonsCounter + 1))).id + ".ttf", true)) {
                this.btnNext.setDisabled(true);
            } else {
                this.btnNext.setDisabled(false);
            }
        } else {
            this.btnNext.setDisabled(false);
        }
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        if ((float)width != this.stage.getViewport().getWorldWidth() || (float)height != this.stage.getViewport().getWorldHeight()) {
            this.stage.getViewport().setWorldSize(width, height);
            this.buildUI();
        }
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Main.stopSound();
        RestClient.updateTime(Main.getToriiTime(), Main.getStudyTime(), Main.getReviewTime());
    }

    @Override
    public void dispose() {
    }

    private void buildUI() {
        this.table = new VisTable();
        this.tblVocab = new VisTable(true);
        this.tblTabs = new VisTable();
        this.tblLinks = new VisTable(true);
        this.tblButtons = new VisTable(true);
        this.tblTabbedPane = new VisTable();
        this.tblExamples = new VisTable();
        this.tblCustom = new VisTable(true);
        this.tblCustomSynonyms = new VisTable(true);
        this.tblCustomReadings = new VisTable(true);
        this.tblProblem = new VisTable(false);
        this.listSynonyms = new List("Synonyms");
        this.listReadings = new List("Readings");
        this.lLessonsCounter = new VisLabel((CharSequence)"", Main.labelStyleX1_w);
        this.lCharCounter = new VisLabel((CharSequence)("0/" + this.charLimitNotes), Main.labelStyleX1);
        this.llJisho = new LinkLabel("Jisho.org");
        this.llTatoeba = new LinkLabel("Tatoeba.org");
        this.llReportProblem = new LinkLabel((CharSequence)"Report a problem", (CharSequence)"", Main.linkLabelStyleX0p5);
        this.btnMeaning = new VisTextButton("Meaning", Main.btnStyleToggleWhite);
        this.btnExamples = new VisTextButton("Examples", Main.btnStyleToggleWhite);
        this.btnCustom = new VisTextButton("Notes", Main.btnStyleToggleWhite);
        this.btnSynonymsAdd = new VisTextButton("+", Main.btnStyleX1p25);
        this.btnSynonymsRemove = new VisTextButton("-", Main.btnStyleX1p25);
        this.btnReadingsAdd = new VisTextButton("+", Main.btnStyleX1p25);
        this.btnReadingsRemove = new VisTextButton("-", Main.btnStyleX1p25);
        this.examplesStyle = new VisTextField.VisTextFieldStyle(Main.taStyle);
        this.styleKanji = new Label.LabelStyle(new VisLabel().getStyle());
        this.styleKana = new Label.LabelStyle(new VisLabel().getStyle());
        this.sentenceStyle = new Label.LabelStyle(new VisLabel().getStyle());
        this.styleKana.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X2, BitmapFont.class, true);
        this.styleKanji.background = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.styleKana.background = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.tblTabs.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
        this.styleKana.fontColor = Color.WHITE;
        this.styleKanji.fontColor = Color.WHITE;
        this.sentenceStyle.fontColor = Main.FONT;
        this.examplesStyle.fontColor = Main.FONT;
        this.taExamples = new ScrollableTextArea("", this.examplesStyle);
        this.taNotes = new ScrollableTextArea("", new VisTextField.VisTextFieldStyle(Main.taStyle));
        this.taNotes.getStyle().font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
        this.lVocabKana = new VisLabel((CharSequence)"X", this.styleKana);
        this.lVocabKanji = new VisLabel((CharSequence)"X", this.styleKanji);
        this.lVocabMeaning = new VisLabel((CharSequence)"X", Main.labelStyleX2plus);
        this.lSentence = new VisLabel((CharSequence)"", this.sentenceStyle);
        this.lSentenceMeaning = new VisLabel((CharSequence)"X", Main.labelStyleX1);
        this.lPartOfSpeech = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        this.lJlptLevel = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        this.btnNext = new VisTextButton("Next \u2192", Main.btnStyleX1p25);
        this.btnPrevious = new VisTextButton("\u2190 Back", Main.btnStyleX1p25);
        Drawable btnUp = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnOver = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDown = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDisabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Image imgArchive = new Image((Texture)Main.getAsset(Main.ARCHIVE_BTN_PATH, Texture.class, true));
        Drawable archive = imgArchive.getDrawable();
        this.btnArchiveVocab = new VisImageButton(archive, "Archive");
        this.btnArchiveVocab.getStyle().up = btnUp;
        this.btnArchiveVocab.getStyle().over = btnOver;
        this.btnArchiveVocab.getStyle().down = btnDown;
        this.btnArchiveVocab.getStyle().disabled = btnDisabled;
        this.btnArchiveVocab.getStyle().imageDown = Main.uiSkin.newDrawable(archive, Main.OBJECT_PRESSED);
        this.btnArchiveVocab.getStyle().imageDisabled = Main.uiSkin.newDrawable(archive, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgPlus = new Image((Texture)Main.getAsset(Main.PLUS_BTN_PATH, Texture.class, true));
        Drawable plus = imgPlus.getDrawable();
        this.btnPlus = new VisImageButton(plus, "Add to List");
        this.btnPlus.getStyle().up = btnUp;
        this.btnPlus.getStyle().over = btnOver;
        this.btnPlus.getStyle().down = btnDown;
        this.btnPlus.getStyle().disabled = btnDisabled;
        this.btnPlus.getStyle().imageDown = Main.uiSkin.newDrawable(plus, Main.OBJECT_PRESSED);
        this.btnPlus.getStyle().imageDisabled = Main.uiSkin.newDrawable(plus, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgKeybinds = new Image((Texture)Main.getAsset(Main.KEYBINDS_BTN_PATH, Texture.class, true));
        Drawable keybinds = imgKeybinds.getDrawable();
        this.btnKeybinds = new VisImageButton(keybinds, " Key Bindings ");
        this.btnKeybinds.getStyle().up = btnUp;
        this.btnKeybinds.getStyle().over = btnOver;
        this.btnKeybinds.getStyle().down = btnDown;
        this.btnKeybinds.getStyle().disabled = btnDisabled;
        this.btnKeybinds.getStyle().imageDown = Main.uiSkin.newDrawable(keybinds, Main.OBJECT_PRESSED);
        this.btnKeybinds.getStyle().imageDisabled = Main.uiSkin.newDrawable(keybinds, new VisTextButton((String)"").getStyle().disabledFontColor);
        this.taExamples.setMessageText("No examples available.");
        this.taNotes.setMessageText("Click to add a note or mnemonic.");
        this.lCharCounter.setTouchable(Touchable.disabled);
        this.lVocabKanji.setAlignment(1);
        this.lVocabKana.setAlignment(1);
        this.lVocabMeaning.setAlignment(1);
        this.lSentence.setAlignment(1);
        this.lSentenceMeaning.setAlignment(1);
        this.lPartOfSpeech.setAlignment(1);
        this.lJlptLevel.setAlignment(1);
        this.lLessonsCounter.setAlignment(16);
        this.lCharCounter.setAlignment(20);
        this.btnArchiveVocab.setFocusBorderEnabled(false);
        this.btnPlus.setFocusBorderEnabled(false);
        this.btnKeybinds.setFocusBorderEnabled(false);
        this.taExamples.setFocusBorderEnabled(false);
        this.btnNext.setFocusBorderEnabled(false);
        this.btnPrevious.setFocusBorderEnabled(false);
        this.btnMeaning.setFocusBorderEnabled(false);
        this.btnExamples.setFocusBorderEnabled(false);
        this.btnCustom.setFocusBorderEnabled(false);
        this.btnSynonymsAdd.setFocusBorderEnabled(false);
        this.btnSynonymsRemove.setFocusBorderEnabled(false);
        this.btnReadingsAdd.setFocusBorderEnabled(false);
        this.btnReadingsRemove.setFocusBorderEnabled(false);
        this.lVocabKanji.setWrap(false);
        this.lVocabKana.setWrap(false);
        this.lJlptLevel.setWrap(false);
        this.taExamples.setDisabled(true);
        this.lVocabMeaning.setWrap(true);
        this.lSentence.setWrap(true);
        this.lSentenceMeaning.setWrap(true);
        this.lPartOfSpeech.setWrap(true);
        this.btnNext.setDisabled(true);
        this.btnMeaning.setChecked(true);
        this.renderer = new ShapeRenderer();
        this.renderer.setAutoShapeType(true);
        this.taExamples.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.spExamples = (VisScrollPane)this.taExamples.createCompatibleScrollPane();
        this.spExamples.setFlickScroll(true);
        this.spExamples.setFadeScrollBars(false);
        this.spExamples.setScrollingDisabled(true, false);
        this.taNotes.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.taNotes.setAlignment(1);
        this.spNotes = (VisScrollPane)this.taNotes.createCompatibleScrollPane();
        this.table.setFillParent(true);
        this.table.align(2);
        VisTable tblTopLeft = new VisTable(false);
        tblTopLeft.add(this.btnPlus).size(1.5f * (float)Main.getPPUY()).padRight(Main.getPPUY());
        tblTopLeft.add(this.btnArchiveVocab).size(1.75f * (float)Main.getPPUY());
        if (Main.isDesktop()) {
            tblTopLeft.add(this.btnKeybinds).size(1.5f * (float)Main.getPPUY()).padLeft(4 * Main.getPPUY());
        }
        VisTable tblTopRight = new VisTable(false);
        tblTopRight.add(this.lLessonsCounter);
        this.topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                if (!StudyScreen.this.isViewingVocab) {
                    Dialogs.showConfirmDialog(StudyScreen.this.stage, "Quit Session", "Do you want to quit this study session?", new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            StudyScreen.this.stage.unfocusAll();
                            Gdx.input.setOnscreenKeyboardVisible(false);
                            StudyScreen.this.disposeAssets();
                            Dashboard.showOnScreen();
                        }
                    });
                } else {
                    StudyScreen.this.stage.unfocusAll();
                    Gdx.input.setOnscreenKeyboardVisible(false);
                    StudyScreen.this.disposeAssets();
                    Dashboard.showOnScreen();
                }
            }
        };
        this.topMenu.swapLeft(tblTopLeft, 8);
        this.topMenu.swapRight(tblTopRight, 16);
        this.plt = new PracticeScreen.PracticeListsTable(this.stage, true, false);
        this.setActorListeners();
    }

    private void rebuildTable() {
        this.table.clearChildren();
        this.tblVocab.clearChildren();
        this.tblTabs.clearChildren();
        this.tblLinks.clearChildren();
        this.tblButtons.clearChildren();
        this.tblExamples.clearChildren();
        this.tblCustomSynonyms.clearChildren();
        this.tblCustomReadings.clearChildren();
        this.tblCustom.clearChildren();
        this.tblProblem.clearChildren();
        this.tblTabbedPane.clearChildren();
        if (!KanaConverter.isKanaWord(this.currentLesson.vocabKanji)) {
            this.tblVocab.add(this.lVocabKana).fillX().height(this.kanaFontSize).padBottom(0.5f * (float)Main.getPPUY()).row();
        }
        this.tblVocab.add(this.lVocabKanji).fillX().height(this.kanjiFontSize).row();
        this.tblTabs.defaults().height(2 * Main.getPPUY());
        this.tblTabs.add(this.btnMeaning);
        this.tblTabs.add(this.btnExamples);
        this.tblTabs.add(this.btnCustom);
        this.tblLinks.add(this.llJisho).expandX().uniform().align(16);
        this.tblLinks.add(new VisLabel((CharSequence)"  |  ", Main.labelStyleX1));
        this.tblLinks.add(this.llTatoeba).expandX().uniform().align(8).row();
        this.tblLinks.add(this.llReportProblem).padTop(0.5f * (float)Main.getPPUY()).colspan(3).row();
        this.tblButtons.defaults().expandX().fillX().uniform();
        this.tblButtons.add(this.btnPrevious);
        this.tblButtons.add(this.btnNext);
        VisTable tblMeaning = new VisTable(false);
        tblMeaning.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f).fillX();
        tblMeaning.add(this.lVocabMeaning).padTop(Main.getPPUY()).padBottom(Main.getPPUY()).row();
        tblMeaning.add(this.lPartOfSpeech).padBottom(0.1f * (float)Main.getPPUY()).row();
        tblMeaning.add(this.lJlptLevel).padBottom(1.0f * (float)Main.getPPUY()).row();
        tblMeaning.addSeparator().padBottom(1.0f * (float)Main.getPPUY()).row();
        tblMeaning.add(this.lSentence).padBottom(1.0f * (float)Main.getPPUY()).row();
        tblMeaning.add(this.lSentenceMeaning).expandY().align(2).padBottom(0.5f * (float)Main.getPPUY()).row();
        tblMeaning.add(this.tblLinks).row();
        this.spMeaning = new VisScrollPane((Actor)tblMeaning);
        this.spMeaning.setScrollingDisabled(true, false);
        this.spMeaning.setFadeScrollBars(false);
        this.tblExamples.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f).expand().fill();
        this.tblExamples.add(this.spExamples).height(0.0f);
        this.tblCustomSynonyms.defaults().expandX().fillX();
        this.tblCustomSynonyms.add(this.listSynonyms).colspan(2).expand().fill().align(2).row();
        this.tblCustomSynonyms.add(this.btnSynonymsAdd).uniform();
        this.tblCustomSynonyms.add(this.btnSynonymsRemove).uniform().row();
        this.tblCustomReadings.defaults().expandX().fillX();
        this.tblCustomReadings.add(this.listReadings).colspan(2).expand().fill().align(2).row();
        this.tblCustomReadings.add(this.btnReadingsAdd).uniform();
        this.tblCustomReadings.add(this.btnReadingsRemove).uniform().row();
        Stack stack = new Stack(this.spNotes, this.lCharCounter);
        this.tblCustom.add(stack).colspan(2).height(6.5f * (float)Main.getPPUY()).expandX().fillX().row();
        this.tblCustom.add(this.tblCustomSynonyms).expand().fill().uniformX();
        this.tblCustom.add(this.tblCustomReadings).expand().fill().uniformX();
        final VisSelectBox<String> sbIssue = new VisSelectBox<String>();
        sbIssue.setItems(" Select the issue...", " Wrong item info", " Wrong example sentences", " Missing audio", " Broken link", " Other (specify below)");
        this.taMessage = new ScrollableTextArea("", new VisTextField.VisTextFieldStyle(Main.taStyle));
        this.taMessage.setMessageText("Optional information (max 300 characters)");
        VisTextButton tbSubmit = new VisTextButton("Send", Main.btnStyleX1);
        VisTextButton tbCancel = new VisTextButton("Cancel", Main.btnStyleX1);
        tbSubmit.setFocusBorderEnabled(false);
        tbCancel.setFocusBorderEnabled(false);
        tbCancel.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                StudyScreen.this.simulateClick(StudyScreen.this.btnMeaning);
            }
        });
        tbSubmit.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (sbIssue.getSelectedIndex() == 0) {
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Please select the subject.");
                } else if (sbIssue.getSelectedIndex() == sbIssue.getItems().size - 1 && StudyScreen.this.taMessage.getText().trim().equals("")) {
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Please describe the issue.");
                } else {
                    Dialogs.showConfirmDialog(StudyScreen.this.stage, "Confirmation", "Do you want to report this issue?", new String[]{"Send Report", "Edit"}, new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            String s = ((StudyScreen)StudyScreen.this).currentLesson.id + " " + ((StudyScreen)StudyScreen.this).currentLesson.vocabKanji + " (" + ((StudyScreen)StudyScreen.this).currentLesson.vocabKana + ")\n";
                            RestClient.sendSupportRequest("N/A", (String)sbIssue.getSelected(), s + StudyScreen.this.taMessage.getText().trim(), true);
                            sbIssue.setSelectedIndex(0);
                            StudyScreen.this.taMessage.clearText();
                        }
                    });
                }
            }
        });
        this.taMessage.setTextFieldListener(new VisTextField.TextFieldListener(){

            @Override
            public void keyTyped(VisTextField textField, char key) {
                int cursorPos = textField.getCursorPosition();
                String content = textField.getText().replaceAll(" +", " ").replaceAll("\n+", "\n");
                if (content.length() > 0 && content.charAt(0) == '\n') {
                    content = content.replaceFirst("\n", "");
                }
                if (content.length() > 300) {
                    content = content.substring(0, 300);
                }
                textField.setText(content);
                textField.setCursorPosition(cursorPos);
            }
        });
        VisLabel lProblem = new VisLabel((CharSequence)"Is there something wrong with this item?", Main.labelStyleX1);
        lProblem.setAlignment(1);
        lProblem.setWrap(true);
        this.tblProblem.add(lProblem).colspan(2).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom((float)Main.getPPUY() * 0.5f).row();
        this.tblProblem.add(sbIssue).colspan(2).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        this.tblProblem.add(this.taMessage.createCompatibleScrollPane()).colspan(2).expand().fill().padBottom((float)Main.getPPUY() * 0.5f).row();
        this.tblProblem.add(tbCancel).expandX().fillX().uniformX().padRight((float)Main.getPPUY() * 0.25f);
        this.tblProblem.add(tbSubmit).expandX().fillX().uniformX().padLeft((float)Main.getPPUY() * 0.25f);
        this.tblTabbedPane.add(this.spMeaning);
        this.table.add(this.topMenu.getTable()).width(this.stage.getViewport().getWorldWidth()).row();
        this.table.add(this.tblVocab).width(this.stage.getViewport().getWorldWidth()).height(4.5f * (float)Main.getPPUY() + this.kanaFontSize + this.kanjiFontSize).row();
        this.table.add(this.tblTabs).width(this.stage.getViewport().getWorldWidth() * 1.1f).row();
        this.table.add(this.tblTabbedPane).width(this.stage.getViewport().getWorldWidth() * 0.95f).fill().expand().padTop(Main.getPPUY()).row();
        this.table.add(this.tblButtons).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(Main.getPPUY()).padBottom(Main.getPPUY());
        this.stage.clear();
        this.setStageListener();
        this.stage.addActor(this.table);
    }

    static void hideProblemReportTable() {
        lessonScreen.simulateClick(StudyScreen.lessonScreen.btnMeaning);
    }

    static void showOnScreen() {
        Main.setNewScreen(lessonScreen);
        Hints.showArchiveVocabHint(StudyScreen.lessonScreen.stage);
    }

    static boolean isOnScreen() {
        return Main.getCurrentScreen() == lessonScreen;
    }

    static void regenerateStudyMode(int studyMode, boolean includeWK, boolean includeKanaOnly) {
        StudyScreen.lessonScreen.studyMode = new StudyMode(studyMode, includeWK, includeKanaOnly);
    }

    static StudyMode getStudyMode() {
        return StudyScreen.lessonScreen.studyMode;
    }

    static void setAllLessonsCleared(boolean isTrue) {
        StudyScreen.lessonScreen.allLessonsCleared = isTrue;
    }

    static boolean getAllLessonsCleared() {
        return StudyScreen.lessonScreen.allLessonsCleared;
    }

    static void setHideKana(boolean hideKana) {
        StudyScreen.lessonScreen.hideKana = hideKana;
    }

    static boolean getHideKana() {
        return StudyScreen.lessonScreen.hideKana;
    }

    static void setHideSentenceMeaning(boolean hideSentenceMeaning) {
        StudyScreen.lessonScreen.hideSentenceMeaning = hideSentenceMeaning;
    }

    static boolean getHideSentenceMeaning() {
        return StudyScreen.lessonScreen.hideSentenceMeaning;
    }

    static void setAutoplayAudio(boolean autoplayAudio) {
        StudyScreen.lessonScreen.autoplayAudio = autoplayAudio;
    }

    static boolean getAutoplayAudio() {
        return StudyScreen.lessonScreen.autoplayAudio;
    }

    static void setStudySessionAutoContinue(boolean autoContinue) {
        StudyScreen.lessonScreen.studySessionAutoContinue = autoContinue;
    }

    static boolean getStudySessionAutoContinue() {
        return StudyScreen.lessonScreen.studySessionAutoContinue;
    }

    static void setStudyFullscreen(boolean on) {
        StudyScreen.lessonScreen.studyFullscreen = on;
    }

    static boolean getStudyFullscreen() {
        return StudyScreen.lessonScreen.studyFullscreen;
    }

    static void setDailyLimit(int limit) {
        StudyScreen.lessonScreen.dailyLimit = limit;
    }

    static int getDailyLimit() {
        return StudyScreen.lessonScreen.dailyLimit;
    }

    static void setDailyLimitLeft(int limitLeft) {
        if (limitLeft < 1) {
            limitLeft = 0;
        }
        StudyScreen.lessonScreen.dailyLimitLeft = limitLeft;
    }

    static int getDailyLimitLeft() {
        return StudyScreen.lessonScreen.dailyLimitLeft;
    }

    static void setPlaceholder(String placeholder) {
        StudyScreen.lessonScreen.placeholder = placeholder;
    }

    static String getPlaceholder() {
        return StudyScreen.lessonScreen.placeholder;
    }

    static int getCharLimitNotes() {
        return StudyScreen.lessonScreen.charLimitNotes;
    }

    static void resetCharLimitNotes() {
        StudyScreen.lessonScreen.charLimitNotes = Main.isPrime() ? 300 : 150;
    }

    static void viewVocab(int id, String vocabKanji, String vocabKana, String meaning, String altMeanings, String altReadings, String sentence, String sentenceMeaning, String examples, String partOfSpeech, String jlptLevel, String vocabAudio, String sentenceAudio, String synonyms, String readings, String notes) {
        StudyScreen.lessonScreen.isViewingVocab = true;
        StudyScreen.lessonScreen.lessonsList = new HashMap();
        for (int i = 0; i <= 1; ++i) {
            StudyScreen.lessonScreen.lessonsList.put(i, new Lesson(id, vocabKanji, vocabKana, meaning, altMeanings, altReadings, sentence, sentenceMeaning, examples, partOfSpeech, jlptLevel, vocabAudio, sentenceAudio, synonyms, readings, notes));
        }
        StudyScreen.lessonScreen.noOfLessons = -1;
        StudyScreen.lessonScreen.lessonsCounter = -1;
        Main.finishLoadingAsset("kanjiLesson" + id + ".ttf", true);
        Main.finishLoadingAsset("examplesLesson" + id + ".ttf", true);
        StudyScreen.showOnScreen();
    }

    static void setData(int noOfLessons, int[] id, String[] vocabKanji, String[] vocabKana, String[] meaning, String[] altMeanings, String[] altReadings, String[] sentence, String[] sentenceMeaning, String[] examples, String[] partOfSpeech, String[] jlptLevel, String[] vocabAudio, String[] sentenceAudio, String[] synonyms, String[] readings, String[] notes) {
        StudyScreen.lessonScreen.isViewingVocab = false;
        StudyScreen.lessonScreen.lessonsList = new HashMap();
        for (int x = 0; x < noOfLessons; ++x) {
            StudyScreen.lessonScreen.lessonsList.put(x, new Lesson(id[x], vocabKanji[x], vocabKana[x], meaning[x], altMeanings[x], altReadings[x], sentence[x], sentenceMeaning[x], examples[x], partOfSpeech[x], jlptLevel[x], vocabAudio[x], sentenceAudio[x], synonyms[x], readings[x], notes[x]));
            StudyScreen.lessonScreen.arrLoadedAssetIds.add(id[x]);
        }
        StudyScreen.lessonScreen.noOfLessons = noOfLessons;
        StudyScreen.lessonScreen.lessonsCounter = -1;
        Main.finishLoadingAsset("kanjiLesson" + id[0] + ".ttf", true);
        Main.finishLoadingAsset("examplesLesson" + id[0] + ".ttf", true);
        if (Main.isDesktop() && StudyScreen.getStudyFullscreen()) {
            Main.enterFullscreenMode();
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                StudyScreen.showOnScreen();
            }
        });
    }

    static void archiveVocab(String vocab, int vocabID) {
        if (StudyScreen.lessonScreen.isViewingVocab) {
            lessonScreen.disposeAssets();
            Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentlySelectedPracticeListID(), BrowseScreen.getCurrentPage()));
            return;
        }
        if (StudyScreen.lessonScreen.lessonsList.containsKey(StudyScreen.lessonScreen.lessonsCounter + 1)) {
            int d = StudyScreen.lessonScreen.lessonsCounter;
            while (StudyScreen.lessonScreen.lessonsList.containsKey(d + 1)) {
                StudyScreen.lessonScreen.lessonsList.put(d, StudyScreen.lessonScreen.lessonsList.get(d + 1));
                ++d;
            }
            StudyScreen.lessonScreen.lessonsList.remove(d);
        } else {
            StudyScreen.lessonScreen.lessonsList.remove(StudyScreen.lessonScreen.lessonsCounter);
            --StudyScreen.lessonScreen.lessonsCounter;
        }
        --StudyScreen.lessonScreen.noOfLessons;
        --StudyScreen.lessonScreen.lessonsCounter;
        if (StudyScreen.lessonScreen.noOfLessons == 0) {
            lessonScreen.disposeAssets();
            Dashboard.showOnScreen();
        } else {
            lessonScreen.simulateClick(StudyScreen.lessonScreen.btnNext);
            lessonScreen.showItemArchivedToast(vocab, vocabID);
        }
    }

    static void restoreVocab(String vocab, int vocabID) {
        lessonScreen.showItemRestoredToast(vocab, vocabID);
    }

    private void showItemArchivedToast(final String vocab, final int vocabID) {
        float windowsWidth = this.stage.getViewport().getWorldWidth() * 0.8f;
        int padX = (int)(this.stage.getViewport().getWorldWidth() * 0.09f);
        int padY = Main.getPPUY() * 2;
        Label.LabelStyle labelStyle = new Label.LabelStyle(new VisLabel().getStyle());
        VisLabel s1 = new VisLabel("Item ' ");
        VisLabel s3 = new VisLabel(" ' archived.");
        VisLabel s2 = new VisLabel((CharSequence)vocab, labelStyle);
        LinkLabel ll = new LinkLabel((CharSequence)"Undo", (CharSequence)"");
        labelStyle.font = (BitmapFont)Main.getAsset("examplesLesson" + vocabID + ".ttf", BitmapFont.class, true);
        s2.setStyle(labelStyle);
        final ToastManager toastManager = new ToastManager(this.stage);
        toastManager.setAlignment(12);
        toastManager.setScreenPadding(padX, padY);
        VisTable toastContent = new VisTable(false);
        toastContent.add().colspan(3).width(windowsWidth).row();
        toastContent.add(s1).expandX().align(16).padTop(Main.getPPUY());
        toastContent.add(s2).padTop(Main.getPPUY());
        toastContent.add(s3).expandX().align(8).padTop(Main.getPPUY()).row();
        toastContent.add(ll).colspan(3).padTop((float)Main.getPPUY() * 0.5f).padBottom(Main.getPPUY()).row();
        final Toast primeToast = new Toast(toastContent);
        ll.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                toastManager.remove(primeToast);
                RestClient.archiveVocab(vocab, vocabID, false);
            }
        });
        toastManager.show(primeToast, 5.0f);
    }

    private void showItemRestoredToast(String vocab, int vocabID) {
        float windowsWidth = this.stage.getViewport().getWorldWidth() * 0.8f;
        int padX = (int)(this.stage.getViewport().getWorldWidth() * 0.09f);
        int padY = Main.getPPUY() * 2;
        Label.LabelStyle labelStyle = new Label.LabelStyle(new VisLabel().getStyle());
        VisLabel s1 = new VisLabel("Item ' ");
        VisLabel s3 = new VisLabel(" ' restored.");
        VisLabel s2 = new VisLabel((CharSequence)vocab, labelStyle);
        labelStyle.font = (BitmapFont)Main.getAsset("examplesLesson" + vocabID + ".ttf", BitmapFont.class, true);
        s2.setStyle(labelStyle);
        ToastManager toastManager = new ToastManager(this.stage);
        toastManager.setAlignment(12);
        toastManager.setScreenPadding(padX, padY);
        VisTable toastContent = new VisTable(false);
        toastContent.add().colspan(3).width(windowsWidth).row();
        toastContent.add(s1).expandX().align(16).padTop(Main.getPPUY());
        toastContent.add(s2).padTop(Main.getPPUY());
        toastContent.add(s3).expandX().align(8).padTop(Main.getPPUY()).row();
        toastContent.add().colspan(3).padBottom(Main.getPPUY()).width(windowsWidth).row();
        Toast primeToast = new Toast(toastContent);
        toastManager.show(primeToast, 2.0f);
    }

    private void disposeAssets() {
        Main.finishLoadingAssets(true);
        Iterator iterator = this.arrLoadedAssetIds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Main.disposeAsset("kanjiLesson" + i + ".ttf", true);
            Main.disposeAsset("examplesLesson" + i + ".ttf", true);
            this.arrLoadedAssetIds.removeValue(i, true);
        }
    }

    private void previousLesson() {
        this.nextLesson(true);
    }

    private void nextLesson() {
        this.nextLesson(false);
    }

    private void nextLesson(boolean previous) {
        this.lessonsCounter = !previous ? ++this.lessonsCounter : --this.lessonsCounter;
        this.currentLesson = this.lessonsList.get(this.lessonsCounter);
        this.rebuildTable();
        if (this.lessonsCounter == this.noOfLessons - 1) {
            this.btnNext.setText("Start Quiz");
        } else {
            this.btnNext.setText("Next \u2192");
        }
        this.btnPrevious.setText("\u2190 Back");
        if (this.lessonsCounter == 0) {
            this.btnPrevious.setDisabled(true);
        } else {
            this.btnPrevious.setDisabled(false);
        }
        this.styleKanji.font = (BitmapFont)Main.getAsset("kanjiLesson" + this.currentLesson.id + ".ttf", BitmapFont.class, true);
        this.sentenceStyle.font = (BitmapFont)Main.getAsset("examplesLesson" + this.currentLesson.id + ".ttf", BitmapFont.class, true);
        this.examplesStyle.font = (BitmapFont)Main.getAsset("examplesLesson" + this.currentLesson.id + ".ttf", BitmapFont.class, true);
        VisLabel lDummy = new VisLabel((CharSequence)this.currentLesson.vocabKanji, this.styleKanji);
        while (lDummy.getWidth() > this.stage.getViewport().getWorldWidth()) {
            this.styleKanji.font.getData().setScale(this.styleKanji.font.getScaleX() - 0.01f, this.styleKanji.font.getScaleY() - 0.01f);
            lDummy.pack();
        }
        this.lVocabKanji.setStyle(this.styleKanji);
        this.lSentence.setStyle(this.sentenceStyle);
        this.taExamples.setStyle(this.examplesStyle);
        this.lLessonsCounter.setText(this.lessonsCounter + 1 + "/" + this.noOfLessons);
        this.lVocabKanji.setText(this.currentLesson.vocabKanji);
        this.lVocabMeaning.setText(this.currentLesson.meaning);
        this.lSentence.setText(this.currentLesson.sentence);
        this.lPartOfSpeech.setText(this.currentLesson.partOfSpeech);
        this.lJlptLevel.setText(this.currentLesson.jlptLevel);
        this.taExamples.setText(this.currentLesson.examples);
        this.llJisho.setUrl(RestClient.createJishoLink(this.currentLesson.vocabKanji));
        this.llTatoeba.setUrl(RestClient.createTatoebaLink(this.currentLesson.vocabKanji));
        this.taNotes.setText(this.currentLesson.notes);
        if (this.taNotes.getText().length() > StudyScreen.getCharLimitNotes()) {
            this.taNotes.setText(this.taNotes.getText().substring(0, StudyScreen.getCharLimitNotes()));
        }
        this.synonymsTemp = this.currentLesson.synonyms != null ? this.currentLesson.synonyms.split(";") : new String[0];
        this.listSynonyms.setItems(this.synonymsTemp);
        this.listSynonyms.setSelectedIndex(-1);
        this.readingsTemp = this.currentLesson.readings != null ? this.currentLesson.readings.split(";") : new String[0];
        this.listReadings.setItems(this.readingsTemp);
        this.listReadings.setSelectedIndex(-1);
        if (!this.hideKana) {
            this.lVocabKana.setText(this.currentLesson.vocabKana);
        } else {
            this.lVocabKana.setText(this.placeholder);
        }
        if (!this.hideSentenceMeaning) {
            this.lSentenceMeaning.setText(this.currentLesson.sentenceMeaning);
        } else {
            this.lSentenceMeaning.setText(this.placeholder);
        }
        this.taExamples.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.spExamples.setActor(this.taExamples.createCompatibleScrollPane());
        this.btnMeaning.setChecked(true);
        this.btnExamples.setChecked(false);
        this.btnCustom.setChecked(false);
        this.lCharCounter.addAction(Actions.fadeOut(0.0f));
        this.tblTabbedPane.clearChildren();
        this.tblTabbedPane.add(this.spMeaning).expand().fill();
        this.spMeaning.setScrollY(0.0f);
        this.spMeaning.updateVisualScroll();
        if (!this.isViewingVocab) {
            if (this.autoplayAudio) {
                Main.playSound(this.currentLesson.vocabAudio, this.currentLesson.sentenceAudio);
            } else {
                Main.playSound(null, null);
            }
        } else {
            this.lLessonsCounter.setText("");
            this.btnPrevious.setText("Go Back");
            this.btnNext.setText("Save Changes");
            this.btnPrevious.setDisabled(false);
        }
    }

    private void showAddSynonymDialog() {
        Dialogs.showInputDialog(this.stage, "Add Synonym:", "", 25, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getDiacriticsChars() + "A-Za-z0-9\\' ]", "").replaceAll(" +", " ").trim().toLowerCase()).equals("")) {
                    return;
                }
                for (int x = 0; x < StudyScreen.this.synonymsTemp.length; ++x) {
                    if (!StudyScreen.this.synonymsTemp[x].equals(input)) continue;
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Synonym already exists.");
                    return;
                }
                ((StudyScreen)StudyScreen.this).currentLesson.synonyms = ((StudyScreen)StudyScreen.this).currentLesson.synonyms != null ? ((StudyScreen)StudyScreen.this).currentLesson.synonyms + input + ";" : input + ";";
                StudyScreen.access$902(StudyScreen.this, ((StudyScreen)StudyScreen.this).currentLesson.synonyms.split(";"));
                StudyScreen.this.listSynonyms.setItems(StudyScreen.this.synonymsTemp);
                StudyScreen.this.listSynonyms.setSelectedIndex(-1);
            }
        });
    }

    private void showAddReadingDialog() {
        Dialogs.showInputDialog(this.stage, "Add Reading:", "", 15, false, true, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getKanaChars() + "]+", "").trim()).equals("")) {
                    return;
                }
                for (int x = 0; x < StudyScreen.this.readingsTemp.length; ++x) {
                    if (!StudyScreen.this.readingsTemp[x].equals(input)) continue;
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Reading already exists.");
                    return;
                }
                ((StudyScreen)StudyScreen.this).currentLesson.readings = ((StudyScreen)StudyScreen.this).currentLesson.readings != null ? ((StudyScreen)StudyScreen.this).currentLesson.readings + input + ";" : input + ";";
                StudyScreen.access$1102(StudyScreen.this, ((StudyScreen)StudyScreen.this).currentLesson.readings.split(";"));
                StudyScreen.this.listReadings.setItems(StudyScreen.this.readingsTemp);
                StudyScreen.this.listReadings.setSelectedIndex(-1);
            }
        });
    }

    private void setStageListener() {
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (StudyScreen.this.stage.getKeyboardFocus() != StudyScreen.this.taNotes && StudyScreen.this.stage.getKeyboardFocus() != StudyScreen.this.taMessage) {
                    SettingsScreen.KeyBindingsHandler handler = SettingsScreen.getKeyBindingsHandler();
                    if (!handler.isWindowVisible()) {
                        if (keycode == 66) {
                            StudyScreen.this.simulateClick(StudyScreen.this.btnNext);
                        } else if (keycode == 111) {
                            StudyScreen.this.simulateClick(StudyScreen.this.btnPrevious);
                        } else if (keycode == 22) {
                            if (StudyScreen.this.btnMeaning.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnExamples);
                            } else if (StudyScreen.this.btnExamples.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnCustom);
                            } else if (StudyScreen.this.btnCustom.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnMeaning);
                            }
                        } else if (keycode == 21) {
                            if (StudyScreen.this.btnMeaning.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnCustom);
                            } else if (StudyScreen.this.btnExamples.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnMeaning);
                            } else if (StudyScreen.this.btnCustom.isChecked()) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnExamples);
                            }
                        } else if (StudyScreen.this.btnMeaning.isChecked() || StudyScreen.this.btnExamples.isChecked()) {
                            if (keycode == handler.getBind(SettingsScreen.KeyBindings.VOCAB_AUDIO)) {
                                if (handler.getBind(SettingsScreen.KeyBindings.VOCAB_AUDIO) == handler.getBind(SettingsScreen.KeyBindings.SENTENCE_AUDIO)) {
                                    Main.playSound(((StudyScreen)StudyScreen.this).currentLesson.vocabAudio, ((StudyScreen)StudyScreen.this).currentLesson.sentenceAudio);
                                } else {
                                    Main.playSound(((StudyScreen)StudyScreen.this).currentLesson.vocabAudio, null);
                                }
                            } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.SENTENCE_AUDIO)) {
                                Main.playSound(null, ((StudyScreen)StudyScreen.this).currentLesson.sentenceAudio);
                            } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.ARCHIVE)) {
                                StudyScreen.this.simulateClick(StudyScreen.this.btnArchiveVocab);
                            }
                        } else if (StudyScreen.this.btnCustom.isChecked()) {
                            switch (keycode) {
                                case 61: {
                                    if (StudyScreen.this.listSynonyms.getSelectedIndex() == -1 && ((StudyScreen)StudyScreen.this).listSynonyms.getItems().size > 0) {
                                        StudyScreen.this.listSynonyms.setSelectedIndex(0);
                                        StudyScreen.this.listReadings.setSelectedIndex(-1);
                                        break;
                                    }
                                    if (StudyScreen.this.listReadings.getSelectedIndex() == -1 && ((StudyScreen)StudyScreen.this).listReadings.getItems().size > 0) {
                                        StudyScreen.this.listReadings.setSelectedIndex(0);
                                        StudyScreen.this.listSynonyms.setSelectedIndex(-1);
                                        break;
                                    }
                                    StudyScreen.this.listSynonyms.setSelectedIndex(-1);
                                    StudyScreen.this.listReadings.setSelectedIndex(-1);
                                    break;
                                }
                                case 20: {
                                    if (StudyScreen.this.listSynonyms.getSelectedIndex() != -1) {
                                        int index = StudyScreen.this.listSynonyms.getSelectedIndex();
                                        StudyScreen.this.listReadings.setSelectedIndex(-1);
                                        StudyScreen.this.listSynonyms.setSelectedIndex(index + 1 == ((StudyScreen)StudyScreen.this).listSynonyms.getItems().size ? 0 : index + 1);
                                        break;
                                    }
                                    if (StudyScreen.this.listReadings.getSelectedIndex() == -1) break;
                                    int index = StudyScreen.this.listReadings.getSelectedIndex();
                                    StudyScreen.this.listReadings.setSelectedIndex(index + 1 == ((StudyScreen)StudyScreen.this).listReadings.getItems().size ? 0 : index + 1);
                                    break;
                                }
                                case 19: {
                                    if (StudyScreen.this.listSynonyms.getSelectedIndex() != -1) {
                                        int index = StudyScreen.this.listSynonyms.getSelectedIndex();
                                        StudyScreen.this.listReadings.setSelectedIndex(-1);
                                        StudyScreen.this.listSynonyms.setSelectedIndex(index - 1 == -1 ? ((StudyScreen)StudyScreen.this).listSynonyms.getItems().size - 1 : index - 1);
                                        break;
                                    }
                                    if (StudyScreen.this.listReadings.getSelectedIndex() == -1) break;
                                    int index = StudyScreen.this.listReadings.getSelectedIndex();
                                    StudyScreen.this.listReadings.setSelectedIndex(index - 1 == -1 ? ((StudyScreen)StudyScreen.this).listReadings.getItems().size - 1 : index - 1);
                                    break;
                                }
                                case 8: 
                                case 145: {
                                    StudyScreen.this.simulateClick(StudyScreen.this.btnSynonymsAdd);
                                    break;
                                }
                                case 9: 
                                case 146: {
                                    StudyScreen.this.simulateClick(StudyScreen.this.btnSynonymsRemove);
                                    break;
                                }
                                case 10: 
                                case 147: {
                                    StudyScreen.this.simulateClick(StudyScreen.this.btnReadingsAdd);
                                    break;
                                }
                                case 11: 
                                case 148: {
                                    StudyScreen.this.simulateClick(StudyScreen.this.btnReadingsRemove);
                                }
                            }
                        }
                    }
                } else if (keycode == 111 && StudyScreen.this.taNotes.getText().trim().equals("")) {
                    StudyScreen.this.taNotes.setText("");
                }
                return true;
            }
        });
    }

    private void setActorListeners() {
        this.taNotes.setTextFieldListener(new VisTextField.TextFieldListener(){

            @Override
            public void keyTyped(VisTextField textField, char key) {
                int cursorPos = textField.getCursorPosition();
                String content = textField.getText().replaceAll(" +", " ").replaceAll("\n+", "\n");
                if (content.length() > 0 && content.charAt(0) == '\n') {
                    content = content.replaceFirst("\n", "");
                }
                if (content.length() > StudyScreen.this.charLimitNotes) {
                    content = content.substring(0, StudyScreen.this.charLimitNotes);
                }
                ((StudyScreen)StudyScreen.this).currentLesson.notes = content;
                textField.setText(content);
                textField.setCursorPosition(cursorPos);
                StudyScreen.this.lCharCounter.addAction(Actions.fadeIn(0.0f));
                StudyScreen.this.lCharCounter.setText(content.length() + "/" + StudyScreen.this.charLimitNotes + " ");
                if (StudyScreen.this.charCounterTimer.isScheduled()) {
                    StudyScreen.this.charCounterTimer.cancel();
                }
                Timer.schedule(StudyScreen.this.charCounterTimer, 2.0f, 2.0f, 0);
            }
        });
        this.llReportProblem.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                StudyScreen.this.stage.unfocusAll();
                Gdx.input.setOnscreenKeyboardVisible(false);
                if (Main.getSupportRequestKS()) {
                    Dialogs.showOKDialog(StudyScreen.this.stage, "Sorry", "We are currently unable to receive support requests. Please check back later.");
                } else {
                    StudyScreen.this.tblTabbedPane.clearChildren();
                    StudyScreen.this.tblTabbedPane.add(StudyScreen.this.tblProblem).expand().fill();
                    StudyScreen.this.btnMeaning.setChecked(false);
                    StudyScreen.this.btnExamples.setChecked(false);
                    StudyScreen.this.btnCustom.setChecked(false);
                }
            }
        });
        this.lVocabKana.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                StudyScreen.this.hideKana = !StudyScreen.this.hideKana;
                if (!StudyScreen.this.hideKana) {
                    StudyScreen.this.lVocabKana.setText(((StudyScreen)StudyScreen.this).currentLesson.vocabKana);
                } else {
                    StudyScreen.this.lVocabKana.setText(StudyScreen.this.placeholder);
                }
            }
        });
        this.lVocabKanji.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Main.playSound(((StudyScreen)StudyScreen.this).currentLesson.vocabAudio, null);
            }
        });
        this.lSentence.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Main.playSound(null, ((StudyScreen)StudyScreen.this).currentLesson.sentenceAudio);
            }
        });
        this.lSentenceMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                StudyScreen.this.hideSentenceMeaning = !StudyScreen.this.hideSentenceMeaning;
                if (!StudyScreen.this.hideSentenceMeaning) {
                    StudyScreen.this.lSentenceMeaning.setText(((StudyScreen)StudyScreen.this).currentLesson.sentenceMeaning);
                } else {
                    StudyScreen.this.lSentenceMeaning.setText(StudyScreen.this.placeholder);
                }
            }
        });
        this.btnArchiveVocab.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!StudyScreen.this.isViewingVocab || BrowseScreen.getCurrentInterface() != BrowseScreen.BrowseInterface.ARCHIVED) {
                    if (!StudyScreen.this.itemArchivedThisSession) {
                        Dialogs.showConfirmDialog(StudyScreen.this.stage, "Archive Word", "Do you want to archive this word and exclude it from your daily reviews?\n\nArchived vocab items can be restored through Dashboard > Browse > Archived Vocab.", new Dialogs.ConfirmAdapter(){

                            @Override
                            public void yes() {
                                StudyScreen.this.itemArchivedThisSession = true;
                                RestClient.archiveVocab(((StudyScreen)StudyScreen.this).currentLesson.vocabKanji, ((StudyScreen)StudyScreen.this).currentLesson.id, true);
                            }
                        });
                    } else {
                        RestClient.archiveVocab(((StudyScreen)StudyScreen.this).currentLesson.vocabKanji, ((StudyScreen)StudyScreen.this).currentLesson.id, true);
                    }
                }
            }
        });
        this.btnPlus.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                StudyScreen.this.stage.unfocusAll();
                Gdx.input.setOnscreenKeyboardVisible(false);
                if (Main.isPrime()) {
                    if (StudyScreen.this.tblTabbedPane.getCells().get(0).getActor() != StudyScreen.this.plt) {
                        StudyScreen.this.plt.setVocab(((StudyScreen)StudyScreen.this).currentLesson.id);
                        StudyScreen.this.tblTabbedPane.clearChildren();
                        StudyScreen.this.tblTabbedPane.add(StudyScreen.this.plt).expand().fill();
                        StudyScreen.this.btnMeaning.setChecked(false);
                        StudyScreen.this.btnExamples.setChecked(false);
                        StudyScreen.this.btnCustom.setChecked(false);
                        StudyScreen.this.plt.refreshData();
                    }
                } else {
                    Dialogs.showOKDialog(StudyScreen.this.stage, "Uh-oh", "Practice Lists are a Prime feature. To learn more, click the 'Go Prime' button on the dashboard.");
                }
            }
        });
        this.btnKeybinds.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!StudyScreen.this.btnKeybinds.isDisabled()) {
                    SettingsScreen.getKeyBindingsHandler().show(StudyScreen.this.stage);
                }
            }
        });
        this.btnNext.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!StudyScreen.this.btnNext.isDisabled()) {
                    if (!StudyScreen.this.isViewingVocab) {
                        if (StudyScreen.this.lessonsCounter < StudyScreen.this.noOfLessons - 1) {
                            StudyScreen.this.nextLesson();
                        } else {
                            StudyScreen.this.disposeAssets();
                            String[] vocabKanji = new String[StudyScreen.this.noOfLessons * 2];
                            String[] vocabKana = new String[StudyScreen.this.noOfLessons * 2];
                            String[] meaning = new String[StudyScreen.this.noOfLessons * 2];
                            String[] altMeanings = new String[StudyScreen.this.noOfLessons * 2];
                            String[] altReadings = new String[StudyScreen.this.noOfLessons * 2];
                            String[] sentence = new String[StudyScreen.this.noOfLessons * 2];
                            String[] sentenceMeaning = new String[StudyScreen.this.noOfLessons * 2];
                            String[] partOfSpeech = new String[StudyScreen.this.noOfLessons * 2];
                            String[] jlptLevel = new String[StudyScreen.this.noOfLessons * 2];
                            String[] vocabAudio = new String[StudyScreen.this.noOfLessons * 2];
                            String[] sentenceAudio = new String[StudyScreen.this.noOfLessons * 2];
                            String[] synonyms = new String[StudyScreen.this.noOfLessons * 2];
                            String[] readings = new String[StudyScreen.this.noOfLessons * 2];
                            String[] notes = new String[StudyScreen.this.noOfLessons * 2];
                            int[] id = new int[StudyScreen.this.noOfLessons * 2];
                            int[] streakMeaning = new int[StudyScreen.this.noOfLessons * 2];
                            int[] streakReading = new int[StudyScreen.this.noOfLessons * 2];
                            for (int i = 0; i < StudyScreen.this.noOfLessons * 2; ++i) {
                                int j;
                                if (i < StudyScreen.this.noOfLessons) {
                                    j = i;
                                    streakMeaning[j] = 0;
                                    streakReading[j] = -1;
                                } else {
                                    j = i - StudyScreen.this.noOfLessons;
                                    streakMeaning[j] = -1;
                                    streakReading[j] = 0;
                                }
                                id[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).id;
                                vocabKanji[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).vocabKanji;
                                vocabKana[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).vocabKana;
                                meaning[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).meaning;
                                altMeanings[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).altMeanings;
                                altReadings[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).altReadings;
                                sentence[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).sentence;
                                sentenceMeaning[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).sentenceMeaning;
                                partOfSpeech[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).partOfSpeech;
                                jlptLevel[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).jlptLevel;
                                vocabAudio[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).vocabAudio;
                                sentenceAudio[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).sentenceAudio;
                                synonyms[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).synonyms;
                                readings[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).readings;
                                notes[i] = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)j))).notes;
                            }
                            ReviewScreen.setData(true, -1, id, streakMeaning, streakReading, vocabKanji, vocabKana, meaning, altMeanings, altReadings, sentence, sentenceMeaning, partOfSpeech, jlptLevel, vocabAudio, sentenceAudio, synonyms, readings, notes);
                        }
                    } else {
                        String notesOriginal;
                        String synonyms = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).synonyms != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).synonyms : "";
                        String readings = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).readings != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).readings : "";
                        String notes = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).notes != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).notes : "";
                        String synonymsOriginal = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).synonyms != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).synonyms : "";
                        String readingsOriginal = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).readings != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).readings : "";
                        String string = notesOriginal = ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).notes != null ? ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).notes : "";
                        if (!(synonyms.equals(synonymsOriginal) && readings.equals(readingsOriginal) && notes.equals(notesOriginal))) {
                            synonyms = synonyms.equals("") ? null : synonyms;
                            readings = readings.equals("") ? null : readings;
                            notes = notes.equals("") ? null : notes;
                            ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).synonyms = synonyms;
                            ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).readings = readings;
                            ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)1))).notes = notes;
                            RestClient.updateVocab(null, ((Lesson)((StudyScreen)StudyScreen.this).lessonsList.get((Object)Integer.valueOf((int)0))).id, -1, -1, synonyms, readings, notes, false);
                        }
                    }
                }
            }
        });
        this.btnPrevious.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!StudyScreen.this.btnPrevious.isDisabled()) {
                    if (!StudyScreen.this.isViewingVocab) {
                        if (StudyScreen.this.lessonsCounter > 0) {
                            StudyScreen.this.previousLesson();
                        }
                    } else {
                        StudyScreen.this.disposeAssets();
                        Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentlySelectedPracticeListID(), BrowseScreen.getCurrentPage()));
                    }
                }
            }
        });
        this.btnMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(StudyScreen.this.btnMeaning.isChecked() || StudyScreen.this.btnExamples.isChecked() || StudyScreen.this.btnCustom.isChecked())) {
                    StudyScreen.this.btnMeaning.setChecked(true);
                } else {
                    StudyScreen.this.btnExamples.setChecked(false);
                    StudyScreen.this.btnCustom.setChecked(false);
                    StudyScreen.this.tblTabbedPane.clearChildren();
                    StudyScreen.this.tblTabbedPane.add(StudyScreen.this.spMeaning).expand().fill();
                }
            }
        });
        this.btnExamples.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(StudyScreen.this.btnMeaning.isChecked() || StudyScreen.this.btnExamples.isChecked() || StudyScreen.this.btnCustom.isChecked())) {
                    StudyScreen.this.btnExamples.setChecked(true);
                } else {
                    StudyScreen.this.btnMeaning.setChecked(false);
                    StudyScreen.this.btnCustom.setChecked(false);
                    StudyScreen.this.tblTabbedPane.clearChildren();
                    StudyScreen.this.tblTabbedPane.add(StudyScreen.this.tblExamples).expand().fill();
                }
            }
        });
        this.btnCustom.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(StudyScreen.this.btnMeaning.isChecked() || StudyScreen.this.btnExamples.isChecked() || StudyScreen.this.btnCustom.isChecked())) {
                    StudyScreen.this.btnCustom.setChecked(true);
                } else {
                    StudyScreen.this.btnMeaning.setChecked(false);
                    StudyScreen.this.btnExamples.setChecked(false);
                    StudyScreen.this.tblTabbedPane.clearChildren();
                    StudyScreen.this.tblTabbedPane.add(StudyScreen.this.tblCustom).expand().fill();
                }
            }
        });
        this.btnSynonymsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (StudyScreen.this.synonymsTemp.length < 5) {
                    if (Hints.getHintAddSynonym()) {
                        Hints.showAddSynonymHint(StudyScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                StudyScreen.this.showAddSynonymDialog();
                            }
                        });
                    } else {
                        StudyScreen.this.showAddSynonymDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Sorry, only 5 Synonyms allowed.");
                }
            }
        });
        this.btnSynonymsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (StudyScreen.this.listSynonyms.getSelectedIndex() > -1) {
                    ((StudyScreen)StudyScreen.this).currentLesson.synonyms = ((StudyScreen)StudyScreen.this).currentLesson.synonyms.replace(StudyScreen.this.listSynonyms.getSelected() + ";", "");
                    if (((StudyScreen)StudyScreen.this).currentLesson.synonyms.equals("")) {
                        ((StudyScreen)StudyScreen.this).currentLesson.synonyms = null;
                    }
                    if (((StudyScreen)StudyScreen.this).currentLesson.synonyms != null) {
                        StudyScreen.access$902(StudyScreen.this, ((StudyScreen)StudyScreen.this).currentLesson.synonyms.split(";"));
                    } else {
                        StudyScreen.access$902(StudyScreen.this, new String[0]);
                    }
                    StudyScreen.this.listSynonyms.setItems(StudyScreen.this.synonymsTemp);
                    StudyScreen.this.listSynonyms.setSelectedIndex(-1);
                }
            }
        });
        this.btnReadingsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (StudyScreen.this.readingsTemp.length < 5) {
                    if (Hints.getHintAddReading()) {
                        Hints.showAddReadingHint(StudyScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                StudyScreen.this.showAddReadingDialog();
                            }
                        });
                    } else {
                        StudyScreen.this.showAddReadingDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(StudyScreen.this.stage, "Sorry, only 5 Readings allowed.");
                }
            }
        });
        this.btnReadingsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (StudyScreen.this.listReadings.getSelectedIndex() > -1) {
                    ((StudyScreen)StudyScreen.this).currentLesson.readings = ((StudyScreen)StudyScreen.this).currentLesson.readings.replace(StudyScreen.this.listReadings.getSelected() + ";", "");
                    if (((StudyScreen)StudyScreen.this).currentLesson.readings.equals("")) {
                        ((StudyScreen)StudyScreen.this).currentLesson.readings = null;
                    }
                    if (((StudyScreen)StudyScreen.this).currentLesson.readings != null) {
                        StudyScreen.access$1102(StudyScreen.this, ((StudyScreen)StudyScreen.this).currentLesson.readings.split(";"));
                    } else {
                        StudyScreen.access$1102(StudyScreen.this, new String[0]);
                    }
                    StudyScreen.this.listReadings.setItems(StudyScreen.this.readingsTemp);
                    StudyScreen.this.listReadings.setSelectedIndex(-1);
                }
            }
        });
    }

    private void simulateClick(Actor actor) {
        InputEvent ie = new InputEvent();
        ie.setType(InputEvent.Type.touchDown);
        actor.fire(ie);
        ie.setType(InputEvent.Type.touchUp);
        actor.fire(ie);
    }

    static /* synthetic */ String[] access$902(StudyScreen x0, String[] x1) {
        x0.synonymsTemp = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1102(StudyScreen x0, String[] x1) {
        x0.readingsTemp = x1;
        return x1;
    }

    private static class Lesson {
        final int id;
        final String vocabKanji;
        final String vocabKana;
        final String meaning;
        final String altMeanings;
        final String altReadings;
        final String sentence;
        final String sentenceMeaning;
        final String examples;
        final String partOfSpeech;
        final String jlptLevel;
        final String vocabAudio;
        final String sentenceAudio;
        String synonyms;
        String readings;
        String notes;

        Lesson(int id, String vocabKanji, String vocabKana, String meaning, String altMeanings, String altReadings, String sentence, String sentenceMeaning, String examples, String partOfSpeech, String jlptLevel, String vocabAudio, String sentenceAudio, String synonyms, String readings, String notes) {
            this.id = id;
            this.vocabKanji = vocabKanji;
            this.vocabKana = vocabKana;
            this.meaning = meaning;
            this.altMeanings = altMeanings;
            this.altReadings = altReadings;
            this.sentence = sentence;
            this.sentenceMeaning = sentenceMeaning;
            this.examples = examples;
            this.partOfSpeech = partOfSpeech;
            this.jlptLevel = jlptLevel;
            this.vocabAudio = vocabAudio;
            this.sentenceAudio = sentenceAudio;
            this.synonyms = synonyms;
            this.readings = readings;
            this.notes = notes;
            Main.loadTTFtoAssetManager("kanjiLesson" + this.id + ".ttf", (int)lessonScreen.kanjiFontSize, this.vocabKanji, true, 1, 3);
            Main.loadTTFtoAssetManager("examplesLesson" + this.id + ".ttf", Main.getPPUY(), this.sentence + this.examples, true);
        }
    }

    static class StudyMode {
        final int studyMode;
        final boolean includeWK;
        final boolean includeKanaOnly;
        final boolean is10k;
        final boolean isWK;
        final boolean isKanaOnly;
        final boolean isJlpt5;
        final boolean isJlpt4;
        final boolean isJlpt3;
        final boolean isJlpt2;
        final boolean isJlpt1;
        String sStudyMode;

        StudyMode(int studyMode, boolean includeWK, boolean includeKanaOnly) {
            this.studyMode = studyMode;
            this.includeWK = includeWK;
            this.includeKanaOnly = includeKanaOnly;
            int[] jlpt5Valid = new int[]{3, 9, 15, 21, 27, 33, 39, 45, 51, 57, 63, 69, 75, 81, 87, 93};
            int[] jlpt4Valid = new int[]{6, 9, 18, 21, 30, 33, 42, 45, 54, 57, 66, 69, 78, 81, 90, 93};
            int[] jlpt3Valid = new int[]{12, 15, 18, 21, 36, 39, 42, 45, 60, 63, 66, 69, 84, 87, 90, 93};
            int[] jlpt2Valid = new int[]{24, 27, 30, 33, 36, 39, 42, 45, 72, 75, 78, 81, 84, 87, 90, 93};
            int[] jlpt1Valid = new int[]{48, 51, 54, 57, 60, 63, 66, 69, 72, 75, 78, 81, 84, 87, 90, 93};
            this.is10k = studyMode == 1;
            this.isWK = studyMode == 2;
            this.isKanaOnly = studyMode == 100;
            this.isJlpt5 = this.contains(jlpt5Valid, studyMode);
            this.isJlpt4 = this.contains(jlpt4Valid, studyMode);
            this.isJlpt3 = this.contains(jlpt3Valid, studyMode);
            this.isJlpt2 = this.contains(jlpt2Valid, studyMode);
            this.isJlpt1 = this.contains(jlpt1Valid, studyMode);
            if (this.is10k) {
                this.sStudyMode = "10k ";
                this.sStudyMode = includeWK && includeKanaOnly ? this.sStudyMode + "(including WaniKani and kana-only vocabulary)" : (includeWK ? this.sStudyMode + "(including WaniKani but excluding kana-only vocabulary)" : (includeKanaOnly ? this.sStudyMode + "(including kana-only but excluding WaniKani vocabulary)" : this.sStudyMode + "(excluding WaniKani and kana-only vocabulary)"));
            } else if (this.isWK) {
                this.sStudyMode = "WaniKani ";
                this.sStudyMode = includeKanaOnly ? this.sStudyMode + "(including kana-only vocabulary)" : this.sStudyMode + "(excluding kana-only vocabulary)";
            } else if (this.isKanaOnly) {
                this.sStudyMode = "Kana-Only";
            } else {
                this.sStudyMode = "JLPT ";
                if (this.isJlpt5) {
                    this.sStudyMode = this.sStudyMode + "N5 ";
                }
                if (this.isJlpt4) {
                    this.sStudyMode = this.sStudyMode + "N4 ";
                }
                if (this.isJlpt3) {
                    this.sStudyMode = this.sStudyMode + "N3 ";
                }
                if (this.isJlpt2) {
                    this.sStudyMode = this.sStudyMode + "N2 ";
                }
                if (this.isJlpt1) {
                    this.sStudyMode = this.sStudyMode + "N1 ";
                }
                this.sStudyMode = includeWK && includeKanaOnly ? this.sStudyMode + "(including WaniKani and kana-only vocabulary)" : (includeWK ? this.sStudyMode + "(including WaniKani but excluding kana-only vocabulary)" : (includeKanaOnly ? this.sStudyMode + "(including kana-only but excluding WaniKani vocabulary)" : this.sStudyMode + "(excluding WaniKani and kana-only vocabulary)"));
            }
        }

        private boolean contains(int[] array, int key) {
            for (int aJlpt5Valid : array) {
                if (aJlpt5Valid != key) continue;
                return true;
            }
            return false;
        }
    }
}

