/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.spinner.IntSpinnerModel;
import com.kotcrab.vis.ui.widget.spinner.Spinner;
import com.torii.srs.Dialogs;
import com.torii.srs.DownloadManager;
import com.torii.srs.FileManager;
import com.torii.srs.Hints;
import com.torii.srs.LoadingScreen;
import com.torii.srs.LoginScreen;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.ReviewScreen;
import com.torii.srs.StudyScreen;
import com.torii.srs.widget.List;
import com.torii.srs.widget.TextField;
import com.torii.srs.widget.TopMenu;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class SettingsScreen
implements Screen {
    static final int DEFAULT_TIMEZONE_ID = -127;
    private static SettingsScreen settingsScreen;
    private KeyBindingsHandler keyBindings;
    private Screen parentScreen;
    private Stage stage;
    private VisTable table;
    private VisTable tblTabs;
    private VisTable tblCurrentTab;
    private VisTable tblAccount;
    private VisTable tblLessons;
    private VisTable tblReviews;
    private VisTable tblFonts;
    private VisTable tblFontsContent;
    private VisTable tblFontsInstalled;
    private VisTable tblFontsGetMore;
    private VisLabel lVacationModeInfo;
    private VisLabel lCurrentStudyMode;
    private VisLabel lAudioReviewModeInfo;
    private VisLabel lFontName;
    private VisLabel lFontSize;
    private VisTextButton btnAccount;
    private VisTextButton btnLessons;
    private VisTextButton btnReviews;
    private VisTextButton btnUpdateEmail;
    private VisTextButton btnUpdatePw;
    private VisTextButton btnLogOut;
    private VisTextButton btnResetStudyMode;
    private VisTextButton btnResetAccount;
    private VisTextButton btnDeleteAccount;
    private VisTextButton btnVacation;
    private VisTextButton btnFontRandomization;
    private VisTextButton btnFontsInstalled;
    private VisTextButton btnFontsGetMore;
    private VisTextButton btnRemoveFont;
    private VisTextButton btnInstallFont;
    private VisTextButton btnFontLeft;
    private VisTextButton btnFontRight;
    private TextField tfEmail;
    private TextField tfNewPw;
    private TextField tfNewPwConfirm;
    private TextField tfStudyPlaceholder;
    private TextField tfReviewPlaceholder;
    private VisSelectBox<String> sbTimezone;
    private VisCheckBox cbStudyHideKana;
    private VisCheckBox cbStudyHideSentenceMeaning;
    private VisCheckBox cbStudyAutoplayAudio;
    private VisCheckBox cbStudyAutoContinue;
    private VisCheckBox cbStudyFullscreen;
    private VisCheckBox cbFontRandomization;
    private VisCheckBox cbReviewHideKana;
    private VisCheckBox cbReviewShowKanaAfterAnswer;
    private VisCheckBox cbReviewAutoplayAudio;
    private VisCheckBox cbReviewAutoplayAudioSentence;
    private VisCheckBox cbLightningMode;
    private VisCheckBox cbHyperjumpMode;
    private VisCheckBox cbReviewAutoExpand;
    private VisCheckBox cbReviewAutoContinue;
    private VisCheckBox cbAndroidNotifications;
    private VisCheckBox cbReviewFullscreen;
    private VisCheckBox cbReviewAudioStart;
    private VisCheckBox cbReviewAudioAfterAlways;
    private VisCheckBox cbReviewAudioAfterIncorrect;
    private VisSelectBox<String> sbAudioMode;
    private IntSpinnerModel spinnerModel;
    private List listFontsInstalled;
    private String sVacationModeInfo;
    private String sVacationModeDate;
    private Font[] fonts;
    private Image img;
    private int timezone;
    private int getMoreFontsIndex;
    private VisScrollPane spp;
    private VisLabel lPreview;

    SettingsScreen() {
        settingsScreen = this;
        this.keyBindings = new KeyBindingsHandler();
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.buildUI();
    }

    private void buildUI() {
        float space = Main.getPPUY();
        this.sVacationModeInfo = "If you are going to be away from Torii for a prolonged period of time, you can freeze the spaced repetition system until you deactivate the vacation mode.\n[CR]Note:[] This feature does not extend your Prime subscription.\nYour last vacation was deactivated on ";
        this.sVacationModeDate = "[CR]N/A[].";
        this.table = new VisTable();
        this.tblTabs = new VisTable();
        this.tblCurrentTab = new VisTable();
        this.tblAccount = new VisTable();
        this.tblLessons = new VisTable();
        this.tblReviews = new VisTable();
        this.tblFonts = new VisTable(false);
        this.tblFontsContent = new VisTable(false);
        this.tblFontsInstalled = new VisTable(false);
        this.tblFontsGetMore = new VisTable(false);
        this.lVacationModeInfo = new VisLabel((CharSequence)(this.sVacationModeInfo + this.sVacationModeDate), Main.labelStyleX0p5);
        this.lCurrentStudyMode = new VisLabel((CharSequence)"Current Mode: N/A", Main.labelStyleX0p5);
        this.lAudioReviewModeInfo = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        this.lFontName = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.lFontSize = new VisLabel((CharSequence)"0", Main.labelStyleX1);
        this.lPreview = new VisLabel((CharSequence)"", Main.labelStyleX1p25);
        this.btnAccount = new VisTextButton("Account", Main.btnStyleToggleWhite);
        this.btnLessons = new VisTextButton("Lessons", Main.btnStyleToggleWhite);
        this.btnReviews = new VisTextButton("Reviews", Main.btnStyleToggleWhite);
        this.btnFontsInstalled = new VisTextButton("Installed", Main.btnStyleToggleWhite);
        this.btnFontsGetMore = new VisTextButton("Get more", Main.btnStyleToggleWhite);
        this.btnLogOut = new VisTextButton("Log out", Main.btnStyleX1);
        this.btnResetStudyMode = new VisTextButton("Switch Study Modes", Main.btnStyleX1);
        this.btnResetAccount = new VisTextButton("Reset Account", Main.btnStyleX1);
        this.btnDeleteAccount = new VisTextButton("Delete Account", Main.btnStyleX1);
        this.btnUpdateEmail = new VisTextButton("Update Email", Main.btnStyleX1);
        this.btnUpdatePw = new VisTextButton("Update Password", Main.btnStyleX1);
        this.btnVacation = new VisTextButton("N/A", Main.btnStyleX1);
        this.btnFontRandomization = new VisTextButton("Manage Fonts", Main.btnStyleX1);
        this.btnRemoveFont = new VisTextButton("Remove Font", Main.btnStyleX1p25);
        this.btnInstallFont = new VisTextButton("", Main.btnStyleX1p25);
        this.btnFontLeft = new VisTextButton("\u2190", Main.btnStyleX1p25);
        this.btnFontRight = new VisTextButton("\u2192", Main.btnStyleX1p25);
        this.cbStudyHideKana = new VisCheckBox(" Hide Kana");
        this.cbStudyHideSentenceMeaning = new VisCheckBox(" Hide Context Sentence Translation");
        this.cbStudyAutoplayAudio = new VisCheckBox(" Autoplay Audio");
        this.cbStudyAutoContinue = new VisCheckBox(" Session Auto Continue");
        this.cbStudyFullscreen = new VisCheckBox(" Fullscreen Study");
        this.cbFontRandomization = new VisCheckBox(" Font Randomizer");
        this.cbReviewHideKana = new VisCheckBox(" Hide Kana");
        this.cbReviewShowKanaAfterAnswer = new VisCheckBox(" Reveal after answer");
        this.cbReviewAutoplayAudio = new VisCheckBox(" Autoplay Vocab Audio");
        this.cbReviewAutoplayAudioSentence = new VisCheckBox(" Autoplay Sentence Audio");
        this.cbReviewAudioStart = new VisCheckBox(" Play at start");
        this.cbReviewAudioAfterAlways = new VisCheckBox(" Play after answer");
        this.cbReviewAudioAfterIncorrect = new VisCheckBox(" Play after incorrect answer");
        this.cbLightningMode = new VisCheckBox(" Lightning Mode");
        this.cbHyperjumpMode = new VisCheckBox(" Hyperjump Mode");
        this.cbReviewAutoExpand = new VisCheckBox(" Auto-expand vocab details pane after wrong answer");
        this.cbReviewAutoContinue = new VisCheckBox(" Session Auto Continue");
        this.cbAndroidNotifications = new VisCheckBox(" Study Reminders (Android Only)");
        this.cbReviewFullscreen = new VisCheckBox(" Fullscreen Review");
        this.tfEmail = new TextField("", Main.tfStyleX1);
        this.tfNewPw = new TextField("", Main.tfStyleX1);
        this.tfNewPwConfirm = new TextField("", Main.tfStyleX1);
        this.tfStudyPlaceholder = new TextField("", Main.tfStyleX1);
        this.tfReviewPlaceholder = new TextField("", Main.tfStyleX1);
        this.listFontsInstalled = new List();
        this.img = new Image();
        this.spp = new VisScrollPane((Actor)this.img);
        this.sbTimezone = new VisSelectBox();
        this.sbAudioMode = new VisSelectBox();
        this.sbTimezone.setItems((String[])new String[]{"< Default Timezone >", "(UTC-12) International Date Line West", "(UTC-11) Coordinated Universal Time-11", "(UTC-10) Hawaii, Aleutian Islands", "(UTC-9) Alaska", "(UTC-8) Pacific Time (US & Canada)", "(UTC-7) Mountain Time (US & Canada)", "(UTC-6) Central Time (US & Canada), Mexico City", "(UTC-5) Eastern Time (US & Canada), Bogota, Lima", "(UTC-4) Atlantic Time (Canada), Caracas, Georgetown", "(UTC-3) Brasilia, Buenos Aires, Greenland", "(UTC-2) Coordinated Universal Time-02", "(UTC-1) Azores, Cabo Verde Islands", "(UTC+0) Dublin, London, Lisbon", "(UTC+1) Vienna, Berlin, Brussels, Madrid, Paris, Rome", "(UTC+2) Athens, South Africa", "(UTC+3) Baghdad, Istanbul, Moscow, St. Petersburg", "(UTC+4) Abu Dhabi, Baku, Tbilisi", "(UTC+5) Ekaterinburg, Islamabad, Karachi", "(UTC+6) Astana, Dhaka", "(UTC+7) Bangkok, Hanoi, Jakarta", "(UTC+8) Beijing, Singapore, Hong Kong", "(UTC+9) Tokyo, Seoul, Osaka, Sapporo", "(UTC+10) Eastern Australia, Guam", "(UTC+11) Magadan, Solomon Islands, New Caledonia", "(UTC+12) Aukland, Wellington, Fiji", "(UTC+13) Samoa", "(UTC+14) Kiritimati Island"});
        this.sbAudioMode.setItems((String[])new String[]{"Off", "Alternate", "Exclusive"});
        this.sbTimezone.setMaxListCount(10);
        this.cbReviewAutoExpand.getLabelCell().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.cbReviewAutoExpand.getLabel().setWrap(true);
        String spinnerLabelText = "Daily Lessons Limit";
        this.spinnerModel = new IntSpinnerModel(10, 5, 50, 5);
        Spinner spinner = new Spinner(spinnerLabelText, this.spinnerModel);
        spinner.getTextField().setStyle(Main.tfStyleX1);
        VisLabel l = (VisLabel)spinner.getCells().get(0).getActor();
        l.getStyle().fontColor = Main.FONT;
        float checkboxSize = Main.getPPUY();
        this.cbStudyHideKana.getImageStackCell().size(checkboxSize);
        this.cbStudyHideSentenceMeaning.getImageStackCell().size(checkboxSize);
        this.cbStudyAutoplayAudio.getImageStackCell().size(checkboxSize);
        this.cbStudyAutoContinue.getImageStackCell().size(checkboxSize);
        this.cbStudyFullscreen.getImageStackCell().size(checkboxSize);
        this.cbFontRandomization.getImageStackCell().size(checkboxSize);
        this.cbReviewHideKana.getImageStackCell().size(checkboxSize);
        this.cbReviewShowKanaAfterAnswer.getImageStackCell().size(checkboxSize);
        this.cbReviewAutoplayAudio.getImageStackCell().size(checkboxSize);
        this.cbReviewAutoplayAudioSentence.getImageStackCell().size(checkboxSize);
        this.cbReviewAudioStart.getImageStackCell().size(checkboxSize);
        this.cbReviewAudioAfterAlways.getImageStackCell().size(checkboxSize);
        this.cbReviewAudioAfterIncorrect.getImageStackCell().size(checkboxSize);
        this.cbLightningMode.getImageStackCell().size(checkboxSize);
        this.cbHyperjumpMode.getImageStackCell().size(checkboxSize);
        this.cbReviewAutoExpand.getImageStackCell().size(checkboxSize);
        this.cbReviewAutoContinue.getImageStackCell().size(checkboxSize);
        this.cbAndroidNotifications.getImageStackCell().size(checkboxSize);
        this.cbReviewFullscreen.getImageStackCell().size(checkboxSize);
        this.tfStudyPlaceholder.setAlignment(1);
        this.tfReviewPlaceholder.setAlignment(1);
        this.lPreview.setAlignment(1);
        spinner.getTextField().setAlignment(1);
        this.sbTimezone.setAlignment(1);
        this.sbAudioMode.setAlignment(1);
        this.btnAccount.setFocusBorderEnabled(false);
        this.btnLessons.setFocusBorderEnabled(false);
        this.btnReviews.setFocusBorderEnabled(false);
        this.btnFontsInstalled.setFocusBorderEnabled(false);
        this.btnFontsGetMore.setFocusBorderEnabled(false);
        this.btnUpdateEmail.setFocusBorderEnabled(false);
        this.btnUpdatePw.setFocusBorderEnabled(false);
        this.btnLogOut.setFocusBorderEnabled(false);
        this.btnResetStudyMode.setFocusBorderEnabled(false);
        this.btnResetAccount.setFocusBorderEnabled(false);
        this.btnDeleteAccount.setFocusBorderEnabled(false);
        this.btnVacation.setFocusBorderEnabled(false);
        this.btnFontRandomization.setFocusBorderEnabled(false);
        this.btnRemoveFont.setFocusBorderEnabled(false);
        this.btnInstallFont.setFocusBorderEnabled(false);
        this.btnFontLeft.setFocusBorderEnabled(false);
        this.btnFontRight.setFocusBorderEnabled(false);
        this.cbStudyHideKana.setFocusBorderEnabled(false);
        this.cbStudyHideSentenceMeaning.setFocusBorderEnabled(false);
        this.cbStudyAutoplayAudio.setFocusBorderEnabled(false);
        this.cbStudyAutoContinue.setFocusBorderEnabled(false);
        this.cbStudyFullscreen.setFocusBorderEnabled(false);
        this.cbFontRandomization.setFocusBorderEnabled(false);
        this.cbReviewHideKana.setFocusBorderEnabled(false);
        this.cbReviewShowKanaAfterAnswer.setFocusBorderEnabled(false);
        this.cbReviewAutoplayAudio.setFocusBorderEnabled(false);
        this.cbReviewAutoplayAudioSentence.setFocusBorderEnabled(false);
        this.cbReviewAudioStart.setFocusBorderEnabled(false);
        this.cbReviewAudioAfterAlways.setFocusBorderEnabled(false);
        this.cbReviewAudioAfterIncorrect.setFocusBorderEnabled(false);
        this.cbLightningMode.setFocusBorderEnabled(false);
        this.cbHyperjumpMode.setFocusBorderEnabled(false);
        this.cbReviewAutoExpand.setFocusBorderEnabled(false);
        this.cbReviewAutoContinue.setFocusBorderEnabled(false);
        this.cbAndroidNotifications.setFocusBorderEnabled(false);
        this.cbReviewFullscreen.setFocusBorderEnabled(false);
        this.tfNewPw.setPasswordMode(true);
        this.tfNewPwConfirm.setPasswordMode(true);
        this.lVacationModeInfo.setWrap(true);
        this.lCurrentStudyMode.setWrap(true);
        this.lAudioReviewModeInfo.setWrap(true);
        this.btnAccount.setChecked(true);
        this.img.setScaling(Scaling.none);
        this.tblTabs.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
        this.listFontsInstalled.setBackgroundColor(Main.TRANSPARENT);
        this.tblTabs.defaults().height(2 * Main.getPPUY());
        this.tblTabs.add(this.btnAccount);
        this.tblTabs.add(this.btnLessons);
        this.tblTabs.add(this.btnReviews);
        VisTable tblAccountButtons = new VisTable(false);
        tblAccountButtons.defaults().fillX().uniformX().align(1);
        tblAccountButtons.add(this.btnLogOut).colspan(2).padBottom(space).row();
        tblAccountButtons.add(this.btnResetAccount).padRight(space);
        tblAccountButtons.add(this.btnDeleteAccount);
        VisTable tblAccountChild = new VisTable(false);
        tblAccountChild.align(10);
        tblAccountChild.defaults().align(8);
        tblAccountChild.add(new VisLabel((CharSequence)"Email", Main.labelStyleX1)).row();
        tblAccountChild.add(this.tfEmail).expandX().fillX().padBottom(space).row();
        tblAccountChild.add(this.btnUpdateEmail).row();
        tblAccountChild.addSeparator().padTop(space).padBottom(0.5f * space);
        tblAccountChild.add(new VisLabel((CharSequence)"New Password", Main.labelStyleX1)).row();
        tblAccountChild.add(this.tfNewPw).expandX().fillX().padBottom(space).row();
        tblAccountChild.add(new VisLabel((CharSequence)"Confirm New Password", Main.labelStyleX1)).row();
        tblAccountChild.add(this.tfNewPwConfirm).expandX().fillX().padBottom(space).row();
        tblAccountChild.add(this.btnUpdatePw).row();
        tblAccountChild.addSeparator().padTop(space).padBottom(0.5f * space);
        tblAccountChild.add(new VisLabel((CharSequence)"Vacation Mode", Main.labelStyleX1)).row();
        tblAccountChild.add(this.lVacationModeInfo).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.5f * space).padBottom(space).row();
        tblAccountChild.add(this.btnVacation).row();
        tblAccountChild.addSeparator().padTop(space).padBottom(space);
        tblAccountChild.add(tblAccountButtons).expandX().fillX().row();
        VisScrollPane spAccount = new VisScrollPane((Actor)tblAccountChild);
        spAccount.setScrollingDisabled(true, false);
        spAccount.setFadeScrollBars(false);
        this.tblAccount.align(10);
        this.tblAccount.defaults().align(8);
        this.tblAccount.add(new VisLabel((CharSequence)"Account Settings", Main.labelStyleX2)).row();
        this.tblAccount.add(spAccount).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(space);
        VisTable tblLessonsChild1 = new VisTable(false);
        tblLessonsChild1.add(new VisLabel((CharSequence)"Placeholder", Main.labelStyleX1)).padRight(10.0f);
        tblLessonsChild1.add(this.tfStudyPlaceholder);
        VisLabel dummy = new VisLabel(spinnerLabelText);
        VisLabel lLessonsInfo1 = new VisLabel((CharSequence)"The maximum number of new words you can learn per day. Choose any value between 5 and 50.", Main.labelStyleX0p5);
        VisLabel lLessonsInfo2 = new VisLabel((CharSequence)"Furigana or the English context sentence will be replaced by the text in the 'Placeholder' field. Leave it empty if you don't want anything shown.", Main.labelStyleX0p5);
        VisLabel lLessonsInfo5 = new VisLabel((CharSequence)"Changing your Study Mode does not affect your daily lesson limit or overall progress. You can switch between modes anytime and as often as you like.", Main.labelStyleX0p5);
        lLessonsInfo1.setWrap(true);
        lLessonsInfo2.setWrap(true);
        lLessonsInfo5.setWrap(true);
        VisTable tblLessonsContainer = new VisTable(false);
        tblLessonsContainer.align(10);
        tblLessonsContainer.defaults().align(8);
        tblLessonsContainer.add(spinner).width(dummy.getWidth() * 1.5f).height(space).padBottom(0.5f * space).row();
        tblLessonsContainer.add(lLessonsInfo1).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(0.5f * space).row();
        tblLessonsContainer.add(this.sbTimezone).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(space).row();
        tblLessonsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblLessonsContainer.add(this.cbStudyFullscreen).row();
        tblLessonsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblLessonsContainer.add(this.cbStudyAutoContinue).row();
        tblLessonsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblLessonsContainer.add(this.cbStudyAutoplayAudio).row();
        tblLessonsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblLessonsContainer.add(this.cbStudyHideKana).padBottom(0.5f * space).row();
        tblLessonsContainer.add(this.cbStudyHideSentenceMeaning).padBottom(0.5f * space).row();
        tblLessonsContainer.add(tblLessonsChild1).row();
        tblLessonsContainer.add(lLessonsInfo2).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.5f * space).row();
        tblLessonsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblLessonsContainer.add(new VisLabel((CharSequence)"Study Mode", Main.labelStyleX1)).padBottom(0.5f * space).row();
        tblLessonsContainer.add(lLessonsInfo5).width(this.stage.getViewport().getWorldWidth() * 0.95f).row();
        tblLessonsContainer.add(this.lCurrentStudyMode).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(space).row();
        tblLessonsContainer.add(this.btnResetStudyMode).padBottom(space).row();
        VisScrollPane spLessons = new VisScrollPane((Actor)tblLessonsContainer);
        spLessons.setScrollingDisabled(true, false);
        spLessons.setFadeScrollBars(false);
        this.tblLessons.align(10);
        this.tblLessons.defaults().align(8);
        this.tblLessons.add(new VisLabel((CharSequence)"Study Settings", Main.labelStyleX2)).padBottom(0.5f * space).row();
        this.tblLessons.add(spLessons).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(space);
        VisTable tblReviewsChild1 = new VisTable();
        tblReviewsChild1.add(new VisLabel((CharSequence)"Placeholder", Main.labelStyleX1)).padRight(10.0f);
        tblReviewsChild1.add(this.tfReviewPlaceholder);
        VisLabel lReviewsInfo1 = new VisLabel((CharSequence)"Furigana will be replaced by the text in the 'Placeholder' field. Leave it empty if you don't want anything shown.", Main.labelStyleX0p5);
        VisLabel lReviewsInfo3 = new VisLabel((CharSequence)"Automatically move to the next review item after a correct answer.", Main.labelStyleX0p5);
        VisLabel lReviewsInfo4 = new VisLabel((CharSequence)"Your input is checked as you type. If it matches the expected answer, it's submitted automatically.", Main.labelStyleX0p5);
        VisLabel lReviewsInfo5 = new VisLabel((CharSequence)"You'll receive a phone notification whenever new reviews become available.", Main.labelStyleX0p5);
        lReviewsInfo1.setWrap(true);
        lReviewsInfo3.setWrap(true);
        lReviewsInfo4.setWrap(true);
        lReviewsInfo5.setWrap(true);
        VisTable tblReviewsContainer = new VisTable(false);
        tblReviewsContainer.align(10);
        tblReviewsContainer.defaults().align(8);
        tblReviewsContainer.add(this.cbFontRandomization).padBottom(0.5f * space).row();
        tblReviewsContainer.add(this.btnFontRandomization).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbLightningMode).row();
        tblReviewsContainer.add(lReviewsInfo3).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.25f * space).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbHyperjumpMode).row();
        tblReviewsContainer.add(lReviewsInfo4).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.25f * space).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbReviewFullscreen).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbReviewAutoExpand).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbReviewAutoContinue).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbReviewAutoplayAudio).row();
        tblReviewsContainer.add(this.cbReviewAutoplayAudioSentence).padBottom(0.5f * space).row();
        tblReviewsContainer.add(this.cbReviewAudioStart).padLeft(space).padBottom(0.5f * space).row();
        tblReviewsContainer.add(this.cbReviewAudioAfterAlways).padLeft(space).row();
        tblReviewsContainer.add(this.cbReviewAudioAfterIncorrect).padLeft(space).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbReviewHideKana).padBottom(0.5f * space).row();
        tblReviewsContainer.add(this.cbReviewShowKanaAfterAnswer).padLeft(space).padBottom(space).row();
        tblReviewsContainer.add(tblReviewsChild1).row();
        tblReviewsContainer.add(lReviewsInfo1).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.5f * space).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(this.cbAndroidNotifications).row();
        tblReviewsContainer.add(lReviewsInfo5).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(0.25f * space).row();
        tblReviewsContainer.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        tblReviewsContainer.add(new VisLabel((CharSequence)"Audio Review Mode", Main.labelStyleX1)).padBottom(0.5f * space).row();
        tblReviewsContainer.add(new VisLabel((CharSequence)"Only applies to JP \u2192 EN.", Main.labelStyleX0p5)).row();
        tblReviewsContainer.add(this.lAudioReviewModeInfo).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(space).row();
        tblReviewsContainer.add(this.sbAudioMode).row();
        VisScrollPane spReviews = new VisScrollPane((Actor)tblReviewsContainer);
        spReviews.setScrollingDisabled(true, false);
        spReviews.setFadeScrollBars(false);
        this.tblReviews.align(10);
        this.tblReviews.defaults().align(8);
        this.tblReviews.add(new VisLabel((CharSequence)"Review Settings", Main.labelStyleX2)).padBottom(0.5f * space).row();
        this.tblReviews.add(spReviews).width(this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(Main.getPPUY());
        VisTable tblTabsFonts = new VisTable();
        VisTable tblFontGetMoreHeader = new VisTable(false);
        VisTable tblFontGetMoreFooter = new VisTable(false);
        tblTabsFonts.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
        tblTabsFonts.defaults().height(1.5f * space).uniformX().fillX();
        tblTabsFonts.add(this.btnFontsInstalled);
        tblTabsFonts.add(this.btnFontsGetMore);
        this.tblFontsInstalled.add(this.listFontsInstalled).expand().fill().align(2).padTop(0.5f * space).padBottom(0.5f * space).row();
        this.tblFontsInstalled.add(this.btnRemoveFont).padBottom(0.5f * space).row();
        tblFontGetMoreHeader.add(this.lFontName);
        tblFontGetMoreHeader.add(" [");
        tblFontGetMoreHeader.add(this.lFontSize);
        tblFontGetMoreHeader.add(" MB]");
        tblFontGetMoreFooter.add(this.btnFontLeft).padRight(space);
        tblFontGetMoreFooter.add(this.btnInstallFont).padRight(space);
        tblFontGetMoreFooter.add(this.btnFontRight);
        this.tblFontsGetMore.defaults().expandX().fillX();
        this.tblFontsGetMore.add(tblFontGetMoreHeader).padTop(0.5f * space).padBottom(0.5f * space).row();
        this.tblFontsGetMore.add(tblFontGetMoreFooter).padBottom(0.5f * space).row();
        this.tblFontsGetMore.add(this.spp).expandY().fillY().row();
        this.tblFontsContent.setBackground(Main.uiSkin.newDrawable("white", Main.UI_BG_LIGHTER));
        this.tblFontsContent.add(this.tblFontsInstalled).expand().fill();
        this.tblFonts.align(10);
        this.tblFonts.defaults().align(8);
        this.tblFonts.add(tblTabsFonts).width(this.stage.getViewport().getWorldWidth() * 0.95f).row();
        this.tblFonts.add(this.tblFontsContent).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY().padBottom(Main.getPPUY()).row();
        TopMenu topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                SettingsScreen.this.home();
            }
        };
        this.table.setFillParent(true);
        this.table.align(2);
        this.table.add(topMenu.getTable()).width(this.stage.getViewport().getWorldWidth()).row();
        this.table.add(this.tblCurrentTab).width(this.stage.getViewport().getWorldWidth() * 0.95f).fill().expand().padTop(Main.getPPUY()).row();
        this.table.add(this.tblTabs).width(this.stage.getViewport().getWorldWidth()).row();
        this.stage.clear();
        this.setActorListeners();
        this.stage.addActor(this.table);
    }

    private void home() {
        String studyPlaceholder = this.tfStudyPlaceholder.getText().trim();
        String reviewPlaceholder = this.tfReviewPlaceholder.getText().trim();
        if (studyPlaceholder.length() > 5) {
            studyPlaceholder = studyPlaceholder.substring(0, 5);
        }
        if (reviewPlaceholder.length() > 5) {
            reviewPlaceholder = reviewPlaceholder.substring(0, 5);
        }
        StudyScreen.setPlaceholder(studyPlaceholder);
        ReviewScreen.setPlaceholder(reviewPlaceholder);
        this.cbFontRandomization.setChecked(ReviewScreen.getRandomizeFont());
        Main.setNewScreen(this.parentScreen);
        this.parentScreen = null;
        int newDailyLimit = this.spinnerModel.getValue();
        int currentDailyLimit = StudyScreen.getDailyLimit();
        int newTimezone = this.sbTimezone.getSelectedIndex();
        int n = newTimezone = newTimezone == 0 ? -127 : newTimezone - 13;
        if (newDailyLimit != currentDailyLimit || newTimezone != this.timezone) {
            RestClient.updateStudyLimitAndTimezone(newDailyLimit, newTimezone);
        }
        RestClient.updateSettings();
    }

    private void updateCurrentFont() {
        final int curIndex = this.getMoreFontsIndex;
        this.lPreview.setText("Loading preview...");
        this.img.setDrawable(null);
        if (this.spp.hasParent()) {
            this.tblFontsGetMore.getCell(this.spp).setActor(this.lPreview);
        }
        this.lFontName.setText(this.fonts[this.getMoreFontsIndex].name);
        this.lFontName.pack();
        this.lFontSize.setText(this.fonts[this.getMoreFontsIndex].getSizeInMB() + "");
        this.lFontSize.pack();
        String fileNameImg = this.fonts[this.getMoreFontsIndex].getFilenameWithoutSuffix() + ".png";
        final FileHandle fh = FileManager.getTempFile(fileNameImg);
        if (this.listFontsInstalled.getItems().contains(this.fonts[this.getMoreFontsIndex].fileName, false)) {
            this.btnInstallFont.setText("Installed");
            this.btnInstallFont.setDisabled(true);
        } else {
            this.btnInstallFont.setText("Download");
            this.btnInstallFont.setDisabled(false);
        }
        if (!fh.exists()) {
            new DownloadManager(RestClient.getFontsHost() + fileNameImg, fh){

                @Override
                void success() {
                    if (curIndex == SettingsScreen.this.getMoreFontsIndex) {
                        SettingsScreen.this.img.setDrawable(new SpriteDrawable(new Sprite(new Texture(fh))));
                        if (!SettingsScreen.this.spp.hasParent()) {
                            SettingsScreen.this.tblFontsGetMore.getCell(SettingsScreen.this.lPreview).setActor(SettingsScreen.this.spp);
                        }
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                SettingsScreen.this.spp.setScrollPercentX(0.5f);
                                SettingsScreen.this.spp.setScrollPercentY(0.0f);
                                SettingsScreen.this.spp.updateVisualScroll();
                            }
                        });
                    }
                }

                @Override
                void failed() {
                    if (curIndex == SettingsScreen.this.getMoreFontsIndex) {
                        SettingsScreen.this.lPreview.setText("No preview available.");
                    }
                }
            }.download(true);
        } else {
            Texture tex = new Texture(fh);
            this.img.setDrawable(new SpriteDrawable(new Sprite(tex)));
            this.tblFontsGetMore.getCell(this.lPreview).setActor(this.spp);
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    SettingsScreen.this.spp.setScrollPercentX(0.5f);
                    SettingsScreen.this.spp.setScrollPercentY(0.0f);
                    SettingsScreen.this.spp.updateVisualScroll();
                }
            });
        }
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        if (Main.getPreviousScreen() != LoadingScreen.loadingScreen && Main.getPreviousScreen() != settingsScreen) {
            this.buildUI();
            Hints.showSettingsHint(this.stage);
        }
        this.tfEmail.setText(Main.getUserEmail());
        this.tfStudyPlaceholder.setText(StudyScreen.getPlaceholder());
        this.tfReviewPlaceholder.setText(ReviewScreen.getPlaceholder());
        this.tfNewPw.clearText();
        this.tfNewPwConfirm.clearText();
        this.cbStudyHideKana.setChecked(StudyScreen.getHideKana());
        this.cbStudyHideSentenceMeaning.setChecked(StudyScreen.getHideSentenceMeaning());
        this.cbStudyAutoplayAudio.setChecked(StudyScreen.getAutoplayAudio());
        this.cbStudyAutoContinue.setChecked(StudyScreen.getStudySessionAutoContinue());
        this.cbStudyFullscreen.setChecked(StudyScreen.getStudyFullscreen());
        this.cbReviewHideKana.setChecked(ReviewScreen.getHideKana());
        this.cbReviewShowKanaAfterAnswer.setChecked(ReviewScreen.getShowKanaAfterAnswer());
        this.cbReviewShowKanaAfterAnswer.setDisabled(!this.cbReviewHideKana.isChecked());
        this.cbReviewAutoplayAudio.setChecked(ReviewScreen.getAutoplayAudio());
        this.cbReviewAutoplayAudioSentence.setChecked(ReviewScreen.getAutoplayAudioSentence());
        this.cbReviewAudioStart.setChecked(ReviewScreen.getPlayAudioAtStart());
        this.cbReviewAudioAfterAlways.setChecked(ReviewScreen.getPlayAudioAtEnd());
        this.cbReviewAudioAfterIncorrect.setChecked(ReviewScreen.getPlayAudioOnWrongAnswer());
        if (!this.cbReviewAutoplayAudio.isChecked()) {
            this.cbReviewAutoplayAudioSentence.setDisabled(true);
            this.cbReviewAudioStart.setDisabled(true);
            this.cbReviewAudioAfterAlways.setDisabled(true);
            this.cbReviewAudioAfterIncorrect.setDisabled(true);
        }
        this.cbLightningMode.setChecked(ReviewScreen.getLightningMode());
        this.cbHyperjumpMode.setChecked(ReviewScreen.getHyperjumpMode());
        this.cbReviewAutoExpand.setChecked(ReviewScreen.getAutoExpandDetailsAfterWrongAnswer());
        this.cbReviewAutoContinue.setChecked(ReviewScreen.getReviewSessionAutoContinue());
        this.cbAndroidNotifications.setChecked(Main.getAndroidNotifications());
        this.cbReviewFullscreen.setChecked(ReviewScreen.getReviewFullscreen());
        this.lCurrentStudyMode.setText("[CR]Current Mode:[] " + StudyScreen.getStudyMode().sStudyMode);
        this.sbAudioMode.setSelectedIndex(ReviewScreen.getAudioReviewMode());
        this.updateAudioReviewModeInfo();
        this.spinnerModel.setValue(StudyScreen.getDailyLimit());
        this.sbTimezone.setSelectedIndex(this.timezone == -127 ? 0 : this.timezone + 13);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    static void refreshDailyLimitValue() {
        SettingsScreen.settingsScreen.spinnerModel.setValue(StudyScreen.getDailyLimit());
        SettingsScreen.settingsScreen.sbTimezone.setSelectedIndex(SettingsScreen.settingsScreen.timezone == -127 ? 0 : SettingsScreen.settingsScreen.timezone + 13);
    }

    static void showOnScreen() {
        if (SettingsScreen.settingsScreen.parentScreen == null) {
            SettingsScreen.settingsScreen.parentScreen = Main.getCurrentScreen();
        }
        Main.setNewScreen(settingsScreen);
        if (Main.getLastVacationEnded() != null) {
            SettingsScreen.settingsScreen.sVacationModeDate = "[CR]" + new SimpleDateFormat("MMMM dd, yyyy", Locale.ENGLISH).format(Main.getLastVacationEnded().getTime()) + "[].";
            SettingsScreen.settingsScreen.lVacationModeInfo.setText(SettingsScreen.settingsScreen.sVacationModeInfo + SettingsScreen.settingsScreen.sVacationModeDate);
        }
        String sVacationModeButtonText = Main.isVacationModeActivated() ? "Deactivate Vacation Mode" : "Activate Vacation Mode";
        SettingsScreen.settingsScreen.btnVacation.setText(sVacationModeButtonText);
        SettingsScreen.settingsScreen.cbFontRandomization.setChecked(ReviewScreen.getRandomizeFont());
        SettingsScreen.settingsScreen.btnFontRandomization.setDisabled(!SettingsScreen.settingsScreen.cbFontRandomization.isChecked());
        SettingsScreen.settingsScreen.btnAccount.setChecked(true);
        SettingsScreen.settingsScreen.btnLessons.setChecked(false);
        SettingsScreen.settingsScreen.btnReviews.setChecked(false);
        SettingsScreen.settingsScreen.tblCurrentTab.clearChildren();
        SettingsScreen.settingsScreen.tblCurrentTab.add(SettingsScreen.settingsScreen.tblAccount).expand().fill();
    }

    static KeyBindingsHandler getKeyBindingsHandler() {
        return SettingsScreen.settingsScreen.keyBindings;
    }

    static void setTimezone(int timezone) {
        SettingsScreen.settingsScreen.timezone = timezone;
    }

    static void setInstallableFontsList(Font[] fonts) {
        SettingsScreen.settingsScreen.fonts = fonts;
        SettingsScreen.settingsScreen.getMoreFontsIndex = 0;
        settingsScreen.updateCurrentFont();
    }

    private void updateAudioReviewModeInfo() {
        switch (this.sbAudioMode.getSelectedIndex()) {
            case 0: {
                this.lAudioReviewModeInfo.setText("[CR]Off:[] No audio reviews.");
                break;
            }
            case 1: {
                this.lAudioReviewModeInfo.setText("[CR]Alternate:[] Switch between regular and audio reviews randomly.");
                break;
            }
            case 2: {
                this.lAudioReviewModeInfo.setText("[CR]Exclusive:[] Audio reviews only.");
            }
        }
    }

    private void updateInstalledFontsList() {
        Array<String> arInstalledFonts = FileManager.getFontFiles();
        if (!arInstalledFonts.isEmpty()) {
            this.listFontsInstalled.setItems(arInstalledFonts.toArray(String.class));
        } else {
            this.listFontsInstalled.setItems(new String[]{"No fonts installed. Click on 'Get more'."});
        }
        this.listFontsInstalled.setSelectedIndex(-1);
        this.btnRemoveFont.setDisabled(true);
    }

    private void setActorListeners() {
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111 || keycode == 4) {
                    if (SettingsScreen.this.tblFonts.hasParent()) {
                        SettingsScreen.this.simulateClick(SettingsScreen.this.btnReviews);
                    } else {
                        SettingsScreen.this.home();
                    }
                }
                return true;
            }
        });
        this.listFontsInstalled.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (FileManager.getFontFile(SettingsScreen.this.listFontsInstalled.getSelected()).exists()) {
                    SettingsScreen.this.btnRemoveFont.setDisabled(false);
                } else {
                    SettingsScreen.this.btnRemoveFont.setDisabled(true);
                }
            }
        });
        this.btnAccount.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(SettingsScreen.this.btnAccount.isChecked() || SettingsScreen.this.btnLessons.isChecked() || SettingsScreen.this.btnReviews.isChecked())) {
                    SettingsScreen.this.btnAccount.setChecked(true);
                } else {
                    SettingsScreen.this.btnLessons.setChecked(false);
                    SettingsScreen.this.btnReviews.setChecked(false);
                    SettingsScreen.this.tblCurrentTab.clearChildren();
                    SettingsScreen.this.tblCurrentTab.add(SettingsScreen.this.tblAccount).expand().fill();
                }
            }
        });
        this.btnLessons.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(SettingsScreen.this.btnAccount.isChecked() || SettingsScreen.this.btnLessons.isChecked() || SettingsScreen.this.btnReviews.isChecked())) {
                    SettingsScreen.this.btnLessons.setChecked(true);
                } else {
                    SettingsScreen.this.btnAccount.setChecked(false);
                    SettingsScreen.this.btnReviews.setChecked(false);
                    SettingsScreen.this.tblCurrentTab.clearChildren();
                    SettingsScreen.this.tblCurrentTab.add(SettingsScreen.this.tblLessons).expand().fill();
                }
            }
        });
        this.btnReviews.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(SettingsScreen.this.btnAccount.isChecked() || SettingsScreen.this.btnLessons.isChecked() || SettingsScreen.this.btnReviews.isChecked())) {
                    SettingsScreen.this.btnReviews.setChecked(true);
                } else {
                    SettingsScreen.this.btnAccount.setChecked(false);
                    SettingsScreen.this.btnLessons.setChecked(false);
                    SettingsScreen.this.tblCurrentTab.clearChildren();
                    SettingsScreen.this.tblCurrentTab.add(SettingsScreen.this.tblReviews).expand().fill();
                }
            }
        });
        this.btnUpdateEmail.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                final String newEmail = SettingsScreen.this.tfEmail.getText().trim();
                final String currentEmail = Main.getUserEmail();
                if (!currentEmail.equals(newEmail)) {
                    Dialogs.showInputDialog(SettingsScreen.this.stage, "Update Email", "Password", -1, true, false, new Dialogs.InputAdapter(){

                        @Override
                        public void finished(String input) {
                            if ((input = Main.generatePasswordHash(input)).equals(Main.getUserPassword())) {
                                RestClient.updateEmail(currentEmail, newEmail);
                            } else {
                                Dialogs.showErrorDialog(SettingsScreen.this.stage, "Password incorrect.");
                            }
                        }
                    });
                }
            }
        });
        this.btnUpdatePw.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                final String newPw = SettingsScreen.this.tfNewPw.getText();
                String newPwConfirm = SettingsScreen.this.tfNewPwConfirm.getText();
                if (!newPw.equals("") && !newPwConfirm.equals("")) {
                    if (newPw.equals(newPwConfirm)) {
                        if (LoginScreen.passwordRequirementsFulfilled(newPw)) {
                            Dialogs.showInputDialog(SettingsScreen.this.stage, "Update Password", "Current Password", -1, true, false, new Dialogs.InputAdapter(){

                                @Override
                                public void finished(String input) {
                                    if ((input = Main.generatePasswordHash(input)).equals(Main.getUserPassword())) {
                                        String newPwHash = Main.generatePasswordHash(newPw);
                                        RestClient.updatePassword(newPwHash);
                                    } else {
                                        Dialogs.showErrorDialog(SettingsScreen.this.stage, "Password incorrect.");
                                    }
                                }
                            });
                        } else {
                            SettingsScreen.this.tfNewPw.clearText();
                            SettingsScreen.this.tfNewPwConfirm.clearText();
                            Dialogs.showOKDialog(SettingsScreen.this.stage, "Password requirements", "6-32 characters\nAt least 1 letter\nAt least 1 number");
                        }
                    } else {
                        SettingsScreen.this.tfNewPw.clearText();
                        SettingsScreen.this.tfNewPwConfirm.clearText();
                        Dialogs.showErrorDialog(SettingsScreen.this.stage, "Passwords do not match.");
                    }
                }
            }
        });
        this.btnLogOut.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                LoginScreen.logOut(SettingsScreen.this.stage);
            }
        });
        this.btnResetStudyMode.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showConfirmDialog(SettingsScreen.this.stage, "Study Mode Selection", "Switch to another Study Mode right now?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.resetStudyMode();
                    }
                });
            }
        });
        this.btnResetAccount.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showConfirmDialog(SettingsScreen.this.stage, "Careful", "All your progress will be wiped and you will have to start from scratch.\nAre you sure you want to reset your account?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        Dialogs.showInputDialog(SettingsScreen.this.stage, "Reset Account", "Password", -1, true, false, new Dialogs.InputAdapter(){

                            @Override
                            public void finished(String input) {
                                if ((input = Main.generatePasswordHash(input)).equals(Main.getUserPassword())) {
                                    RestClient.resetAccount();
                                } else {
                                    Dialogs.showErrorDialog(SettingsScreen.this.stage, "Password incorrect.");
                                }
                            }
                        });
                    }
                });
            }
        });
        this.btnDeleteAccount.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showConfirmDialog(SettingsScreen.this.stage, "Caution", "Deleted accounts cannot be recovered!\n\nIf you're experiencing technical issues, you can always get in touch with the support:\n[CR]support@torii-srs.com[]\n\nAre you sure you want to [CR]permanently[] delete your account?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        Dialogs.showInputDialog(SettingsScreen.this.stage, "Delete Account", "Password", -1, true, false, new Dialogs.InputAdapter(){

                            @Override
                            public void finished(String input) {
                                if ((input = Main.generatePasswordHash(input)).equals(Main.getUserPassword())) {
                                    RestClient.deleteAccount();
                                } else {
                                    Dialogs.showErrorDialog(SettingsScreen.this.stage, "Password incorrect.");
                                }
                            }
                        });
                    }
                });
            }
        });
        this.btnVacation.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RestClient.updateVacationMode(!Main.isVacationModeActivated());
            }
        });
        this.btnFontRandomization.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!SettingsScreen.this.btnFontRandomization.isDisabled()) {
                    SettingsScreen.this.btnAccount.setChecked(false);
                    SettingsScreen.this.btnLessons.setChecked(false);
                    SettingsScreen.this.btnReviews.setChecked(false);
                    SettingsScreen.this.tblFontsContent.clearChildren();
                    SettingsScreen.this.tblFontsContent.add(SettingsScreen.this.tblFontsInstalled).expand().fill();
                    SettingsScreen.this.tblCurrentTab.clearChildren();
                    SettingsScreen.this.tblCurrentTab.add(SettingsScreen.this.tblFonts).expand().fill();
                    SettingsScreen.this.btnFontsInstalled.setChecked(true);
                    SettingsScreen.this.btnFontsGetMore.setChecked(false);
                    SettingsScreen.this.updateInstalledFontsList();
                }
            }
        });
        this.btnFontsInstalled.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!SettingsScreen.this.btnFontsInstalled.isChecked() && !SettingsScreen.this.btnFontsGetMore.isChecked()) {
                    SettingsScreen.this.btnFontsInstalled.setChecked(true);
                } else {
                    SettingsScreen.this.btnFontsGetMore.setChecked(false);
                    SettingsScreen.this.tblFontsContent.clearChildren();
                    SettingsScreen.this.tblFontsContent.add(SettingsScreen.this.tblFontsInstalled).expand().fill();
                    SettingsScreen.this.updateInstalledFontsList();
                }
            }
        });
        this.btnFontsGetMore.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!SettingsScreen.this.btnFontsInstalled.isChecked() && !SettingsScreen.this.btnFontsGetMore.isChecked()) {
                    SettingsScreen.this.btnFontsGetMore.setChecked(true);
                } else {
                    SettingsScreen.this.btnFontsInstalled.setChecked(false);
                    SettingsScreen.this.tblFontsContent.clearChildren();
                    SettingsScreen.this.tblFontsContent.add(SettingsScreen.this.tblFontsGetMore).expand().fill();
                    RestClient.getFonts();
                }
            }
        });
        this.btnRemoveFont.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!SettingsScreen.this.btnRemoveFont.isDisabled()) {
                    Dialogs.showConfirmDialog(SettingsScreen.this.stage, "Remove Font", "Do you want to remove [CR]" + SettingsScreen.this.listFontsInstalled.getSelected() + "[] from your hard drive?", new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            FileManager.deleteFontFile(SettingsScreen.this.listFontsInstalled.getSelected());
                            SettingsScreen.this.updateInstalledFontsList();
                        }
                    });
                }
            }
        });
        this.btnInstallFont.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!SettingsScreen.this.btnInstallFont.isDisabled()) {
                    FileHandle fh = FileManager.getFontFile(((SettingsScreen)SettingsScreen.this).fonts[((SettingsScreen)SettingsScreen.this).getMoreFontsIndex].fileName);
                    new DownloadManager(RestClient.getFontsHost() + ((SettingsScreen)SettingsScreen.this).fonts[((SettingsScreen)SettingsScreen.this).getMoreFontsIndex].fileName, fh){

                        @Override
                        void success() {
                            SettingsScreen.this.updateInstalledFontsList();
                            SettingsScreen.this.updateCurrentFont();
                        }
                    }.download();
                }
            }
        });
        this.btnFontLeft.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (SettingsScreen.this.getMoreFontsIndex == 0) {
                    SettingsScreen.this.getMoreFontsIndex = SettingsScreen.this.fonts.length - 1;
                } else {
                    SettingsScreen.this.getMoreFontsIndex--;
                }
                SettingsScreen.this.updateCurrentFont();
            }
        });
        this.btnFontRight.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (SettingsScreen.this.getMoreFontsIndex == SettingsScreen.this.fonts.length - 1) {
                    SettingsScreen.this.getMoreFontsIndex = 0;
                } else {
                    SettingsScreen.this.getMoreFontsIndex++;
                }
                SettingsScreen.this.updateCurrentFont();
            }
        });
        this.cbStudyHideKana.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StudyScreen.setHideKana(SettingsScreen.this.cbStudyHideKana.isChecked());
            }
        });
        this.cbStudyHideSentenceMeaning.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StudyScreen.setHideSentenceMeaning(SettingsScreen.this.cbStudyHideSentenceMeaning.isChecked());
            }
        });
        this.cbStudyAutoplayAudio.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StudyScreen.setAutoplayAudio(SettingsScreen.this.cbStudyAutoplayAudio.isChecked());
            }
        });
        this.cbStudyAutoContinue.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StudyScreen.setStudySessionAutoContinue(SettingsScreen.this.cbStudyAutoContinue.isChecked());
            }
        });
        this.cbStudyFullscreen.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                StudyScreen.setStudyFullscreen(SettingsScreen.this.cbStudyFullscreen.isChecked());
            }
        });
        this.cbFontRandomization.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setRandomizeFont(SettingsScreen.this.cbFontRandomization.isChecked());
            }
        });
        this.cbFontRandomization.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SettingsScreen.this.btnFontRandomization.setDisabled(!SettingsScreen.this.cbFontRandomization.isChecked());
            }
        });
        this.cbReviewHideKana.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                SettingsScreen.this.cbReviewShowKanaAfterAnswer.setDisabled(!SettingsScreen.this.cbReviewHideKana.isChecked());
                ReviewScreen.setHideKana(SettingsScreen.this.cbReviewHideKana.isChecked());
            }
        });
        this.cbReviewShowKanaAfterAnswer.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setShowKanaAfterAnswer(SettingsScreen.this.cbReviewShowKanaAfterAnswer.isChecked());
            }
        });
        this.cbReviewAutoplayAudio.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!SettingsScreen.this.cbReviewAutoplayAudio.isChecked()) {
                    SettingsScreen.this.cbReviewAutoplayAudioSentence.setDisabled(true);
                    SettingsScreen.this.cbReviewAudioStart.setDisabled(true);
                    SettingsScreen.this.cbReviewAudioAfterAlways.setDisabled(true);
                    SettingsScreen.this.cbReviewAudioAfterIncorrect.setDisabled(true);
                } else {
                    SettingsScreen.this.cbReviewAutoplayAudioSentence.setDisabled(false);
                    SettingsScreen.this.cbReviewAudioStart.setDisabled(false);
                    SettingsScreen.this.cbReviewAudioAfterAlways.setDisabled(false);
                    SettingsScreen.this.cbReviewAudioAfterIncorrect.setDisabled(false);
                }
                ReviewScreen.setAutoplayAudio(SettingsScreen.this.cbReviewAutoplayAudio.isChecked());
            }
        });
        this.cbReviewAutoplayAudioSentence.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setAutoplayAudioSentence(SettingsScreen.this.cbReviewAutoplayAudioSentence.isChecked());
            }
        });
        this.cbReviewAudioStart.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setPlayAudioAtStart(SettingsScreen.this.cbReviewAudioStart.isChecked());
            }
        });
        this.cbReviewAudioAfterAlways.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (SettingsScreen.this.cbReviewAudioAfterAlways.isChecked()) {
                    SettingsScreen.this.cbReviewAudioAfterIncorrect.setChecked(false);
                }
                ReviewScreen.setPlayAudioAtEnd(SettingsScreen.this.cbReviewAudioAfterAlways.isChecked());
            }
        });
        this.cbReviewAudioAfterIncorrect.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (SettingsScreen.this.cbReviewAudioAfterIncorrect.isChecked()) {
                    SettingsScreen.this.cbReviewAudioAfterAlways.setChecked(false);
                }
                ReviewScreen.setPlayAudioOnWrongAnswer(SettingsScreen.this.cbReviewAudioAfterIncorrect.isChecked());
            }
        });
        this.cbLightningMode.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setLightningMode(SettingsScreen.this.cbLightningMode.isChecked());
            }
        });
        this.cbHyperjumpMode.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setHyperjumpMode(SettingsScreen.this.cbHyperjumpMode.isChecked());
            }
        });
        this.cbReviewAutoExpand.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setAutoExpandDetailsAfterWrongAnswer(SettingsScreen.this.cbReviewAutoExpand.isChecked());
            }
        });
        this.cbReviewAutoContinue.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setReviewSessionAutoContinue(SettingsScreen.this.cbReviewAutoContinue.isChecked());
            }
        });
        this.cbAndroidNotifications.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                Main.setAndroidNotifications(SettingsScreen.this.cbAndroidNotifications.isChecked());
            }
        });
        this.cbReviewFullscreen.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setReviewFullscreen(SettingsScreen.this.cbReviewFullscreen.isChecked());
            }
        });
        this.sbAudioMode.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ReviewScreen.setAudioReviewMode(SettingsScreen.this.sbAudioMode.getSelectedIndex());
                SettingsScreen.this.updateAudioReviewModeInfo();
            }
        });
    }

    private void simulateClick(Actor button) {
        InputEvent ie = new InputEvent();
        ie.setType(InputEvent.Type.touchDown);
        button.fire(ie);
        ie.setType(InputEvent.Type.touchUp);
        button.fire(ie);
    }

    static class Font {
        final String name;
        final String fileName;
        final long size;

        Font(String name, String fileName, long size) {
            this.name = name;
            this.fileName = fileName;
            this.size = size;
        }

        String getFilenameWithoutSuffix() {
            return this.fileName.substring(0, this.fileName.lastIndexOf("."));
        }

        float getSizeInMB() {
            float number = (float)this.size / 1000.0f / 1000.0f;
            int scale = 2;
            int pow = 10;
            for (int i = 1; i < scale; ++i) {
                pow *= 10;
            }
            float tmp = number * (float)pow;
            return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
        }
    }

    class KeyBindingsHandler {
        private final int defConfirm = 66;
        private final int defIgnore = 111;
        private final int defInfo = -1;
        private final int defFurigana = 61;
        private final int defSkip = -1;
        private final int defVocabAudio = -1;
        private final int defSentenceAudio = -1;
        private final int defFont = 62;
        private final int defArchive = -1;
        private final float space = Main.getPPUY();
        private VisWindow winKeybinds = new VisWindow("Key Bindings", true);
        private VisTable tblContent;
        private VisTable tblBindings;
        private VisTable tblButtons;
        private VisScrollPane scroll;
        private LinkLabel llConfirm;
        private LinkLabel llIgnore;
        private LinkLabel llInfo;
        private LinkLabel llFurigana;
        private LinkLabel llSkip;
        private LinkLabel llVocabAudio;
        private LinkLabel llSentenceAudio;
        private LinkLabel llFont;
        private LinkLabel llArchive;
        private int confirm;
        private int ignore;
        private int info;
        private int furigana;
        private int skip;
        private int vocabAudio;
        private int sentenceAudio;
        private int font;
        private int archive;
        private boolean waitingForButton = false;
        private KeyBindings whichKey;

        private boolean isModifierKeyPressed() {
            return Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130) || Gdx.input.isKeyPressed(57) || Gdx.input.isKeyPressed(58);
        }

        private boolean isAllowedKey(int keycode) {
            return keycode >= 7 && keycode <= 16 || keycode >= 144 && keycode <= 153 || keycode >= 29 && keycode <= 54 || keycode >= 131 && keycode <= 142;
        }

        boolean validateKey(int keycode) {
            if (keycode >= 7 && keycode <= 16 || keycode >= 144 && keycode <= 153 || keycode >= 29 && keycode <= 54) {
                return this.isModifierKeyPressed();
            }
            return true;
        }

        KeyBindingsHandler() {
            this.winKeybinds.padTop((float)Main.getPPUY() * 1.5f);
            this.winKeybinds.setCenterOnAdd(true);
            this.winKeybinds.setModal(true);
            this.winKeybinds.setMovable(false);
            this.buildUI();
        }

        void buildUI() {
            LinkLabel.LinkLabelStyle llStyle = new LinkLabel.LinkLabelStyle(new LinkLabel("").getStyle());
            llStyle.fontColor = Color.WHITE;
            llStyle.underline = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
            this.tblContent = new VisTable(false);
            this.tblContent.align(2);
            VisTextButton btnSave = new VisTextButton("Save Changes", Main.btnStyleX1p25);
            VisTextButton btnDefaults = new VisTextButton("Defaults", Main.btnStyleX1p25);
            btnSave.setFocusBorderEnabled(false);
            btnDefaults.setFocusBorderEnabled(false);
            btnSave.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    RestClient.updateKeyBindings();
                    KeyBindingsHandler.this.waitingForButton = false;
                    KeyBindingsHandler.this.whichKey = null;
                    KeyBindingsHandler.this.winKeybinds.remove();
                }
            });
            btnDefaults.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    KeyBindingsHandler.this.waitingForButton = false;
                    KeyBindingsHandler.this.whichKey = null;
                    Dialogs.showConfirmDialog(Main.getCurrentStage(), "Reset Key Bindings", "Are you sure you want to reset all key bindings to their default value?", new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            KeyBindingsHandler.this.setBindings(66, 111, -1, 61, -1, -1, -1, 62, -1);
                        }
                    });
                }
            });
            this.tblButtons = new VisTable(false);
            this.tblButtons.defaults().uniformX().fillX();
            this.tblButtons.add(btnSave).padRight(this.space);
            this.tblButtons.add(btnDefaults);
            VisTable tblConfirm = new VisTable(false);
            this.llConfirm = new LinkLabel((CharSequence)"", llStyle);
            this.llConfirm.setTouchable(Touchable.disabled);
            tblConfirm.align(8);
            tblConfirm.add("Press ");
            tblConfirm.add(this.llConfirm);
            tblConfirm.add(" .").row();
            VisTable tblIgnore = new VisTable(false);
            this.llIgnore = new LinkLabel((CharSequence)"", llStyle);
            this.llIgnore.setTouchable(Touchable.disabled);
            tblIgnore.align(8);
            tblIgnore.add("Press ");
            tblIgnore.add(this.llIgnore);
            tblIgnore.add(" after submitting your answer.").row();
            VisTable tblInfo = new VisTable(false);
            this.llInfo = new LinkLabel((CharSequence)"", llStyle);
            tblInfo.align(8);
            tblInfo.add("Press ");
            tblInfo.add(this.llInfo);
            tblInfo.add(" after submitting your answer.").row();
            VisTable tblFurigana = new VisTable(false);
            this.llFurigana = new LinkLabel((CharSequence)"", llStyle);
            this.llFurigana.setTouchable(Touchable.disabled);
            tblFurigana.align(8);
            tblFurigana.add("Press ");
            tblFurigana.add(this.llFurigana);
            tblFurigana.add(" or [TB]left-click[] on the Furigana.").row();
            VisTable tblSkip = new VisTable(false);
            this.llSkip = new LinkLabel((CharSequence)"", llStyle);
            tblSkip.align(8);
            tblSkip.add("Press ");
            tblSkip.add(this.llSkip);
            tblSkip.add(" .").row();
            VisTable tblVocabAudio = new VisTable(false);
            this.llVocabAudio = new LinkLabel((CharSequence)"", llStyle);
            tblVocabAudio.align(8);
            tblVocabAudio.add("Press ");
            tblVocabAudio.add(this.llVocabAudio);
            tblVocabAudio.add(" or [TB]left-click[] on the vocab.").row();
            VisTable tblSentenceAudio = new VisTable(false);
            this.llSentenceAudio = new LinkLabel((CharSequence)"", llStyle);
            tblSentenceAudio.align(8);
            tblSentenceAudio.add("Press ");
            tblSentenceAudio.add(this.llSentenceAudio);
            tblSentenceAudio.add(" or [TB]double-click[] on the vocab.").row();
            VisTable tblFont = new VisTable(false);
            this.llFont = new LinkLabel((CharSequence)"", llStyle);
            this.llFont.setTouchable(Touchable.disabled);
            tblFont.align(8);
            tblFont.defaults().align(8);
            tblFont.add("Hold ");
            tblFont.add(this.llFont);
            tblFont.add(" or hover over the vocab").row();
            tblFont.add("and [TB]right-click & hold[].").colspan(3).row();
            VisTable tblArchive = new VisTable(false);
            this.llArchive = new LinkLabel((CharSequence)"", llStyle);
            tblArchive.align(8);
            tblArchive.add("Press ");
            tblArchive.add(this.llArchive);
            tblArchive.add(" .").row();
            VisLabel lInformation = new VisLabel((CharSequence)"Reviews: If an action is bound to 0-9 or A-Z, press [TB]Control[]/[TB]Alt[] + [TB]<Bound Key>[] to make it work.\nClick on the [TB]blue text[] to reassign a keybind. If it's not clickable, the corresponding bind cannot be changed.", Main.labelStyleX1);
            lInformation.setWrap(true);
            this.tblBindings = new VisTable(false);
            this.tblBindings.setBackground(Main.uiSkin.newDrawable("white", Main.UI_BG));
            this.tblBindings.align(2);
            this.tblBindings.defaults().expandX().fillX().padLeft(this.space / 2.0f).padRight(this.space / 2.0f);
            this.tblBindings.add(lInformation).padTop(this.space / 2.0f).padBottom(this.space / 2.0f).row();
            this.tblBindings.addSeparator();
            this.tblBindings.add(new VisLabel((CharSequence)"Reviews", Main.labelStyleX1p25)).padTop(this.space).padBottom(this.space).row();
            this.tblBindings.add("[CR]Confirm answer / next item[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblConfirm).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Ignore answer[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblIgnore).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Toggle Furigana[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblFurigana).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Toggle font[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblFont).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Skip item[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblSkip).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Expand/collapse vocab details pane[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblInfo).padBottom(this.space / 2.0f).row();
            this.tblBindings.addSeparator();
            this.tblBindings.add(new VisLabel((CharSequence)"Lessons & Reviews", Main.labelStyleX1p25)).padTop(this.space).padBottom(this.space).row();
            this.tblBindings.add("[CR]Play vocab audio[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblVocabAudio).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Play sentence audio[]").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblSentenceAudio).padBottom(this.space / 2.0f).row();
            this.tblBindings.add("[CR]Archive item[] (Lessons & Reviews)").padTop(this.space / 2.0f).row();
            this.tblBindings.add(tblArchive).padBottom(this.space / 2.0f).row();
            this.setListeners();
        }

        void show(Stage parent) {
            this.buildUI();
            float windowWidth = parent.getViewport().getWorldWidth() * 0.95f;
            float windowHeight = parent.getViewport().getWorldHeight() * 0.9f;
            this.setBindingLabels();
            VisTable tblScroll = new VisTable(false);
            tblScroll.add(this.tblBindings).width(windowWidth * 0.95f);
            this.scroll = new VisScrollPane((Actor)tblScroll);
            this.scroll.setFadeScrollBars(false);
            this.tblContent.clearChildren();
            this.tblContent.add(this.scroll).expandX().fillX().padTop(this.space / 2.0f).padBottom(this.space / 2.0f).row();
            this.tblContent.addSeparator();
            this.tblContent.add(this.tblButtons).padTop(this.space / 2.0f).padBottom(this.space / 2.0f).align(1);
            this.winKeybinds.clearChildren();
            this.winKeybinds.add(this.tblContent).width(windowWidth).height(windowHeight);
            this.winKeybinds.pack();
            parent.addActor(this.winKeybinds);
        }

        void setBindings(int confirm, int ignore, int info, int furigana, int skip, int vocabAudio, int sentenceAudio, int font, int archive) {
            this.confirm = confirm != -1 ? confirm : 66;
            this.ignore = ignore != -1 ? ignore : 111;
            this.info = info != -1 ? info : -1;
            this.furigana = furigana != -1 ? furigana : 61;
            this.skip = skip != -1 ? skip : -1;
            this.vocabAudio = vocabAudio != -1 ? vocabAudio : -1;
            this.sentenceAudio = sentenceAudio != -1 ? sentenceAudio : -1;
            this.font = font != -1 ? font : 62;
            this.archive = archive != -1 ? archive : -1;
            this.setBindingLabels();
        }

        boolean isWindowVisible() {
            return this.winKeybinds.hasParent();
        }

        int getBind(KeyBindings which) {
            switch (which.ordinal()) {
                case 0: {
                    return this.confirm;
                }
                case 1: {
                    return this.ignore;
                }
                case 2: {
                    return this.info;
                }
                case 3: {
                    return this.furigana;
                }
                case 4: {
                    return this.skip;
                }
                case 5: {
                    return this.vocabAudio;
                }
                case 6: {
                    return this.sentenceAudio;
                }
                case 7: {
                    return this.font;
                }
                case 8: {
                    return this.archive;
                }
            }
            return -1;
        }

        private String keycodeToString(int keycode) {
            String sNoBind = "<Not Bound>";
            return keycode != -1 ? Input.Keys.toString(keycode) : "<Not Bound>";
        }

        private void setBindingLabels() {
            this.llConfirm.setText("[TB]" + this.keycodeToString(this.confirm) + "[]");
            this.llIgnore.setText("[TB]" + this.keycodeToString(this.ignore) + "[]");
            this.llInfo.setText("[TB]" + this.keycodeToString(this.info) + "[]");
            this.llFurigana.setText("[TB]" + this.keycodeToString(this.furigana) + "[]");
            this.llSkip.setText("[TB]" + this.keycodeToString(this.skip) + "[]");
            this.llVocabAudio.setText("[TB]" + this.keycodeToString(this.vocabAudio) + "[]");
            this.llSentenceAudio.setText("[TB]" + this.keycodeToString(this.sentenceAudio) + "[]");
            this.llFont.setText("[TB]" + this.keycodeToString(this.font) + "[]");
            this.llArchive.setText("[TB]" + this.keycodeToString(this.archive) + "[]");
        }

        private void setListeners() {
            String pres = "[CR]<PRESS KEY>[]";
            this.winKeybinds.addListener(new ClickListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        if (KeyBindingsHandler.this.isAllowedKey(keycode)) {
                            KeyBindingsHandler.this.waitingForButton = false;
                            switch (KeyBindingsHandler.this.whichKey.ordinal()) {
                                case 0: {
                                    KeyBindingsHandler.this.confirm = keycode;
                                    break;
                                }
                                case 1: {
                                    KeyBindingsHandler.this.ignore = keycode;
                                    break;
                                }
                                case 2: {
                                    KeyBindingsHandler.this.info = keycode;
                                    break;
                                }
                                case 3: {
                                    KeyBindingsHandler.this.furigana = keycode;
                                    break;
                                }
                                case 4: {
                                    KeyBindingsHandler.this.skip = keycode;
                                    break;
                                }
                                case 5: {
                                    KeyBindingsHandler.this.vocabAudio = keycode;
                                    break;
                                }
                                case 6: {
                                    KeyBindingsHandler.this.sentenceAudio = keycode;
                                    break;
                                }
                                case 7: {
                                    KeyBindingsHandler.this.font = keycode;
                                    break;
                                }
                                case 8: {
                                    KeyBindingsHandler.this.archive = keycode;
                                }
                            }
                            KeyBindingsHandler.this.whichKey = null;
                            KeyBindingsHandler.this.setBindingLabels();
                        } else if (keycode == 111) {
                            KeyBindingsHandler.this.waitingForButton = false;
                            KeyBindingsHandler.this.whichKey = null;
                            KeyBindingsHandler.this.setBindingLabels();
                        }
                    } else if (keycode == 66) {
                        RestClient.updateKeyBindings();
                        KeyBindingsHandler.this.winKeybinds.remove();
                    } else if (keycode == 111) {
                        KeyBindingsHandler.this.winKeybinds.remove();
                    }
                    return true;
                }
            });
            this.llConfirm.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.CONFIRM) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.CONFIRM;
                        KeyBindingsHandler.this.llConfirm.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llIgnore.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.IGNORE) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.IGNORE;
                        KeyBindingsHandler.this.llIgnore.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llInfo.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.INFO) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.INFO;
                        KeyBindingsHandler.this.llInfo.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llFurigana.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.FURIGANA) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.FURIGANA;
                        KeyBindingsHandler.this.llFurigana.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llSkip.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.SKIP) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.SKIP;
                        KeyBindingsHandler.this.llSkip.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llVocabAudio.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.VOCAB_AUDIO) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.VOCAB_AUDIO;
                        KeyBindingsHandler.this.llVocabAudio.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llSentenceAudio.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.SENTENCE_AUDIO) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.SENTENCE_AUDIO;
                        KeyBindingsHandler.this.llSentenceAudio.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llFont.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.FONT) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.FONT;
                        KeyBindingsHandler.this.llFont.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
            this.llArchive.setListener(new LinkLabel.LinkLabelListener(){

                @Override
                public void clicked(String url) {
                    if (KeyBindingsHandler.this.waitingForButton) {
                        KeyBindingsHandler.this.setBindingLabels();
                    }
                    if (KeyBindingsHandler.this.whichKey != KeyBindings.ARCHIVE) {
                        KeyBindingsHandler.this.whichKey = KeyBindings.ARCHIVE;
                        KeyBindingsHandler.this.llArchive.setText("[CR]<PRESS KEY>[]");
                        KeyBindingsHandler.this.waitingForButton = true;
                    } else {
                        KeyBindingsHandler.this.waitingForButton = false;
                        KeyBindingsHandler.this.whichKey = null;
                    }
                }
            });
        }
    }

    static enum KeyBindings {
        CONFIRM,
        IGNORE,
        INFO,
        FURIGANA,
        SKIP,
        VOCAB_AUDIO,
        SENTENCE_AUDIO,
        FONT,
        ARCHIVE;

    }
}

