/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisProgressBar;
import com.kotcrab.vis.ui.widget.VisTable;
import com.torii.srs.Dashboard;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.widget.TopMenu;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ProgressScreen
implements Screen {
    private static ProgressScreen progScreen;
    private TopMenu topMenu;
    private Stage stage;
    private SpriteBatch batch;
    private VisTable tblStreak;
    private VisTable tblLessonsReviews;
    private VisTable tblLessonsReviewsSpacer;
    private VisTable tblTime;
    private VisLabel lTimeUntilReset;
    private VisLabel lStreakCurrentValue;
    private VisLabel lStreakBestValue;
    private VisLabel lItemsLearnedPercentage;
    private VisLabel lItemsLearnedValue;
    private VisLabel lItemsToLearnValue;
    private VisLabel lCorrectPercentage;
    private VisLabel lItemsReviewedValue;
    private VisLabel lItemsAnsweredCorrectlyValue;
    private VisLabel lStudyTime;
    private VisLabel lReviewTime;
    private VisLabel lAccountCreated;
    private VisProgressBar pbItemsLearned;
    private VisProgressBar pbReviewCorrectPercentage;
    private String accountCreated;
    private final float progressBarAnimationDuration;
    private int studyStreakCurrent;
    private int studyStreakBest;
    private int itemsReviewed;
    private int itemsAnsweredCorrectly;
    private int itemsLearned;
    private int itemsToLearn;
    private int secUntilDailyReset;
    private int toriiTime;
    private int studyTime;
    private int reviewTime;
    private Animation<TextureRegion> animGreen;
    private final int animGreenWidth = 150;
    private final int animGreenHeight = 150;
    private float deltaGreen;

    ProgressScreen() {
        progScreen = this;
        this.progressBarAnimationDuration = 1.0f;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.batch = new SpriteBatch();
        this.animGreen = Main.pngToAnimation((Texture)Main.getAsset(Main.GREEN_PATH, Texture.class, true), 150, 150, 0.1f);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.buildUI();
        if (Main.getPreviousScreen() != LoadingScreen.loadingScreen) {
            this.refreshData();
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
        if (Dashboard.isKonamiStreakOver9000()) {
            this.deltaGreen += delta;
            this.batch.begin();
            this.batch.draw(this.animGreen.getKeyFrame(this.deltaGreen, true), 0.0f, this.getStageLocation((Actor)this.tblTime).y, 150.0f, 150.0f);
            this.batch.end();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.resetData();
    }

    @Override
    public void dispose() {
    }

    static void showOnScreen() {
        Main.setNewScreen(progScreen);
    }

    static void setAccountCreated(String value) {
        ProgressScreen.progScreen.accountCreated = value;
    }

    static void setStudyStreakCurrent(int value) {
        ProgressScreen.progScreen.studyStreakCurrent = value;
    }

    static void setStudyStreakBest(int value) {
        ProgressScreen.progScreen.studyStreakBest = value;
    }

    static void setItemsReviewed(int value) {
        ProgressScreen.progScreen.itemsReviewed = value;
    }

    static void setItemsAnsweredCorrectly(int value) {
        ProgressScreen.progScreen.itemsAnsweredCorrectly = value;
    }

    static void setItemsLearned(int value) {
        ProgressScreen.progScreen.itemsLearned = value;
    }

    static void setItemsToLearn(int value) {
        ProgressScreen.progScreen.itemsToLearn = value;
    }

    static void setTimeUntilDailyReset(int value) {
        ProgressScreen.progScreen.secUntilDailyReset = value;
    }

    static void setToriiTime(int value) {
        ProgressScreen.progScreen.toriiTime = value;
    }

    static void setStudyTime(int value) {
        ProgressScreen.progScreen.studyTime = value;
    }

    static void setReviewTime(int value) {
        ProgressScreen.progScreen.reviewTime = value;
    }

    static void setData() {
        int learnedPercentage = ProgressScreen.progScreen.itemsLearned * 100 / ProgressScreen.progScreen.itemsToLearn;
        int answeredCorrectlyPercentage = ProgressScreen.progScreen.itemsReviewed == 0 ? 100 : ProgressScreen.progScreen.itemsAnsweredCorrectly * 100 / ProgressScreen.progScreen.itemsReviewed;
        String s1 = ProgressScreen.progScreen.studyStreakCurrent == 1 ? " Day" : " Days";
        String s2 = ProgressScreen.progScreen.studyStreakBest == 1 ? " Day" : " Days";
        ProgressScreen.progScreen.lStreakCurrentValue.setText(ProgressScreen.progScreen.studyStreakCurrent + s1);
        ProgressScreen.progScreen.lStreakCurrentValue.pack();
        ProgressScreen.progScreen.lStreakBestValue.setText(ProgressScreen.progScreen.studyStreakBest + s2);
        ProgressScreen.progScreen.lStreakBestValue.pack();
        ProgressScreen.progScreen.lItemsLearnedPercentage.setText("Study Mode Progress (" + learnedPercentage + "%)");
        ProgressScreen.progScreen.lItemsLearnedPercentage.pack();
        ProgressScreen.progScreen.lItemsLearnedValue.setText("" + ProgressScreen.progScreen.itemsLearned);
        ProgressScreen.progScreen.lItemsLearnedValue.pack();
        ProgressScreen.progScreen.lItemsToLearnValue.setText("" + ProgressScreen.progScreen.itemsToLearn);
        ProgressScreen.progScreen.lItemsToLearnValue.pack();
        ProgressScreen.progScreen.lItemsReviewedValue.setText("" + ProgressScreen.progScreen.itemsReviewed);
        ProgressScreen.progScreen.lItemsReviewedValue.pack();
        ProgressScreen.progScreen.lItemsAnsweredCorrectlyValue.setText("" + ProgressScreen.progScreen.itemsAnsweredCorrectly);
        ProgressScreen.progScreen.lItemsAnsweredCorrectlyValue.pack();
        ProgressScreen.progScreen.pbItemsLearned.setAnimateDuration(ProgressScreen.progScreen.progressBarAnimationDuration);
        ProgressScreen.progScreen.pbItemsLearned.setRange(0.0f, ProgressScreen.progScreen.itemsToLearn);
        ProgressScreen.progScreen.pbItemsLearned.setValue(ProgressScreen.progScreen.itemsLearned);
        ProgressScreen.progScreen.lCorrectPercentage.setText("You've got " + answeredCorrectlyPercentage + "% of your reviews right!");
        ProgressScreen.progScreen.lCorrectPercentage.pack();
        ProgressScreen.progScreen.pbReviewCorrectPercentage.setAnimateDuration(ProgressScreen.progScreen.progressBarAnimationDuration);
        ProgressScreen.progScreen.pbReviewCorrectPercentage.setValue(answeredCorrectlyPercentage);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.ENGLISH);
        String accountCreated = "";
        try {
            Date date = format.parse(ProgressScreen.progScreen.accountCreated);
            accountCreated = new SimpleDateFormat("MMMM dd, yyyy", Locale.ENGLISH).format(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ProgressScreen.progScreen.lAccountCreated.setText("Member since: " + accountCreated);
        ProgressScreen.progScreen.lAccountCreated.pack();
        int seconds = ProgressScreen.progScreen.studyTime;
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        String study = hours > 0 ? hours + "h " + minutes + "m" : (minutes > 0 ? minutes + "min" : "<1min");
        ProgressScreen.progScreen.lStudyTime.setText(study);
        ProgressScreen.progScreen.lStudyTime.pack();
        seconds = ProgressScreen.progScreen.reviewTime;
        hours = seconds / 3600;
        minutes = seconds % 3600 / 60;
        study = hours > 0 ? hours + "h " + minutes + "m" : (minutes > 0 ? minutes + "min" : "<1min");
        ProgressScreen.progScreen.lReviewTime.setText(study);
        ProgressScreen.progScreen.lReviewTime.pack();
        seconds = ProgressScreen.progScreen.secUntilDailyReset;
        hours = seconds / 3600;
        minutes = seconds % 3600 / 60;
        study = hours > 0 ? hours + "h " + minutes + "m" : (minutes > 0 ? minutes + "min" : "<1min");
        ProgressScreen.progScreen.lTimeUntilReset.setText("Next daily reset: " + study);
        ProgressScreen.progScreen.lTimeUntilReset.pack();
    }

    private void buildUI() {
        VisTable table = new VisTable(false);
        this.tblStreak = new VisTable(false);
        this.tblLessonsReviews = new VisTable(false);
        this.tblLessonsReviewsSpacer = new VisTable(false);
        this.tblTime = new VisTable(false);
        VisLabel lStreakCurrent = new VisLabel((CharSequence)"Current Streak", Main.labelStyleX1);
        VisLabel lStreakBest = new VisLabel((CharSequence)"Best Streak", Main.labelStyleX1);
        this.lTimeUntilReset = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.lStreakCurrentValue = new VisLabel((CharSequence)"N/A", Main.labelStyleX2);
        this.lStreakBestValue = new VisLabel((CharSequence)"N/A", Main.labelStyleX2);
        this.lItemsLearnedPercentage = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.lItemsLearnedValue = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lItemsToLearnValue = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lCorrectPercentage = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.lItemsReviewedValue = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lItemsAnsweredCorrectlyValue = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lStudyTime = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lReviewTime = new VisLabel((CharSequence)"0", Main.labelStyleX2);
        this.lAccountCreated = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.pbItemsLearned = new VisProgressBar(0.0f, 1.0f, 1.0f, false);
        this.pbReviewCorrectPercentage = new VisProgressBar(0.0f, 100.0f, 1.0f, false);
        this.lStreakCurrentValue.setAlignment(1);
        this.lStreakBestValue.setAlignment(1);
        this.lStudyTime.setAlignment(1);
        this.lReviewTime.setAlignment(1);
        this.pbItemsLearned.setAnimateDuration(this.progressBarAnimationDuration);
        this.pbReviewCorrectPercentage.setAnimateDuration(this.progressBarAnimationDuration);
        this.tblStreak.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        this.tblLessonsReviews.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        this.tblLessonsReviewsSpacer.setBackground(Main.uiSkin.newDrawable("white", Main.UI_BG));
        this.tblTime.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        this.tblStreak.add(this.lTimeUntilReset).colspan(2).padTop(0.5f * (float)Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblStreak.add(this.lStreakCurrentValue).expandX().fillX();
        this.tblStreak.add(this.lStreakBestValue).expandX().fillX().row();
        this.tblStreak.add(lStreakCurrent);
        this.tblStreak.add(lStreakBest).row();
        this.tblStreak.add().padBottom(0.5f * (float)Main.getPPUY());
        this.tblLessonsReviews.add(this.lItemsLearnedPercentage).colspan(3).padTop(0.5f * (float)Main.getPPUY()).padBottom(1 * Main.getPPUY()).row();
        this.tblLessonsReviews.add(this.pbItemsLearned).colspan(3).width(this.stage.getViewport().getWorldWidth() * 0.9f).expandX().fillX().row();
        this.tblLessonsReviews.add(this.lItemsLearnedValue);
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"out of", Main.labelStyleX1));
        this.tblLessonsReviews.add(this.lItemsToLearnValue).row();
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"Words Learned", Main.labelStyleX0p5)).align(1);
        this.tblLessonsReviews.add();
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"Total Words", Main.labelStyleX0p5)).align(1).row();
        this.tblLessonsReviews.add(this.tblLessonsReviewsSpacer).colspan(3).height(0.5f * (float)Main.getPPUY()).expandX().fillX().padTop(0.5f * (float)Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblLessonsReviews.add(this.lCorrectPercentage).colspan(3).padBottom(1 * Main.getPPUY()).row();
        this.tblLessonsReviews.add(this.pbReviewCorrectPercentage).colspan(3).width(this.stage.getViewport().getWorldWidth() * 0.9f).expandX().fillX().row();
        this.tblLessonsReviews.add(this.lItemsAnsweredCorrectlyValue);
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"out of", Main.labelStyleX1));
        this.tblLessonsReviews.add(this.lItemsReviewedValue).row();
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"Answered Correctly", Main.labelStyleX0p5)).align(1);
        this.tblLessonsReviews.add();
        this.tblLessonsReviews.add(new VisLabel((CharSequence)"Total Reviews", Main.labelStyleX0p5)).align(1).row();
        this.tblLessonsReviews.add().padBottom(0.5f * (float)Main.getPPUY());
        this.tblTime.add(this.lAccountCreated).colspan(2).padTop(0.5f * (float)Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblTime.add(this.lStudyTime).expandX().fillX();
        this.tblTime.add(this.lReviewTime).expandX().fillX().row();
        this.tblTime.add(new VisLabel((CharSequence)"Study Time", Main.labelStyleX1));
        this.tblTime.add(new VisLabel((CharSequence)"Review Time", Main.labelStyleX1)).row();
        this.tblTime.add().padBottom(0.5f * (float)Main.getPPUY());
        this.topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                Dashboard.showOnScreen();
            }
        };
        table.setFillParent(true);
        table.align(2);
        table.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        table.add(this.topMenu.getTable()).width(this.stage.getViewport().getWorldWidth()).row();
        table.add(new VisLabel((CharSequence)"Study Streak", Main.labelStyleX1)).padTop(Main.getPPUY()).row();
        table.add(this.tblStreak).row();
        table.add(new VisLabel((CharSequence)"Lessons & Reviews", Main.labelStyleX1)).padTop(Main.getPPUY()).row();
        table.add(this.tblLessonsReviews).row();
        table.add(new VisLabel((CharSequence)"Time Investment", Main.labelStyleX1)).padTop(Main.getPPUY()).row();
        table.add(this.tblTime).row();
        this.stage.clear();
        this.setActorListeners();
        this.stage.addActor(table);
    }

    private void resetData() {
        this.lTimeUntilReset.setText("Next daily reset: N/A");
        this.lTimeUntilReset.pack();
        this.lStreakCurrentValue.setText("N/A");
        this.lStreakCurrentValue.pack();
        this.lStreakBestValue.setText("N/A");
        this.lStreakBestValue.pack();
        this.lItemsLearnedPercentage.setText("Study Mode Progress (0%)");
        this.lItemsLearnedPercentage.pack();
        this.lItemsLearnedValue.setText("0");
        this.lItemsLearnedValue.pack();
        this.lItemsToLearnValue.setText("0");
        this.lItemsToLearnValue.pack();
        this.lItemsReviewedValue.setText("0");
        this.lItemsReviewedValue.pack();
        this.lItemsAnsweredCorrectlyValue.setText("0");
        this.lItemsAnsweredCorrectlyValue.pack();
        this.pbItemsLearned.setAnimateDuration(0.0f);
        this.pbItemsLearned.setRange(0.0f, 1.0f);
        this.pbItemsLearned.setValue(0.0f);
        this.lCorrectPercentage.setText("You've got 0% of your reviews right!");
        this.lCorrectPercentage.pack();
        this.pbReviewCorrectPercentage.setAnimateDuration(0.0f);
        this.pbReviewCorrectPercentage.setValue(0.0f);
        this.lAccountCreated.setText(" ");
        this.lAccountCreated.pack();
        this.lStudyTime.setText("N/A");
        this.lStudyTime.pack();
        this.lReviewTime.setText("N/A");
        this.lReviewTime.pack();
    }

    private void refreshData() {
        RestClient.getProgressionDetails();
    }

    private Vector2 getStageLocation(Actor actor) {
        return actor.localToStageCoordinates(new Vector2(0.0f, 0.0f));
    }

    private void setActorListeners() {
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111 || keycode == 4) {
                    Dashboard.showOnScreen();
                }
                return true;
            }
        });
    }
}

