/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.Hints;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.ReviewScreen;
import com.torii.srs.widget.List;
import com.torii.srs.widget.TopMenu;
import java.util.HashMap;
import java.util.Map;

public class PracticeScreen
implements Screen {
    private static PracticeScreen practiceScreen;
    private Preferences prefs;
    private PracticeListsTable plt;
    private Stage stage;
    private VisCheckBox cbJPtoEN;
    private VisCheckBox cbENtoJP;
    private VisCheckBox cbAudioToEN;
    private VisCheckBox cbAudioToJP;
    private VisCheckBox cbRookie1;
    private VisCheckBox cbRookie2;
    private VisCheckBox cbRookie3;
    private VisCheckBox cbRookie4;
    private VisCheckBox cbAmateur1;
    private VisCheckBox cbAmateur2;
    private VisCheckBox cbExpert;
    private VisCheckBox cbMaster;
    private VisCheckBox cbSensei;
    private final String prefsEntryJPtoEN;
    private final String prefsEntryENtoJP;
    private final String prefsEntryAudioToEN;
    private final String prefsEntryAudioToJP;
    private final String prefsEntryRookie1;
    private final String prefsEntryRookie2;
    private final String prefsEntryRookie3;
    private final String prefsEntryRookie4;
    private final String prefsEntryAmateur1;
    private final String prefsEntryAmateur2;
    private final String prefsEntryExpert;
    private final String prefsEntryMaster;
    private final String prefsEntrySensei;

    PracticeScreen() {
        practiceScreen = this;
        this.prefs = Gdx.app.getPreferences("torii_prefs_practice");
        this.prefsEntryJPtoEN = "pr_jp_to_en";
        this.prefsEntryENtoJP = "pr_en_to_jp";
        this.prefsEntryAudioToEN = "pr_ad_to_en";
        this.prefsEntryAudioToJP = "pr_ad_to_jp";
        this.prefsEntryRookie1 = "pr_en_ro1";
        this.prefsEntryRookie2 = "pr_en_ro2";
        this.prefsEntryRookie3 = "pr_en_ro3";
        this.prefsEntryRookie4 = "pr_en_ro4";
        this.prefsEntryAmateur1 = "pr_en_am1";
        this.prefsEntryAmateur2 = "pr_en_am2";
        this.prefsEntryExpert = "pr_en_ex";
        this.prefsEntryMaster = "pr_en_ma";
        this.prefsEntrySensei = "pr_en_se";
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        TopMenu topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                Dashboard.showOnScreen();
            }
        };
        this.plt = new PracticeListsTable(this.stage, false, false);
        this.plt.setListHeaderText("Your Practice Lists");
        final VisTextButton tbEndless = new VisTextButton("Endless", Main.btnStyleX1p25);
        final VisTextButton tbCustom = new VisTextButton("Custom Vocab", Main.btnStyleX1p25);
        final VisTextButton tbStartListPractice = new VisTextButton("Practice List", Main.btnStyleX1p25);
        VisLabel lEndless = new VisLabel((CharSequence)"Practice everything you've learned so far.\nArchived vocabulary is excluded.", Main.labelStyleX0p5);
        VisLabel lCustom = new VisLabel((CharSequence)"Practice your 'Practice Mode' custom vocabulary.", Main.labelStyleX0p5);
        VisLabel lLeech = new VisLabel((CharSequence)"Practice Lists help you review specific words as much as you need - like troublesome 'leeches'. You can add or remove words during a study or review session, or while viewing/editing a vocab item in the Browse interface.", Main.labelStyleX0p5);
        float space = Main.getPPUY();
        float btnWidth = tbCustom.getWidth();
        float btnHeight = tbCustom.getHeight();
        float checkboxSize = Main.getPPUY();
        this.cbJPtoEN = new VisCheckBox(" Japanese \u2192 English", Main.cbStyleWhite);
        this.cbENtoJP = new VisCheckBox(" English \u2192 Japanese", Main.cbStyleWhite);
        this.cbAudioToJP = new VisCheckBox(" Audio \u2192 Reading", Main.cbStyleWhite);
        this.cbAudioToEN = new VisCheckBox(" Audio \u2192 Meaning", Main.cbStyleWhite);
        this.cbRookie1 = new VisCheckBox(" Rookie 1", Main.cbStyleWhite);
        this.cbRookie2 = new VisCheckBox(" Rookie 2", Main.cbStyleWhite);
        this.cbRookie3 = new VisCheckBox(" Rookie 3", Main.cbStyleWhite);
        this.cbRookie4 = new VisCheckBox(" Rookie 4", Main.cbStyleWhite);
        this.cbAmateur1 = new VisCheckBox(" Amateur 1", Main.cbStyleWhite);
        this.cbAmateur2 = new VisCheckBox(" Amateur 2", Main.cbStyleWhite);
        this.cbExpert = new VisCheckBox(" Expert", Main.cbStyleWhite);
        this.cbMaster = new VisCheckBox(" Master", Main.cbStyleWhite);
        this.cbSensei = new VisCheckBox(" Sensei", Main.cbStyleWhite);
        this.cbJPtoEN.getImageStackCell().size(checkboxSize);
        this.cbENtoJP.getImageStackCell().size(checkboxSize);
        this.cbAudioToJP.getImageStackCell().size(checkboxSize);
        this.cbAudioToEN.getImageStackCell().size(checkboxSize);
        this.cbRookie1.getImageStackCell().size(checkboxSize);
        this.cbRookie2.getImageStackCell().size(checkboxSize);
        this.cbRookie3.getImageStackCell().size(checkboxSize);
        this.cbRookie4.getImageStackCell().size(checkboxSize);
        this.cbAmateur1.getImageStackCell().size(checkboxSize);
        this.cbAmateur2.getImageStackCell().size(checkboxSize);
        this.cbExpert.getImageStackCell().size(checkboxSize);
        this.cbMaster.getImageStackCell().size(checkboxSize);
        this.cbSensei.getImageStackCell().size(checkboxSize);
        this.setEndlessSettingsCheckboxes();
        Image imgSettings = new Image((Texture)Main.getAsset(Main.SETTINGS_BTN_PATH, Texture.class, true));
        Drawable settings = imgSettings.getDrawable();
        VisImageButton btnSettings = new VisImageButton(settings);
        btnSettings.getImageCell().size(btnHeight * 0.9f);
        btnSettings.getStyle().up = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
        btnSettings.getStyle().over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        btnSettings.getStyle().down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        btnSettings.getStyle().imageUp = Main.uiSkin.newDrawable(settings, Main.FONT);
        btnSettings.getStyle().imageDown = Main.uiSkin.newDrawable(settings, Main.FONT);
        tbStartListPractice.setDisabled(true);
        lEndless.setAlignment(1);
        lCustom.setAlignment(1);
        lLeech.setAlignment(1);
        lEndless.setWrap(true);
        lCustom.setWrap(true);
        lLeech.setWrap(true);
        tbEndless.setFocusBorderEnabled(false);
        btnSettings.setFocusBorderEnabled(false);
        tbCustom.setFocusBorderEnabled(false);
        tbStartListPractice.setFocusBorderEnabled(false);
        this.cbJPtoEN.setFocusBorderEnabled(false);
        this.cbENtoJP.setFocusBorderEnabled(false);
        this.cbAudioToJP.setFocusBorderEnabled(false);
        this.cbAudioToEN.setFocusBorderEnabled(false);
        this.cbRookie1.setFocusBorderEnabled(false);
        this.cbRookie2.setFocusBorderEnabled(false);
        this.cbRookie3.setFocusBorderEnabled(false);
        this.cbRookie4.setFocusBorderEnabled(false);
        this.cbAmateur1.setFocusBorderEnabled(false);
        this.cbAmateur2.setFocusBorderEnabled(false);
        this.cbExpert.setFocusBorderEnabled(false);
        this.cbMaster.setFocusBorderEnabled(false);
        this.cbSensei.setFocusBorderEnabled(false);
        VisTable tblEndless = new VisTable(false);
        tblEndless.align(16);
        tblEndless.add().size(btnHeight).padRight(space / 2.0f);
        tblEndless.add(tbEndless).width(btnWidth).padRight(space / 2.0f);
        tblEndless.add(btnSettings).size(btnHeight).row();
        VisTable tblSelect = new VisTable(false);
        tblSelect.align(2);
        tblSelect.add(new VisLabel((CharSequence)"Standard Practice Modes", Main.labelStyleX1p25)).padBottom(space * 2.0f).row();
        tblSelect.add(tblEndless).padBottom(space / 2.0f).row();
        tblSelect.add(lEndless).expandX().fillX().padBottom(space * 2.0f).row();
        tblSelect.add(tbCustom).width(btnWidth).padBottom(space / 2.0f).row();
        tblSelect.add(lCustom).expandX().fillX().padBottom(space).row();
        tblSelect.addSeparator().padBottom(space);
        tblSelect.add(new VisLabel((CharSequence)"Prime Practice Modes", Main.labelStyleX1p25)).padBottom(space * 2.0f).row();
        tblSelect.add(tbStartListPractice).width(btnWidth).padBottom(space / 2.0f).row();
        tblSelect.add(lLeech).expandX().fillX().padBottom(space).row();
        tblSelect.add(this.plt).expand().fill().row();
        VisTable tblMain = new VisTable(false);
        tblMain.setFillParent(true);
        tblMain.add(topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        tblMain.add(tblSelect).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY().padBottom(Main.getPPUY());
        tbEndless.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                int reviewModeID = !(!PracticeScreen.this.cbJPtoEN.isChecked() && !PracticeScreen.this.cbAudioToEN.isChecked() || !PracticeScreen.this.cbENtoJP.isChecked() && !PracticeScreen.this.cbAudioToJP.isChecked()) ? 3 : (PracticeScreen.this.cbENtoJP.isChecked() || PracticeScreen.this.cbAudioToJP.isChecked() ? 2 : 1);
                boolean[] includeSRSstages = new boolean[]{PracticeScreen.this.cbRookie1.isChecked(), PracticeScreen.this.cbRookie2.isChecked(), PracticeScreen.this.cbRookie3.isChecked(), PracticeScreen.this.cbRookie4.isChecked(), PracticeScreen.this.cbAmateur1.isChecked(), PracticeScreen.this.cbAmateur2.isChecked(), PracticeScreen.this.cbExpert.isChecked(), PracticeScreen.this.cbMaster.isChecked(), PracticeScreen.this.cbSensei.isChecked()};
                ReviewScreen.setEndlessPracticeSettings(reviewModeID, includeSRSstages);
                RestClient.getReviews(reviewModeID, 0, includeSRSstages);
            }
        });
        btnSettings.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PracticeScreen.this.createEndlessSettingsWindow();
            }
        });
        tbCustom.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RestClient.getReviews(1);
            }
        });
        tbStartListPractice.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!tbStartListPractice.isDisabled()) {
                    RestClient.getReviews(practiceScreen.plt.getSelectedListID());
                }
            }
        });
        this.plt.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (Main.isPrime()) {
                    tbStartListPractice.setDisabled(PracticeScreen.this.plt.getSelectedListID() == -1);
                }
            }
        });
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                switch (keycode) {
                    case 4: 
                    case 111: {
                        Dashboard.showOnScreen();
                        break;
                    }
                    case 8: 
                    case 33: 
                    case 145: {
                        PracticeScreen.this.simulateClick(tbEndless);
                        break;
                    }
                    case 9: 
                    case 31: 
                    case 146: {
                        PracticeScreen.this.simulateClick(tbCustom);
                    }
                }
                return true;
            }
        });
        this.stage.addActor(tblMain);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        if (Main.getPreviousScreen() != LoadingScreen.loadingScreen && Main.getPreviousScreen() != practiceScreen && !Hints.showPracticeHint(this.stage, this.plt)) {
            this.plt.refreshData();
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private void createEndlessSettingsWindow() {
        final VisWindow winEndlessSettings = new VisWindow("Endless Practice Settings", true);
        winEndlessSettings.padTop((float)Main.getPPUY() * 1.5f);
        winEndlessSettings.setCenterOnAdd(true);
        winEndlessSettings.setModal(true);
        winEndlessSettings.setMovable(true);
        winEndlessSettings.closeOnEscape();
        winEndlessSettings.addCloseButton();
        float space = Main.getPPUY();
        VisTextButton tbSave = new VisTextButton("Save Changes", Main.btnStyleX1);
        tbSave.setFocusBorderEnabled(false);
        tbSave.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!(PracticeScreen.this.cbJPtoEN.isChecked() || PracticeScreen.this.cbENtoJP.isChecked() || PracticeScreen.this.cbAudioToEN.isChecked() || PracticeScreen.this.cbAudioToJP.isChecked())) {
                    PracticeScreen.this.cbJPtoEN.setChecked(true);
                    PracticeScreen.this.cbENtoJP.setChecked(true);
                }
                if (!(PracticeScreen.this.cbRookie1.isChecked() || PracticeScreen.this.cbRookie2.isChecked() || PracticeScreen.this.cbRookie3.isChecked() || PracticeScreen.this.cbRookie4.isChecked() || PracticeScreen.this.cbAmateur1.isChecked() || PracticeScreen.this.cbAmateur2.isChecked() || PracticeScreen.this.cbExpert.isChecked() || PracticeScreen.this.cbMaster.isChecked() || PracticeScreen.this.cbSensei.isChecked())) {
                    PracticeScreen.this.cbRookie1.setChecked(true);
                }
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryJPtoEN, PracticeScreen.this.cbJPtoEN.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryENtoJP, PracticeScreen.this.cbENtoJP.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryAudioToEN, PracticeScreen.this.cbAudioToEN.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryAudioToJP, PracticeScreen.this.cbAudioToJP.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryRookie1, PracticeScreen.this.cbRookie1.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryRookie2, PracticeScreen.this.cbRookie2.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryRookie3, PracticeScreen.this.cbRookie3.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryRookie4, PracticeScreen.this.cbRookie4.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryAmateur1, PracticeScreen.this.cbAmateur1.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryAmateur2, PracticeScreen.this.cbAmateur2.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryExpert, PracticeScreen.this.cbExpert.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntryMaster, PracticeScreen.this.cbMaster.isChecked());
                PracticeScreen.this.prefs.putBoolean(PracticeScreen.this.prefsEntrySensei, PracticeScreen.this.cbSensei.isChecked());
                PracticeScreen.this.prefs.flush();
                PracticeScreen.this.updateAudioPracticeModes();
                winEndlessSettings.remove();
            }
        });
        VisTable tblCheckboxesModes = new VisTable(false);
        tblCheckboxesModes.defaults().align(8).padBottom(space / 2.0f);
        tblCheckboxesModes.add(this.cbJPtoEN).row();
        tblCheckboxesModes.add(this.cbENtoJP).row();
        tblCheckboxesModes.add(this.cbAudioToEN).row();
        tblCheckboxesModes.add(this.cbAudioToJP).row();
        VisTable tblCheckboxesLevels = new VisTable(false);
        tblCheckboxesLevels.defaults().align(8).padBottom(space / 2.0f);
        tblCheckboxesLevels.add(this.cbRookie1);
        tblCheckboxesLevels.add(this.cbRookie2).row();
        tblCheckboxesLevels.add(this.cbRookie3);
        tblCheckboxesLevels.add(this.cbRookie4).row();
        tblCheckboxesLevels.add(this.cbAmateur1).padRight(space / 2.0f);
        tblCheckboxesLevels.add(this.cbAmateur2).row();
        tblCheckboxesLevels.add(this.cbExpert);
        tblCheckboxesLevels.add(this.cbMaster).row();
        tblCheckboxesLevels.add(this.cbSensei).colspan(2).row();
        this.setEndlessSettingsCheckboxes();
        VisTable tblContent = new VisTable(false);
        tblContent.addSeparator().padTop(space / 2.0f);
        tblContent.add("Mode").padTop(space / 2.0f).padBottom(space / 2.0f).row();
        tblContent.add(tblCheckboxesModes).row();
        tblContent.addSeparator();
        tblContent.add("SRS Level").padTop(space / 2.0f).padBottom(space / 2.0f).row();
        tblContent.add(tblCheckboxesLevels).row();
        tblContent.addSeparator();
        tblContent.add(tbSave).padTop(space / 2.0f).padBottom(space / 2.0f).align(1);
        winEndlessSettings.add(tblContent).width(this.stage.getViewport().getWorldWidth() * 0.75f);
        winEndlessSettings.pack();
        this.stage.addActor(winEndlessSettings);
    }

    private void setEndlessSettingsCheckboxes() {
        this.cbJPtoEN.setChecked(this.prefs.getBoolean(this.prefsEntryJPtoEN, true));
        this.cbENtoJP.setChecked(this.prefs.getBoolean(this.prefsEntryENtoJP, true));
        this.cbAudioToEN.setChecked(this.prefs.getBoolean(this.prefsEntryAudioToEN, false));
        this.cbAudioToJP.setChecked(this.prefs.getBoolean(this.prefsEntryAudioToJP, false));
        this.cbRookie1.setChecked(this.prefs.getBoolean(this.prefsEntryRookie1, true));
        this.cbRookie2.setChecked(this.prefs.getBoolean(this.prefsEntryRookie2, true));
        this.cbRookie3.setChecked(this.prefs.getBoolean(this.prefsEntryRookie3, true));
        this.cbRookie4.setChecked(this.prefs.getBoolean(this.prefsEntryRookie4, true));
        this.cbAmateur1.setChecked(this.prefs.getBoolean(this.prefsEntryAmateur1, true));
        this.cbAmateur2.setChecked(this.prefs.getBoolean(this.prefsEntryAmateur2, true));
        this.cbExpert.setChecked(this.prefs.getBoolean(this.prefsEntryExpert, true));
        this.cbMaster.setChecked(this.prefs.getBoolean(this.prefsEntryMaster, true));
        this.cbSensei.setChecked(this.prefs.getBoolean(this.prefsEntrySensei, true));
        this.updateAudioPracticeModes();
    }

    private void updateAudioPracticeModes() {
        if (this.cbAudioToEN.isChecked()) {
            if (this.cbJPtoEN.isChecked()) {
                ReviewScreen.setAudioToENPracticeMode(ReviewScreen.AudioModes.ALTERNATE);
            } else {
                ReviewScreen.setAudioToENPracticeMode(ReviewScreen.AudioModes.EXCLUSIVE);
            }
        } else {
            ReviewScreen.setAudioToENPracticeMode(ReviewScreen.AudioModes.OFF);
        }
        if (this.cbAudioToJP.isChecked()) {
            if (this.cbENtoJP.isChecked()) {
                ReviewScreen.setAudioToJPPracticeMode(ReviewScreen.AudioModes.ALTERNATE);
            } else {
                ReviewScreen.setAudioToJPPracticeMode(ReviewScreen.AudioModes.EXCLUSIVE);
            }
        } else {
            ReviewScreen.setAudioToJPPracticeMode(ReviewScreen.AudioModes.OFF);
        }
    }

    private void simulateClick(Actor actor) {
        try {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            actor.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            actor.fire(ie);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static class PracticeListsTable
    extends VisTable {
        private List lists = new List("Available Lists");
        private List parentLists = new List("Lists containing this item");
        private HashMap<String, PracticeList> mapLists = new HashMap();
        private HashMap<String, PracticeList> mapParentLists = new HashMap();
        private VisTextButton tbAddList = new VisTextButton("Add List", Main.btnStyleX1);
        private VisTextButton tbDeleteList = new VisTextButton("Delete List", Main.btnStyleX1);
        private int vocabID = -1;
        private boolean isAutoDbUpdatesEnabled = true;

        PracticeListsTable(final Stage parentStage, boolean hasVocab, boolean isReadOnly) {
            final VisTextButton tbAddVocabToList = new VisTextButton("\u2191", Main.btnStyleX1p25);
            final VisTextButton tbRemoveVocabFromList = new VisTextButton("\u2193", Main.btnStyleX1p25);
            this.lists.setFadeScrollBars(false);
            this.parentLists.setFadeScrollBars(false);
            float space = Main.getPPUY();
            this.tbAddList.setDisabled(true);
            this.tbDeleteList.setDisabled(true);
            tbAddVocabToList.setDisabled(true);
            tbRemoveVocabFromList.setDisabled(true);
            this.lists.setAlignment(1);
            this.parentLists.setAlignment(1);
            this.tbAddList.setFocusBorderEnabled(false);
            this.tbDeleteList.setFocusBorderEnabled(false);
            tbAddVocabToList.setFocusBorderEnabled(false);
            tbRemoveVocabFromList.setFocusBorderEnabled(false);
            VisTable tblListButtons = new VisTable(false);
            tblListButtons.defaults().expandX().fillX().uniformX();
            tblListButtons.add(this.tbAddList).padRight(0.33f * (float)Main.getPPUY());
            tblListButtons.add(this.tbDeleteList).row();
            VisTable tblButtons = new VisTable(false);
            tblButtons.add(tbAddVocabToList).size(1.5f * (float)Main.getPPUY()).padRight(2 * Main.getPPUY());
            tblButtons.add(tbRemoveVocabFromList).size(1.5f * (float)Main.getPPUY());
            if (hasVocab) {
                this.add(this.parentLists).expand().fill().uniform().padBottom(space).row();
                this.add(tblButtons).padBottom(space).row();
            }
            this.add(this.lists).expand().fill().uniform().row();
            if (!isReadOnly) {
                this.add(tblListButtons).expandX().fillX().padTop(0.33f * (float)Main.getPPUY()).row();
            }
            this.lists.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (lists.getSelectedIndex() != -1) {
                        parentLists.setSelectedIndex(-1);
                    }
                    if (Main.isPrime()) {
                        tbDeleteList.setDisabled(lists.getSelectedIndex() == -1 || this.isLockedList(this.getSelectedListID()));
                        tbAddVocabToList.setDisabled(lists.getSelectedIndex() == -1 || this.isLockedList(this.getSelectedListID()));
                    }
                }
            });
            this.parentLists.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (parentLists.getSelectedIndex() != -1) {
                        lists.setSelectedIndex(-1);
                    }
                    if (Main.isPrime()) {
                        tbRemoveVocabFromList.setDisabled(parentLists.getSelectedIndex() == -1 || this.isLockedList(this.getSelectedListID()));
                    }
                }
            });
            tbAddVocabToList.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!tbAddVocabToList.isDisabled()) {
                        if (isAutoDbUpdatesEnabled) {
                            RestClient.addVocabToPracticeList(this, this.getSelectedListID(), vocabID, false);
                        } else {
                            this.moveItemBetweenLists(false);
                        }
                    }
                }
            });
            tbRemoveVocabFromList.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!tbRemoveVocabFromList.isDisabled()) {
                        if (isAutoDbUpdatesEnabled) {
                            RestClient.addVocabToPracticeList(this, this.getSelectedListID(), vocabID, true);
                        } else {
                            this.moveItemBetweenLists(true);
                        }
                    }
                }
            });
            this.tbAddList.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!tbAddList.isDisabled()) {
                        Dialogs.showInputDialog(parentStage, "Add Practice List", "", 25, new Dialogs.InputAdapter(){

                            @Override
                            public void finished(String input) {
                                if (!(input = input.trim()).equals("")) {
                                    String[] listNamesAndCounts;
                                    for (String listNameAndCount : listNamesAndCounts = lists.getItems().toArray(String.class)) {
                                        String listName = listNameAndCount.substring(0, listNameAndCount.lastIndexOf(" "));
                                        if (!input.equals(listName)) continue;
                                        Dialogs.showErrorDialog(parentStage, "There is already a list with this name.");
                                        return;
                                    }
                                    RestClient.addPracticeList(this, input, false);
                                }
                            }
                        });
                    }
                }
            });
            this.tbDeleteList.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!tbDeleteList.isDisabled()) {
                        Dialogs.showConfirmDialog(parentStage, "Delete Practice List", "Are you sure you want to permanently delete \"" + this.getSelectedListName() + "\" ?", new Dialogs.ConfirmAdapter(){

                            @Override
                            public void yes() {
                                RestClient.addPracticeList(this, this.getSelectedListName(), true);
                            }
                        });
                    }
                }
            });
        }

        void refreshData() {
            this.mapLists.clear();
            this.mapParentLists.clear();
            this.lists.clearItems();
            this.parentLists.clearItems();
            RestClient.getPracticeLists(this);
        }

        void moveItemBetweenLists(boolean removed) {
            if (!removed) {
                String selectedListNameAndCount = this.lists.getSelected();
                String selectedListName = this.getSelectedListName();
                int selectedListId = this.getSelectedListID();
                int selectedListCount = this.getSelectedListVocabCount();
                this.lists.getItems().removeValue(selectedListNameAndCount, false);
                this.parentLists.getItems().add(selectedListNameAndCount);
                this.mapLists.remove(selectedListName);
                this.mapParentLists.put(selectedListName, new PracticeList(selectedListId, selectedListCount, selectedListName));
            } else {
                String selectedListNameAndCount = this.parentLists.getSelected();
                String selectedListName = this.getSelectedListName();
                int selectedListId = this.getSelectedListID();
                int selectedListCount = this.getSelectedListVocabCount();
                this.parentLists.getItems().removeValue(selectedListNameAndCount, false);
                this.lists.getItems().add(selectedListNameAndCount);
                this.mapParentLists.remove(selectedListName);
                this.mapLists.put(selectedListName, new PracticeList(selectedListId, selectedListCount, selectedListName));
            }
            this.lists.setSelectedIndex(-1);
            this.parentLists.setSelectedIndex(-1);
            this.lists.layoutAll();
            this.parentLists.layoutAll();
        }

        void disableAutomaticDatabaseUpdates(boolean disable) {
            this.isAutoDbUpdatesEnabled = !disable;
        }

        boolean isAutoDbUpdatesEnabled() {
            return this.isAutoDbUpdatesEnabled;
        }

        void pushChangesToDB() {
            String[] listItems = this.parentLists.getItems().toArray(String.class);
            if (listItems.length > 0) {
                int[] listIDs = new int[listItems.length];
                for (int x = 0; x < listItems.length; ++x) {
                    String listName = listItems[x].substring(0, listItems[x].lastIndexOf(" "));
                    listIDs[x] = this.mapParentLists.get((Object)listName).id;
                }
                RestClient.addVocabToPracticeList(this, listIDs, this.vocabID, false);
            }
        }

        void setPracticeLists(int[] id, int[] count, String[] name) {
            this.mapLists.clear();
            String[] listItems = new String[id.length];
            for (int i = 0; i < id.length; ++i) {
                this.mapLists.put(name[i], new PracticeList(id[i], count[i], name[i]));
                listItems[i] = name[i] + " (" + count[i] + ")";
            }
            this.lists.setItems(listItems);
            this.lists.setSelectedIndex(-1);
            if (Main.isPrime()) {
                this.tbAddList.setDisabled(false);
            }
        }

        void setParentLists(int[] id, int[] count, String[] name) {
            this.mapParentLists.clear();
            String[] parentListItems = new String[id.length];
            for (int i = 0; i < id.length; ++i) {
                this.mapParentLists.put(name[i], new PracticeList(id[i], 0, name[i]));
                parentListItems[i] = name[i] + " (" + count[i] + ")";
            }
            Array<String> a = this.lists.getItems();
            for (String aName : parentListItems) {
                if (!a.removeValue(aName, false)) continue;
                this.mapLists.remove(aName);
            }
            this.parentLists.setItems(parentListItems);
            this.parentLists.setSelectedIndex(-1);
        }

        void setVocab(int vocabID) {
            this.vocabID = vocabID;
        }

        void setListHeaderText(String text) {
            this.lists.setHeaderText(text);
        }

        boolean isLockedList(int listID) {
            int[] lockedLists;
            for (int i : lockedLists = new int[]{10}) {
                if (i != listID) continue;
                return true;
            }
            return false;
        }

        int getVocabID() {
            return this.vocabID;
        }

        int getSelectedListID() {
            if (this.lists.getSelectedIndex() != -1) {
                return this.mapLists.get((Object)this.getSelectedListName()).id;
            }
            if (this.parentLists.getSelectedIndex() != -1) {
                return this.mapParentLists.get((Object)this.getSelectedListName()).id;
            }
            return -1;
        }

        int getSelectedListVocabCount() {
            if (this.lists.getSelectedIndex() != -1) {
                return this.mapLists.get((Object)this.getSelectedListName()).vocabCount;
            }
            if (this.parentLists.getSelectedIndex() != -1) {
                return this.mapParentLists.get((Object)this.getSelectedListName()).vocabCount;
            }
            return -1;
        }

        String getSelectedListName() {
            if (this.lists.getSelectedIndex() != -1) {
                String selectedListNameAndCount = this.lists.getSelected();
                return selectedListNameAndCount.substring(0, selectedListNameAndCount.lastIndexOf(" "));
            }
            if (this.parentLists.getSelectedIndex() != -1) {
                String selectedListNameAndCount = this.parentLists.getSelected();
                return selectedListNameAndCount.substring(0, selectedListNameAndCount.lastIndexOf(" "));
            }
            return null;
        }

        String getListName(int listID) {
            PracticeList pl;
            for (Map.Entry<String, PracticeList> entry : this.mapLists.entrySet()) {
                pl = entry.getValue();
                if (listID != pl.id) continue;
                return entry.getKey();
            }
            for (Map.Entry<String, PracticeList> entry : this.mapParentLists.entrySet()) {
                pl = entry.getValue();
                if (listID != pl.id) continue;
                return entry.getKey();
            }
            return null;
        }

        class PracticeList {
            final int id;
            final int vocabCount;
            final String name;

            PracticeList(int id, int count, String name) {
                this.id = id;
                this.vocabCount = count;
                this.name = name;
            }
        }
    }
}

