/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.LocalFileHandleResolver;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.AudioHandler;
import com.torii.srs.Dashboard;
import com.torii.srs.DesktopSoundStateChecker;
import com.torii.srs.FileManager;
import com.torii.srs.InfoScreen;
import com.torii.srs.LoadingScreen;
import com.torii.srs.LoginScreen;
import com.torii.srs.NotificationHandler;
import com.torii.srs.ProgressScreen;
import com.torii.srs.ResourceMonitor;
import com.torii.srs.RestClient;
import com.torii.srs.ReviewScreen;
import com.torii.srs.SettingsScreen;
import com.torii.srs.StudyScreen;
import com.torii.srs.WelcomeScreen;
import com.torii.srs.widget.TextField;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class Main
extends Game {
    static final String VERSION = "1.4.9";
    static final String VERSION_DATE = "Nov. 20 2025";
    private static Main main;
    private static int WORLD_WIDTH;
    private static int WORLD_HEIGHT;
    private static int PPUX;
    private static int PPUY;
    private int windowedWidth;
    private int windowedHeight;
    private int windowedSizeLogical;
    private Screen previousScreen;
    private static Stage curStage;
    private static Stage dialogStage;
    private ShapeRenderer renderer;
    public static Color TRANSPARENT;
    public static Color UI_BG;
    public static Color UI_BG_LIGHTER;
    public static Color OBJECT_BG;
    public static Color OBJECT_OVER;
    public static Color OBJECT_PRESSED;
    public static Color FONT;
    public static Color GREEN_LIGHTEST;
    public static Color GREEN_LIGHT;
    public static Color GREEN_DARK;
    public static Color GREEN_DARKEST;
    public static Color GRAY_DARK;
    public static Color GRAY_BRIGHT;
    public static Color GOLD;
    static Color STUDY;
    static Color STUDY_OVER;
    static Color REVIEW;
    static Color REVIEW_OVER;
    static Color FUNCTION;
    static Color FUNCTION_OVER;
    public static Skin uiSkin;
    public static String FONT_KANA_X1;
    public static String FONT_KANA_X1P5;
    public static String FONT_KANA_X2;
    public static String fontX0p5;
    public static String fontX1;
    public static String fontX1p25;
    public static String fontX2;
    public static String fontX3;
    public static String fontX5;
    public static String fontX2plus;
    public static Label.LabelStyle labelStyleX0p5;
    public static Label.LabelStyle labelStyleX1;
    public static Label.LabelStyle labelStyleX1p25;
    public static Label.LabelStyle labelStyleX2;
    public static Label.LabelStyle labelStyleX3;
    public static Label.LabelStyle labelStyleX2plus;
    public static Label.LabelStyle labelStyleX0p5_w;
    public static Label.LabelStyle labelStyleX1_w;
    public static Label.LabelStyle labelStyleX1p25_w;
    public static Label.LabelStyle labelStyleX2_w;
    public static Label.LabelStyle labelStyleX3_w;
    public static Label.LabelStyle labelStyleX2plus_w;
    static LinkLabel.LinkLabelStyle linkLabelStyleX0p5;
    static LinkLabel.LinkLabelStyle linkLabelStyleX1;
    static Label.LabelStyle labelStyleKanaX1;
    static Label.LabelStyle labelStyleKanaX1_w;
    static VisTextField.VisTextFieldStyle tfStyleX0p5;
    static VisTextField.VisTextFieldStyle tfStyleX1;
    static VisTextField.VisTextFieldStyle tfStyleX1p25;
    static VisTextField.VisTextFieldStyle tfStyleX2;
    static VisTextField.VisTextFieldStyle taStyle;
    static VisTextButton.VisTextButtonStyle btnStyleX0p5;
    static VisTextButton.VisTextButtonStyle btnStyleX1;
    static VisTextButton.VisTextButtonStyle btnStyleX1p25;
    static VisTextButton.VisTextButtonStyle btnStyleX2;
    static VisTextButton.VisTextButtonStyle btnStyleToggleWhite;
    static VisCheckBox.VisCheckBoxStyle cbStyleWhite;
    private String userEmail = "";
    private String userPasswordHash = "";
    private String diacriticsChars;
    private String kanaChars;
    private String hiraganaChars;
    private String katakanaChars;
    private AssetManager assetManagerInternal;
    private AssetManager assetManagerAbsolute;
    public static String HOME_BTN_PATH;
    public static String SIGNOUT_BTN_PATH;
    public static String HELP_BTN_PATH;
    public static String THEME_BTN_PATH;
    public static String MENU_BTN_PATH;
    public static String ARCHIVE_BTN_PATH;
    public static String PLUS_BTN_PATH;
    public static String FLASH_BTN_PATH;
    public static String FONT_BTN_PATH;
    public static String KEYBINDS_BTN_PATH;
    public static String PLAY_BTN_PATH;
    public static String NEXT_BTN_PATH;
    public static String IGNORE_BTN_PATH;
    public static String SKIP_BTN_PATH;
    public static String INFO_BTN_PATH;
    public static String FONT_PATH;
    public static String DOWNLOADING_PATH;
    static String PROGRESS_BTN_PATH;
    static String SETTINGS_BTN_PATH;
    static String BROWSE_BTN_PATH;
    static String ADD_BTN_PATH;
    static String PRO_BTN_PATH;
    static String PRACTICE_BTN_PATH;
    static String LOAD_PATH;
    static String CHECKED_PATH;
    static String CHECKBOX_PATH;
    static String CHECKBOX_OVER_PATH;
    static String ROOKIE_UP_PATH;
    static String AMATEUR_UP_PATH;
    static String EXPERT_UP_PATH;
    static String MASTER_UP_PATH;
    static String SENSEI_UP_PATH;
    static String ROOKIE_DOWN_PATH;
    static String AMATEUR_DOWN_PATH;
    static String EXPERT_DOWN_PATH;
    static String MASTER_DOWN_PATH;
    static String SENSEI_DOWN_PATH;
    static String STAR_BTN_PATH;
    static String YELLOW_PATH;
    static String RED_PATH;
    static String ORANGE_PATH;
    static String GREEN_PATH;
    static String FLUFF_PATH;
    private int fps = 30;
    private int toriiTime = 0;
    private int studyTime = 0;
    private int reviewTime = 0;
    private int customVocabAmount = 0;
    private boolean isVacationModeActivated = false;
    private boolean isPrime = false;
    private boolean useDarkTheme = false;
    private boolean androidNotifications = true;
    private boolean macHdpiCompatMode = false;
    private boolean isSupportRequestKS;
    private Calendar lastVacationEnded;
    private Calendar isPrimeUntil;
    private AudioHandler audioHandler;
    private Timer.Task timerTask;
    public NotificationHandler handler;
    DesktopSoundStateChecker desktopSoundStateChecker;
    float t = 0.0f;
    private long diff;
    private long start = System.currentTimeMillis();

    @Override
    public void create() {
        main = this;
        Gdx.input.setCatchKey(4, true);
        this.assetManagerInternal = new AssetManager();
        this.assetManagerAbsolute = new AssetManager();
        this.audioHandler = new AudioHandler();
        dialogStage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.renderer = new ShapeRenderer();
        this.renderer.setAutoShapeType(true);
        this.renderer.setColor(0.0f, 0.0f, 0.0f, 0.75f);
        if (Main.isAndroid()) {
            this.handler.cancelScheduledNotification();
        }
        FileManager.deleteTemporaryFiles();
        HOME_BTN_PATH = "buttons/home.png";
        SIGNOUT_BTN_PATH = "buttons/signout.png";
        HELP_BTN_PATH = "buttons/help.png";
        THEME_BTN_PATH = "buttons/theme.png";
        MENU_BTN_PATH = "buttons/menu.png";
        ARCHIVE_BTN_PATH = "buttons/hide.png";
        PLUS_BTN_PATH = "buttons/plus.png";
        FLASH_BTN_PATH = "buttons/flash.png";
        FONT_BTN_PATH = "buttons/font.png";
        KEYBINDS_BTN_PATH = "buttons/keyboard.png";
        PLAY_BTN_PATH = "buttons/play.png";
        NEXT_BTN_PATH = "buttons/next.png";
        IGNORE_BTN_PATH = "buttons/ignore.png";
        SKIP_BTN_PATH = "buttons/skip.png";
        INFO_BTN_PATH = "buttons/info.png";
        PROGRESS_BTN_PATH = "buttons/progress.png";
        SETTINGS_BTN_PATH = "buttons/settings.png";
        BROWSE_BTN_PATH = "buttons/browse.png";
        ADD_BTN_PATH = "buttons/add.png";
        PRO_BTN_PATH = "buttons/pro.png";
        PRACTICE_BTN_PATH = "buttons/practice.png";
        DOWNLOADING_PATH = "buttons/download.png";
        LOAD_PATH = "images/loading.png";
        CHECKED_PATH = "drawables/checked.png";
        CHECKBOX_PATH = "drawables/checkbox.png";
        CHECKBOX_OVER_PATH = "drawables/checkbox_over.png";
        ROOKIE_UP_PATH = "labels/rookie-up.png";
        AMATEUR_UP_PATH = "labels/amateur-up.png";
        EXPERT_UP_PATH = "labels/expert-up.png";
        MASTER_UP_PATH = "labels/master-up.png";
        SENSEI_UP_PATH = "labels/sensei-up.png";
        ROOKIE_DOWN_PATH = "labels/rookie-down.png";
        AMATEUR_DOWN_PATH = "labels/amateur-down.png";
        EXPERT_DOWN_PATH = "labels/expert-down.png";
        MASTER_DOWN_PATH = "labels/master-down.png";
        SENSEI_DOWN_PATH = "labels/sensei-down.png";
        STAR_BTN_PATH = "buttons/star.png";
        YELLOW_PATH = "images/am.png";
        RED_PATH = "images/gm.png";
        ORANGE_PATH = "images/pm.png";
        GREEN_PATH = "images/tm.png";
        FLUFF_PATH = "images/rm.png";
        FONT_PATH = "fonts/SourceHanSansJPMedium.ttf";
        FONT_KANA_X1 = "kanaX1.ttf";
        FONT_KANA_X1P5 = "kanaX1p5.ttf";
        FONT_KANA_X2 = "kanaX2.ttf";
        fontX0p5 = "fontX0p5.ttf";
        fontX1 = "fontX1.ttf";
        fontX1p25 = "fontX1p25.ttf";
        fontX2 = "fontX2.ttf";
        fontX3 = "fontX3.ttf";
        fontX5 = "fontX5.ttf";
        fontX2plus = "fontX2plus.ttf";
        this.diacriticsChars = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u00b5";
        this.hiraganaChars = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d\u3083\u3085\u3087\u3093\u3063\u3041\u3043\u3045\u3047\u3049\u3095\u3096\u308e\u3094";
        this.katakanaChars = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30e3\u30e5\u30e7\u30f3\u30c3\u30a1\u30a3\u30a5\u30a7\u30a9\u30f5\u30f6\u30ee\u30f4";
        this.kanaChars = this.hiraganaChars + this.katakanaChars + "\u30fc\uff01\u3002\u30010123456789";
        GRAY_BRIGHT = new Color(0.90588236f, 0.90588236f, 0.90588236f, 1.0f);
        GOLD = new Color(0.6509804f, 0.4862745f, 0.0f, 1.0f);
        STUDY = new Color(0.98039216f, 0.0f, 0.6509804f, 1.0f);
        STUDY_OVER = new Color(Main.STUDY.r * 0.85f, Main.STUDY.g * 0.85f, Main.STUDY.b * 0.85f, 1.0f);
        REVIEW = new Color(0.63529414f, 0.0f, 0.95686275f, 1.0f);
        REVIEW_OVER = new Color(Main.REVIEW.r * 0.85f, Main.REVIEW.g * 0.85f, Main.REVIEW.b * 0.85f, 1.0f);
        FUNCTION = new Color(0.28235295f, 0.40392157f, 0.8784314f, 1.0f);
        FUNCTION_OVER = new Color(0.0f, 0.3137255f, 0.4509804f, 1.0f);
        TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        GREEN_LIGHTEST = new Color(0.32156864f, 0.7490196f, 0.5647059f, 1.0f);
        GREEN_LIGHT = new Color(0.09019608f, 0.67058825f, 0.5058824f, 1.0f);
        GREEN_DARK = new Color(0.25490198f, 0.59607846f, 0.4509804f, 1.0f);
        GREEN_DARKEST = new Color(0.22352941f, 0.52156866f, 0.39215687f, 1.0f);
        this.windowedWidth = Gdx.graphics.getWidth();
        this.windowedHeight = Gdx.graphics.getHeight();
        if (Main.isDesktop() || Main.isWeb()) {
            WORLD_WIDTH = 40;
            WORLD_HEIGHT = 40;
        } else {
            WORLD_WIDTH = 20;
            WORLD_HEIGHT = 40;
        }
        PPUX = this.windowedWidth / WORLD_WIDTH;
        PPUY = this.windowedHeight / WORLD_HEIGHT;
        this.loadAssets();
        this.createSkin();
        VisUI.load(uiSkin);
        VisUI.setDefaultTitleAlign(1);
        this.updateUItheme();
        new FileManager();
        new InfoScreen();
        new LoginScreen();
        new LoadingScreen();
        new WelcomeScreen();
        new Dashboard();
        new ProgressScreen();
        new StudyScreen();
        new ReviewScreen();
        new SettingsScreen();
        new ResourceMonitor();
        RestClient.checkUpdates();
        this.timerTask = new Timer.Task(){
            int timePassed = 0;

            @Override
            public void run() {
                ++this.timePassed;
                Main.this.toriiTime += 1;
                if (StudyScreen.isOnScreen()) {
                    Main.this.studyTime += 1;
                } else if (ReviewScreen.isOnScreen()) {
                    Main.this.reviewTime += 1;
                }
                long nextReviewDueSeconds = Dashboard.getNextReviewDueSeconds();
                if (nextReviewDueSeconds > 0L) {
                    Dashboard.setNextReviewDueSeconds(nextReviewDueSeconds - 1L);
                }
                if (this.timePassed == 60) {
                    this.timePassed = 0;
                    RestClient.updateTime(Main.this.toriiTime, Main.this.studyTime, Main.this.reviewTime);
                }
            }
        };
    }

    @Override
    public void render() {
        super.render();
        if (Main.getCurrentStage() == dialogStage) {
            Gdx.gl.glEnable(3042);
            Gdx.gl.glBlendFunc(770, 771);
            this.renderer.begin(ShapeRenderer.ShapeType.Filled);
            this.renderer.rect(0.0f, 0.0f, dialogStage.getViewport().getWorldWidth(), dialogStage.getViewport().getWorldHeight());
            this.renderer.end();
        }
        dialogStage.act();
        dialogStage.draw();
        this.checkResourceMonitor();
        this.sleep(this.fps);
    }

    @Override
    public void dispose() {
        RestClient.updateTime(this.toriiTime, this.studyTime, this.reviewTime);
        FileManager.deleteTemporaryFiles();
        this.assetManagerInternal.dispose();
        if (Main.isAndroid()) {
            System.exit(0);
        }
    }

    @Override
    public void resize(int width, int height) {
        dialogStage.getViewport().setWorldSize(width, height);
        dialogStage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
        long nextReviewDueSeconds;
        if (Main.isAndroid() && this.androidNotifications && (nextReviewDueSeconds = Dashboard.getNextReviewDueSeconds()) > 0L) {
            this.handler.scheduleNotification(nextReviewDueSeconds * 1000L);
        }
    }

    @Override
    public void resume() {
        if (Main.isAndroid()) {
            this.handler.cancelScheduledNotification();
        }
    }

    static void enterFullscreenMode() {
        String macosMonitorName = "color lcd";
        Graphics.DisplayMode currentDisplayMode = Gdx.graphics.getDisplayMode();
        Graphics.Monitor primaryMonitor = Gdx.graphics.getMonitor();
        if (Main.isMac() && primaryMonitor.name.toLowerCase().equals("color lcd") && Main.getMacHdpiCompatMode()) {
            Graphics.DisplayMode[] displayModeArray = Gdx.graphics.getDisplayModes();
            int n = displayModeArray.length;
            for (int i = 0; i < n; ++i) {
                Graphics.DisplayMode mode;
                currentDisplayMode = mode = displayModeArray[i];
            }
        }
        Gdx.graphics.setFullscreenMode(currentDisplayMode);
    }

    static void exitFullscreenMode() {
        boolean isSupported = Gdx.graphics.setWindowedMode(Main.main.windowedSizeLogical, Main.main.windowedSizeLogical);
    }

    static void setFPS(int fps) {
        Main.main.fps = fps;
    }

    private void sleep(int fps) {
        if (fps > 0) {
            this.diff = System.currentTimeMillis() - this.start;
            long targetDelay = 1000 / fps;
            if (this.diff < targetDelay) {
                try {
                    Thread.sleep(targetDelay - this.diff);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.start = System.currentTimeMillis();
        }
    }

    static String generatePasswordHash(String plainPassword) {
        String hashedPassword = plainPassword;
        try {
            MessageDigest dig = MessageDigest.getInstance("SHA-256");
            byte[] byteHash = dig.digest(plainPassword.getBytes(StandardCharsets.UTF_8));
            char[] charHash = Base64Coder.encode(byteHash);
            hashedPassword = String.valueOf(charHash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hashedPassword;
    }

    public static <T> T getAsset(String name, Class type, boolean internal) {
        return internal ? Main.main.assetManagerInternal.get(name, type) : Main.main.assetManagerAbsolute.get(name, type);
    }

    public static void disposeAsset(String name, boolean internal) {
        if (internal) {
            if (Main.main.assetManagerInternal.isLoaded(name)) {
                Main.main.assetManagerInternal.unload(name);
            }
        } else if (Main.main.assetManagerAbsolute.isLoaded(name)) {
            Main.main.assetManagerAbsolute.unload(name);
        }
    }

    public static void finishLoadingAsset(String name, boolean internal) {
        if (internal) {
            Main.main.assetManagerInternal.finishLoadingAsset(name);
            if (Main.main.assetManagerInternal.getAssetType(name) == BitmapFont.class) {
                Main.main.assetManagerInternal.get((String)name, BitmapFont.class).getData().markupEnabled = true;
            }
        } else {
            Main.main.assetManagerAbsolute.finishLoadingAsset(name);
            if (Main.main.assetManagerAbsolute.getAssetType(name) == BitmapFont.class) {
                Main.main.assetManagerAbsolute.get((String)name, BitmapFont.class).getData().markupEnabled = true;
            }
        }
    }

    static void finishLoadingAssets(boolean internal) {
        if (internal) {
            Main.main.assetManagerInternal.finishLoading();
        } else {
            Main.main.assetManagerAbsolute.finishLoading();
        }
    }

    static boolean updateAssetManager(boolean internal) {
        return internal ? Main.main.assetManagerInternal.update() : Main.main.assetManagerAbsolute.update();
    }

    static boolean isAssetLoaded(String name, boolean internal) {
        return internal ? Main.main.assetManagerInternal.isLoaded(name) : Main.main.assetManagerAbsolute.isLoaded(name);
    }

    private void loadAssets() {
        TextureLoader.TextureParameter param = new TextureLoader.TextureParameter();
        param.minFilter = Texture.TextureFilter.MipMapLinearLinear;
        param.genMipMaps = true;
        this.assetManagerInternal.load(HOME_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(SIGNOUT_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(HELP_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(THEME_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(MENU_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(ARCHIVE_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(PLUS_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(FLASH_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(FONT_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(KEYBINDS_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(PLAY_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(NEXT_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(IGNORE_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(SKIP_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(INFO_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(PROGRESS_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(SETTINGS_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(BROWSE_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(ADD_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(PRO_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(PRACTICE_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(DOWNLOADING_PATH, Texture.class, param);
        this.assetManagerInternal.load(LOAD_PATH, Texture.class, param);
        this.assetManagerInternal.load(CHECKED_PATH, Texture.class, param);
        this.assetManagerInternal.load(CHECKBOX_PATH, Texture.class, param);
        this.assetManagerInternal.load(CHECKBOX_OVER_PATH, Texture.class, param);
        this.assetManagerInternal.load(ROOKIE_UP_PATH, Texture.class, param);
        this.assetManagerInternal.load(AMATEUR_UP_PATH, Texture.class, param);
        this.assetManagerInternal.load(EXPERT_UP_PATH, Texture.class, param);
        this.assetManagerInternal.load(MASTER_UP_PATH, Texture.class, param);
        this.assetManagerInternal.load(SENSEI_UP_PATH, Texture.class, param);
        this.assetManagerInternal.load(ROOKIE_DOWN_PATH, Texture.class, param);
        this.assetManagerInternal.load(AMATEUR_DOWN_PATH, Texture.class, param);
        this.assetManagerInternal.load(EXPERT_DOWN_PATH, Texture.class, param);
        this.assetManagerInternal.load(MASTER_DOWN_PATH, Texture.class, param);
        this.assetManagerInternal.load(SENSEI_DOWN_PATH, Texture.class, param);
        this.assetManagerInternal.load(STAR_BTN_PATH, Texture.class, param);
        this.assetManagerInternal.load(YELLOW_PATH, Texture.class, param);
        this.assetManagerInternal.load(RED_PATH, Texture.class, param);
        this.assetManagerInternal.load(ORANGE_PATH, Texture.class, param);
        this.assetManagerInternal.load(GREEN_PATH, Texture.class, param);
        this.assetManagerInternal.load(FLUFF_PATH, Texture.class, param);
        float dummy = 0.6f * (float)PPUY;
        float dummy2 = 1.25f * (float)PPUY;
        float dummy3 = 1.5f * (float)PPUY;
        Main.loadTTFtoAssetManager(FONT_KANA_X1, PPUY, this.kanaChars + "\u7b54", false);
        Main.loadTTFtoAssetManager(FONT_KANA_X1P5, (int)dummy3, this.kanaChars + "\u7b54", false, 1, 2);
        Main.loadTTFtoAssetManager(FONT_KANA_X2, 2 * PPUY, this.kanaChars + "\u7b54", false, 1, 2);
        this.loadTTFtoAssetManager(fontX0p5, (int)dummy);
        this.loadTTFtoAssetManager(fontX1, PPUY);
        this.loadTTFtoAssetManager(fontX1p25, (int)dummy2);
        this.loadTTFtoAssetManager(fontX2, 2 * PPUY);
        this.loadTTFtoAssetManager(fontX3, 3 * PPUY);
        this.loadTTFtoAssetManager(fontX5, 5 * PPUY);
        Main.loadTTFtoAssetManager(fontX2plus, 2 * PPUY, "", false, 1, 2);
        this.assetManagerInternal.finishLoading();
        this.assetManagerInternal.get((String)Main.fontX0p5, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX1, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX1p25, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX2, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX3, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX5, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.FONT_KANA_X1, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.FONT_KANA_X1P5, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.FONT_KANA_X2, BitmapFont.class).getData().markupEnabled = true;
        this.assetManagerInternal.get((String)Main.fontX2plus, BitmapFont.class).getData().markupEnabled = true;
    }

    static void launchApp(boolean exitApp) {
        if (!exitApp) {
            FileManager.CredentialPrefs prr = FileManager.readCredentialPreferences();
            Main.setTheme(prr.useDarkTheme);
            Main.setMacHdpiCompatMode(prr.macHdpiCompatMode);
            if (prr.isUserCredentialsValid()) {
                Main.main.userEmail = prr.userName;
                Main.main.userPasswordHash = prr.userPassword;
                RestClient.checkSessionExpired(Main.main.userEmail);
            } else {
                LoginScreen.showOnScreen();
            }
        } else {
            Gdx.app.exit();
        }
    }

    static void setData(String email, String passwordHash) {
        Main.main.userEmail = email;
        Main.main.userPasswordHash = passwordHash;
        FileManager.writeCredentialPreferences();
    }

    static NotificationHandler getNotificationHandler() {
        return Main.main.handler;
    }

    void setNotificationHandler(NotificationHandler handler) {
        this.handler = handler;
    }

    static DesktopSoundStateChecker getDesktopSoundStateChecker() {
        return Main.main.desktopSoundStateChecker;
    }

    public void setDesktopWindowedSizeLogical(int size) {
        this.windowedSizeLogical = size;
    }

    public void setDesktopSoundStateChecker(DesktopSoundStateChecker desktopSoundStateChecker) {
        this.desktopSoundStateChecker = desktopSoundStateChecker;
    }

    static void startTimer() {
        if (!Main.main.timerTask.isScheduled()) {
            Timer.schedule(Main.main.timerTask, 1.0f, 1.0f);
        }
    }

    static void stopTimer() {
        if (Main.main.timerTask.isScheduled()) {
            Main.main.timerTask.cancel();
            Main.main.toriiTime = 0;
            Main.main.studyTime = 0;
            Main.main.reviewTime = 0;
        }
    }

    static void setAKS(boolean enabled) {
        Main.main.audioHandler.setAKS(enabled);
    }

    static boolean isAKS() {
        return Main.main.audioHandler.isAKS();
    }

    static void setSupportRequestKS(boolean enabled) {
        Main.main.isSupportRequestKS = enabled;
    }

    static boolean getSupportRequestKS() {
        return Main.main.isSupportRequestKS;
    }

    static void playSound(String vocabFileName, String sentenceFileName) {
        Main.main.audioHandler.playExampleAudio(vocabFileName, sentenceFileName);
    }

    static void playTheThing() {
        Main.main.audioHandler.playTheThing();
    }

    static void stopSound() {
        Main.main.audioHandler.stopSound();
    }

    static void stopMusic() {
        Main.main.audioHandler.stopMusic();
    }

    static Stage getDialogStage() {
        return dialogStage;
    }

    static boolean getAndroidNotifications() {
        return Main.main.androidNotifications;
    }

    static void setAndroidNotifications(boolean enabled) {
        Main.main.androidNotifications = enabled;
    }

    static void setIsVacationModeActivated(boolean isVacationModeActivated, String lastVacationEnded) {
        Main.main.isVacationModeActivated = isVacationModeActivated;
        Main.main.lastVacationEnded = Main.timestampToCalendar(lastVacationEnded);
    }

    static boolean isVacationModeActivated() {
        return Main.main.isVacationModeActivated;
    }

    static Calendar getLastVacationEnded() {
        return Main.main.lastVacationEnded;
    }

    static void setIsPrime(boolean isPrime, String isPrimeUntil) {
        Main.main.isPrime = isPrime;
        Main.main.isPrimeUntil = Main.timestampToCalendar(isPrimeUntil);
        Dashboard.setPrimeLayout(isPrime);
    }

    static Calendar timestampToCalendar(String s) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.ENGLISH);
        Calendar cal = null;
        try {
            Date date = format.parse(s);
            cal = Calendar.getInstance();
            cal.setTime(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cal;
    }

    static boolean isPrime() {
        return Main.main.isPrime;
    }

    static Calendar getIsPrimeUntil() {
        return Main.main.isPrimeUntil;
    }

    static void setTheme(boolean useDarkTheme) {
        Main.main.useDarkTheme = useDarkTheme;
        main.updateUItheme();
    }

    static boolean getTheme() {
        return Main.main.useDarkTheme;
    }

    static void setMacHdpiCompatMode(boolean macHdpiCompatMode) {
        Main.main.macHdpiCompatMode = macHdpiCompatMode;
    }

    static boolean getMacHdpiCompatMode() {
        return Main.main.macHdpiCompatMode;
    }

    static int getToriiTime() {
        return Main.main.toriiTime;
    }

    static int getStudyTime() {
        return Main.main.studyTime;
    }

    static int getReviewTime() {
        return Main.main.reviewTime;
    }

    static void setToriiTime(int value) {
        Main.main.toriiTime = value;
    }

    static void setStudyTime(int value) {
        Main.main.studyTime = value;
    }

    static void setReviewTime(int value) {
        Main.main.reviewTime = value;
    }

    static void setCustomVocabAmount(int value) {
        Main.main.customVocabAmount = value;
    }

    static int getCustomVocabAmount() {
        return Main.main.customVocabAmount;
    }

    static boolean isMobile() {
        return Main.isAndroid() || Main.isIos();
    }

    static boolean isDesktop() {
        return Gdx.app.getType() == Application.ApplicationType.Desktop;
    }

    static boolean isAndroid() {
        return Gdx.app.getType() == Application.ApplicationType.Android;
    }

    static boolean isIos() {
        return Gdx.app.getType() == Application.ApplicationType.iOS;
    }

    static boolean isWeb() {
        return Gdx.app.getType() == Application.ApplicationType.Applet || Gdx.app.getType() == Application.ApplicationType.WebGL;
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    static void setNewScreen(Screen newScreen) {
        if (Main.main.previousScreen != main.getScreen()) {
            Main.main.previousScreen = main.getScreen();
        }
        main.setScreen(newScreen);
    }

    static Screen getCurrentScreen() {
        return main.getScreen();
    }

    static Screen getPreviousScreen() {
        return Main.main.previousScreen;
    }

    static void setCurrentStage(Stage stage) {
        curStage = stage;
    }

    public static Stage getCurrentStage() {
        return curStage;
    }

    static int getWorldWidth() {
        return WORLD_WIDTH;
    }

    static int getWorldHeight() {
        return WORLD_HEIGHT;
    }

    static int getPPUX() {
        return PPUX;
    }

    public static int getPPUY() {
        return PPUY;
    }

    static int getWindowedWidth() {
        return Main.main.windowedWidth;
    }

    static int getWindowedHeight() {
        return Main.main.windowedHeight;
    }

    static String getUserEmail() {
        return Main.main.userEmail;
    }

    static String getUserPassword() {
        return Main.main.userPasswordHash;
    }

    static String getDiacriticsChars() {
        return Main.main.diacriticsChars;
    }

    public static String getKanaChars() {
        return Main.main.kanaChars;
    }

    static Animation<TextureRegion> pngToAnimation(Texture pngFile, int pngWidth, int pngHeight, float frameDuration) {
        Texture imgLoading = pngFile;
        imgLoading.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Nearest);
        int cols = imgLoading.getWidth() / pngWidth;
        int rows = imgLoading.getHeight() / pngHeight;
        TextureRegion[][] txRegion3dTmp = TextureRegion.split(imgLoading, pngWidth, pngHeight);
        TextureRegion[] txRegion2dTmp = new TextureRegion[cols * rows];
        int index = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                txRegion2dTmp[index] = txRegion3dTmp[i][j];
                ++index;
            }
        }
        return new Animation<TextureRegion>(frameDuration, txRegion2dTmp);
    }

    private void loadTTFtoAssetManager(String name, int fontSize) {
        Main.loadTTFtoAssetManager(true, FONT_PATH, name, fontSize, "", false, 0, 0);
    }

    public static void loadTTFtoAssetManager(String name, int fontSize, String characters, boolean isCharsExclusive) {
        Main.loadTTFtoAssetManager(true, FONT_PATH, name, fontSize, characters, isCharsExclusive, 0, 0);
    }

    static void loadTTFtoAssetManager(String name, int fontSize, String characters, boolean isCharsExclusive, int borderWidth, int shadowOffset) {
        Main.loadTTFtoAssetManager(true, FONT_PATH, name, fontSize, characters, isCharsExclusive, borderWidth, shadowOffset);
    }

    static void loadTTFtoAssetManager(boolean internal, String path, String name, int fontSize, String characters, boolean isCharsExclusive, int borderWidth, int shadowOffset) {
        FreeTypeFontGenerator.setMaxTextureSize(2048);
        FileHandleResolver resolver = internal ? new InternalFileHandleResolver() : new LocalFileHandleResolver();
        AssetManager assetManager = internal ? Main.main.assetManagerInternal : Main.main.assetManagerAbsolute;
        assetManager.setLoader(FreeTypeFontGenerator.class, new FreeTypeFontGeneratorLoader(resolver));
        assetManager.setLoader(BitmapFont.class, ".ttf", new FreetypeFontLoader(resolver));
        FreetypeFontLoader.FreeTypeFontLoaderParameter font = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        String defaultChars = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u2014\u2022\u21c4\u2190\u2192\u2191\u2193\u221e\u2661";
        font.fontFileName = path;
        font.fontParameters.color = Color.WHITE;
        font.fontParameters.size = fontSize;
        font.fontParameters.characters = !characters.equals("") ? (!isCharsExclusive ? defaultChars + characters : characters) : defaultChars;
        if (borderWidth != 0) {
            font.fontParameters.borderColor = Color.BLACK;
            font.fontParameters.borderWidth = borderWidth;
        }
        if (shadowOffset != 0) {
            font.fontParameters.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.25f);
            font.fontParameters.shadowOffsetX = shadowOffset;
            font.fontParameters.shadowOffsetY = shadowOffset;
        }
        if (assetManager.isLoaded(name, BitmapFont.class)) {
            assetManager.unload(name);
        }
        assetManager.load(name, BitmapFont.class, font);
    }

    private void checkResourceMonitor() {
        boolean show = false;
        if (this.getScreen() != ResourceMonitor.resourceMonitor && curStage != dialogStage && Gdx.input.isKeyPressed(142)) {
            show = true;
        }
        if (show) {
            ResourceMonitor.showOnScreen();
        }
    }

    private void createSkin() {
        uiSkin = new Skin();
        uiSkin.add("default", Main.getAsset(fontX1, BitmapFont.class, true));
        uiSkin.addRegions(new TextureAtlas(Gdx.files.internal("skins/uiskin.atlas")));
        uiSkin.load(Gdx.files.internal("skins/uiskin.json"));
    }

    private void updateUItheme() {
        Color disabledFontColor;
        if (this.useDarkTheme) {
            FONT = Color.WHITE;
            UI_BG = new Color(0.18431373f, 0.19215687f, 0.21176471f, 1.0f);
            UI_BG_LIGHTER = new Color(0.21176471f, 0.22352941f, 0.24313726f, 1.0f);
            OBJECT_BG = new Color(0.28235295f, 0.29803923f, 0.32156864f, 1.0f);
            OBJECT_OVER = new Color(0.3529412f, 0.37254903f, 0.4f, 1.0f);
            OBJECT_PRESSED = new Color(0.105882354f, 0.6313726f, 0.8862745f, 1.0f);
            GRAY_DARK = new Color(0.1254902f, 0.13333334f, 0.14509805f, 1.0f);
            disabledFontColor = new Color(Main.OBJECT_BG.r / 0.6f, Main.OBJECT_BG.g / 0.6f, Main.OBJECT_BG.b / 0.6f, 1.0f);
        } else {
            FONT = new Color(0.19607843f, 0.19607843f, 0.19607843f, 1.0f);
            UI_BG_LIGHTER = new Color(0.95686275f, 0.95686275f, 0.95686275f, 1.0f);
            UI_BG = new Color(0.87058824f, 0.87058824f, 0.87058824f, 1.0f);
            OBJECT_BG = new Color(0.6862745f, 0.6862745f, 0.6862745f, 1.0f);
            OBJECT_OVER = new Color(0.5882353f, 0.5882353f, 0.5882353f, 1.0f);
            OBJECT_PRESSED = new Color(0.105882354f, 0.6313726f, 0.8862745f, 1.0f);
            GRAY_DARK = new Color(0.37254903f, 0.37254903f, 0.37254903f, 1.0f);
            disabledFontColor = new Color(Main.OBJECT_BG.r * 0.6f, Main.OBJECT_BG.g * 0.6f, Main.OBJECT_BG.b * 0.6f, 1.0f);
        }
        Label.LabelStyle dummyLabelStyle = new VisLabel("").getStyle();
        dummyLabelStyle.fontColor = Color.WHITE;
        labelStyleX0p5 = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX0p5, BitmapFont.class, true), FONT);
        labelStyleX1 = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true), FONT);
        labelStyleX1p25 = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX1p25, BitmapFont.class, true), FONT);
        labelStyleX2 = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX2, BitmapFont.class, true), FONT);
        labelStyleX3 = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX3, BitmapFont.class, true), FONT);
        labelStyleX2plus = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX2plus, BitmapFont.class, true), FONT);
        labelStyleKanaX1 = new Label.LabelStyle((BitmapFont)Main.getAsset(FONT_KANA_X1, BitmapFont.class, true), FONT);
        labelStyleX0p5_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX0p5, BitmapFont.class, true), Color.WHITE);
        labelStyleX1_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true), Color.WHITE);
        labelStyleX1p25_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX1p25, BitmapFont.class, true), Color.WHITE);
        labelStyleX2_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX2, BitmapFont.class, true), Color.WHITE);
        labelStyleX3_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX3, BitmapFont.class, true), Color.WHITE);
        labelStyleX2plus_w = new Label.LabelStyle((BitmapFont)Main.getAsset(fontX2plus, BitmapFont.class, true), Color.WHITE);
        labelStyleKanaX1_w = new Label.LabelStyle((BitmapFont)Main.getAsset(FONT_KANA_X1, BitmapFont.class, true), Color.WHITE);
        Main.labelStyleX0p5.fontColor = FONT;
        Main.labelStyleX1.fontColor = FONT;
        Main.labelStyleX1p25.fontColor = FONT;
        Main.labelStyleX2.fontColor = FONT;
        Main.labelStyleX3.fontColor = FONT;
        Main.labelStyleX2plus.fontColor = FONT;
        Main.labelStyleKanaX1.fontColor = FONT;
        LinkLabel.LinkLabelStyle dummyLinkLabel = new LinkLabel("").getStyle();
        dummyLinkLabel.fontColor = FUNCTION;
        linkLabelStyleX0p5 = new LinkLabel.LinkLabelStyle(new LinkLabel("").getStyle());
        linkLabelStyleX1 = new LinkLabel.LinkLabelStyle(new LinkLabel("").getStyle());
        Main.linkLabelStyleX0p5.font = (BitmapFont)Main.getAsset(fontX0p5, BitmapFont.class, true);
        Main.linkLabelStyleX1.font = (BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true);
        Main.linkLabelStyleX0p5.fontColor = FUNCTION;
        Main.linkLabelStyleX1.fontColor = FUNCTION;
        VisTextField.VisTextFieldStyle dummyTextField = new TextField("").getStyle();
        dummyTextField.background = uiSkin.newDrawable("white", OBJECT_BG);
        dummyTextField.backgroundOver = uiSkin.newDrawable("white", OBJECT_OVER);
        dummyTextField.disabledBackground = dummyTextField.background;
        dummyTextField.focusedBackground = dummyTextField.background;
        dummyTextField.disabledFontColor = FONT;
        dummyTextField.background.setLeftWidth(dummyTextField.background.getLeftWidth() + TextField.offset);
        dummyTextField.background.setRightWidth(dummyTextField.background.getRightWidth() + TextField.offset);
        dummyTextField.backgroundOver.setLeftWidth(dummyTextField.backgroundOver.getLeftWidth() + TextField.offset);
        dummyTextField.backgroundOver.setRightWidth(dummyTextField.backgroundOver.getRightWidth() + TextField.offset);
        tfStyleX0p5 = new VisTextField.VisTextFieldStyle(new TextField("").getStyle());
        tfStyleX1 = new VisTextField.VisTextFieldStyle(new TextField("").getStyle());
        tfStyleX1p25 = new VisTextField.VisTextFieldStyle(new TextField("").getStyle());
        tfStyleX2 = new VisTextField.VisTextFieldStyle(new TextField("").getStyle());
        Main.tfStyleX0p5.font = (BitmapFont)Main.getAsset(fontX0p5, BitmapFont.class, true);
        Main.tfStyleX1.font = (BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true);
        Main.tfStyleX1p25.font = (BitmapFont)Main.getAsset(fontX1p25, BitmapFont.class, true);
        Main.tfStyleX2.font = (BitmapFont)Main.getAsset(fontX2, BitmapFont.class, true);
        Main.tfStyleX0p5.fontColor = FONT;
        Main.tfStyleX1.fontColor = FONT;
        Main.tfStyleX1p25.fontColor = FONT;
        Main.tfStyleX2.fontColor = FONT;
        taStyle = new VisTextField.VisTextFieldStyle(new TextField("").getStyle());
        Main.taStyle.font = (BitmapFont)Main.getAsset(FONT_KANA_X1, BitmapFont.class, true);
        Main.taStyle.fontColor = FONT;
        Main.taStyle.messageFontColor = disabledFontColor;
        Main.taStyle.backgroundOver = Main.taStyle.background = uiSkin.newDrawable("white", OBJECT_BG);
        Main.taStyle.disabledBackground = Main.taStyle.background;
        Main.taStyle.focusedBackground = Main.taStyle.background;
        Main.taStyle.background.setTopHeight(Main.taStyle.background.getTopHeight() + (float)Main.getPPUY() / 2.0f);
        Main.taStyle.background.setLeftWidth(Main.taStyle.background.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        Main.taStyle.background.setRightWidth(Main.taStyle.background.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        VisTextButton.VisTextButtonStyle dummyTextButton = (VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle();
        dummyTextButton.font = (BitmapFont)Main.getAsset(fontX1p25, BitmapFont.class, true);
        dummyTextButton.up = uiSkin.newDrawable("white", OBJECT_BG);
        dummyTextButton.over = uiSkin.newDrawable("white", OBJECT_OVER);
        dummyTextButton.down = uiSkin.newDrawable("white", OBJECT_PRESSED);
        dummyTextButton.disabled = dummyTextButton.up;
        dummyTextButton.disabledFontColor = disabledFontColor;
        dummyTextButton.up.setLeftWidth(dummyTextButton.up.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton.up.setRightWidth(dummyTextButton.up.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton.over.setLeftWidth(dummyTextButton.over.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton.over.setRightWidth(dummyTextButton.over.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton.down.setLeftWidth(dummyTextButton.down.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton.down.setRightWidth(dummyTextButton.down.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        btnStyleX0p5 = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        btnStyleX1 = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        btnStyleX1p25 = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        btnStyleX2 = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        Main.btnStyleX0p5.font = (BitmapFont)Main.getAsset(fontX0p5, BitmapFont.class, true);
        Main.btnStyleX1.font = (BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true);
        Main.btnStyleX1p25.font = (BitmapFont)Main.getAsset(fontX1p25, BitmapFont.class, true);
        Main.btnStyleX2.font = (BitmapFont)Main.getAsset(fontX2, BitmapFont.class, true);
        Main.btnStyleX0p5.fontColor = FONT;
        Main.btnStyleX1.fontColor = FONT;
        Main.btnStyleX1p25.fontColor = FONT;
        Main.btnStyleX2.fontColor = FONT;
        VisTextButton.VisTextButtonStyle dummyTextButton2 = (VisTextButton.VisTextButtonStyle)new VisTextButton("", "toggle").getStyle();
        dummyTextButton2.font = (BitmapFont)Main.getAsset(fontX1, BitmapFont.class, true);
        dummyTextButton2.up = uiSkin.newDrawable("white", TRANSPARENT);
        dummyTextButton2.over = uiSkin.newDrawable("white", OBJECT_OVER);
        dummyTextButton2.checked = dummyTextButton2.down = uiSkin.newDrawable("white", OBJECT_PRESSED);
        dummyTextButton2.up.setLeftWidth(dummyTextButton2.up.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.up.setRightWidth(dummyTextButton2.up.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.over.setLeftWidth(dummyTextButton2.over.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.over.setRightWidth(dummyTextButton2.over.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.down.setLeftWidth(dummyTextButton2.down.getLeftWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.down.setRightWidth(dummyTextButton2.down.getRightWidth() + (float)Main.getPPUY() / 2.0f);
        dummyTextButton2.fontColor = FONT;
        dummyTextButton2.checkedFontColor = Color.WHITE;
        dummyTextButton2.disabledFontColor = disabledFontColor;
        btnStyleToggleWhite = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("", "toggle").getStyle());
        Main.btnStyleToggleWhite.fontColor = Color.WHITE;
        VisCheckBox.VisCheckBoxStyle dummyCheckBox = new VisCheckBox("").getStyle();
        Image imgChecked = new Image((Texture)Main.getAsset(CHECKED_PATH, Texture.class, true));
        Drawable checked = imgChecked.getDrawable();
        imgChecked = new Image((Texture)Main.getAsset(CHECKBOX_PATH, Texture.class, true));
        Drawable checkbox = imgChecked.getDrawable();
        imgChecked = new Image((Texture)Main.getAsset(CHECKBOX_OVER_PATH, Texture.class, true));
        Drawable checkbox_over = imgChecked.getDrawable();
        dummyCheckBox.checkBackground = checkbox;
        dummyCheckBox.checkBackgroundDown = checkbox;
        dummyCheckBox.checkBackgroundOver = checkbox_over;
        dummyCheckBox.tick = checked;
        dummyCheckBox.fontColor = FONT;
        cbStyleWhite = new VisCheckBox.VisCheckBoxStyle(new VisCheckBox("").getStyle());
        Main.cbStyleWhite.fontColor = Color.WHITE;
        SelectBox.SelectBoxStyle dummySelectBox = new VisSelectBox().getStyle();
        dummySelectBox.background = uiSkin.newDrawable("white", OBJECT_BG);
        dummySelectBox.backgroundOver = uiSkin.newDrawable("white", OBJECT_OVER);
        dummySelectBox.backgroundOpen = uiSkin.newDrawable("white", OBJECT_OVER);
        dummySelectBox.listStyle.background = uiSkin.newDrawable("white", OBJECT_BG);
        dummySelectBox.listStyle.fontColorUnselected = FONT;
        dummySelectBox.listStyle.fontColorSelected = FONT;
        dummySelectBox.fontColor = FONT;
        Colors.put("CR", new Color(1.0f, 0.0f, 0.19607843f, 1.0f));
        Colors.put("CRED", new Color(1.0f, 0.0f, 0.19607843f, 1.0f));
        Colors.put("TB", OBJECT_PRESSED);
        Colors.put("DISABLED", new VisTextButton((String)"").getStyle().disabledFontColor);
    }
}

