/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.torii.srs.Dashboard;
import com.torii.srs.InfoScreen;
import com.torii.srs.Main;

public class LoadingScreen
implements Screen {
    static LoadingScreen loadingScreen;
    private static Screen parentScreen;
    private final float textureSize;
    private Stage stage;
    private SpriteBatch batch;
    private ShapeRenderer renderer;
    private Animation<TextureRegion> animLoading;
    private Animation<TextureRegion> animFluff;
    private float deltaLoading;
    private float deltaFluff;
    private final int animFluffWidth = 84;
    private final int animFluffHeight = 84;
    private Timer.Task failsafe;

    LoadingScreen() {
        loadingScreen = this;
        this.textureSize = 3 * Main.getPPUY();
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.batch = new SpriteBatch();
        this.renderer = new ShapeRenderer();
        this.renderer.setAutoShapeType(true);
        this.renderer.setColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.animLoading = Main.pngToAnimation((Texture)Main.getAsset(Main.LOAD_PATH, Texture.class, true), 128, 128, 0.03f);
        this.animFluff = Main.pngToAnimation((Texture)Main.getAsset(Main.FLUFF_PATH, Texture.class, true), 84, 84, 0.25f);
        this.deltaLoading = 0.0f;
        this.failsafe = new Timer.Task(){

            @Override
            public void run() {
                this.cancel();
                if (LoadingScreen.isOnScreen()) {
                    if (parentScreen != null) {
                        LoadingScreen.hideOnScreen();
                    } else {
                        InfoScreen.showNoNetworkNotification();
                    }
                }
            }
        };
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
    }

    @Override
    public void render(float delta) {
        if (parentScreen != null) {
            parentScreen.render(delta);
        }
        this.stage.act(delta);
        this.stage.draw();
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.rect(0.0f, 0.0f, this.stage.getViewport().getWorldWidth(), this.stage.getViewport().getWorldHeight());
        this.renderer.end();
        this.stage.getViewport().apply();
        if (!Dashboard.isKonamiStreakOver9000()) {
            this.deltaLoading += delta;
            this.batch.begin();
            this.batch.draw(this.animLoading.getKeyFrame(this.deltaLoading, true), this.stage.getViewport().getWorldWidth() / 2.0f - this.textureSize / 2.0f, this.stage.getViewport().getWorldHeight() / 2.0f - this.textureSize / 2.0f, this.textureSize, this.textureSize);
            this.batch.end();
        } else {
            this.deltaFluff += delta;
            this.batch.begin();
            this.batch.draw(this.animFluff.getKeyFrame(this.deltaFluff, true), this.stage.getViewport().getWorldWidth() / 2.0f - 84.0f, this.stage.getViewport().getWorldHeight() / 2.0f - 84.0f, 168.0f, 168.0f);
            this.batch.end();
        }
    }

    @Override
    public void resize(int width, int height) {
        if ((float)width != this.stage.getViewport().getWorldWidth() || (float)height != this.stage.getViewport().getWorldHeight()) {
            this.stage.getViewport().setWorldSize(width, height);
            this.batch = new SpriteBatch();
            this.renderer = new ShapeRenderer();
            this.renderer.setAutoShapeType(true);
            this.renderer.setColor(0.0f, 0.0f, 0.0f, 0.75f);
        }
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private static boolean isOnScreen() {
        return Main.getCurrentScreen() == loadingScreen;
    }

    public static void showOnScreen() {
        if (!LoadingScreen.isOnScreen()) {
            parentScreen = Main.getCurrentScreen();
            Main.setNewScreen(loadingScreen);
            if (!LoadingScreen.loadingScreen.failsafe.isScheduled()) {
                Timer.schedule(LoadingScreen.loadingScreen.failsafe, 20.0f);
            }
        }
    }

    static void hideOnScreen() {
        Main.setNewScreen(parentScreen);
        if (LoadingScreen.loadingScreen.failsafe.isScheduled()) {
            LoadingScreen.loadingScreen.failsafe.cancel();
        }
    }
}

