/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.RestClient;

class Hints {
    private static boolean showHints;
    private static boolean hintSettings;
    private static boolean hintAddSynonym;
    private static boolean hintAddReading;
    private static boolean hintArchive;
    private static boolean hintNavigate;
    private static boolean hintPractice;

    Hints() {
    }

    static void setShowHints(boolean value) {
        showHints = value;
    }

    static void setHintSettings(boolean show) {
        hintSettings = show;
    }

    static void setHintAddSynonym(boolean show) {
        hintAddSynonym = show;
    }

    static void setHintAddReading(boolean show) {
        hintAddReading = show;
    }

    static void setHintArchive(boolean show) {
        hintArchive = show;
    }

    static void setHintNavigate(boolean show) {
        hintNavigate = show;
    }

    static void setHintPractice(boolean show) {
        hintPractice = show;
    }

    static boolean getShowHints() {
        return showHints;
    }

    static boolean getHintSettings() {
        return hintSettings;
    }

    static boolean getHintAddSynonym() {
        return hintAddSynonym;
    }

    static boolean getHintAddReading() {
        return hintAddReading;
    }

    static boolean getHintArchive() {
        return hintArchive;
    }

    static boolean getHintNavigate() {
        return hintNavigate;
    }

    static boolean getHintPractice() {
        return hintPractice;
    }

    static void showSettingsHint(Stage stage) {
        if (showHints && hintSettings) {
            Dialogs.showHintDialog(stage, "To save your changes and return to the dashboard, click the Torii button at the top of the screen.", new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintSettings = false;
                    RestClient.updateHints();
                }
            });
        }
    }

    static void showAddSynonymHint(Stage stage, final Dialogs.HintAdapter adapter) {
        if (showHints && hintAddSynonym) {
            Dialogs.showHintDialog(stage, "You can add translations in your native language as synonyms. Synonyms must use basic Latin characters (A\u2013Z) plus the following:\n\n" + Main.getDiacriticsChars(), new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintAddSynonym = false;
                    RestClient.updateHints();
                }

                @Override
                public void finished() {
                    adapter.finished();
                }
            });
        }
    }

    static void showAddReadingHint(Stage stage, final Dialogs.HintAdapter adapter) {
        if (showHints && hintAddReading) {
            Dialogs.showHintDialog(stage, "Alternative readings can contain only Kana characters.", new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintAddReading = false;
                    RestClient.updateHints();
                }

                @Override
                public void finished() {
                    adapter.finished();
                }
            });
        }
    }

    static void showArchiveVocabHint(Stage stage) {
        if (showHints && hintArchive) {
            Dialogs.showHintDialog(stage, "You can archive any item and prevent it from appearing in your reviews by clicking the eye icon in the top-left corner.", new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintArchive = false;
                    RestClient.updateHints();
                }
            });
        }
    }

    static boolean showMobileNavigationHint(Stage stage) {
        if (showHints && hintNavigate) {
            Dialogs.showHintDialog(stage, "Use the navigation buttons inside the app to switch between screens. Using your phone's Back button may cause unexpected behavior.", new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintNavigate = false;
                    RestClient.updateHints();
                }

                @Override
                public void finished() {
                    Dashboard.setIsReadyToRefresh(true);
                }
            });
            return true;
        }
        return false;
    }

    static boolean showPracticeHint(Stage stage, final PracticeScreen.PracticeListsTable plt) {
        if (showHints && hintPractice) {
            Dialogs.showHintDialog(stage, "You can practice as much as you like - there's no limit. Your answers won't affect SRS levels or your statistics.", new Dialogs.HintAdapter(){

                @Override
                public void hide() {
                    hintPractice = false;
                    RestClient.updateHints();
                }

                @Override
                public void finished() {
                    plt.refreshData();
                }
            });
            return true;
        }
        return false;
    }
}

