/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.torii.srs.ContactScreen;
import com.torii.srs.Dashboard;
import com.torii.srs.Main;
import com.torii.srs.PrimeScreen;
import com.torii.srs.RestClient;
import com.torii.srs.widget.CollapsibleWidget;
import com.torii.srs.widget.TopMenu;

public class HelpScreen
implements Screen {
    private HelpScreen helpScreen = this;
    private Stage stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
    private VisTable tblMain = new VisTable(false);

    HelpScreen(JsonValue kb) {
        TopMenu topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                Dashboard.showOnScreen();
            }
        };
        float space = Main.getPPUY();
        VisLabel lAboutVersion = new VisLabel((CharSequence)"Torii SRS v1.4.9 (Nov. 20 2025)", Main.labelStyleX1);
        VisLabel lLastUpdated = new VisLabel((CharSequence)("KB last updated: " + kb.getString("updated")), Main.labelStyleX0p5);
        LinkLabel llWebsite = new LinkLabel((CharSequence)"Visit the Website", (CharSequence)RestClient.getWebsite());
        LinkLabel llSupport = new LinkLabel((CharSequence)"Support Torii", (CharSequence)"");
        LinkLabel llContact = new LinkLabel((CharSequence)"Contact the Developer", (CharSequence)"");
        llSupport.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                PrimeScreen.init();
                Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
            }
        });
        llContact.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                Main.setNewScreen(new ContactScreen(HelpScreen.this.helpScreen));
                Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
            }
        });
        VisTable tblAboutChild1 = new VisTable(false);
        tblAboutChild1.add(lAboutVersion).expandX().padBottom(0.5f * space).row();
        tblAboutChild1.add(llSupport).expandX().row();
        tblAboutChild1.add(llWebsite).expandX().padBottom(0.5f * space).row();
        tblAboutChild1.add(llContact).expandX().row();
        VisTable tblGroups = new VisTable(false);
        tblGroups.add(this.createButtons(kb.get(1))).row();
        tblGroups.add(lLastUpdated).expandY().align(4);
        VisTable tblLandingPage = new VisTable(false);
        tblLandingPage.align(2);
        tblLandingPage.add(tblAboutChild1).width(this.stage.getViewport().getWorldWidth() * 0.95f).row();
        tblLandingPage.addSeparator().width(this.stage.getViewport().getWorldWidth()).padTop(0.5f * space).padBottom(0.5f * space);
        tblLandingPage.add(new VisLabel((CharSequence)"Knowledge Base", Main.labelStyleX2)).padBottom(space).row();
        tblLandingPage.add(tblGroups).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY().padBottom(0.5f * space).row();
        VisScrollPane spAbout = new VisScrollPane((Actor)tblLandingPage);
        spAbout.setScrollingDisabled(true, false);
        spAbout.setFadeScrollBars(false);
        this.tblMain.setFillParent(true);
        this.tblMain.align(2);
        this.tblMain.add(topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        this.tblMain.add(spAbout).width(this.stage.getViewport().getWorldWidth()).expandY().fillY().row();
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 4 || keycode == 111) {
                    Dashboard.showOnScreen();
                }
                return true;
            }
        });
        this.stage.addActor(this.tblMain);
    }

    private VisTable createButtons(JsonValue kb) {
        VisTable table = new VisTable(false);
        for (int i = 0; i < kb.size; ++i) {
            final JsonValue group = kb.get(i);
            VisTextButton tb = new VisTextButton(group.name, Main.btnStyleX1);
            tb.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    Main.setNewScreen(new Part(HelpScreen.this.helpScreen, group));
                }
            });
            table.add(tb).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        }
        return table;
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private class Part
    implements Screen {
        Stage stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        VisTable tblMain = new VisTable(false);

        Part(final HelpScreen parent, JsonValue kb) {
            TopMenu topMenu = new TopMenu(false, " Knowledge Base Overview "){

                @Override
                public void homeButton() {
                    Main.setNewScreen(parent);
                }
            };
            VisTextButton.VisTextButtonStyle tbStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("", "toggle").getStyle());
            tbStyle.up = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
            tbStyle.over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
            tbStyle.down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
            tbStyle.disabled = tbStyle.up;
            tbStyle.fontColor = Main.FONT;
            VisTable tblContent = new VisTable(false);
            tblContent.align(2);
            tblContent.add(new VisLabel((CharSequence)("Q&A - " + kb.name), Main.labelStyleX1)).padTop(Main.getPPUY()).row();
            for (int i = 0; i < kb.size; ++i) {
                VisTable tblAnswer = new VisTable(false);
                tblAnswer.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_OVER));
                VisLabel lAnswer = new VisLabel((CharSequence)kb.getString(i).replace("[CONTACT]", ""), Main.labelStyleX1);
                lAnswer.setWrap(true);
                tblAnswer.defaults().width(this.stage.getViewport().getWorldWidth() * 0.9f).padLeft(this.stage.getViewport().getWorldWidth() * 0.025f).padRight(this.stage.getViewport().getWorldWidth() * 0.025f).row();
                tblAnswer.add().padTop((float)Main.getPPUY() * 0.5f).row();
                if (!lAnswer.getText().toString().trim().equals("")) {
                    tblAnswer.add(lAnswer).row();
                }
                if (kb.getString(i).contains("[CONTACT]")) {
                    LinkLabel llContact = new LinkLabel((CharSequence)"Contact the Developer", (CharSequence)"");
                    llContact.setListener(new LinkLabel.LinkLabelListener(){

                        @Override
                        public void clicked(String url) {
                            Main.setNewScreen(new ContactScreen(HelpScreen.this.helpScreen));
                            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
                        }
                    });
                    tblAnswer.add(llContact).align(8).row();
                }
                tblAnswer.add().padBottom((float)Main.getPPUY() * 0.5f);
                final CollapsibleWidget widget = new CollapsibleWidget(tblAnswer);
                widget.setCollapsed(true, false);
                VisTextButton tbQuestion = new VisTextButton(kb.get((int)i).name, tbStyle);
                tbQuestion.setFocusBorderEnabled(false);
                tbQuestion.setChecked(false);
                tbQuestion.getLabelCell().width(this.stage.getViewport().getWorldWidth() * 0.9f);
                tbQuestion.getLabel().setWrap(true);
                tbQuestion.getLabel().setAlignment(8);
                tbQuestion.invalidate();
                tbQuestion.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        widget.setCollapsed(!widget.isCollapsed());
                    }
                });
                tblContent.add().padTop(Main.getPPUY()).row();
                tblContent.add(tbQuestion).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandX().fillX().row();
                tblContent.add(widget).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandX().fillX().row();
            }
            VisScrollPane spAbout = new VisScrollPane((Actor)tblContent);
            spAbout.setScrollingDisabled(true, false);
            spAbout.setFadeScrollBars(false);
            this.tblMain.setFillParent(true);
            this.tblMain.align(2);
            this.tblMain.add(topMenu.getTable()).width(this.stage.getViewport().getWorldWidth()).row();
            this.tblMain.add(spAbout).width(this.stage.getViewport().getWorldWidth()).expandY().fillY().row();
            this.stage.addListener(new ClickListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    if (keycode == 4 || keycode == 111) {
                        Main.setNewScreen(parent);
                    }
                    return true;
                }
            });
            this.stage.addActor(this.tblMain);
        }

        @Override
        public void show() {
            Gdx.input.setInputProcessor(this.stage);
            Main.setCurrentStage(this.stage);
        }

        @Override
        public void render(float delta) {
            Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
            Gdx.gl.glClear(16384);
            this.stage.act(delta);
            this.stage.draw();
        }

        @Override
        public void resize(int width, int height) {
        }

        @Override
        public void pause() {
        }

        @Override
        public void resume() {
        }

        @Override
        public void hide() {
        }

        @Override
        public void dispose() {
        }
    }
}

