/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.torii.srs.Main;
import java.io.InputStream;

class FileManager {
    private static final String tempDir = ".toriiTemp/";
    private static final String fontDir = "torii_fonts/";

    FileManager() {
    }

    static String getFontDirectory() {
        return fontDir;
    }

    static FileHandle getTempFile(String fileName) {
        return Gdx.files.local(tempDir + fileName);
    }

    static FileHandle getFontFile(String fileName) {
        return Gdx.files.local(fontDir + fileName);
    }

    static FileHandle getInternalFile(String fileName) {
        return Gdx.files.internal(fileName);
    }

    static void saveAudioFile(InputStream is, String fileName) {
        Gdx.files.local(tempDir + fileName).write(is, false);
    }

    static Array<String> getFontFiles() {
        String[] allowedSuffixes = new String[]{"ttf", "otf"};
        FileHandle fhDir = Gdx.files.local(fontDir);
        if (!fhDir.exists()) {
            fhDir.mkdirs();
        }
        FileHandle[] files = fhDir.list();
        Array<String> ar = new Array<String>();
        block0: for (FileHandle fh : files) {
            for (String s : allowedSuffixes) {
                if (!fh.extension().equals(s)) continue;
                ar.add(fh.name());
                continue block0;
            }
        }
        return ar;
    }

    static CredentialPrefs readCredentialPreferences() {
        return new CredentialPrefs(false);
    }

    static void writeCredentialPreferences() {
        new CredentialPrefs(true);
    }

    static boolean deleteTemporaryFiles() {
        return Gdx.files.local(tempDir).deleteDirectory();
    }

    static boolean deleteFontFile(String fileName) {
        return Gdx.files.local(fontDir + fileName).delete();
    }

    static class CredentialPrefs {
        private final String defaultValue = "NA";
        private final String prefsFileName = "torii_prefs";
        private final String prefsEntryEmail = "email";
        private final String prefsEntryPassword = "pw";
        private final String prefsDarkTheme = "dark_theme";
        private final String prefsMacHdpi = "macos_hdpi_fscm";
        final String userName;
        final String userPassword;
        final boolean useDarkTheme;
        final boolean macHdpiCompatMode;

        CredentialPrefs(boolean write) {
            Preferences prefs = Gdx.app.getPreferences("torii_prefs");
            if (!write) {
                this.userName = prefs.getString("email", "NA");
                this.userPassword = prefs.getString("pw", "NA");
                this.useDarkTheme = prefs.getBoolean("dark_theme", true);
                this.macHdpiCompatMode = prefs.getBoolean("macos_hdpi_fscm", false);
            } else {
                this.userName = Main.getUserEmail();
                this.userPassword = Main.getUserPassword();
                this.useDarkTheme = Main.getTheme();
                this.macHdpiCompatMode = Main.getMacHdpiCompatMode();
                prefs.putString("email", this.userName);
                prefs.putString("pw", this.userPassword);
                prefs.putBoolean("dark_theme", this.useDarkTheme);
                prefs.putBoolean("macos_hdpi_fscm", this.macHdpiCompatMode);
                prefs.flush();
            }
        }

        boolean isUserCredentialsValid() {
            return !this.userName.equals("NA") && !this.userPassword.equals("NA") && !this.userName.equals("") && !this.userPassword.equals("");
        }
    }

    static class AudioFileHandleResolver
    implements FileHandleResolver {
        AudioFileHandleResolver() {
        }

        @Override
        public FileHandle resolve(String fileName) {
            return Gdx.files.local(FileManager.tempDir + fileName);
        }
    }
}

