/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.widget.VisDialog;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.torii.srs.Main;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DownloadManager {
    private VisDialog container;
    private VisTextButton button;
    private String url;
    private FileHandle saveLocation;
    private long read;
    private long size;
    private boolean cancel = false;

    DownloadManager(String url, FileHandle saveLocation) {
        this.url = url;
        this.saveLocation = saveLocation;
    }

    void success() {
    }

    void failed() {
    }

    void download() {
        this.download(false);
    }

    void download(boolean hideDialog) {
        this.container = new VisDialog("Downloading File");
        VisTable tblProgress = new VisTable(false);
        this.button = new VisTextButton("Cancel Download");
        this.button.setFocusBorderEnabled(false);
        final VisLabel lDownloaded = new VisLabel((CharSequence)"0", Main.labelStyleX1);
        final VisLabel lDownloadSize = new VisLabel((CharSequence)"0", Main.labelStyleX1);
        tblProgress.align(1);
        tblProgress.add(lDownloaded);
        tblProgress.add(" MB / ");
        tblProgress.add(lDownloadSize);
        tblProgress.add(" MB");
        float space = Main.getPPUY();
        this.container.padTop((float)Main.getPPUY() * 1.5f);
        this.container.setModal(true);
        this.container.setMovable(false);
        this.container.setFillParent(false);
        this.container.getContentTable().add(tblProgress).expandX().fillX().align(1).padTop(space / 2.0f).padBottom(space / 2.0f).row();
        this.container.getButtonsTable().add(this.button).align(1).padBottom(space / 2.0f).padLeft(space / 2.0f).padRight(space / 2.0f).row();
        this.container.pack();
        if (!hideDialog) {
            this.container.show(Main.getCurrentStage());
        }
        Net.HttpRequest request = new Net.HttpRequest("GET");
        request.setTimeOut(0);
        request.setUrl(this.url);
        Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                DownloadManager.this.size = Long.parseLong(httpResponse.getHeader("Content-Length"));
                InputStream is = httpResponse.getResultAsStream();
                OutputStream os = DownloadManager.this.saveLocation.write(false);
                byte[] bytes = new byte[1024];
                DownloadManager.this.read = 0L;
                try {
                    int count;
                    while ((count = is.read(bytes, 0, bytes.length)) != -1 && !DownloadManager.this.cancel) {
                        os.write(bytes, 0, count);
                        DownloadManager.this.read += count;
                        final int progress = (int)((double)DownloadManager.this.read / (double)DownloadManager.this.size * 100.0);
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (progress == 100) {
                                    DownloadManager.this.button.setDisabled(true);
                                }
                                lDownloaded.setText(DownloadManager.this.convertBytesToMB(DownloadManager.this.read, 2) + "");
                                lDownloaded.pack();
                                lDownloadSize.setText(DownloadManager.this.convertBytesToMB(DownloadManager.this.size, 2) + "");
                                lDownloadSize.pack();
                                DownloadManager.this.container.pack();
                            }
                        });
                    }
                    os.close();
                    if (DownloadManager.this.cancel) {
                        DownloadManager.this.saveLocation.delete();
                        DownloadManager.this.downloadFailed();
                    } else {
                        DownloadManager.this.container.fadeOut(0.0f);
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                DownloadManager.this.success();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    DownloadManager.this.downloadFailed();
                }
            }

            @Override
            public void failed(Throwable t) {
                DownloadManager.this.downloadFailed();
            }

            @Override
            public void cancelled() {
                DownloadManager.this.downloadFailed();
            }
        });
        this.button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!DownloadManager.this.button.isDisabled()) {
                    DownloadManager.this.button.setDisabled(true);
                    DownloadManager.this.cancel = true;
                }
            }
        });
    }

    private void downloadFailed() {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                DownloadManager.this.button.setText("Download failed");
                DownloadManager.this.button.setDisabled(true);
                DownloadManager.this.failed();
            }
        });
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                DownloadManager.this.container.fadeOut(0.0f);
            }
        }, 3.0f, 3.0f, 0);
    }

    private float convertBytesToMB(long sizeBytes, int decimalPlaces) {
        float number = (float)sizeBytes / 1000.0f / 1000.0f;
        int pow = 10;
        for (int i = 1; i < decimalPlaces; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }
}

