/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.util.ToastManager;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.toast.Toast;
import com.torii.srs.AddVocabScreen;
import com.torii.srs.BrowseScreen;
import com.torii.srs.Dialogs;
import com.torii.srs.FileManager;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.PrimeScreen;
import com.torii.srs.ProgressScreen;
import com.torii.srs.RestClient;
import com.torii.srs.ReviewScreen;
import com.torii.srs.SettingsScreen;
import com.torii.srs.StudyScreen;
import com.torii.srs.widget.TopMenu;

public class Dashboard
implements Screen {
    private static Dashboard dashboard;
    private TopMenu topMenu;
    private Stage stage;
    private ShapeRenderer renderer;
    private SpriteBatch batch;
    private VisImageButton btnHelp;
    private VisImageButton btnTheme;
    private VisTextButton btnStudy;
    private VisTextButton btnStudyDisabled;
    private VisTextButton btnReview;
    private VisTextButton btnReviewDisabled;
    private VisTextButton btnProgression;
    private VisTextButton btnSettings;
    private VisTextButton btnBrowse;
    private VisTextButton btnAdd;
    private VisTextButton btnPro;
    private VisTextButton btnPractice;
    private VisTextButton btnStar;
    private VisTextButton.VisTextButtonStyle btnStyle;
    private VisTextButton.VisTextButtonStyle btnProStyle;
    private VisLabel lLessons;
    private VisLabel lReviews;
    private VisLabel lLessonsValue;
    private VisLabel lReviewsValue;
    private VisLabel lProgress;
    private VisLabel lSettings;
    private VisLabel lBrowse;
    private VisLabel lAdd;
    private VisLabel lPro;
    private VisLabel lPractice;
    private VisLabel lLevel1;
    private VisLabel lLevel2;
    private VisLabel lLevel3;
    private VisLabel lLevel4;
    private VisLabel lLevel5;
    private VisLabel lProgress1;
    private VisLabel lProgress2;
    private VisLabel lProgress3;
    private VisLabel lProgress4;
    private VisLabel lProgress5;
    private VisSelectBox<String> sbReviewMode;
    private String nextReviewDue;
    private int lessonsAvailable;
    private int reviewsAvailable;
    private int lvl1Value;
    private int lvl2Value;
    private int lvl3Value;
    private int lvl4Value;
    private int lvl5Value;
    private long nextReviewDueSeconds;
    private float rectWidth;
    private float rectHeight;
    private float leftX;
    private float rightX;
    private float bottomY;
    private float centerY;
    private float topY;
    private boolean isReadyToRefresh = false;
    private boolean skipNextRefresh = false;
    private boolean appJustLaunched = true;
    private Image img;
    private Image img2;
    private Image img3;
    private Image img4;
    private Image img5;
    private Image img6;
    private int konamiStreak = -1;
    private Animation<TextureRegion> animYellow;
    private Animation<TextureRegion> animStar;
    private final int animYellowWidth = 400;
    private final int animYellowHeight = 90;
    private final int animStarWidth = 500;
    private final int animStarHeight = 500;
    private float deltaYellow;
    private float deltaStar;
    private boolean specialButtonEnabled = false;

    public Dashboard() {
        dashboard = this;
        this.animYellow = Main.pngToAnimation((Texture)Main.getAsset(Main.YELLOW_PATH, Texture.class, true), 400, 90, 0.4f);
        this.animStar = Main.pngToAnimation((Texture)Main.getAsset(Main.STAR_BTN_PATH, Texture.class, true), 500, 500, 0.2f);
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.renderer = new ShapeRenderer();
        this.batch = new SpriteBatch();
        VisTable table = new VisTable();
        VisTable tblContent = new VisTable(true);
        this.img = new Image((Texture)Main.getAsset(Main.PROGRESS_BTN_PATH, Texture.class, true));
        this.img2 = new Image((Texture)Main.getAsset(Main.SETTINGS_BTN_PATH, Texture.class, true));
        this.img3 = new Image((Texture)Main.getAsset(Main.BROWSE_BTN_PATH, Texture.class, true));
        this.img4 = new Image((Texture)Main.getAsset(Main.ADD_BTN_PATH, Texture.class, true));
        this.img5 = new Image((Texture)Main.getAsset(Main.PRO_BTN_PATH, Texture.class, true));
        this.img6 = new Image((Texture)Main.getAsset(Main.PRACTICE_BTN_PATH, Texture.class, true));
        this.lLessons = new VisLabel((CharSequence)"Lessons", Main.labelStyleX1_w);
        this.lReviews = new VisLabel((CharSequence)"Reviews", Main.labelStyleX1_w);
        this.lLessonsValue = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lReviewsValue = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lProgress = new VisLabel((CharSequence)"Progress", Main.labelStyleX0p5_w);
        this.lSettings = new VisLabel((CharSequence)"Settings", Main.labelStyleX0p5_w);
        this.lBrowse = new VisLabel((CharSequence)"Browse", Main.labelStyleX0p5_w);
        this.lAdd = new VisLabel((CharSequence)"Add Vocab", Main.labelStyleX0p5_w);
        this.lPro = new VisLabel((CharSequence)"Go Prime", Main.labelStyleX0p5_w);
        this.lPractice = new VisLabel((CharSequence)"Practice", Main.labelStyleX0p5_w);
        this.lLevel1 = new VisLabel((CharSequence)"Rookie", Main.labelStyleX0p5_w);
        this.lLevel2 = new VisLabel((CharSequence)"Amateur", Main.labelStyleX0p5_w);
        this.lLevel3 = new VisLabel((CharSequence)"Expert", Main.labelStyleX0p5_w);
        this.lLevel4 = new VisLabel((CharSequence)"Master", Main.labelStyleX0p5_w);
        this.lLevel5 = new VisLabel((CharSequence)"Sensei", Main.labelStyleX0p5_w);
        this.lProgress1 = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lProgress2 = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lProgress3 = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lProgress4 = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.lProgress5 = new VisLabel((CharSequence)"0", Main.labelStyleX2_w);
        this.sbReviewMode = new VisSelectBox(new SelectBox.SelectBoxStyle(new VisSelectBox().getStyle()));
        this.sbReviewMode.setItems((String[])new String[]{"JP \u2192 EN", "EN \u2192 JP", "JP \u21c4 EN"});
        this.renderer.setAutoShapeType(true);
        this.lLessons.setAlignment(1);
        this.lReviews.setAlignment(1);
        this.lLessonsValue.setAlignment(1);
        this.lReviewsValue.setAlignment(1);
        this.lProgress.setAlignment(1);
        this.lSettings.setAlignment(1);
        this.lBrowse.setAlignment(1);
        this.lAdd.setAlignment(1);
        this.lPro.setAlignment(1);
        this.lPractice.setAlignment(1);
        this.sbReviewMode.setAlignment(1);
        this.lLessons.setTouchable(Touchable.disabled);
        this.lLessonsValue.setTouchable(Touchable.disabled);
        this.lProgress.setTouchable(Touchable.disabled);
        this.lSettings.setTouchable(Touchable.disabled);
        this.lBrowse.setTouchable(Touchable.disabled);
        this.lAdd.setTouchable(Touchable.disabled);
        this.lPro.setTouchable(Touchable.disabled);
        this.lPractice.setTouchable(Touchable.disabled);
        this.img.setTouchable(Touchable.disabled);
        this.img2.setTouchable(Touchable.disabled);
        this.img3.setTouchable(Touchable.disabled);
        this.img4.setTouchable(Touchable.disabled);
        this.img5.setTouchable(Touchable.disabled);
        this.img6.setTouchable(Touchable.disabled);
        VisTextButton.VisTextButtonStyle btnStudyStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        VisTextButton.VisTextButtonStyle btnReviewStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        VisTextButton.VisTextButtonStyle btnStarStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        this.btnProStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        this.btnStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("").getStyle());
        this.btnStyle.font = (BitmapFont)Main.getAsset(Main.fontX1, BitmapFont.class, true);
        btnStudyStyle.up = Main.uiSkin.newDrawable("white", Main.STUDY);
        btnReviewStyle.up = Main.uiSkin.newDrawable("white", Main.REVIEW);
        this.btnProStyle.up = Main.uiSkin.newDrawable("white", Color.FIREBRICK);
        this.btnStyle.up = Main.uiSkin.newDrawable("white", Main.FUNCTION);
        btnStudyStyle.over = Main.uiSkin.newDrawable("white", Main.STUDY_OVER);
        btnReviewStyle.over = Main.uiSkin.newDrawable("white", Main.REVIEW_OVER);
        this.btnProStyle.over = Main.uiSkin.newDrawable("white", Main.FUNCTION_OVER);
        this.btnStyle.over = Main.uiSkin.newDrawable("white", Main.FUNCTION_OVER);
        btnStudyStyle.disabled = Main.uiSkin.newDrawable("white", Main.STUDY_OVER);
        btnReviewStyle.disabled = Main.uiSkin.newDrawable("white", Main.REVIEW_OVER);
        btnStudyStyle.disabledFontColor = Color.WHITE;
        btnReviewStyle.disabledFontColor = Color.WHITE;
        btnStarStyle.up = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        btnStarStyle.over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        btnStarStyle.down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        btnStarStyle.disabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Image imgHelp = new Image((Texture)Main.getAsset(Main.HELP_BTN_PATH, Texture.class, true));
        Drawable help = imgHelp.getDrawable();
        this.btnHelp = new VisImageButton(help, " Knowledge Base ");
        this.btnHelp.getStyle().up = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.btnHelp.getStyle().over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        this.btnHelp.getStyle().down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        Image imgTheme = new Image((Texture)Main.getAsset(Main.THEME_BTN_PATH, Texture.class, true));
        Drawable theme = imgTheme.getDrawable();
        this.btnTheme = new VisImageButton(theme, " Change Theme ");
        this.btnTheme.getStyle().up = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        this.btnTheme.getStyle().over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        this.btnTheme.getStyle().down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        this.sbReviewMode.getStyle().background = Main.uiSkin.newDrawable("white", Main.REVIEW);
        this.sbReviewMode.getStyle().backgroundOver = Main.uiSkin.newDrawable("white", Main.REVIEW_OVER);
        this.sbReviewMode.getStyle().backgroundOpen = Main.uiSkin.newDrawable("white", Main.REVIEW_OVER);
        this.sbReviewMode.getStyle().listStyle.background = Main.uiSkin.newDrawable("white", Main.REVIEW);
        this.sbReviewMode.getStyle().fontColor = Color.WHITE;
        this.sbReviewMode.getStyle().listStyle.fontColorUnselected = Color.WHITE;
        this.sbReviewMode.getStyle().listStyle.fontColorSelected = Color.WHITE;
        this.btnStudy = new VisTextButton("", btnStudyStyle);
        this.btnStudyDisabled = new VisTextButton("", btnStudyStyle);
        this.btnReview = new VisTextButton("", btnReviewStyle);
        this.btnReviewDisabled = new VisTextButton("", btnReviewStyle);
        this.btnProgression = new VisTextButton("", this.btnStyle);
        this.btnSettings = new VisTextButton("", this.btnStyle);
        this.btnBrowse = new VisTextButton("", this.btnStyle);
        this.btnAdd = new VisTextButton("", this.btnStyle);
        this.btnPro = new VisTextButton("", this.btnProStyle);
        this.btnPractice = new VisTextButton("", this.btnStyle);
        this.btnStar = new VisTextButton("", btnStarStyle);
        this.btnStudy.setFocusBorderEnabled(false);
        this.btnStudyDisabled.setFocusBorderEnabled(false);
        this.btnReview.setFocusBorderEnabled(false);
        this.btnReviewDisabled.setFocusBorderEnabled(false);
        this.btnProgression.setFocusBorderEnabled(false);
        this.btnSettings.setFocusBorderEnabled(false);
        this.btnBrowse.setFocusBorderEnabled(false);
        this.btnAdd.setFocusBorderEnabled(false);
        this.btnPro.setFocusBorderEnabled(false);
        this.btnPractice.setFocusBorderEnabled(false);
        this.btnStar.setFocusBorderEnabled(false);
        this.btnHelp.setFocusBorderEnabled(false);
        this.btnTheme.setFocusBorderEnabled(false);
        this.btnStudy.setDisabled(true);
        this.btnReview.setDisabled(true);
        this.btnStudyDisabled.setDisabled(true);
        this.btnReviewDisabled.setDisabled(true);
        this.btnStar.setVisible(false);
        this.rectWidth = this.stage.getViewport().getWorldWidth() * 0.95f / 2.0f;
        this.rectHeight = 4.5f * (float)Main.getPPUY();
        this.leftX = this.stage.getViewport().getWorldWidth() * 0.025f;
        this.rightX = this.leftX + this.rectWidth;
        this.bottomY = Main.getPPUY();
        this.centerY = this.bottomY + this.rectHeight;
        this.topY = this.bottomY + this.rectHeight * 2.0f;
        VisTable tblContentChild1 = new VisTable(true);
        tblContentChild1.add(this.btnAdd).width(4 * Main.getPPUY()).height(4 * Main.getPPUY());
        tblContentChild1.add(this.btnBrowse).width(4 * Main.getPPUY()).height(4 * Main.getPPUY());
        tblContentChild1.add(this.btnPractice).width(4 * Main.getPPUY()).height(4 * Main.getPPUY()).row();
        tblContentChild1.add(this.btnProgression).width(4 * Main.getPPUY()).height(4 * Main.getPPUY());
        tblContentChild1.add(this.btnPro).width(4 * Main.getPPUY()).height(4 * Main.getPPUY());
        tblContentChild1.add(this.btnSettings).width(4 * Main.getPPUY()).height(4 * Main.getPPUY()).row();
        VisTable tblContentChild3 = new VisTable(true);
        tblContentChild3.add(tblContentChild1);
        tblContent.add(this.btnStudyDisabled).size(5 * Main.getPPUY()).align(16);
        tblContent.add(this.btnStudy).width(this.stage.getViewport().getWorldWidth() * 0.95f / 2.0f).height(5 * Main.getPPUY()).align(8).row();
        tblContent.add(this.btnReviewDisabled).size(5 * Main.getPPUY()).align(16);
        tblContent.add(this.btnReview).width(this.stage.getViewport().getWorldWidth() * 0.95f / 2.0f).height(5 * Main.getPPUY()).align(8).row();
        tblContent.add().width(5 * Main.getPPUY()).height(1.5f * (float)Main.getPPUY()).padBottom(Main.getPPUY());
        tblContent.add(this.sbReviewMode).width(this.stage.getViewport().getWorldWidth() * 0.95f / 2.0f).height(1.5f * (float)Main.getPPUY()).padBottom(Main.getPPUY()).row();
        tblContent.add(tblContentChild3).colspan(2).row();
        VisTable tblTopLeft = new VisTable(false);
        tblTopLeft.add(this.btnTheme).size(2.0f * (float)Main.getPPUY()).padRight((float)Main.getPPUY() * 0.5f);
        tblTopLeft.add(this.btnHelp).size(2.0f * (float)Main.getPPUY());
        this.topMenu = new TopMenu(true, " Refresh Dashboard "){

            @Override
            public void homeButton() {
                if (Dashboard.this.konamiStreak != 10) {
                    Dashboard.resetKonamiStreak();
                    if (Dashboard.this.isReadyToRefresh) {
                        Dashboard.this.refreshProgressionData(false, false);
                    } else if (this.getHomeButton().getClickListener().getTapCount() >= 5) {
                        if (!Dashboard.isKonamiStreakOver9000()) {
                            System.out.println("OK");
                            Dashboard.this.konamiStreak = 0;
                        }
                        Dialogs.showOKDialog(Dashboard.this.stage, "Easy, there!", "You can refresh your dashboard once every 10 seconds.");
                    }
                } else {
                    Dashboard.this.konamiStreak = 9001;
                    System.out.println("START");
                    Main.playTheThing();
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            Dashboard.this.specialButtonEnabled = true;
                            Dashboard.this.btnStar.setVisible(true);
                        }
                    }, 2.0f, 2.0f, 0);
                }
            }
        };
        this.topMenu.swapRight(tblTopLeft, 16);
        table.setFillParent(true);
        table.align(2);
        table.defaults().width(this.stage.getViewport().getWorldWidth());
        table.add(this.topMenu.getTable()).padBottom(Main.getPPUY()).row();
        table.add(tblContent);
        this.setActorListeners();
        this.stage.addActor(table);
        this.stage.addActor(this.lProgress1);
        this.stage.addActor(this.lLevel1);
        this.stage.addActor(this.lProgress2);
        this.stage.addActor(this.lLevel2);
        this.stage.addActor(this.lProgress3);
        this.stage.addActor(this.lLevel3);
        this.stage.addActor(this.lProgress4);
        this.stage.addActor(this.lLevel4);
        this.stage.addActor(this.lProgress5);
        this.stage.addActor(this.lLevel5);
        this.stage.addActor(this.lLessons);
        this.stage.addActor(this.lLessonsValue);
        this.stage.addActor(this.lReviews);
        this.stage.addActor(this.lReviewsValue);
        this.stage.addActor(this.lProgress);
        this.stage.addActor(this.lSettings);
        this.stage.addActor(this.lBrowse);
        this.stage.addActor(this.lAdd);
        this.stage.addActor(this.lPro);
        this.stage.addActor(this.lPractice);
        this.stage.addActor(this.img);
        this.stage.addActor(this.img2);
        this.stage.addActor(this.img3);
        this.stage.addActor(this.img4);
        this.stage.addActor(this.img5);
        this.stage.addActor(this.img6);
        this.stage.addActor(this.btnStar);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        this.stage.unfocusAll();
        Gdx.input.setOnscreenKeyboardVisible(false);
        this.sbReviewMode.setSelectedIndex(ReviewScreen.getReviewMode() - 1);
        if (this.isReadyToRefresh) {
            if (!this.skipNextRefresh) {
                this.refreshProgressionData(false, false);
            } else {
                this.skipNextRefresh = false;
            }
        }
        this.invalidateColorScheme();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.setColor(Main.UI_BG_LIGHTER);
        float f = this.bottomY + this.topY + this.rectHeight - 0.5f * (float)Main.getPPUY();
        this.renderer.rect(this.leftX, f, this.rectWidth * 2.0f, this.stage.getViewport().getWorldHeight() - f - (this.topMenu.getTable().getHeight() + 0.5f * (float)Main.getPPUY()));
        this.renderer.setColor(Main.GREEN_LIGHTEST);
        this.renderer.rect(this.leftX, this.topY, this.rectWidth, this.rectHeight);
        this.renderer.setColor(Main.GREEN_LIGHT);
        this.renderer.rect(this.rightX, this.topY, this.rectWidth, this.rectHeight);
        this.renderer.setColor(Main.GREEN_DARK);
        this.renderer.rect(this.leftX, this.centerY, this.rectWidth, this.rectHeight);
        this.renderer.setColor(Main.GREEN_DARKEST);
        this.renderer.rect(this.rightX, this.centerY, this.rectWidth, this.rectHeight);
        this.renderer.setColor(Color.GOLDENROD);
        this.renderer.rect(this.leftX, this.bottomY, this.rectWidth * 2.0f, this.rectHeight);
        this.renderer.end();
        this.updateActorPositions();
        this.stage.act(delta);
        this.stage.draw();
        if (Dashboard.isKonamiStreakOver9000()) {
            this.deltaYellow += delta;
            this.batch.begin();
            this.batch.draw(this.animYellow.getKeyFrame(this.deltaYellow, true), this.getStageLocation((Actor)this.btnReview).x + this.btnReview.getWidth() / 2.0f - 200.0f, this.getStageLocation((Actor)this.btnReview).y + this.btnReview.getHeight(), 400.0f, 90.0f);
            this.batch.end();
        }
        if (this.specialButtonEnabled && this.btnStar.isVisible()) {
            float size = 2.5f * (float)Main.getPPUY();
            this.deltaStar += delta;
            this.batch.begin();
            this.batch.draw(this.animStar.getKeyFrame(this.deltaStar, true), this.getStageLocation((Actor)this.btnStar).x + this.btnStar.getWidth() / 2.0f - size / 2.0f, this.getStageLocation((Actor)this.btnStar).y + this.btnStar.getHeight() / 2.0f - size / 2.0f, size, size);
            this.batch.end();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().setWorldSize(Main.getWindowedWidth(), Main.getWindowedHeight());
        this.stage.getViewport().update(Main.getWindowedWidth(), Main.getWindowedHeight(), true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    static void resetKonamiStreak() {
        Dashboard.dashboard.konamiStreak = -1;
        Dashboard.dashboard.specialButtonEnabled = false;
        Dashboard.dashboard.btnStar.setVisible(false);
        Main.stopMusic();
    }

    static boolean isKonamiStreakOver9000() {
        return Dashboard.dashboard.konamiStreak > 9000;
    }

    public static void showOnScreen() {
        if (Main.isDesktop() && Gdx.graphics.isFullscreen()) {
            Main.exitFullscreenMode();
        }
        Main.setNewScreen(dashboard);
    }

    static void setPrimeLayout(boolean isPrime) {
        if (isPrime) {
            Dashboard.dashboard.btnPro.setStyle(Dashboard.dashboard.btnStyle);
            Dashboard.dashboard.lPro.setText("Prime");
        } else {
            Dashboard.dashboard.btnPro.setStyle(Dashboard.dashboard.btnProStyle);
            Dashboard.dashboard.lPro.setText("Go Prime");
        }
    }

    static void setIsReadyToRefresh(boolean value) {
        Dashboard.dashboard.isReadyToRefresh = value;
        if (value) {
            dashboard.refreshProgressionData(false, false);
        }
    }

    static void setData(String nextReviewDueSeconds, int reviews, int lvl1, int lvl2, int lvl3, int lvl4, int lvl5) {
        if (nextReviewDueSeconds != null) {
            long seconds = Long.parseLong(nextReviewDueSeconds);
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            Dashboard.dashboard.nextReviewDueSeconds = seconds;
            Dashboard.dashboard.nextReviewDue = hours > 0L ? hours + "h " + minutes + "m" : (minutes > 0L ? minutes + "min" : "<1 min");
        } else {
            Dashboard.dashboard.nextReviewDue = "N/A";
        }
        Dashboard.dashboard.lessonsAvailable = StudyScreen.getDailyLimitLeft();
        Dashboard.dashboard.reviewsAvailable = reviews;
        Dashboard.dashboard.lvl1Value = lvl1;
        Dashboard.dashboard.lvl2Value = lvl2;
        Dashboard.dashboard.lvl3Value = lvl3;
        Dashboard.dashboard.lvl4Value = lvl4;
        Dashboard.dashboard.lvl5Value = lvl5;
        Dashboard.dashboard.lLessonsValue.setText("" + Dashboard.dashboard.lessonsAvailable);
        Dashboard.dashboard.lLessonsValue.pack();
        Dashboard.dashboard.lReviewsValue.setText("" + Dashboard.dashboard.reviewsAvailable);
        Dashboard.dashboard.lReviewsValue.pack();
        Dashboard.dashboard.lProgress1.setText("" + Dashboard.dashboard.lvl1Value);
        Dashboard.dashboard.lProgress1.pack();
        Dashboard.dashboard.lProgress2.setText("" + Dashboard.dashboard.lvl2Value);
        Dashboard.dashboard.lProgress2.pack();
        Dashboard.dashboard.lProgress3.setText("" + Dashboard.dashboard.lvl3Value);
        Dashboard.dashboard.lProgress3.pack();
        Dashboard.dashboard.lProgress4.setText("" + Dashboard.dashboard.lvl4Value);
        Dashboard.dashboard.lProgress4.pack();
        Dashboard.dashboard.lProgress5.setText("" + Dashboard.dashboard.lvl5Value);
        Dashboard.dashboard.lProgress5.pack();
        if (Main.isVacationModeActivated()) {
            Dashboard.dashboard.lLessonsValue.setText("0");
            Dashboard.dashboard.lLessonsValue.pack();
            Dashboard.dashboard.lReviewsValue.setText("0");
            Dashboard.dashboard.lReviewsValue.pack();
            Dashboard.dashboard.btnStudy.setDisabled(true);
            Dashboard.dashboard.btnStudy.setText("Vacation Mode\nis active.");
            Dashboard.dashboard.btnReview.setDisabled(true);
            Dashboard.dashboard.btnReview.setText("Assignments\nare locked.");
        } else {
            if (Dashboard.dashboard.lessonsAvailable == 0) {
                Dashboard.dashboard.btnStudy.setDisabled(true);
                if (!StudyScreen.getAllLessonsCleared()) {
                    Dashboard.dashboard.btnStudy.setText("Done for today!");
                } else {
                    Dashboard.dashboard.btnStudy.setText("All done!");
                }
            } else {
                Dashboard.dashboard.btnStudy.setDisabled(false);
                Dashboard.dashboard.btnStudy.setText("Study Now");
            }
            if (Dashboard.dashboard.reviewsAvailable == 0) {
                Dashboard.dashboard.btnReview.setDisabled(true);
                Dashboard.dashboard.btnReview.setText("Next Review\n" + Dashboard.dashboard.nextReviewDue);
            } else {
                Dashboard.dashboard.nextReviewDueSeconds = -1L;
                Dashboard.dashboard.btnReview.setDisabled(false);
                Dashboard.dashboard.btnReview.setText("Review Now");
            }
        }
        if (Dashboard.dashboard.appJustLaunched && !Main.isPrime() && PrimeScreen.isOnSale()) {
            Dashboard.dashboard.appJustLaunched = false;
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    dashboard.showPrimeToast();
                }
            }, 1.0f, 1.0f, 0);
        }
        Timer.schedule(new Timer.Task(){

            @Override
            public void run() {
                dashboard.isReadyToRefresh = true;
            }
        }, 10.0f, 1.0f, 0);
    }

    static int getReviewsAvailable() {
        return Dashboard.dashboard.reviewsAvailable;
    }

    static void setReviewsAvailable(int reviewsLeft) {
        if (reviewsLeft < 1) {
            reviewsLeft = 0;
        }
        Dashboard.dashboard.reviewsAvailable = reviewsLeft;
    }

    static long getNextReviewDueSeconds() {
        return Dashboard.dashboard.nextReviewDueSeconds;
    }

    static void setNextReviewDueSeconds(long value) {
        Dashboard.dashboard.nextReviewDueSeconds = value;
    }

    private void invalidateColorScheme() {
        this.topMenu.invalidateColorScheme();
    }

    private void refreshProgressionData(boolean startStudySession, boolean startReviewSession) {
        Dashboard.dashboard.isReadyToRefresh = false;
        if (!startStudySession && !startReviewSession) {
            Dashboard.dashboard.lLessonsValue.setText("0");
            Dashboard.dashboard.lLessonsValue.pack();
            Dashboard.dashboard.lReviewsValue.setText("0");
            Dashboard.dashboard.lReviewsValue.pack();
            Dashboard.dashboard.lProgress1.setText("0");
            Dashboard.dashboard.lProgress1.pack();
            Dashboard.dashboard.lProgress2.setText("0");
            Dashboard.dashboard.lProgress2.pack();
            Dashboard.dashboard.lProgress3.setText("0");
            Dashboard.dashboard.lProgress3.pack();
            Dashboard.dashboard.lProgress4.setText("0");
            Dashboard.dashboard.lProgress4.pack();
            Dashboard.dashboard.lProgress5.setText("0");
            Dashboard.dashboard.lProgress5.pack();
        }
        RestClient.getProgression(startStudySession, startReviewSession);
    }

    private void showPrimeToast() {
        float windowsWidth = this.stage.getViewport().getWorldWidth() * 0.8f;
        int padX = (int)(this.stage.getViewport().getWorldWidth() * 0.09f);
        int padY = Main.getPPUY() * 2;
        VisLabel s = new VisLabel(PrimeScreen.getSaleMessage());
        VisLabel s2 = new VisLabel("Prime is on sale.");
        LinkLabel ll = new LinkLabel((CharSequence)"Check Prices", (CharSequence)"");
        final ToastManager toastManager = new ToastManager(this.stage);
        toastManager.setAlignment(12);
        toastManager.setScreenPadding(padX, padY);
        VisTable toastContent = new VisTable(false);
        toastContent.add().width(windowsWidth).row();
        toastContent.add(s).row();
        toastContent.add(s2).row();
        toastContent.add(ll).row();
        final Toast primeToast = new Toast(toastContent);
        ll.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                toastManager.remove(primeToast);
                Dashboard.this.skipNextRefresh = true;
                PrimeScreen.init();
            }
        });
        toastManager.show(primeToast, 5.0f);
    }

    private Vector2 getStageLocation(Actor actor) {
        return actor.localToStageCoordinates(new Vector2(0.0f, 0.0f));
    }

    private void updateActorPositions() {
        float x = this.getStageLocation((Actor)this.btnStudyDisabled).x;
        float y = this.getStageLocation((Actor)this.btnStudyDisabled).y;
        float x2 = this.getStageLocation((Actor)this.btnReviewDisabled).x;
        float y2 = this.getStageLocation((Actor)this.btnReviewDisabled).y;
        float x3 = this.getStageLocation((Actor)this.btnProgression).x;
        float y3 = this.getStageLocation((Actor)this.btnProgression).y + this.lProgress.getHeight() / 4.0f;
        float x4 = this.getStageLocation((Actor)this.btnSettings).x;
        float y4 = this.getStageLocation((Actor)this.btnSettings).y + this.lSettings.getHeight() / 4.0f;
        float x5 = this.getStageLocation((Actor)this.btnBrowse).x;
        float y5 = this.getStageLocation((Actor)this.btnBrowse).y + this.lBrowse.getHeight() / 4.0f;
        float x6 = this.getStageLocation((Actor)this.btnAdd).x;
        float y6 = this.getStageLocation((Actor)this.btnAdd).y + this.lAdd.getHeight() / 4.0f;
        float x7 = this.getStageLocation((Actor)this.btnPro).x;
        float y7 = this.getStageLocation((Actor)this.btnPro).y + this.lPro.getHeight() / 4.0f;
        float x8 = this.getStageLocation((Actor)this.btnPractice).x;
        float y8 = this.getStageLocation((Actor)this.btnPractice).y + this.lPractice.getHeight() / 4.0f;
        this.lProgress.setPosition(x3 + this.btnProgression.getWidth() / 2.0f - this.lProgress.getWidth() / 2.0f, y3);
        this.lSettings.setPosition(x4 + this.btnSettings.getWidth() / 2.0f - this.lSettings.getWidth() / 2.0f, y4);
        this.lBrowse.setPosition(x5 + this.btnBrowse.getWidth() / 2.0f - this.lBrowse.getWidth() / 2.0f, y5);
        this.lAdd.setPosition(x6 + this.btnAdd.getWidth() / 2.0f - this.lAdd.getWidth() / 2.0f, y6);
        this.lPro.setPosition(x7 + this.btnPro.getWidth() / 2.0f - this.lPro.getWidth() / 2.0f, y7);
        this.lPractice.setPosition(x8 + this.btnPractice.getWidth() / 2.0f - this.lPractice.getWidth() / 2.0f, y8);
        this.lLessons.setPosition(x + this.btnStudyDisabled.getWidth() / 2.0f - this.lLessons.getWidth() / 2.0f, y);
        this.lLessonsValue.setPosition(x + this.btnStudyDisabled.getWidth() / 2.0f - this.lLessonsValue.getWidth() / 2.0f, y + this.btnStudyDisabled.getHeight() / 2.0f - this.lLessonsValue.getHeight() / 2.0f + this.lLessons.getHeight() / 2.0f);
        this.lReviews.setPosition(x2 + this.btnReviewDisabled.getWidth() / 2.0f - this.lReviews.getWidth() / 2.0f, y2);
        this.lReviewsValue.setPosition(x2 + this.btnReviewDisabled.getWidth() / 2.0f - this.lReviewsValue.getWidth() / 2.0f, y2 + this.btnReviewDisabled.getHeight() / 2.0f - this.lReviewsValue.getHeight() / 2.0f + this.lReviews.getHeight() / 2.0f);
        this.lProgress1.setPosition(this.leftX + this.rectWidth / 2.0f - this.lProgress1.getWidth() / 2.0f, this.topY + this.rectHeight / 2.0f - (this.lProgress1.getHeight() - this.lLevel1.getHeight()) / 2.0f);
        this.lLevel1.setPosition(this.leftX + this.rectWidth / 2.0f - this.lLevel1.getWidth() / 2.0f, this.lProgress1.getY() - this.lLevel1.getHeight());
        this.lProgress2.setPosition(this.rightX + this.rectWidth / 2.0f - this.lProgress2.getWidth() / 2.0f, this.topY + this.rectHeight / 2.0f - (this.lProgress2.getHeight() - this.lLevel2.getHeight()) / 2.0f);
        this.lLevel2.setPosition(this.rightX + this.rectWidth / 2.0f - this.lLevel2.getWidth() / 2.0f, this.lProgress2.getY() - this.lLevel2.getHeight());
        this.lProgress3.setPosition(this.leftX + this.rectWidth / 2.0f - this.lProgress3.getWidth() / 2.0f, this.centerY + this.rectHeight / 2.0f - (this.lProgress3.getHeight() - this.lLevel3.getHeight()) / 2.0f);
        this.lLevel3.setPosition(this.leftX + this.rectWidth / 2.0f - this.lLevel3.getWidth() / 2.0f, this.lProgress3.getY() - this.lLevel3.getHeight());
        this.lProgress4.setPosition(this.rightX + this.rectWidth / 2.0f - this.lProgress4.getWidth() / 2.0f, this.centerY + this.rectHeight / 2.0f - (this.lProgress4.getHeight() - this.lLevel4.getHeight()) / 2.0f);
        this.lLevel4.setPosition(this.rightX + this.rectWidth / 2.0f - this.lLevel4.getWidth() / 2.0f, this.lProgress4.getY() - this.lLevel4.getHeight());
        this.lProgress5.setPosition(this.leftX + this.rectWidth - this.lProgress5.getWidth() / 2.0f, this.bottomY + this.rectHeight / 2.0f - (this.lProgress5.getHeight() - this.lLevel5.getHeight()) / 2.0f);
        this.lLevel5.setPosition(this.leftX + this.rectWidth - this.lLevel5.getWidth() / 2.0f, this.lProgress5.getY() - this.lLevel5.getHeight());
        float size = 2.5f * (float)Main.getPPUY();
        float xx5 = this.getStageLocation((Actor)this.btnProgression).x + this.btnProgression.getWidth() / 2.0f - size / 2.0f;
        float xx6 = this.getStageLocation((Actor)this.btnSettings).x + this.btnSettings.getWidth() / 2.0f - size / 2.0f;
        float xx7 = this.getStageLocation((Actor)this.btnBrowse).x + this.btnBrowse.getWidth() / 2.0f - size / 2.0f;
        float xx8 = this.getStageLocation((Actor)this.btnAdd).x + this.btnAdd.getWidth() / 2.0f - size / 2.0f;
        float xx9 = this.getStageLocation((Actor)this.btnPro).x + this.btnPro.getWidth() / 2.0f - size / 2.0f;
        float xx10 = this.getStageLocation((Actor)this.btnPractice).x + this.btnPractice.getWidth() / 2.0f - size / 2.0f;
        float yy5 = this.getStageLocation((Actor)this.lAdd).y + this.lAdd.getHeight();
        float yy6 = this.getStageLocation((Actor)this.lProgress).y + this.lProgress.getHeight();
        this.img.setBounds(xx5, yy6, size, size);
        this.img2.setBounds(xx6, yy6, size, size);
        this.img3.setBounds(xx7, yy5, size, size);
        this.img4.setBounds(xx8, yy5, size, size);
        this.img5.setBounds(xx9, yy6, size, size);
        this.img6.setBounds(xx10, yy5, size, size);
        this.btnStar.setBounds(0.0f - size / 2.0f, 0.0f - size / 2.0f, size, size);
    }

    private void setActorListeners() {
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                switch (keycode) {
                    case 4: 
                    case 111: {
                        Dashboard.this.topMenu.clickExitButton();
                        break;
                    }
                    case 40: 
                    case 47: {
                        Dashboard.this.simulateClick(Dashboard.this.btnStudy);
                        break;
                    }
                    case 46: {
                        Dashboard.this.simulateClick(Dashboard.this.btnReview);
                        break;
                    }
                    case 36: {
                        Dashboard.this.simulateClick(Dashboard.this.btnHelp);
                        break;
                    }
                    case 48: {
                        Dashboard.this.simulateClick(Dashboard.this.btnTheme);
                        break;
                    }
                    case 8: 
                    case 29: 
                    case 50: 
                    case 145: {
                        Dashboard.this.simulateClick(Dashboard.this.btnAdd);
                        break;
                    }
                    case 9: 
                    case 30: 
                    case 146: {
                        Dashboard.this.simulateClick(Dashboard.this.btnBrowse);
                        break;
                    }
                    case 10: 
                    case 44: 
                    case 147: {
                        Dashboard.this.simulateClick(Dashboard.this.btnPractice);
                        break;
                    }
                    case 11: 
                    case 148: {
                        Dashboard.this.simulateClick(Dashboard.this.btnProgression);
                        break;
                    }
                    case 12: 
                    case 149: {
                        Dashboard.this.simulateClick(Dashboard.this.btnPro);
                        break;
                    }
                    case 13: 
                    case 150: {
                        Dashboard.this.simulateClick(Dashboard.this.btnSettings);
                    }
                }
                return true;
            }
        });
        this.btnHelp.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dashboard.this.skipNextRefresh = true;
                RestClient.getKnowledgeBase();
            }
        });
        this.btnTheme.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Main.setTheme(!Main.getTheme());
                Dashboard.this.invalidateColorScheme();
                FileManager.writeCredentialPreferences();
            }
        });
        this.btnStudy.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!Dashboard.this.btnStudy.isDisabled()) {
                    Dashboard.this.refreshProgressionData(true, false);
                }
            }
        });
        this.btnReview.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!Dashboard.this.btnReview.isDisabled()) {
                    Dashboard.this.refreshProgressionData(false, true);
                }
            }
        });
        this.btnProgression.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 4 && Dashboard.this.konamiStreak != 6) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    ProgressScreen.showOnScreen();
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("LEFT");
                }
            }
        });
        this.btnSettings.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 5 && Dashboard.this.konamiStreak != 7) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    SettingsScreen.showOnScreen();
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("RIGHT");
                }
            }
        });
        this.btnBrowse.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 0 && Dashboard.this.konamiStreak != 1) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    Main.setNewScreen(new BrowseScreen());
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("UP");
                }
            }
        });
        this.btnAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 9) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    if (Main.isPrime() || Main.getCustomVocabAmount() < 10) {
                        Main.setNewScreen(new AddVocabScreen());
                    } else {
                        Dialogs.showConfirmDialog(Dashboard.this.stage, "Uh-oh", "Standard members can add up to 10 custom words & phrases. If you want to add more than that, please consider getting a Prime membership. It's a great way to support Torii's development!\nWould you like to read more?", new String[]{"Sure!", "No, thanks."}, new Dialogs.ConfirmAdapter(){

                            @Override
                            public void yes() {
                                Dashboard.this.skipNextRefresh = true;
                                PrimeScreen.init();
                            }
                        });
                    }
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("A");
                }
            }
        });
        this.btnPro.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 2 && Dashboard.this.konamiStreak != 3) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    Dashboard.this.skipNextRefresh = true;
                    PrimeScreen.init();
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("DOWN");
                }
            }
        });
        this.btnPractice.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.konamiStreak != 8) {
                    if (!Dashboard.isKonamiStreakOver9000()) {
                        Dashboard.resetKonamiStreak();
                    }
                    Main.setNewScreen(new PracticeScreen());
                } else {
                    Dashboard.this.konamiStreak++;
                    System.out.println("B");
                }
            }
        });
        this.btnStar.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Dashboard.this.specialButtonEnabled) {
                    Dashboard.this.lProgress5.setText("IT'S OVER 9000");
                    Dashboard.this.lProgress5.pack();
                }
            }
        });
        this.sbReviewMode.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                int newReviewModeId = Dashboard.this.sbReviewMode.getSelectedIndex() + 1;
                if (newReviewModeId != ReviewScreen.getReviewMode()) {
                    Dashboard.this.isReadyToRefresh = true;
                    RestClient.updateReviewMode(newReviewModeId);
                }
            }
        });
    }

    private void simulateClick(Actor actor) {
        try {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            actor.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            actor.fire(ie);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

