/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.Dialogs;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.widget.TextField;
import com.torii.srs.widget.TopMenu;

public class ContactScreen
implements Screen {
    private final int messageMaxCharLength = 750;
    private final int messageMinCharLength = 100;
    private Screen parent;
    private Stage stage;
    private VisTable tblMain;
    private ScrollableTextArea taMessage;

    ContactScreen(final Screen parent) {
        this.parent = parent;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.tblMain = new VisTable(false);
        VisLabel lInfo = new VisLabel((CharSequence)"Please browse the Knowledge Base before submitting a support request. Be specific and include as much details as possible. Have some screenshots to help clarify your problem? Either post them online and include the link in your message or send an email.", Main.labelStyleX1);
        VisLabel lEmail = new VisLabel((CharSequence)"Email", Main.labelStyleX0p5);
        VisLabel lSubject = new VisLabel((CharSequence)"Subject", Main.labelStyleX0p5);
        VisLabel lMessage = new VisLabel((CharSequence)"Message", Main.labelStyleX0p5);
        final VisLabel lCharCounter = new VisLabel((CharSequence)"", Main.labelStyleX1);
        LinkLabel llEmail = new LinkLabel((CharSequence)"Compose an Email", (CharSequence)"mailto:hello@torii-srs.com");
        final TextField tfEmail = new TextField(Main.getUserEmail(), Main.tfStyleX1);
        this.taMessage = new ScrollableTextArea("", new VisTextField.VisTextFieldStyle(Main.taStyle));
        VisTextButton tbSubmit = new VisTextButton("Submit", Main.btnStyleX1p25);
        final VisSelectBox<String> sbSubject = new VisSelectBox<String>();
        sbSubject.setItems(" Select a subject...", " Bug Report", " Technical Issue", " General Question", " Feature Request", " Feedback", " Other");
        this.taMessage.getStyle().font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
        this.taMessage.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        lInfo.setWrap(true);
        lCharCounter.setTouchable(Touchable.disabled);
        lCharCounter.setAlignment(20);
        TopMenu topMenu = new TopMenu(false, " Go Back "){

            @Override
            public void homeButton() {
                Main.setNewScreen(parent);
            }
        };
        final Timer.Task charCounterTimer = new Timer.Task(){

            @Override
            public void run() {
                lCharCounter.addAction(Actions.fadeOut(0.25f));
            }
        };
        this.taMessage.setTextFieldListener(new VisTextField.TextFieldListener(){

            @Override
            public void keyTyped(VisTextField textField, char key) {
                int cursorPos = textField.getCursorPosition();
                String content = textField.getText().replaceAll(" +", " ").replaceAll("\n+", "\n");
                if (content.length() > 0 && content.charAt(0) == '\n') {
                    content = content.replaceFirst("\n", "");
                }
                if (content.length() > 750) {
                    content = content.substring(0, 750);
                }
                textField.setText(content);
                textField.setCursorPosition(cursorPos);
                lCharCounter.addAction(Actions.fadeIn(0.0f));
                lCharCounter.setText(content.length() + "/" + 750 + " ");
                if (charCounterTimer.isScheduled()) {
                    charCounterTimer.cancel();
                }
                Timer.schedule(charCounterTimer, 2.0f, 2.0f, 0);
            }
        });
        tbSubmit.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (sbSubject.getSelectedIndex() == 0) {
                    Dialogs.showErrorDialog(ContactScreen.this.stage, "Please specify the subject.");
                } else if (ContactScreen.this.taMessage.getText().trim().equals("")) {
                    Dialogs.showErrorDialog(ContactScreen.this.stage, "The message field appears to be empty.");
                } else if (ContactScreen.this.taMessage.getText().trim().length() < 100) {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Message must be at least 100 characters.");
                } else {
                    Dialogs.showConfirmDialog(ContactScreen.this.stage, "Confirmation", "Do you want to submit your request?", new String[]{"Submit", "Edit"}, new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            RestClient.sendSupportRequest(tfEmail.getText().trim(), (String)sbSubject.getSelected(), ContactScreen.this.taMessage.getText().trim(), false);
                        }
                    });
                }
            }
        });
        float space = Main.getPPUY();
        VisScrollPane spMessage = (VisScrollPane)this.taMessage.createCompatibleScrollPane();
        Stack stack = new Stack(spMessage, lCharCounter);
        VisTable tblInfo = new VisTable(false);
        tblInfo.align(10);
        tblInfo.defaults().align(8);
        tblInfo.add(lInfo).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandX().padBottom(0.5f * space).row();
        tblInfo.add(llEmail);
        VisTable tblContactForm = new VisTable(false);
        tblContactForm.align(10);
        tblContactForm.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f).align(8).expandX();
        tblContactForm.add(lEmail).row();
        tblContactForm.add(tfEmail).padBottom(space).row();
        tblContactForm.add(lSubject).row();
        tblContactForm.add(sbSubject).padBottom(space).row();
        tblContactForm.add(lMessage).row();
        tblContactForm.add(stack).expand().fill().row();
        this.tblMain.setFillParent(true);
        this.tblMain.align(2);
        this.tblMain.add(topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        this.tblMain.add(tblContactForm).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY().row();
        this.tblMain.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        this.tblMain.add(tblInfo).width(this.stage.getViewport().getWorldWidth() * 0.95f).fillY().row();
        this.tblMain.addSeparator().padTop(0.5f * space).padBottom(0.5f * space);
        this.tblMain.add(tbSubmit).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandX().padBottom(0.5f * space);
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 4) {
                    Main.setNewScreen(parent);
                }
                return true;
            }
        });
        this.stage.addActor(this.tblMain);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        FocusManager.switchFocus(this.stage, this.taMessage);
        this.stage.setKeyboardFocus(this.taMessage);
        this.taMessage.getOnscreenKeyboard().show(true);
        if (Main.getSupportRequestKS()) {
            Dialogs.showOKDialog(this.stage, "Sorry", "We are currently unable to receive support requests. Please check back later.", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    Main.setNewScreen(ContactScreen.this.parent);
                }
            });
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.stage.unfocusAll();
        Gdx.input.setOnscreenKeyboardVisible(false);
    }

    @Override
    public void dispose() {
    }
}

