/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.torii.srs.Dashboard;
import com.torii.srs.DownloadManager;
import com.torii.srs.FileManager;
import com.torii.srs.Main;
import com.torii.srs.RestClient;

class AudioHandler {
    private Sound sound;
    private Timer.Task queueTimer;
    private String currentVocab;
    private String currentSentence;
    private static boolean isDownloadingVocabAudio;
    private static boolean isDownloadingSentenceAudio;
    private AssetManager assetManager = new AssetManager(new FileManager.AudioFileHandleResolver());
    private Array<String> filesBeingDownloaded = new Array();
    private Music music;
    private boolean aks;

    AudioHandler() {
    }

    static boolean isDownloadingExampleAudio() {
        return isDownloadingVocabAudio || isDownloadingSentenceAudio;
    }

    static boolean isSoundPlaying() {
        if (Main.isDesktop()) {
            return Main.getDesktopSoundStateChecker().isPlaying(1) || Main.getDesktopSoundStateChecker().isPlaying(2);
        }
        if (Main.isAndroid()) {
            return Main.getNotificationHandler().isSoundPlaying();
        }
        return false;
    }

    private void playMusic(FileHandle file, Music.OnCompletionListener listener) {
        if (this.music != null && this.music.isPlaying()) {
            this.music.dispose();
        }
        this.music = Gdx.audio.newMusic(file);
        this.music.setOnCompletionListener(listener);
        this.music.play();
    }

    void playTheThing() {
        String s0 = "btfly.mp3";
        String s1 = "brvht.mp3";
        String s2 = "bgstdrmr.mp3";
        String s3 = "fr.mp3";
        final FileHandle fh0 = FileManager.getTempFile(s0);
        final FileHandle fh1 = FileManager.getTempFile(s1);
        final FileHandle fh2 = FileManager.getTempFile(s2);
        final FileHandle fh3 = FileManager.getTempFile(s3);
        new DownloadManager(RestClient.getAudioHost() + s0, fh0){

            @Override
            void success() {
                AudioHandler.this.playMusic(fh0, new Music.OnCompletionListener(){

                    @Override
                    public void onCompletion(Music music) {
                        music.dispose();
                        if (fh1.exists()) {
                            AudioHandler.this.playMusic(fh1, new Music.OnCompletionListener(){

                                @Override
                                public void onCompletion(Music music) {
                                    music.dispose();
                                    if (fh2.exists()) {
                                        AudioHandler.this.playMusic(fh2, new Music.OnCompletionListener(){

                                            @Override
                                            public void onCompletion(Music music) {
                                                music.dispose();
                                                if (fh3.exists()) {
                                                    AudioHandler.this.playMusic(fh3, new Music.OnCompletionListener(){

                                                        @Override
                                                        public void onCompletion(Music music) {
                                                            music.dispose();
                                                            Dashboard.resetKonamiStreak();
                                                        }
                                                    });
                                                } else {
                                                    Dashboard.resetKonamiStreak();
                                                }
                                            }
                                        });
                                    } else {
                                        Dashboard.resetKonamiStreak();
                                    }
                                }
                            });
                        } else {
                            Dashboard.resetKonamiStreak();
                        }
                    }
                });
            }
        }.download(true);
        new DownloadManager(RestClient.getAudioHost() + s1, fh1).download(true);
        new DownloadManager(RestClient.getAudioHost() + s2, fh2).download(true);
        new DownloadManager(RestClient.getAudioHost() + s3, fh3).download(true);
    }

    void playExampleAudio(final String vocabFileName, final String sentenceFileName) {
        if (this.aks) {
            return;
        }
        this.stopSound();
        final boolean playVocabAudio = vocabFileName != null;
        final boolean playSentenceAudio = sentenceFileName != null;
        this.currentVocab = vocabFileName;
        this.currentSentence = sentenceFileName;
        final String finalCurrentVocab = this.currentVocab;
        final String finalCurrentSentence = this.currentSentence;
        if (playVocabAudio || playSentenceAudio) {
            Net.HttpRequest httpGet;
            if (playVocabAudio) {
                FileHandle fhVocabAudio = FileManager.getTempFile(this.currentVocab);
                if (fhVocabAudio.exists() && !this.filesBeingDownloaded.contains(this.currentVocab, false)) {
                    if (!this.assetManager.contains(this.currentVocab, Sound.class)) {
                        this.assetManager.load(this.currentVocab, Sound.class);
                    }
                    this.assetManager.finishLoadingAsset(this.currentVocab);
                } else if (this.filesBeingDownloaded.contains(this.currentVocab, false)) {
                    isDownloadingVocabAudio = true;
                } else {
                    isDownloadingVocabAudio = true;
                    httpGet = new Net.HttpRequest("GET");
                    httpGet.setUrl(RestClient.getAudioHost() + vocabFileName);
                    Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

                        @Override
                        public void handleHttpResponse(Net.HttpResponse httpResponse) {
                            FileManager.saveAudioFile(httpResponse.getResultAsStream(), vocabFileName);
                            AudioHandler.this.filesBeingDownloaded.removeValue(finalCurrentVocab, false);
                            if (AudioHandler.this.currentVocab.equals(finalCurrentVocab)) {
                                AudioHandler.this.assetManager.load(AudioHandler.this.currentVocab, Sound.class);
                                AudioHandler.this.assetManager.finishLoadingAsset(AudioHandler.this.currentVocab);
                                isDownloadingVocabAudio = false;
                            }
                        }

                        @Override
                        public void failed(Throwable t) {
                        }

                        @Override
                        public void cancelled() {
                        }
                    });
                    this.filesBeingDownloaded.add(finalCurrentVocab);
                }
            }
            if (playSentenceAudio) {
                FileHandle fhSentenceAudio = FileManager.getTempFile(this.currentSentence);
                if (fhSentenceAudio.exists() && !this.filesBeingDownloaded.contains(this.currentSentence, false)) {
                    if (!this.assetManager.contains(this.currentSentence, Sound.class)) {
                        this.assetManager.load(this.currentSentence, Sound.class);
                    }
                    this.assetManager.finishLoadingAsset(this.currentSentence);
                } else if (this.filesBeingDownloaded.contains(this.currentSentence, false)) {
                    isDownloadingSentenceAudio = true;
                } else {
                    isDownloadingSentenceAudio = true;
                    httpGet = new Net.HttpRequest("GET");
                    httpGet.setUrl(RestClient.getAudioHost() + sentenceFileName);
                    Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

                        @Override
                        public void handleHttpResponse(Net.HttpResponse httpResponse) {
                            FileManager.saveAudioFile(httpResponse.getResultAsStream(), sentenceFileName);
                            AudioHandler.this.filesBeingDownloaded.removeValue(finalCurrentSentence, false);
                            if (AudioHandler.this.currentSentence.equals(finalCurrentSentence)) {
                                AudioHandler.this.assetManager.load(AudioHandler.this.currentSentence, Sound.class);
                                AudioHandler.this.assetManager.finishLoadingAsset(AudioHandler.this.currentSentence);
                                isDownloadingSentenceAudio = false;
                            }
                        }

                        @Override
                        public void failed(Throwable t) {
                        }

                        @Override
                        public void cancelled() {
                        }
                    });
                    this.filesBeingDownloaded.add(finalCurrentSentence);
                }
            }
            this.queueTimer = new Timer.Task(){

                @Override
                public void run() {
                    if (!(playVocabAudio && !AudioHandler.this.assetManager.isLoaded(finalCurrentVocab, Sound.class) || playSentenceAudio && !AudioHandler.this.assetManager.isLoaded(finalCurrentSentence, Sound.class))) {
                        this.cancel();
                        if (Main.isAndroid()) {
                            if (playVocabAudio && playSentenceAudio) {
                                AudioHandler.this.queueTimer = new Timer.Task(){

                                    @Override
                                    public void run() {
                                        AudioHandler.this.playSound(finalCurrentVocab);
                                        AudioHandler.this.queueTimer = new Timer.Task(){

                                            @Override
                                            public void run() {
                                                AudioHandler.this.playSound(finalCurrentSentence);
                                            }
                                        };
                                        Timer.schedule(AudioHandler.this.queueTimer, 1.25f, 1.25f, 0);
                                    }
                                };
                                Timer.schedule(AudioHandler.this.queueTimer, 0.2f, 0.2f, 0);
                            } else if (playVocabAudio) {
                                AudioHandler.this.queueTimer = new Timer.Task(){

                                    @Override
                                    public void run() {
                                        AudioHandler.this.playSound(finalCurrentVocab);
                                    }
                                };
                                Timer.schedule(AudioHandler.this.queueTimer, 0.2f, 0.2f, 0);
                            } else {
                                AudioHandler.this.queueTimer = new Timer.Task(){

                                    @Override
                                    public void run() {
                                        AudioHandler.this.playSound(finalCurrentSentence);
                                    }
                                };
                                Timer.schedule(AudioHandler.this.queueTimer, 0.2f, 0.2f, 0);
                            }
                        } else if (playVocabAudio && playSentenceAudio) {
                            AudioHandler.this.playSound(finalCurrentVocab);
                            AudioHandler.this.queueTimer = new Timer.Task(){

                                @Override
                                public void run() {
                                    AudioHandler.this.playSound(finalCurrentSentence);
                                }
                            };
                            Timer.schedule(AudioHandler.this.queueTimer, 1.25f, 1.25f, 0);
                        } else if (playVocabAudio) {
                            AudioHandler.this.playSound(finalCurrentVocab);
                        } else {
                            AudioHandler.this.playSound(finalCurrentSentence);
                        }
                    }
                }
            };
            Timer.schedule(this.queueTimer, 0.1f, 0.1f);
        }
    }

    private void playSound(String fileName) {
        if (this.sound != null) {
            this.sound.stop();
        }
        this.sound = this.assetManager.get(fileName, Sound.class);
        this.sound.play(1.0f, 1.0f, 0.0f);
    }

    void stopMusic() {
        if (this.music != null && this.music.isPlaying()) {
            this.music.dispose();
        }
    }

    void stopSound() {
        if (this.queueTimer != null) {
            this.queueTimer.cancel();
        }
        isDownloadingVocabAudio = false;
        isDownloadingSentenceAudio = false;
        if (this.sound != null) {
            this.sound.stop();
        }
    }

    void setAKS(boolean enabled) {
        this.aks = enabled;
    }

    boolean isAKS() {
        return this.aks;
    }
}

