/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisSelectBox;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.BrowseScreen;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.Hints;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.RestClient;
import com.torii.srs.StudyScreen;
import com.torii.srs.widget.CollapsibleWidget;
import com.torii.srs.widget.List;
import com.torii.srs.widget.TextField;
import com.torii.srs.widget.TopMenu;

public class AddVocabScreen
implements Screen {
    static final int STANDARD_MEMBER_LIMIT = 10;
    private final String kanjiFontName = "addVocabKanji.ttf";
    private final String sentenceFontName = "addVocabSentence.ttf";
    private PracticeScreen.PracticeListsTable plt;
    private Vocabulary vocab;
    private Stage stage;
    private VisTable tblStep1;
    private TextField tfKanji;
    private TextField tfKana;
    private TextField tfMeaning;
    private TextField tfSentence;
    private TextField tfSentenceMeaning;
    private TextField tfPos;
    private VisTextButton tbAdd;
    private List listSynonyms;
    private List listReadings;
    private String synonyms;
    private String readings;
    private String notes;
    private String[] synonymsTemp;
    private String[] readingsTemp;
    private boolean isEditing;

    AddVocabScreen() {
        this(null);
    }

    AddVocabScreen(Vocabulary vocabulary) {
        this.isEditing = vocabulary != null;
        this.vocab = vocabulary;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        TopMenu topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                AddVocabScreen.this.home();
            }
        };
        this.plt = new PracticeScreen.PracticeListsTable(this.stage, true, false);
        if (this.vocab != null) {
            this.plt.setVocab(this.vocab.id);
        }
        if (!this.isEditing) {
            this.plt.disableAutomaticDatabaseUpdates(true);
        }
        this.createStep1Table();
        VisTable tblMain = new VisTable(false);
        tblMain.setFillParent(true);
        tblMain.align(2);
        tblMain.add(topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        tblMain.add(this.tblStep1).width(this.stage.getViewport().getWorldWidth()).expandY().fillY().padBottom(Main.getPPUY()).row();
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 4 || keycode == 111) {
                    AddVocabScreen.this.home();
                } else if (keycode == 66) {
                    AddVocabScreen.this.fakeClick(AddVocabScreen.this.tbAdd);
                }
                return true;
            }
        });
        this.stage.addActor(tblMain);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.tfKanji.requestFocus();
        if (Main.getPreviousScreen() != LoadingScreen.loadingScreen) {
            this.plt.refreshData();
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private void home() {
        this.stage.unfocusAll();
        Gdx.input.setOnscreenKeyboardVisible(false);
        if (!this.isEditing) {
            if (!this.isUnchanged()) {
                Dialogs.showConfirmDialog(this.stage, "Discard changes?", "Are you sure you want to discard your changes and return to the dashboard?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        AddVocabScreen.this.disposeAssets();
                        Dashboard.showOnScreen();
                    }
                });
            } else {
                this.disposeAssets();
                Dashboard.showOnScreen();
            }
        } else if (!this.isUnchanged()) {
            Dialogs.showConfirmDialog(this.stage, "Discard changes?", "Are you sure you want to discard changes and return to your vocabulary list?", new Dialogs.ConfirmAdapter(){

                @Override
                public void yes() {
                    AddVocabScreen.this.disposeAssets();
                    Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentlySelectedPracticeListID(), BrowseScreen.getCurrentPage()));
                }
            });
        } else {
            this.disposeAssets();
            Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentlySelectedPracticeListID(), BrowseScreen.getCurrentPage()));
        }
    }

    public static void showOnScreen() {
        Main.setNewScreen(new AddVocabScreen());
    }

    private void disposeAssets() {
        Main.disposeAsset("addVocabKanji.ttf", true);
        Main.disposeAsset("addVocabSentence.ttf", true);
    }

    private void createStep1Table() {
        final String sShowOnlyInReviews = "This vocab item will appear in your reviews together with all the standard vocabulary.";
        final String sPracticeOnly = "This vocab item can only be reviewed by starting a custom practice session.";
        VisTextField.VisTextFieldStyle tfKanjiStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        VisTextField.VisTextFieldStyle tfKanaStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        VisTextField.VisTextFieldStyle tfMeaningStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        VisTextField.VisTextFieldStyle tfSentenceStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        VisTextField.VisTextFieldStyle tfSentenceMeaningStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        VisTextField.VisTextFieldStyle tfPosStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        tfSentenceStyle.fontColor = Main.FONT;
        tfKanjiStyle.fontColor = Main.FONT;
        tfKanaStyle.fontColor = Main.FONT;
        tfMeaningStyle.fontColor = Main.FONT;
        tfSentenceStyle.fontColor = Main.FONT;
        tfSentenceMeaningStyle.fontColor = Main.FONT;
        tfPosStyle.fontColor = Main.FONT;
        final VisLabel lCharCounter = new VisLabel((CharSequence)("0/" + StudyScreen.getCharLimitNotes()), Main.labelStyleX1);
        final VisLabel lLevel = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        final VisLabel lReviewMode = new VisLabel((CharSequence)sShowOnlyInReviews, Main.labelStyleX0p5);
        VisLabel lHeadline = new VisLabel((CharSequence)"Add Vocabulary", Main.labelStyleX2);
        this.tfKanji = new TextField("", tfKanjiStyle);
        this.tfKana = new TextField("", tfKanaStyle);
        this.tfMeaning = new TextField("", tfMeaningStyle);
        this.tfSentence = new TextField("", tfSentenceStyle);
        this.tfSentenceMeaning = new TextField("", tfSentenceMeaningStyle);
        this.tfPos = new TextField("", tfPosStyle);
        VisTextButton tbKanji = new VisTextButton("Paste", Main.btnStyleX1);
        VisTextButton tbKana = new VisTextButton("Paste", Main.btnStyleX1);
        VisTextButton tbMeaning = new VisTextButton("Paste", Main.btnStyleX1);
        VisTextButton tbSentence = new VisTextButton("Paste", Main.btnStyleX1);
        VisTextButton tbSentenceMeaning = new VisTextButton("Paste", Main.btnStyleX1);
        VisTextButton tbPos = new VisTextButton("Paste", Main.btnStyleX1);
        this.tbAdd = new VisTextButton("Add To Database", Main.btnStyleX1p25);
        VisTextButton tbSynonymsAdd = new VisTextButton("+", Main.btnStyleX1p25);
        VisTextButton tbSynonymsRemove = new VisTextButton("-", Main.btnStyleX1p25);
        VisTextButton tbReadingsAdd = new VisTextButton("+", Main.btnStyleX1p25);
        VisTextButton tbReadingsRemove = new VisTextButton("-", Main.btnStyleX1p25);
        final VisTextButton tbStandardMode = new VisTextButton("Standard Mode", "toggle");
        final VisTextButton tbPracticeMode = new VisTextButton("Practice Mode", "toggle");
        final VisSelectBox<String> sbLevel = new VisSelectBox<String>(new SelectBox.SelectBoxStyle(new VisSelectBox().getStyle()));
        sbLevel.setItems("Rookie 1", "Rookie 2", "Rookie 3", "Rookie 4", "Amateur 1", "Amateur 2", "Expert", "Master", "Sensei");
        this.listSynonyms = new List("Synonyms");
        this.listReadings = new List("Readings");
        this.synonymsTemp = new String[0];
        this.readingsTemp = new String[0];
        this.disposeAssets();
        Main.loadTTFtoAssetManager("addVocabKanji.ttf", Main.getPPUY(), Main.getKanaChars() + "\u4f8b\u3048\u3070", false);
        Main.loadTTFtoAssetManager("addVocabSentence.ttf", Main.getPPUY(), Main.getKanaChars() + "\u4f8b", false);
        Main.finishLoadingAsset("addVocabKanji.ttf", true);
        Main.finishLoadingAsset("addVocabSentence.ttf", true);
        sbLevel.getStyle().background = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
        sbLevel.getStyle().backgroundOver = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        sbLevel.getStyle().backgroundOpen = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        sbLevel.getStyle().listStyle.background = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
        tfKanjiStyle.font = (BitmapFont)Main.getAsset("addVocabKanji.ttf", BitmapFont.class, true);
        tfKanaStyle.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
        tfSentenceStyle.font = (BitmapFont)Main.getAsset("addVocabSentence.ttf", BitmapFont.class, true);
        this.tfKanji.setRenewFontOnPaste(true, "addVocabKanji.ttf");
        this.tfSentence.setRenewFontOnPaste(true, "addVocabSentence.ttf");
        this.tfKanji.setKanaMode(true);
        this.tfKana.setKanaMode(true);
        this.tfSentence.setKanaMode(true);
        this.tfMeaning.setForbiddenCharacters(new char[]{';', '.'});
        tbStandardMode.setChecked(true);
        lReviewMode.setWrap(true);
        lLevel.setWrap(true);
        lCharCounter.setAlignment(20);
        lReviewMode.setAlignment(1);
        lLevel.setAlignment(1);
        sbLevel.setAlignment(1);
        lCharCounter.setTouchable(Touchable.disabled);
        tbKanji.setFocusBorderEnabled(false);
        tbKana.setFocusBorderEnabled(false);
        tbMeaning.setFocusBorderEnabled(false);
        tbSentence.setFocusBorderEnabled(false);
        tbSentenceMeaning.setFocusBorderEnabled(false);
        tbPos.setFocusBorderEnabled(false);
        tbSynonymsAdd.setFocusBorderEnabled(false);
        tbSynonymsRemove.setFocusBorderEnabled(false);
        tbReadingsAdd.setFocusBorderEnabled(false);
        tbReadingsRemove.setFocusBorderEnabled(false);
        tbStandardMode.setFocusBorderEnabled(false);
        tbPracticeMode.setFocusBorderEnabled(false);
        lCharCounter.addAction(Actions.fadeOut(0.0f));
        this.tfKanji.setCharacterLimit(25);
        this.tfKana.setCharacterLimit(25);
        this.tfMeaning.setCharacterLimit(100);
        this.tfSentence.setCharacterLimit(200);
        this.tfSentenceMeaning.setCharacterLimit(200);
        this.tfPos.setCharacterLimit(100);
        this.tfKanji.setDefaultText("\u4f8b\u3048\u3070");
        this.tfKana.setDefaultText("\u305f\u3068\u3048\u3070");
        this.tfMeaning.setDefaultText("for example, comma separated");
        this.tfSentence.setDefaultText("\u4f8b\u3048\u3070\u3001\u3053\u308c\u306f\u30da\u30f3\u30d1\u30a4\u30ca\u30c3\u30dd\u30fc\u30a2\u30c3\u30dd\u30fc\u30da\u30f3\u3067\u3059\u3002");
        this.tfSentenceMeaning.setDefaultText("For example, this is a pen-pineapple-apple-pen.");
        this.tfPos.setDefaultText("Adverb");
        ScrollableTextArea taNotes = new ScrollableTextArea("", new VisTextField.VisTextFieldStyle(Main.taStyle));
        taNotes.setMessageText("Click to add a note or mnemonic.");
        taNotes.getStyle().font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
        taNotes.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        taNotes.setAlignment(1);
        taNotes.setFocusTraversal(false);
        VisScrollPane spNotes = (VisScrollPane)taNotes.createCompatibleScrollPane();
        if (this.isEditing) {
            this.tfKanji.paste(this.vocab.kanji);
            this.tfKana.paste(this.vocab.kana);
            this.tfMeaning.paste(this.vocab.meaning);
            this.tfSentence.paste(this.vocab.sentence);
            this.tfSentenceMeaning.paste(this.vocab.sentenceMeaning);
            this.tfPos.paste(this.vocab.pos);
            taNotes.setText(this.vocab.notes);
            lHeadline.setText("Edit Vocabulary");
            this.tbAdd.setText("Update Vocabulary");
            this.synonyms = this.vocab.synonyms;
            this.readings = this.vocab.readings;
            this.notes = this.vocab.notes;
            this.tfKanji.setDefaultText(this.vocab.kanji);
            this.tfKana.setDefaultText(this.vocab.kana);
            this.tfMeaning.setDefaultText(this.vocab.meaning);
            this.tfSentence.setDefaultText(this.vocab.sentence);
            this.tfSentenceMeaning.setDefaultText(this.vocab.sentenceMeaning);
            this.tfPos.setDefaultText(this.vocab.pos);
            this.synonymsTemp = this.synonyms != null ? this.synonyms.split(";") : new String[0];
            this.listSynonyms.setItems(this.synonymsTemp);
            this.listSynonyms.setSelectedIndex(-1);
            this.readingsTemp = this.readings != null ? this.readings.split(";") : new String[0];
            this.listReadings.setItems(this.readingsTemp);
            this.listReadings.setSelectedIndex(-1);
        }
        float space = Main.getPPUY();
        VisTable tblCustomSynonyms = new VisTable(true);
        tblCustomSynonyms.defaults().expandX().fillX();
        tblCustomSynonyms.add(this.listSynonyms).colspan(2).height(8 * Main.getPPUY()).expand().fill().align(2).row();
        tblCustomSynonyms.add(tbSynonymsAdd).uniform();
        tblCustomSynonyms.add(tbSynonymsRemove).uniform().row();
        VisTable tblCustomReadings = new VisTable(true);
        tblCustomReadings.defaults().expandX().fillX();
        tblCustomReadings.add(this.listReadings).colspan(2).expand().fill().align(2).row();
        tblCustomReadings.add(tbReadingsAdd).uniform();
        tblCustomReadings.add(tbReadingsRemove).uniform().row();
        Stack stack = new Stack(spNotes, lCharCounter);
        VisTable tblCustom = new VisTable(true);
        tblCustom.setFillParent(true);
        tblCustom.add(stack).colspan(2).height(6.5f * (float)Main.getPPUY()).expandX().fillX().padTop(space).row();
        tblCustom.add(tblCustomSynonyms).expand().fill().uniformX();
        tblCustom.add(tblCustomReadings).expand().fill().uniformX();
        VisTable tblReviewSettings = new VisTable(false);
        tblReviewSettings.setFillParent(true);
        tblReviewSettings.padTop(space);
        if (!this.isEditing) {
            tblReviewSettings.add(sbLevel).colspan(2).padBottom(space / 2.0f).row();
            tblReviewSettings.add(lLevel).colspan(2).expandX().fillX().padBottom(space * 2.0f).row();
        }
        tblReviewSettings.add(tbStandardMode).align(16).uniformX().padBottom(space / 2.0f);
        tblReviewSettings.add(tbPracticeMode).align(8).uniformX().padBottom(space / 2.0f).row();
        tblReviewSettings.add(lReviewMode).colspan(2).expandX().fillX();
        VisTable tblPracticeLists = new VisTable(false);
        tblPracticeLists.setFillParent(true);
        tblPracticeLists.add(this.plt).height(space * 20.0f).expand().fill().padTop(space);
        final CollapsibleWidget cwCustomSettings = new CollapsibleWidget(tblCustom);
        final CollapsibleWidget cwReviewSettings = new CollapsibleWidget(tblReviewSettings);
        final CollapsibleWidget cwLists = new CollapsibleWidget(tblPracticeLists);
        cwCustomSettings.setCollapsed(true, false);
        cwReviewSettings.setCollapsed(true, false);
        cwLists.setCollapsed(true, false);
        VisTextButton.VisTextButtonStyle tbStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("", "toggle").getStyle());
        tbStyle.up = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
        tbStyle.over = Main.uiSkin.newDrawable("white", Main.OBJECT_OVER);
        tbStyle.down = Main.uiSkin.newDrawable("white", Main.OBJECT_PRESSED);
        tbStyle.disabled = tbStyle.up;
        VisTextButton tbCollapseCustomSettings = new VisTextButton("Custom Settings", tbStyle);
        VisTextButton tbCollapseReviewSettings = new VisTextButton("Review Mode Settings", tbStyle);
        final VisTextButton tbCollapseLists = new VisTextButton("Practice List Settings", tbStyle);
        tbCollapseCustomSettings.setFocusBorderEnabled(false);
        tbCollapseReviewSettings.setFocusBorderEnabled(false);
        tbCollapseLists.setFocusBorderEnabled(false);
        tbCollapseCustomSettings.setChecked(false);
        tbCollapseReviewSettings.setChecked(false);
        tbCollapseLists.setChecked(false);
        if (!Main.isPrime()) {
            tbCollapseLists.setText("Practice List Settings (Prime Only)");
            tbCollapseLists.setDisabled(true);
        }
        tbCollapseCustomSettings.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                cwCustomSettings.setCollapsed(!cwCustomSettings.isCollapsed());
            }
        });
        tbCollapseReviewSettings.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                cwReviewSettings.setCollapsed(!cwReviewSettings.isCollapsed());
            }
        });
        tbCollapseLists.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!tbCollapseLists.isDisabled()) {
                    cwLists.setCollapsed(!cwLists.isCollapsed());
                }
            }
        });
        VisTable tblStep1Child = new VisTable(false);
        tblStep1Child.align(2);
        tblStep1Child.add(lHeadline).expandX().fillX().align(8).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Vocabulary", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfKanji).padRight(space / 2.0f).padBottom(space).expandX().fillX();
        tblStep1Child.add(tbKanji).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Reading", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfKana).padRight(space / 2.0f).padBottom(space).expandX().fillX();
        tblStep1Child.add(tbKana).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Translation(s)", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfMeaning).padRight(space / 2.0f).padBottom(space).expandX().fillX();
        tblStep1Child.add(tbMeaning).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Example sentence", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfSentence).padRight(space / 2.0f).padBottom(space).expandX().fillX();
        tblStep1Child.add(tbSentence).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Sentence translation", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfSentenceMeaning).padRight(space / 2.0f).padBottom(space).expandX().fillX();
        tblStep1Child.add(tbSentenceMeaning).padBottom(space).row();
        tblStep1Child.add(new VisLabel((CharSequence)"Part of Speech", Main.labelStyleX1)).expandX().fillX().align(8).row();
        tblStep1Child.add(this.tfPos).padRight(space / 2.0f).padBottom(space / 2.0f).expandX().fillX();
        tblStep1Child.add(tbPos).padBottom(space / 2.0f).row();
        tblStep1Child.addSeparator().colspan(2).padBottom(space / 2.0f);
        tblStep1Child.add(tbCollapseCustomSettings).colspan(2).expandX().fillX().row();
        tblStep1Child.add(cwCustomSettings).colspan(2).expand().fill().padBottom(space / 2.0f).row();
        tblStep1Child.addSeparator().colspan(2).padBottom(space / 2.0f);
        tblStep1Child.add(tbCollapseReviewSettings).colspan(2).expandX().fillX().row();
        tblStep1Child.add(cwReviewSettings).colspan(2).expand().fill().padBottom(space / 2.0f).row();
        tblStep1Child.addSeparator().colspan(2).padBottom(space / 2.0f);
        tblStep1Child.add(tbCollapseLists).colspan(2).expandX().fillX().row();
        tblStep1Child.add(cwLists).colspan(2).expand().fill().padBottom(space / 2.0f).row();
        tblStep1Child.addSeparator().colspan(2).padBottom(space / 2.0f);
        tblStep1Child.add(this.tbAdd).colspan(2).expand().fillX().align(4);
        VisTable tblStep1Child2 = new VisTable(false);
        tblStep1Child2.align(2);
        tblStep1Child2.add(tblStep1Child).width(this.stage.getViewport().getWorldWidth() * 0.95f);
        final VisScrollPane sp = new VisScrollPane((Actor)tblStep1Child2);
        this.tblStep1 = new VisTable(false);
        this.tblStep1.align(2);
        this.tblStep1.add(sp).width(this.stage.getViewport().getWorldWidth());
        final Timer.Task charCounterTimer = new Timer.Task(){

            @Override
            public void run() {
                lCharCounter.addAction(Actions.fadeOut(0.25f));
            }
        };
        tbKanji.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfKanji.paste();
                AddVocabScreen.this.tfKanji.requestFocus();
            }
        });
        tbKana.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfKana.paste();
                AddVocabScreen.this.tfKana.requestFocus();
            }
        });
        tbMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfMeaning.paste();
                AddVocabScreen.this.tfMeaning.requestFocus();
            }
        });
        tbSentence.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfSentence.paste();
                AddVocabScreen.this.tfSentence.requestFocus();
            }
        });
        tbSentenceMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfSentenceMeaning.paste();
                AddVocabScreen.this.tfSentenceMeaning.requestFocus();
            }
        });
        tbPos.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                AddVocabScreen.this.tfPos.paste();
                AddVocabScreen.this.tfPos.requestFocus();
            }
        });
        tbStandardMode.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                lReviewMode.setText(sShowOnlyInReviews);
                tbStandardMode.setChecked(true);
                tbPracticeMode.setChecked(false);
                if (sbLevel.isDisabled()) {
                    sbLevel.setDisabled(false);
                    sbLevel.setSelectedIndex(0);
                }
            }
        });
        tbPracticeMode.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                lReviewMode.setText(sPracticeOnly);
                tbStandardMode.setChecked(false);
                tbPracticeMode.setChecked(true);
                sbLevel.setDisabled(true);
                sbLevel.setSelectedIndex(sbLevel.getItems().size - 1);
            }
        });
        if (this.isEditing && this.vocab.streak == 9) {
            this.fakeClick(tbPracticeMode);
        }
        this.tbAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                int streak = sbLevel.getSelectedIndex() + 1;
                if (!AddVocabScreen.this.isEditing) {
                    if (AddVocabScreen.this.isInputValid()) {
                        RestClient.addCustomVocab(AddVocabScreen.this.plt, -1, AddVocabScreen.this.tfKanji.getText(), AddVocabScreen.this.tfKana.getText(), AddVocabScreen.this.tfMeaning.getText(), AddVocabScreen.this.tfSentence.getText(), AddVocabScreen.this.tfSentenceMeaning.getText(), AddVocabScreen.this.tfPos.getText(), AddVocabScreen.this.synonyms, AddVocabScreen.this.readings, AddVocabScreen.this.notes, streak);
                    } else {
                        sp.setScrollY(0.0f);
                    }
                } else {
                    boolean wasChanged = !AddVocabScreen.this.isUnchanged();
                    streak = -1;
                    if (tbStandardMode.isChecked() && ((AddVocabScreen)AddVocabScreen.this).vocab.streak == 9) {
                        streak = 1;
                        wasChanged = true;
                    } else if (tbPracticeMode.isChecked() && ((AddVocabScreen)AddVocabScreen.this).vocab.streak < 9) {
                        streak = 9;
                        wasChanged = true;
                    }
                    if (AddVocabScreen.this.isInputValid() && wasChanged) {
                        RestClient.addCustomVocab(null, ((AddVocabScreen)AddVocabScreen.this).vocab.id, AddVocabScreen.this.tfKanji.getText(), AddVocabScreen.this.tfKana.getText(), AddVocabScreen.this.tfMeaning.getText(), AddVocabScreen.this.tfSentence.getText(), AddVocabScreen.this.tfSentenceMeaning.getText(), AddVocabScreen.this.tfPos.getText(), AddVocabScreen.this.synonyms, AddVocabScreen.this.readings, AddVocabScreen.this.notes, streak);
                    } else {
                        sp.setScrollY(0.0f);
                    }
                }
            }
        });
        taNotes.setTextFieldListener(new VisTextField.TextFieldListener(){

            @Override
            public void keyTyped(VisTextField textField, char key) {
                int cursorPos = textField.getCursorPosition();
                String content = textField.getText().replaceAll(" +", " ").replaceAll("\n+", "\n");
                if (content.length() > 0 && content.charAt(0) == '\n') {
                    content = content.replaceFirst("\n", "");
                }
                if (content.length() > StudyScreen.getCharLimitNotes()) {
                    content = content.substring(0, StudyScreen.getCharLimitNotes());
                }
                AddVocabScreen.this.notes = content;
                textField.setText(content);
                textField.setCursorPosition(cursorPos);
                lCharCounter.addAction(Actions.fadeIn(0.0f));
                lCharCounter.setText(content.length() + "/" + StudyScreen.getCharLimitNotes());
                if (charCounterTimer.isScheduled()) {
                    charCounterTimer.cancel();
                }
                Timer.schedule(charCounterTimer, 2.0f, 2.0f, 0);
            }
        });
        tbSynonymsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AddVocabScreen.this.synonymsTemp.length < 5) {
                    if (Hints.getHintAddSynonym()) {
                        Hints.showAddSynonymHint(AddVocabScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                AddVocabScreen.this.showAddSynonymDialog();
                            }
                        });
                    } else {
                        AddVocabScreen.this.showAddSynonymDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(AddVocabScreen.this.stage, "Sorry, only 5 Synonyms allowed.");
                }
            }
        });
        tbSynonymsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AddVocabScreen.this.listSynonyms.getSelectedIndex() > -1) {
                    AddVocabScreen.this.synonyms = AddVocabScreen.this.synonyms.replace(AddVocabScreen.this.listSynonyms.getSelected() + ";", "");
                    if (AddVocabScreen.this.synonyms.equals("")) {
                        AddVocabScreen.this.synonyms = null;
                    }
                    if (AddVocabScreen.this.synonyms != null) {
                        AddVocabScreen.access$1802(AddVocabScreen.this, AddVocabScreen.this.synonyms.split(";"));
                    } else {
                        AddVocabScreen.access$1802(AddVocabScreen.this, new String[0]);
                    }
                    AddVocabScreen.this.listSynonyms.setItems(AddVocabScreen.this.synonymsTemp);
                    AddVocabScreen.this.listSynonyms.setSelectedIndex(-1);
                }
            }
        });
        tbReadingsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AddVocabScreen.this.readingsTemp.length < 5) {
                    if (Hints.getHintAddReading()) {
                        Hints.showAddReadingHint(AddVocabScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                AddVocabScreen.this.showAddReadingDialog();
                            }
                        });
                    } else {
                        AddVocabScreen.this.showAddReadingDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(AddVocabScreen.this.stage, "Sorry, only 5 Readings allowed.");
                }
            }
        });
        tbReadingsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (AddVocabScreen.this.listReadings.getSelectedIndex() > -1) {
                    AddVocabScreen.this.readings = AddVocabScreen.this.readings.replace(AddVocabScreen.this.listReadings.getSelected() + ";", "");
                    if (AddVocabScreen.this.readings.equals("")) {
                        AddVocabScreen.this.readings = null;
                    }
                    if (AddVocabScreen.this.readings != null) {
                        AddVocabScreen.access$2202(AddVocabScreen.this, AddVocabScreen.this.readings.split(";"));
                    } else {
                        AddVocabScreen.access$2202(AddVocabScreen.this, new String[0]);
                    }
                    AddVocabScreen.this.listReadings.setItems(AddVocabScreen.this.readingsTemp);
                    AddVocabScreen.this.listReadings.setSelectedIndex(-1);
                }
            }
        });
        sbLevel.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String s;
                if (!sbLevel.isDisabled()) {
                    switch (sbLevel.getSelectedIndex()) {
                        case 0: {
                            s = "4 hours";
                            break;
                        }
                        case 1: {
                            s = "8 hours";
                            break;
                        }
                        case 2: {
                            s = "24 hours";
                            break;
                        }
                        case 3: {
                            s = "48 hours";
                            break;
                        }
                        case 4: {
                            s = "7 days";
                            break;
                        }
                        case 5: {
                            s = "14 days";
                            break;
                        }
                        case 6: {
                            s = "30 days";
                            break;
                        }
                        case 7: {
                            s = "120 days";
                            break;
                        }
                        case 8: {
                            s = "10 years";
                            break;
                        }
                        default: {
                            s = "N/A";
                            break;
                        }
                    }
                } else {
                    s = "Custom";
                }
                lLevel.setText("Next review: " + s);
            }
        });
        sbLevel.fire(new ChangeListener.ChangeEvent());
    }

    private void fakeClick(Actor actor) {
        DelayedRemovalArray<EventListener> listeners = actor.getListeners();
        for (int i = 0; i < listeners.size; ++i) {
            if (!(listeners.get(i) instanceof ClickListener)) continue;
            ((ClickListener)listeners.get(i)).clicked(null, 0.0f, 0.0f);
        }
    }

    private boolean isUnchanged() {
        if (!this.isEditing) {
            return this.tfKanji.getText().equals("") && this.tfKana.getText().equals("") && this.tfMeaning.getText().equals("") && this.tfSentence.getText().equals("") && this.tfSentenceMeaning.getText().equals("") && this.tfPos.getText().equals("") && this.synonyms == null && this.readings == null && this.notes == null;
        }
        return this.tfKanji.getText().equals(this.vocab.kanji) && this.tfKana.getText().equals(this.vocab.kana) && this.tfMeaning.getText().equals(this.vocab.meaning) && this.tfSentence.getText().equals(this.vocab.sentence) && this.tfSentenceMeaning.getText().equals(this.vocab.sentenceMeaning) && this.tfPos.getText().equals(this.vocab.pos) && this.synonyms == this.vocab.synonyms && this.readings == this.vocab.readings && this.notes == this.vocab.notes;
    }

    private boolean isInputValid() {
        this.tfKanji.setInputValid(!this.tfKanji.getText().equals(""));
        this.tfKana.setInputValid(!this.tfKana.getText().equals(""));
        this.tfMeaning.setInputValid(!this.tfMeaning.getText().equals(""));
        this.tfSentence.setInputValid(!this.tfSentence.getText().equals(""));
        this.tfSentenceMeaning.setInputValid(!this.tfSentenceMeaning.getText().equals(""));
        this.tfKanji.setInputValid(this.tfKanji.getText().matches("[^" + Main.getDiacriticsChars() + "a-zA-Z '\\(\\-\\)\\.]+"));
        this.tfKana.setInputValid(this.tfKana.getText().matches("[^" + Main.getDiacriticsChars() + "a-zA-Z '\\(\\-\\)\\.]+"));
        this.tfSentence.setInputValid(this.tfSentence.getText().matches("[^" + Main.getDiacriticsChars() + "a-zA-Z '\\(\\-\\)\\.]+"));
        if (this.tfMeaning.getText().endsWith(",")) {
            this.tfMeaning.setText(this.tfMeaning.getText().substring(0, this.tfMeaning.getText().length() - 1));
        }
        return this.tfKanji.isInputValid() && this.tfKana.isInputValid() && this.tfMeaning.isInputValid() && this.tfSentence.isInputValid() && this.tfSentenceMeaning.isInputValid();
    }

    private void showAddSynonymDialog() {
        Dialogs.showInputDialog(this.stage, "Add Synonym:", "", 25, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getDiacriticsChars() + "A-Za-z\\' ]", "").replaceAll(" +", " ").trim().toLowerCase()).equals("")) {
                    return;
                }
                for (String s : AddVocabScreen.this.synonymsTemp) {
                    if (!s.equals(input)) continue;
                    Dialogs.showErrorDialog(AddVocabScreen.this.stage, "Synonym already exists.");
                    return;
                }
                if (AddVocabScreen.this.synonyms != null) {
                    AddVocabScreen.this.synonyms = AddVocabScreen.this.synonyms + input + ";";
                } else {
                    AddVocabScreen.this.synonyms = input + ";";
                }
                AddVocabScreen.access$1802(AddVocabScreen.this, AddVocabScreen.this.synonyms.split(";"));
                AddVocabScreen.this.listSynonyms.setItems(AddVocabScreen.this.synonymsTemp);
                AddVocabScreen.this.listSynonyms.setSelectedIndex(-1);
            }
        });
    }

    private void showAddReadingDialog() {
        Dialogs.showInputDialog(this.stage, "Add Reading:", "", 15, false, true, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getKanaChars() + "]+", "").trim()).equals("")) {
                    return;
                }
                for (String s : AddVocabScreen.this.readingsTemp) {
                    if (!s.equals(input)) continue;
                    Dialogs.showErrorDialog(AddVocabScreen.this.stage, "Reading already exists.");
                    return;
                }
                if (AddVocabScreen.this.readings != null) {
                    AddVocabScreen.this.readings = AddVocabScreen.this.readings + input + ";";
                } else {
                    AddVocabScreen.this.readings = input + ";";
                }
                AddVocabScreen.access$2202(AddVocabScreen.this, AddVocabScreen.this.readings.split(";"));
                AddVocabScreen.this.listReadings.setItems(AddVocabScreen.this.readingsTemp);
                AddVocabScreen.this.listReadings.setSelectedIndex(-1);
            }
        });
    }

    static /* synthetic */ String[] access$1802(AddVocabScreen x0, String[] x1) {
        x0.synonymsTemp = x1;
        return x1;
    }

    static /* synthetic */ String[] access$2202(AddVocabScreen x0, String[] x1) {
        x0.readingsTemp = x1;
        return x1;
    }

    static class Vocabulary {
        final int id;
        final int streak;
        final String kanji;
        final String kana;
        final String meaning;
        final String sentence;
        final String sentenceMeaning;
        final String pos;
        final String synonyms;
        final String readings;
        final String notes;

        Vocabulary(int id, String kanji, String kana, String meaning, String sentence, String sentenceMeaning, String partOfSpeech, String synonyms, String readings, String notes, int streak) {
            this.id = id;
            this.kanji = kanji;
            this.kana = kana;
            this.meaning = meaning;
            this.sentence = sentence;
            this.sentenceMeaning = sentenceMeaning;
            this.pos = partOfSpeech != null ? partOfSpeech : "";
            this.synonyms = synonyms;
            this.readings = readings;
            this.notes = notes;
            this.streak = streak;
        }
    }
}

