/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.FileTypeFilter;
import com.kotcrab.vis.ui.widget.file.internal.AbstractSuggestionPopup;

public class FileSuggestionPopup
extends AbstractSuggestionPopup {
    public FileSuggestionPopup(FileChooser chooser) {
        super(chooser);
    }

    public void pathFieldKeyTyped(Stage stage, Array<FileHandle> files, VisTextField pathField) {
        if (pathField.getText().length() == 0) {
            this.remove();
            return;
        }
        int suggestions = this.createSuggestions(files, pathField);
        if (suggestions == 0) {
            this.remove();
            return;
        }
        this.showMenu(stage, pathField);
    }

    private int createSuggestions(Array<FileHandle> files, final VisTextField fileNameField) {
        this.clearChildren();
        int suggestions = 0;
        for (final FileHandle file : files) {
            if (file.name().startsWith(fileNameField.getText()) && !file.name().equals(fileNameField.getText())) {
                MenuItem item = this.createMenuItem(this.getTrimmedName(file.name()));
                item.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        FileSuggestionPopup.this.chooser.highlightFiles(file);
                    }
                });
                this.addItem(item);
                ++suggestions;
            }
            if (suggestions != 10) continue;
            break;
        }
        if (this.chooser.getMode() == FileChooser.Mode.SAVE && suggestions == 0 && this.chooser.getActiveFileTypeFilterRule() != null && fileNameField.getText().matches(".*\\.")) {
            FileTypeFilter.Rule rule = this.chooser.getActiveFileTypeFilterRule();
            for (String extension : rule.getExtensions()) {
                MenuItem item = this.createMenuItem(fileNameField.getText() + extension);
                final String arbitraryPath = fileNameField.getText() + extension;
                item.addListener(new ChangeListener(){

                    @Override
                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        fileNameField.setText(arbitraryPath);
                        fileNameField.setCursorAtTextEnd();
                    }
                });
                this.addItem(item);
                ++suggestions;
            }
        }
        return suggestions;
    }

    private String getTrimmedName(String name) {
        if (name.length() > 40) {
            return name.substring(0, 40) + "...";
        }
        return name;
    }
}

