/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.layout.GridGroup;
import com.kotcrab.vis.ui.util.adapter.ArrayAdapter;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import java.util.Objects;

public class FileListAdapter
extends ArrayAdapter<FileHandle, FileChooser.FileItem> {
    private final FileChooser chooser;
    private final Array<FileChooser.FileItem> orderedViews = new Array();
    private GridGroup gridGroup;

    public FileListAdapter(FileChooser chooser, Array<FileHandle> files) {
        super(files);
        this.chooser = chooser;
        this.gridGroup = new GridGroup(128.0f, 2.0f);
    }

    @Override
    protected FileChooser.FileItem createView(FileHandle item) {
        FileChooser fileChooser = this.chooser;
        Objects.requireNonNull(fileChooser);
        return fileChooser.new FileChooser.FileItem(item, this.chooser.getViewMode());
    }

    @Override
    public void fillTable(VisTable itemsTable) {
        FileChooser.ViewMode viewMode;
        this.getViews().clear();
        this.orderedViews.clear();
        this.gridGroup.clear();
        if (this.getItemsSorter() != null) {
            this.sort(this.getItemsSorter());
        }
        if ((viewMode = this.chooser.getViewMode()).isGridMode()) {
            viewMode.setupGridGroup(this.chooser.getSizes(), this.gridGroup);
            for (FileHandle item : this.iterable()) {
                FileChooser.FileItem view = (FileChooser.FileItem)this.getView(item);
                this.orderedViews.add(view);
                this.prepareViewBeforeAddingToTable(item, view);
                this.gridGroup.addActor(view);
            }
            itemsTable.add(this.gridGroup).growX().minWidth(0.0f);
        } else {
            for (FileHandle item : this.iterable()) {
                FileChooser.FileItem view = (FileChooser.FileItem)this.getView(item);
                this.orderedViews.add(view);
                this.prepareViewBeforeAddingToTable(item, view);
                itemsTable.add(view).growX();
                itemsTable.row();
            }
        }
    }

    @Override
    public ObjectMap<FileHandle, FileChooser.FileItem> getViews() {
        return super.getViews();
    }

    public Array<FileChooser.FileItem> getOrderedViews() {
        return this.orderedViews;
    }
}

