/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.util.OsUtils;
import com.kotcrab.vis.ui.widget.file.internal.ServiceThreadFactory;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileChooserWinService {
    private static FileChooserWinService instance;
    private ObjectMap<File, String> nameCache = new ObjectMap();
    private Map<File, ListenerSet> listeners = new HashMap<File, ListenerSet>();
    private final ExecutorService pool = Executors.newFixedThreadPool(3, new ServiceThreadFactory("SystemDisplayNameGetter"));
    private boolean shellFolderSupported = false;
    private Method getShellFolderMethod;
    private Method getShellFolderDisplayNameMethod;

    public static synchronized FileChooserWinService getInstance() {
        if (!OsUtils.isWindows()) {
            return null;
        }
        if (instance == null) {
            instance = new FileChooserWinService();
        }
        return instance;
    }

    protected FileChooserWinService() {
        File[] roots;
        try {
            Class<?> shellFolderClass = Class.forName("sun.awt.shell.ShellFolder");
            this.getShellFolderMethod = shellFolderClass.getMethod("getShellFolder", File.class);
            this.getShellFolderDisplayNameMethod = shellFolderClass.getMethod("getDisplayName", new Class[0]);
            this.shellFolderSupported = true;
        }
        catch (ClassNotFoundException shellFolderClass) {
        }
        catch (NoSuchMethodException shellFolderClass) {
            // empty catch block
        }
        for (File root : roots = File.listRoots()) {
            this.processRoot(root);
        }
    }

    private void processRoot(final File root) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                FileChooserWinService.this.processResult(root, FileChooserWinService.this.getSystemDisplayName(root));
            }
        });
    }

    private void processResult(final File root, final String name) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (name != null) {
                    FileChooserWinService.this.nameCache.put(root, name);
                } else {
                    FileChooserWinService.this.nameCache.put(root, root.toString());
                }
                ListenerSet set = (ListenerSet)FileChooserWinService.this.listeners.get(root);
                if (set != null) {
                    set.notifyListeners(name);
                }
            }
        });
    }

    public void addListener(File root, RootNameListener listener) {
        String cachedName = this.nameCache.get(root);
        if (cachedName != null) {
            listener.setRootName(cachedName);
            return;
        }
        ListenerSet set = this.listeners.get(root);
        if (set == null) {
            set = new ListenerSet();
            this.listeners.put(root, set);
        }
        set.add(listener);
        this.processRoot(root);
    }

    private String getSystemDisplayName(File f) {
        String name;
        if (!this.shellFolderSupported) {
            return null;
        }
        try {
            Object shellFolder = this.getShellFolderMethod.invoke(null, f);
            name = (String)this.getShellFolderDisplayNameMethod.invoke(shellFolder, new Object[0]);
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (name == null || name.length() == 0) {
            name = f.getPath();
        }
        return name;
    }

    private static class ListenerSet {
        Array<WeakReference<RootNameListener>> list = new Array();

        private ListenerSet() {
        }

        public void add(RootNameListener listener) {
            this.list.add(new WeakReference<RootNameListener>(listener));
        }

        public void notifyListeners(String newName) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                RootNameListener listener = (RootNameListener)((WeakReference)it.next()).get();
                if (listener == null) {
                    it.remove();
                    continue;
                }
                listener.setRootName(newName);
            }
        }
    }

    public static interface RootNameListener {
        public void setRootName(String var1);
    }
}

