/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Sort;
import com.kotcrab.vis.ui.util.OsUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Comparator;

public class FileUtils {
    private static final String[] UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"};
    public static final Comparator<FileHandle> FILE_NAME_COMPARATOR = new Comparator<FileHandle>(){

        @Override
        public int compare(FileHandle f1, FileHandle f2) {
            return f1.name().toLowerCase().compareTo(f2.name().toLowerCase());
        }
    };
    public static final Comparator<FileHandle> FILE_MODIFIED_DATE_COMPARATOR = new Comparator<FileHandle>(){

        @Override
        public int compare(FileHandle f1, FileHandle f2) {
            long l2;
            long l1 = f1.lastModified();
            return l1 > (l2 = f2.lastModified()) ? 1 : (l1 == l2 ? FILE_NAME_COMPARATOR.compare(f1, f2) : -1);
        }
    };
    public static final Comparator<FileHandle> FILE_SIZE_COMPARATOR = new Comparator<FileHandle>(){

        @Override
        public int compare(FileHandle f1, FileHandle f2) {
            long l2;
            long l1 = f1.length();
            return l1 > (l2 = f2.length()) ? -1 : (l1 == l2 ? FILE_NAME_COMPARATOR.compare(f1, f2) : 1);
        }
    };

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0 B";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)).replace(",", ".") + " " + UNITS[digitGroups];
    }

    public static Array<FileHandle> sortFiles(FileHandle[] files) {
        return FileUtils.sortFiles(files, FILE_NAME_COMPARATOR);
    }

    public static Array<FileHandle> sortFiles(FileHandle[] files, Comparator<FileHandle> comparator) {
        return FileUtils.sortFiles(files, comparator, false);
    }

    public static Array<FileHandle> sortFiles(FileHandle[] files, Comparator<FileHandle> comparator, boolean descending) {
        Array<FileHandle> directoriesList = new Array<FileHandle>();
        Array<FileHandle> filesList = new Array<FileHandle>();
        for (FileHandle f : files) {
            if (f.isDirectory()) {
                directoriesList.add(f);
                continue;
            }
            filesList.add(f);
        }
        Sort sorter = new Sort();
        sorter.sort(directoriesList, comparator);
        sorter.sort(filesList, comparator);
        if (descending) {
            directoriesList.reverse();
            filesList.reverse();
        }
        directoriesList.addAll(filesList);
        return directoriesList;
    }

    public static boolean isValidFileName(String name) {
        try {
            if (OsUtils.isWindows()) {
                if (name.contains(">") || name.contains("<")) {
                    return false;
                }
                name = name.toLowerCase();
            }
            return new File(name).getCanonicalFile().getName().equals(name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static FileHandle toFileHandle(File file) {
        return Gdx.files.absolute(file.getAbsolutePath());
    }

    public static void showDirInExplorer(FileHandle dir) throws IOException {
        File dirToShow = dir.isDirectory() ? dir.file() : dir.parent().file();
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            try {
                desktopClass.getMethod("browseFileDirectory", File.class).invoke(desktop, dirToShow);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                if (e instanceof InvocationTargetException && !(e.getCause() instanceof UnsupportedOperationException)) {
                    throw e;
                }
                desktopClass.getMethod("open", File.class).invoke(desktop, dirToShow);
            }
        }
        catch (Exception e) {
            Gdx.app.log("VisUI", "Can't open file " + dirToShow.getPath(), e);
        }
    }
}

