/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTextArea;
import com.kotcrab.vis.ui.widget.VisTextField;

public class ScrollableTextArea
extends VisTextArea
implements Cullable {
    private Rectangle cullingArea;

    public ScrollableTextArea(String text) {
        super(text, "textArea");
    }

    public ScrollableTextArea(String text, String styleName) {
        super(text, styleName);
    }

    public ScrollableTextArea(String text, VisTextField.VisTextFieldStyle style) {
        super(text, style);
    }

    @Override
    protected InputListener createInputListener() {
        return new ScrollTextAreaListener();
    }

    @Override
    protected void setParent(Group parent) {
        super.setParent(parent);
        if (parent instanceof ScrollPane) {
            this.calculateOffsets();
        }
    }

    private void updateScrollPosition() {
        if (this.cullingArea == null || !(this.getParent() instanceof ScrollPane)) {
            return;
        }
        ScrollPane scrollPane = (ScrollPane)this.getParent();
        if (!this.cullingArea.contains(this.getCursorX(), this.cullingArea.y)) {
            scrollPane.setScrollPercentX(this.getCursorX() / this.getWidth());
        }
        if (!this.cullingArea.contains(this.cullingArea.x, this.getHeight() - this.getCursorY())) {
            scrollPane.setScrollPercentY(this.getCursorY() / this.getHeight());
        }
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    public ScrollPane createCompatibleScrollPane() {
        VisScrollPane scrollPane = new VisScrollPane((Actor)this);
        scrollPane.setOverscroll(false, false);
        scrollPane.setFlickScroll(false);
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollbarsOnTop(true);
        scrollPane.setScrollingDisabled(true, false);
        return scrollPane;
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.linesShowing = 1000000000;
    }

    @Override
    public float getPrefHeight() {
        return (float)this.getLines() * this.style.font.getLineHeight();
    }

    @Override
    public void setText(String str) {
        super.setText(str);
        if (!this.programmaticChangeEvents) {
            this.updateScrollLayout();
        }
    }

    @Override
    boolean changeText(String oldText, String newText) {
        boolean changed = super.changeText(oldText, newText);
        this.updateScrollLayout();
        return changed;
    }

    void updateScrollLayout() {
        this.invalidateHierarchy();
        this.layout();
        if (this.getParent() instanceof ScrollPane) {
            ((ScrollPane)this.getParent()).layout();
        }
        this.updateScrollPosition();
    }

    public class ScrollTextAreaListener
    extends VisTextArea.TextAreaListener {
        public ScrollTextAreaListener() {
            super(ScrollableTextArea.this);
        }

        @Override
        public boolean keyDown(InputEvent event, int keycode) {
            ScrollableTextArea.this.updateScrollPosition();
            return super.keyDown(event, keycode);
        }

        @Override
        public boolean keyTyped(InputEvent event, char character) {
            ScrollableTextArea.this.updateScrollPosition();
            return super.keyTyped(event, character);
        }
    }
}

