/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.util.highlight.BaseHighlighter;
import com.kotcrab.vis.ui.util.highlight.Highlight;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisTextField;

public class HighlightTextArea
extends ScrollableTextArea {
    private Array<Highlight> highlights = new Array();
    private Array<Chunk> renderChunks = new Array();
    private boolean chunkUpdateScheduled = true;
    private Color defaultColor = Color.WHITE;
    private BaseHighlighter highlighter;
    private float maxAreaWidth = 0.0f;
    private float maxAreaHeight = 0.0f;

    public HighlightTextArea(String text) {
        super(text);
        this.init();
    }

    public HighlightTextArea(String text, String styleName) {
        super(text, styleName);
        this.init();
    }

    public HighlightTextArea(String text, VisTextField.VisTextFieldStyle style) {
        super(text, style);
        this.init();
    }

    private void init() {
        this.softwrap = false;
    }

    @Override
    void updateDisplayText() {
        super.updateDisplayText();
        this.processHighlighter();
    }

    @Override
    protected void calculateOffsets() {
        super.calculateOffsets();
        if (!this.chunkUpdateScheduled) {
            return;
        }
        this.chunkUpdateScheduled = false;
        this.highlights.sort();
        this.renderChunks.clear();
        String text = this.getText();
        Pool<GlyphLayout> layoutPool = Pools.get(GlyphLayout.class);
        GlyphLayout layout = layoutPool.obtain();
        boolean carryHighlight = false;
        int highlightIdx = 0;
        for (int lineIdx = 0; lineIdx < this.linesBreak.size; lineIdx += 2) {
            Highlight highlight;
            int lineStart = this.linesBreak.items[lineIdx];
            int lineEnd = this.linesBreak.items[lineIdx + 1];
            int lineProgress = lineStart;
            float chunkOffset = 0.0f;
            while (highlightIdx < this.highlights.size && (highlight = this.highlights.get(highlightIdx)).getStart() <= lineEnd) {
                if (highlight.getStart() == lineProgress || carryHighlight) {
                    this.renderChunks.add(new Chunk(text.substring(lineProgress, Math.min(highlight.getEnd(), lineEnd)), highlight.getColor(), chunkOffset, lineIdx));
                    lineProgress = Math.min(highlight.getEnd(), lineEnd);
                    if (highlight.getEnd() > lineEnd) {
                        carryHighlight = true;
                    } else {
                        carryHighlight = false;
                        ++highlightIdx;
                    }
                } else {
                    boolean noMatch = false;
                    while (highlight.getStart() <= lineProgress) {
                        if (++highlightIdx >= this.highlights.size) {
                            noMatch = true;
                            break;
                        }
                        highlight = this.highlights.get(highlightIdx);
                        if (highlight.getStart() <= lineEnd) continue;
                        noMatch = true;
                        break;
                    }
                    if (noMatch) break;
                    this.renderChunks.add(new Chunk(text.substring(lineProgress, highlight.getStart()), this.defaultColor, chunkOffset, lineIdx));
                    lineProgress = highlight.getStart();
                }
                Chunk chunk = this.renderChunks.peek();
                layout.setText(this.style.font, chunk.text);
                chunkOffset += layout.width;
                if (!carryHighlight) continue;
                break;
            }
            if (lineProgress >= lineEnd) continue;
            this.renderChunks.add(new Chunk(text.substring(lineProgress, lineEnd), this.defaultColor, chunkOffset, lineIdx));
        }
        this.maxAreaWidth = 0.0f;
        for (String line : text.split("\\n")) {
            layout.setText(this.style.font, line);
            this.maxAreaWidth = Math.max(this.maxAreaWidth, layout.width + 30.0f);
        }
        layoutPool.free(layout);
        this.updateScrollLayout();
    }

    @Override
    protected void drawText(Batch batch, BitmapFont font, float x, float y) {
        this.maxAreaHeight = 0.0f;
        float offsetY = 0.0f;
        float parentAlpha = font.getColor().a;
        for (int i = this.firstLineShowing * 2; i < (this.firstLineShowing + this.linesShowing) * 2 && i < this.linesBreak.size; i += 2) {
            for (Chunk chunk : this.renderChunks) {
                if (chunk.lineIndex != i) continue;
                font.setColor(chunk.color);
                font.getColor().a *= parentAlpha;
                font.draw(batch, chunk.text, x + chunk.offsetX, y + offsetY);
            }
            offsetY -= font.getLineHeight();
            this.maxAreaHeight += font.getLineHeight();
        }
        this.maxAreaHeight += 30.0f;
    }

    public void processHighlighter() {
        if (this.highlights == null) {
            return;
        }
        this.highlights.clear();
        if (this.highlighter != null) {
            this.highlighter.process(this, this.highlights);
        }
        this.chunkUpdateScheduled = true;
    }

    public void setHighlighter(BaseHighlighter highlighter) {
        this.highlighter = highlighter;
        this.processHighlighter();
    }

    public BaseHighlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public float getPrefWidth() {
        return this.maxAreaWidth + 5.0f;
    }

    @Override
    public float getPrefHeight() {
        return this.maxAreaHeight + 5.0f;
    }

    @Override
    public ScrollPane createCompatibleScrollPane() {
        ScrollPane scrollPane = super.createCompatibleScrollPane();
        scrollPane.setScrollingDisabled(false, false);
        return scrollPane;
    }

    private static class Chunk {
        String text;
        Color color;
        float offsetX;
        int lineIndex;

        public Chunk(String text, Color color, float offsetX, int lineIndex) {
            this.text = text;
            this.color = color;
            this.offsetX = offsetX;
            this.lineIndex = lineIndex;
        }
    }
}

