/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.kotcrab.vis.ui.layout.DragPane;
import java.util.Iterator;

public class Draggable
extends InputListener {
    private static final Vector2 MIMIC_COORDINATES = new Vector2();
    private static final Vector2 STAGE_COORDINATES = new Vector2();
    public static float DEFAULT_FADING_TIME = 0.1f;
    public static float DEFAULT_MOVING_TIME = 0.1f;
    public static boolean INVISIBLE_ON_DRAG = false;
    public static boolean KEEP_WITHIN_PARENT = false;
    public static float DEFAULT_ALPHA = 1.0f;
    public static DragListener DEFAULT_LISTENER = new DragPane.DefaultDragListener();
    public static boolean BLOCK_INPUT = true;
    private static final Actor BLOCKER = new Actor();
    private DragListener listener;
    private boolean blockInput = BLOCK_INPUT;
    private boolean invisibleWhenDragged = INVISIBLE_ON_DRAG;
    private boolean keepWithinParent = KEEP_WITHIN_PARENT;
    private float deadzoneRadius;
    private float fadingTime = DEFAULT_FADING_TIME;
    private float movingTime = DEFAULT_FADING_TIME;
    private float alpha = DEFAULT_ALPHA;
    private Interpolation fadingInterpolation = Interpolation.fade;
    private Interpolation movingInterpolation = Interpolation.sineOut;
    private final MimicActor mimic = new MimicActor();
    private float dragStartX;
    private float dragStartY;
    private float offsetX;
    private float offsetY;

    public Draggable() {
        this(DEFAULT_LISTENER);
    }

    public Draggable(DragListener listener) {
        this.listener = listener;
        this.mimic.setTouchable(Touchable.disabled);
    }

    public void attachTo(Actor actor) {
        Iterator listeners = actor.getListeners().iterator();
        while (listeners.hasNext()) {
            EventListener listener = (EventListener)listeners.next();
            if (!(listener instanceof Draggable)) continue;
            listeners.remove();
        }
        actor.addListener(this);
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean isBlockingInput() {
        return this.blockInput;
    }

    public void setBlockInput(boolean blockInput) {
        this.blockInput = blockInput;
    }

    public boolean isInvisibleWhenDragged() {
        return this.invisibleWhenDragged;
    }

    public void setInvisibleWhenDragged(boolean invisibleWhenDragged) {
        this.invisibleWhenDragged = invisibleWhenDragged;
    }

    public boolean isKeptWithinParent() {
        return this.keepWithinParent;
    }

    public void setKeepWithinParent(boolean keepWithinParent) {
        this.keepWithinParent = keepWithinParent;
    }

    public float getDeadzoneRadius() {
        return this.deadzoneRadius;
    }

    public void setDeadzoneRadius(float deadzoneRadius) {
        this.deadzoneRadius = deadzoneRadius;
    }

    public float getFadingTime() {
        return this.fadingTime;
    }

    public void setFadingTime(float fadingTime) {
        this.fadingTime = fadingTime;
    }

    public float getMovingTime() {
        return this.movingTime;
    }

    public void setMovingTime(float movingTime) {
        this.movingTime = movingTime;
    }

    public void setMovingInterpolation(Interpolation movingInterpolation) {
        this.movingInterpolation = movingInterpolation;
    }

    public void setFadingInterpolation(Interpolation fadingInterpolation) {
        this.fadingInterpolation = fadingInterpolation;
    }

    public void setListener(DragListener listener) {
        this.listener = listener;
    }

    public DragListener getListener() {
        return this.listener;
    }

    @Override
    public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
        Actor actor = event.getListenerActor();
        if (!this.isValid(actor) || this.isDisabled(actor)) {
            return false;
        }
        if (this.listener == null || this.listener.onStart(this, actor, event.getStageX(), event.getStageY())) {
            this.attachMimic(actor, event, x, y);
            return true;
        }
        return false;
    }

    protected boolean isValid(Actor actor) {
        return actor != null && actor.getStage() != null;
    }

    protected boolean isDisabled(Actor actor) {
        return actor instanceof Disableable && ((Disableable)((Object)actor)).isDisabled();
    }

    protected void attachMimic(Actor actor, InputEvent event, float x, float y) {
        this.mimic.clearActions();
        this.mimic.getColor().a = this.alpha;
        this.mimic.setActor(actor);
        this.offsetX = -x;
        this.offsetY = -y;
        this.getStageCoordinates(event);
        this.dragStartX = Draggable.MIMIC_COORDINATES.x;
        this.dragStartY = Draggable.MIMIC_COORDINATES.y;
        this.mimic.setPosition(this.dragStartX, this.dragStartY);
        actor.getStage().addActor(this.mimic);
        this.mimic.toFront();
        actor.setVisible(!this.invisibleWhenDragged);
        if (this.blockInput) {
            Draggable.addBlocker(actor.getStage());
        }
    }

    protected static void addBlocker(Stage stage) {
        stage.addActor(BLOCKER);
        BLOCKER.setBounds(0.0f, 0.0f, stage.getWidth(), stage.getHeight());
        BLOCKER.toFront();
    }

    protected static void removeBlocker() {
        BLOCKER.remove();
    }

    protected void getStageCoordinates(InputEvent event) {
        if (this.keepWithinParent) {
            this.getStageCoordinatesWithinParent(event);
        } else if (this.deadzoneRadius > 0.0f) {
            this.getStageCoordinatesWithDeadzone(event);
        } else {
            this.getStageCoordinatesWithOffset(event);
        }
    }

    private void getStageCoordinatesWithDeadzone(InputEvent event) {
        Group parent = this.mimic.getActor().getParent();
        if (parent != null) {
            MIMIC_COORDINATES.set(Vector2.Zero);
            parent.localToStageCoordinates(MIMIC_COORDINATES);
            float parentX = Draggable.MIMIC_COORDINATES.x;
            float parentY = Draggable.MIMIC_COORDINATES.y;
            float parentEndX = parentX + parent.getWidth();
            float parentEndY = parentY + parent.getHeight();
            if (this.isWithinDeadzone(event, parentX, parentY, parentEndX, parentEndY)) {
                MIMIC_COORDINATES.set(event.getStageX() + this.offsetX, event.getStageY() + this.offsetY);
                if (Draggable.MIMIC_COORDINATES.x < parentX) {
                    Draggable.MIMIC_COORDINATES.x = parentX;
                } else if (Draggable.MIMIC_COORDINATES.x + this.mimic.getWidth() > parentEndX) {
                    Draggable.MIMIC_COORDINATES.x = parentEndX - this.mimic.getWidth();
                }
                if (Draggable.MIMIC_COORDINATES.y < parentY) {
                    Draggable.MIMIC_COORDINATES.y = parentY;
                } else if (Draggable.MIMIC_COORDINATES.y + this.mimic.getHeight() > parentEndY) {
                    Draggable.MIMIC_COORDINATES.y = parentEndY - this.mimic.getHeight();
                }
                STAGE_COORDINATES.set(MathUtils.clamp(event.getStageX(), parentX, parentEndX - 1.0f), MathUtils.clamp(event.getStageY(), parentY, parentEndY - 1.0f));
            } else {
                this.getStageCoordinatesWithOffset(event);
            }
        } else {
            this.getStageCoordinatesWithOffset(event);
        }
    }

    private boolean isWithinDeadzone(InputEvent event, float parentX, float parentY, float parentEndX, float parentEndY) {
        return parentX - this.deadzoneRadius <= event.getStageX() && parentEndX + this.deadzoneRadius >= event.getStageX() && parentY - this.deadzoneRadius <= event.getStageY() && parentEndY + this.deadzoneRadius >= event.getStageY();
    }

    private void getStageCoordinatesWithinParent(InputEvent event) {
        Group parent = this.mimic.getActor().getParent();
        if (parent != null) {
            MIMIC_COORDINATES.set(Vector2.Zero);
            parent.localToStageCoordinates(MIMIC_COORDINATES);
            float parentX = Draggable.MIMIC_COORDINATES.x;
            float parentY = Draggable.MIMIC_COORDINATES.y;
            float parentEndX = parentX + parent.getWidth();
            float parentEndY = parentY + parent.getHeight();
            MIMIC_COORDINATES.set(event.getStageX() + this.offsetX, event.getStageY() + this.offsetY);
            if (Draggable.MIMIC_COORDINATES.x < parentX) {
                Draggable.MIMIC_COORDINATES.x = parentX;
            } else if (Draggable.MIMIC_COORDINATES.x + this.mimic.getWidth() > parentEndX) {
                Draggable.MIMIC_COORDINATES.x = parentEndX - this.mimic.getWidth();
            }
            if (Draggable.MIMIC_COORDINATES.y < parentY) {
                Draggable.MIMIC_COORDINATES.y = parentY;
            } else if (Draggable.MIMIC_COORDINATES.y + this.mimic.getHeight() > parentEndY) {
                Draggable.MIMIC_COORDINATES.y = parentEndY - this.mimic.getHeight();
            }
            STAGE_COORDINATES.set(MathUtils.clamp(event.getStageX(), parentX, parentEndX - 1.0f), MathUtils.clamp(event.getStageY(), parentY, parentEndY - 1.0f));
        } else {
            this.getStageCoordinatesWithOffset(event);
        }
    }

    private void getStageCoordinatesWithOffset(InputEvent event) {
        MIMIC_COORDINATES.set(event.getStageX() + this.offsetX, event.getStageY() + this.offsetY);
        STAGE_COORDINATES.set(event.getStageX(), event.getStageY());
    }

    @Override
    public void touchDragged(InputEvent event, float x, float y, int pointer) {
        if (this.isDragged()) {
            this.getStageCoordinates(event);
            this.mimic.setPosition(Draggable.MIMIC_COORDINATES.x, Draggable.MIMIC_COORDINATES.y);
            if (this.listener != null) {
                this.listener.onDrag(this, this.mimic.getActor(), Draggable.STAGE_COORDINATES.x, Draggable.STAGE_COORDINATES.y);
            }
        }
    }

    @Override
    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
        if (this.isDragged()) {
            Draggable.removeBlocker();
            this.getStageCoordinates(event);
            this.mimic.setPosition(Draggable.MIMIC_COORDINATES.x, Draggable.MIMIC_COORDINATES.y);
            if (this.listener == null || this.mimic.getActor().getStage() != null && this.listener.onEnd(this, this.mimic.getActor(), Draggable.STAGE_COORDINATES.x, Draggable.STAGE_COORDINATES.y)) {
                this.addMimicHidingAction(Actions.fadeOut(this.fadingTime, this.fadingInterpolation), this.fadingTime);
            } else {
                this.addMimicHidingAction(Actions.moveTo(this.dragStartX, this.dragStartY, this.movingTime, this.movingInterpolation), this.movingTime);
            }
        }
    }

    public boolean isDragged() {
        return this.mimic.getActor() != null;
    }

    protected void addMimicHidingAction(Action hidingAction, float delay) {
        this.mimic.addAction(Actions.sequence(hidingAction, (Action)Actions.removeActor()));
        this.mimic.getActor().addAction(Actions.delay(delay, Actions.visible(true)));
    }

    static {
        BLOCKER.addListener(new InputListener(){

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                return true;
            }

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                return true;
            }
        });
    }

    public static class MimicActor
    extends Actor {
        private static final Vector2 LAST_POSITION = new Vector2();
        private Actor actor;

        public MimicActor() {
        }

        public MimicActor(Actor actor) {
            this.actor = actor;
        }

        @Override
        public boolean remove() {
            this.actor = null;
            return super.remove();
        }

        public Actor getActor() {
            return this.actor;
        }

        public void setActor(Actor actor) {
            this.actor = actor;
        }

        @Override
        public float getWidth() {
            return this.actor == null ? 0.0f : this.actor.getWidth();
        }

        @Override
        public float getHeight() {
            return this.actor == null ? 0.0f : this.actor.getHeight();
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            if (this.actor != null) {
                LAST_POSITION.set(this.actor.getX(), this.actor.getY());
                this.actor.setPosition(this.getX(), this.getY());
                this.actor.draw(batch, this.getColor().a * parentAlpha);
                this.actor.setPosition(MimicActor.LAST_POSITION.x, MimicActor.LAST_POSITION.y);
            }
        }
    }

    public static class DragAdapter
    implements DragListener {
        @Override
        public boolean onStart(Draggable draggable, Actor actor, float stageX, float stageY) {
            return true;
        }

        @Override
        public void onDrag(Draggable draggable, Actor actor, float stageX, float stageY) {
        }

        @Override
        public boolean onEnd(Draggable draggable, Actor actor, float stageX, float stageY) {
            return true;
        }
    }

    public static interface DragListener {
        public static final boolean CANCEL = false;
        public static final boolean APPROVE = true;

        public boolean onStart(Draggable var1, Actor var2, float var3, float var4);

        public void onDrag(Draggable var1, Actor var2, float var3, float var4);

        public boolean onEnd(Draggable var1, Actor var2, float var3, float var4);
    }
}

