/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.adapter;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.util.adapter.ItemAdapter;

public abstract class CachedItemAdapter<ItemT, ViewT extends Actor>
implements ItemAdapter<ItemT> {
    private ObjectMap<ItemT, ViewT> views = new ObjectMap();

    public final ViewT getView(ItemT item) {
        Actor view = (Actor)this.views.get(item);
        if (view == null) {
            view = this.createView(item);
            if (view == null) {
                throw new IllegalStateException("Returned view view can't be null");
            }
            this.views.put(item, view);
        } else {
            this.updateView(view, item);
        }
        return (ViewT)view;
    }

    protected ObjectMap<ItemT, ViewT> getViews() {
        return this.views;
    }

    protected abstract ViewT createView(ItemT var1);

    protected abstract void updateView(ViewT var1, ItemT var2);
}

