/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

@Deprecated
public class VerticalFlowGroup
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float lastPrefHeight;
    private boolean sizeInvalid = true;
    private float spacing = 0.0f;

    public VerticalFlowGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public VerticalFlowGroup(float spacing) {
        this.spacing = spacing;
        this.setTouchable(Touchable.childrenOnly);
    }

    private void computeSize() {
        this.prefWidth = 0.0f;
        this.prefHeight = this.getHeight();
        this.sizeInvalid = false;
        SnapshotArray<Actor> children = this.getChildren();
        float y = 0.0f;
        float columnWidth = 0.0f;
        for (int i = 0; i < children.size; ++i) {
            Actor child = (Actor)children.get(i);
            float width = child.getWidth();
            float height = child.getHeight();
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            }
            if (y + height > this.getHeight()) {
                y = 0.0f;
                this.prefWidth += columnWidth + this.spacing;
                columnWidth = width;
            } else {
                columnWidth = Math.max(width, columnWidth);
            }
            y += height + this.spacing;
        }
        this.prefWidth += columnWidth + this.spacing;
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
            if (this.lastPrefHeight != this.prefHeight) {
                this.lastPrefHeight = this.prefHeight;
                this.invalidateHierarchy();
            }
        }
        SnapshotArray<Actor> children = this.getChildren();
        float x = 0.0f;
        float y = this.getHeight();
        float columnWidth = 0.0f;
        for (int i = 0; i < children.size; ++i) {
            Actor child = (Actor)children.get(i);
            float width = child.getWidth();
            float height = child.getHeight();
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            }
            if (y - height < 0.0f) {
                y = this.getHeight();
                x += columnWidth + this.spacing;
                columnWidth = width;
            } else {
                columnWidth = Math.max(width, columnWidth);
            }
            child.setBounds(x, y - height, width, height);
            y -= height + this.spacing;
        }
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.invalidateHierarchy();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }
}

