/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.Main;
import com.torii.srs.widget.KanaConverter;

public class TextField
extends VisTextField {
    public static final float offset = Main.getPPUY() / 2;
    private String defaultText = "";
    private String renewFontStyleName;
    private boolean hasDefaultText = false;
    private boolean isCopyPasteMenuEnabled = true;
    private boolean isKanaMode = false;
    private Color fontColor;
    private Color defaultTextFontColor;
    private boolean typed = false;
    private int textAlign = 8;
    private char[] forbiddenChars = null;
    private boolean renewFontOnPaste = false;
    private int charLimit = -1;
    private char prevTypedChar = (char)32;

    public TextField() {
        this("", VisUI.getSkin().get(VisTextField.VisTextFieldStyle.class));
    }

    public TextField(String text) {
        this(text, VisUI.getSkin().get(VisTextField.VisTextFieldStyle.class));
    }

    public TextField(String text, String styleName) {
        this(text, VisUI.getSkin().get(styleName, VisTextField.VisTextFieldStyle.class));
    }

    public TextField(String text, final VisTextField.VisTextFieldStyle style) {
        super(text, style);
        this.removeListener(this.getDefaultInputListener());
        this.addListener(new asdf());
        this.fontColor = style == null ? Main.FONT : style.fontColor;
        this.defaultTextFontColor = Color.GRAY;
        final Timer.Task pasteTimer = new Timer.Task(){

            @Override
            public void run() {
                TextField.this.showMenu();
            }
        };
        this.addListener(new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pasteTimer.isScheduled()) {
                    pasteTimer.cancel();
                }
                if (TextField.this.isCopyPasteMenuEnabled) {
                    Timer.schedule(pasteTimer, 1.0f, 0.0f, 0);
                }
                if (TextField.this.hasDefaultText && TextField.this.getText().equals("")) {
                    TextField.this.setDefaultTextCursorPosition();
                }
                return true;
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (TextField.this.hasDefaultText && TextField.this.getText().equals("")) {
                    TextField.this.setDefaultTextCursorPosition();
                }
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pasteTimer.isScheduled()) {
                    pasteTimer.cancel();
                }
            }

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                if (!(character != '[' && character != ']' || TextField.this.prevTypedChar != '[' && TextField.this.prevTypedChar != ']')) {
                    TextField.this.removeLastInputChar();
                    return true;
                }
                if (TextField.this.charLimit != -1 && TextField.this.getText().length() > TextField.this.charLimit) {
                    TextField.this.removeLastInputChar();
                    return true;
                }
                if (TextField.this.forbiddenChars != null) {
                    for (int c = 0; c < TextField.this.forbiddenChars.length; ++c) {
                        if (TextField.this.forbiddenChars[c] != character) continue;
                        TextField.this.removeLastInputChar();
                    }
                }
                if (TextField.this.hasDefaultText && !TextField.this.typed) {
                    if (Character.isLetterOrDigit(character) || Character.isSpaceChar(character)) {
                        style.fontColor = TextField.this.fontColor;
                        TextField.this.setText("" + character);
                        TextField.this.setCursorAtTextEnd();
                        TextField.this.typed = true;
                    } else {
                        TextField.this.setText(TextField.this.defaultText);
                        TextField.this.setDefaultTextCursorPosition();
                    }
                }
                if (TextField.this.hasActions()) {
                    TextField.this.removeLastInputChar();
                } else if (TextField.this.isKanaMode && !TextField.this.getText().equals("")) {
                    KanaConverter.replaceWithKana(TextField.this);
                }
                TextField.this.prevTypedChar = character;
                return true;
            }

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                if (TextField.this.hasDefaultText && !TextField.this.typed && (keycode == 21 || keycode == 19 || keycode == 22 || keycode == 20)) {
                    TextField.this.setDefaultTextCursorPosition();
                }
                return true;
            }

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (TextField.this.isEmpty() && TextField.this.hasDefaultText) {
                    style.fontColor = TextField.this.defaultTextFontColor;
                    TextField.this.setText(TextField.this.defaultText);
                    TextField.this.setDefaultTextCursorPosition();
                    TextField.this.typed = false;
                }
                return true;
            }
        });
        this.addListener(new FocusListener(){

            @Override
            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (TextField.this.hasDefaultText) {
                    if (focused) {
                        if (TextField.this.getText().equals("")) {
                            TextField.this.setDefaultTextCursorPosition();
                        }
                    } else if (TextField.this.getText().trim().isEmpty()) {
                        style.fontColor = TextField.this.defaultTextFontColor;
                        TextField.this.setText(TextField.this.defaultText);
                        TextField.this.typed = false;
                    }
                }
            }
        });
    }

    @Override
    public String getText() {
        String t = super.getText();
        if (this.hasDefaultText && t.equals(this.defaultText) && !this.typed) {
            t = "";
        }
        return t;
    }

    @Override
    public void clearText() {
        super.clearText();
        if (this.hasDefaultText) {
            this.getStyle().fontColor = this.defaultTextFontColor;
            this.setText(this.defaultText);
            this.setDefaultTextCursorPosition();
            this.typed = false;
        }
    }

    @Override
    protected int letterUnderCursor(float x) {
        return super.letterUnderCursor(x - offset);
    }

    @Override
    public void setAlignment(int alignment) {
        super.setAlignment(alignment);
        this.textAlign = alignment;
    }

    @Override
    public void cut() {
        if (this.getSelection().length() > 0 && !this.isPasswordMode() && !this.getText().equals("")) {
            this.copy();
            String currentContent = this.getText();
            int cursorPos = this.getCursorPosition();
            int indexOfSelectionStart = this.getSelectionStart();
            int indexOfSelectionBegin = cursorPos > this.selectionStart ? indexOfSelectionStart : cursorPos;
            String beforePaste = currentContent.substring(0, indexOfSelectionBegin);
            String afterPaste = currentContent.substring(indexOfSelectionBegin + this.getSelection().length());
            this.setText(beforePaste + afterPaste);
            this.setCursorPosition(indexOfSelectionBegin);
        }
    }

    public void setCopyPasteMenu(boolean enabled) {
        this.isCopyPasteMenuEnabled = enabled;
    }

    public void setKanaMode(boolean enabled) {
        this.isKanaMode = enabled;
    }

    public void setCharacterLimit(int size) {
        this.charLimit = size;
    }

    public void setForbiddenCharacters(char[] chars) {
        this.forbiddenChars = chars;
    }

    public void setDefaultText(String text) {
        if (text.trim().equals("")) {
            if (this.hasDefaultText && this.getText().equals("")) {
                this.getStyle().fontColor = this.fontColor;
                this.setText("");
            }
            this.defaultText = "";
            this.hasDefaultText = false;
        } else {
            this.defaultText = text;
            this.hasDefaultText = true;
            if (this.isEmpty()) {
                this.getStyle().fontColor = this.defaultTextFontColor;
                this.setText(this.defaultText);
            }
        }
    }

    public void requestFocus() {
        FocusManager.switchFocus(this.getStage(), this);
        this.getStage().setKeyboardFocus(this);
        this.getOnscreenKeyboard().show(true);
    }

    public void setRenewFontOnPaste(boolean enabled, String styleName) {
        this.renewFontOnPaste = enabled;
        this.renewFontStyleName = styleName;
    }

    private void setDefaultTextCursorPosition() {
        if (this.textAlign == 8) {
            this.setCursorPosition(0);
        } else if (this.textAlign == 16) {
            this.setCursorAtTextEnd();
        } else if (this.textAlign == 1) {
            this.setCursorPosition(this.defaultText.length() / 2);
        }
    }

    private void removeLastInputChar() {
        String content = this.getText();
        int contentLength = content.length();
        if (contentLength >= 1) {
            int cursorPos = this.getCursorPosition();
            this.setText(content.substring(0, cursorPos - 1) + content.substring(cursorPos));
            this.setCursorPosition(cursorPos - 1);
        }
    }

    private void showMenu() {
        Gdx.input.setOnscreenKeyboardVisible(false);
        PopupMenu menu = new PopupMenu();
        MenuItem selectAll = new MenuItem("Select all", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                TextField.this.selectAll();
                TextField.this.showMenu();
            }
        });
        MenuItem copy = new MenuItem("Copy", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                TextField.this.copy();
            }
        });
        MenuItem paste = new MenuItem("Paste", new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                TextField.this.paste();
            }
        });
        if (this.getSelection().length() != 0) {
            if (!this.getSelection().equals(this.getText())) {
                menu.addItem(selectAll);
                menu.addSeparator();
            }
            menu.addItem(copy);
            menu.addSeparator();
            menu.addItem(paste);
        } else {
            if (this.getText().length() != 0) {
                menu.addItem(selectAll);
                menu.addSeparator();
            }
            menu.addItem(paste);
        }
        menu.showMenu(this.getStage(), this);
    }

    @Override
    public void copy() {
        Gdx.app.getClipboard().setContents(this.getSelection());
    }

    public void paste() {
        this.paste(null);
    }

    public void paste(String content) {
        String clipboardContent;
        int cursorPos = this.getCursorPosition();
        String currentContent = this.getText();
        String string = clipboardContent = content == null ? Gdx.app.getClipboard().getContents() : content;
        if (this.renewFontOnPaste) {
            String kana = "";
            if (this.isKanaMode) {
                kana = Main.getKanaChars();
            }
            Main.disposeAsset(this.renewFontStyleName, true);
            Main.loadTTFtoAssetManager(this.renewFontStyleName, Main.getPPUY(), clipboardContent + this.getText() + this.defaultText + kana, false);
            Main.finishLoadingAsset(this.renewFontStyleName, true);
            this.getStyle().font = (BitmapFont)Main.getAsset(this.renewFontStyleName, BitmapFont.class, true);
        }
        if (this.hasDefaultText && !this.typed) {
            this.getStyle().fontColor = this.fontColor;
            this.setText("");
            this.typed = true;
        }
        if (this.getSelection().length() == 0) {
            String beforePaste = currentContent.substring(0, cursorPos);
            String afterPaste = currentContent.substring(cursorPos);
            this.setText(beforePaste + clipboardContent + afterPaste);
            this.setCursorPosition(cursorPos + clipboardContent.length());
        } else {
            int indexOfSelectionStart = this.getSelectionStart();
            int indexOfSelectionBegin = cursorPos > this.selectionStart ? indexOfSelectionStart : cursorPos;
            String beforePaste = currentContent.substring(0, indexOfSelectionBegin);
            String afterPaste = currentContent.substring(indexOfSelectionBegin);
            afterPaste = afterPaste.replaceFirst(this.getSelection(), clipboardContent);
            this.setText(beforePaste + afterPaste);
            this.setCursorPosition(indexOfSelectionBegin + clipboardContent.length());
        }
        if (this.forbiddenChars != null) {
            String cont = this.getText();
            for (int c = 0; c < this.forbiddenChars.length; ++c) {
                cont = cont.replace("" + this.forbiddenChars[c], "");
            }
            this.setText(cont);
        }
        if (this.charLimit != -1 && this.getText().length() > this.charLimit) {
            this.setText(this.getText().substring(0, this.charLimit));
            this.setCursorAtTextEnd();
        }
        if (this.isEmpty()) {
            this.clearText();
        }
        this.fire(new ChangeListener.ChangeEvent());
    }

    public class asdf
    extends VisTextField.TextFieldClickListener {
        public asdf() {
            super(TextField.this);
        }

        @Override
        public boolean keyDown(InputEvent event, int keycode) {
            boolean repeat;
            block24: {
                boolean jump;
                block19: {
                    int temp;
                    block21: {
                        block23: {
                            block22: {
                                block20: {
                                    if (TextField.this.isDisabled()) {
                                        return false;
                                    }
                                    Stage stage = TextField.this.getStage();
                                    if (stage == null || stage.getKeyboardFocus() != TextField.this) {
                                        return false;
                                    }
                                    if (!TextField.this.isFocusBorderEnabled()) {
                                        return false;
                                    }
                                    repeat = false;
                                    boolean ctrl = UIUtils.ctrl();
                                    boolean bl = jump = ctrl && !TextField.this.isPasswordMode();
                                    if (ctrl) {
                                        if (keycode == 50 && !TextField.this.isReadOnly()) {
                                            TextField.this.paste();
                                        }
                                        if (keycode == 31 || keycode == 124) {
                                            TextField.this.copy();
                                            return true;
                                        }
                                        if (keycode == 52 && !TextField.this.isReadOnly()) {
                                            TextField.this.cut();
                                            return true;
                                        }
                                        if (keycode == 29) {
                                            TextField.this.selectAll();
                                            return true;
                                        }
                                        if (keycode != 54 || !TextField.this.isReadOnly()) {
                                            // empty if block
                                        }
                                    }
                                    if (!UIUtils.shift()) break block19;
                                    if (keycode == 124 && !TextField.this.isReadOnly()) {
                                        TextField.this.paste();
                                    }
                                    if (keycode == 112 && !TextField.this.isReadOnly()) {
                                        TextField.this.cut();
                                    }
                                    temp = TextField.this.cursor;
                                    if (keycode != 21) break block20;
                                    TextField.this.moveCursor(false, jump);
                                    repeat = true;
                                    break block21;
                                }
                                if (keycode != 22) break block22;
                                TextField.this.moveCursor(true, jump);
                                repeat = true;
                                break block21;
                            }
                            if (keycode != 3) break block23;
                            this.goHome(jump);
                            break block21;
                        }
                        if (keycode != 123) break block24;
                        this.goEnd(jump);
                    }
                    if (!TextField.this.hasSelection) {
                        TextField.this.selectionStart = temp;
                        TextField.this.hasSelection = true;
                    }
                    break block24;
                }
                if (keycode == 21) {
                    TextField.this.moveCursor(false, jump);
                    TextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == 22) {
                    TextField.this.moveCursor(true, jump);
                    TextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == 3) {
                    this.goHome(jump);
                    TextField.this.clearSelection();
                }
                if (keycode == 123) {
                    this.goEnd(jump);
                    TextField.this.clearSelection();
                }
            }
            TextField.this.cursor = MathUtils.clamp(TextField.this.cursor, 0, TextField.this.text.length());
            if (repeat) {
                this.scheduleKeyRepeatTask(keycode);
            }
            return true;
        }
    }
}

