/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CollapsibleWidget
extends WidgetGroup {
    public static final float ANIM_DUR_DEFAULT = 1.0f;
    public static final float ANIM_DUR_DOUBLE = 2.0f;
    public static final float ANIM_DUR_TRIPLE = 3.0f;
    public static final float ANIM_DUR_HALVE = 0.5f;
    private Table table;
    private CollapseAction collapseAction = new CollapseAction();
    private float speed = 1.0f;
    private boolean collapsed;
    private boolean actionRunning;
    private float currentHeight;

    public CollapsibleWidget() {
    }

    public CollapsibleWidget(Table table) {
        this(table, false);
    }

    public CollapsibleWidget(Table table, boolean collapsed) {
        this.collapsed = collapsed;
        this.table = table;
        this.updateTouchable();
        if (table != null) {
            this.addActor(table);
        }
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.updateTouchable();
        if (this.table == null) {
            return;
        }
        this.actionRunning = true;
        if (withAnimation) {
            this.addAction(this.collapseAction);
        } else {
            if (collapse) {
                this.currentHeight = 0.0f;
                this.collapsed = true;
            } else {
                this.currentHeight = this.table.getPrefHeight();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    public void setFadeDuration(float duration) {
        this.speed = Gdx.graphics.getHeight() > 1000 && Gdx.graphics.getHeight() < 1500 ? duration * 2.0f : (Gdx.graphics.getHeight() > 1500 ? duration * 3.0f : duration);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private void updateTouchable() {
        if (this.collapsed) {
            this.setTouchable(Touchable.disabled);
        } else {
            this.setTouchable(Touchable.enabled);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentHeight > 1.0f) {
            batch.flush();
            boolean clipEnabled = this.clipBegin(this.getX(), this.getY(), this.getWidth(), this.currentHeight);
            super.draw(batch, parentAlpha);
            batch.flush();
            if (clipEnabled) {
                this.clipEnd();
            }
        }
    }

    @Override
    public void layout() {
        if (this.table == null) {
            return;
        }
        this.table.setBounds(0.0f, 0.0f, this.table.getPrefWidth(), this.table.getPrefHeight());
        if (!this.actionRunning) {
            this.currentHeight = this.collapsed ? 0.0f : this.table.getPrefHeight();
        }
    }

    @Override
    public float getPrefWidth() {
        return this.table == null ? 0.0f : this.table.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.table == null) {
            return 0.0f;
        }
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefHeight();
        }
        return this.currentHeight;
    }

    public void setTable(Table table) {
        this.table = table;
        this.clearChildren();
        this.addActor(table);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.getChildren().size > 1) {
            throw new GdxRuntimeException("Only one actor can be added to CollapsibleWidget");
        }
    }

    private class CollapseAction
    extends Action {
        private CollapseAction() {
        }

        @Override
        public boolean act(float delta) {
            if (CollapsibleWidget.this.collapsed) {
                CollapsibleWidget.this.currentHeight -= delta * 1000.0f * CollapsibleWidget.this.speed;
                if (CollapsibleWidget.this.currentHeight <= 0.0f) {
                    CollapsibleWidget.this.currentHeight = 0.0f;
                    CollapsibleWidget.this.collapsed = true;
                    CollapsibleWidget.this.actionRunning = false;
                }
            } else {
                CollapsibleWidget.this.currentHeight += delta * 1000.0f * CollapsibleWidget.this.speed;
                if (CollapsibleWidget.this.currentHeight > CollapsibleWidget.this.table.getPrefHeight()) {
                    CollapsibleWidget.this.currentHeight = CollapsibleWidget.this.table.getPrefHeight();
                    CollapsibleWidget.this.collapsed = false;
                    CollapsibleWidget.this.actionRunning = false;
                }
            }
            CollapsibleWidget.this.invalidateHierarchy();
            return !CollapsibleWidget.this.actionRunning;
        }
    }
}

