/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.util.ToastManager;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.Tooltip;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.toast.Toast;
import com.torii.srs.AudioHandler;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.FileManager;
import com.torii.srs.Hints;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.RestClient;
import com.torii.srs.SettingsScreen;
import com.torii.srs.StudyScreen;
import com.torii.srs.widget.CollapsibleWidget;
import com.torii.srs.widget.KanaConverter;
import com.torii.srs.widget.List;
import com.torii.srs.widget.TextField;
import com.torii.srs.widget.TopMenu;
import java.util.HashMap;
import java.util.Map;

public class ReviewScreen
implements Screen {
    private static final float UNDO_ARCHIVING_TIMEOUT = 5.0f;
    static ReviewScreen reviewScreen;
    private TopMenu topMenu;
    private PracticeScreen.PracticeListsTable plt;
    private final String kanjiFontName;
    private final String kanaFontName;
    private final String sentenceFontName;
    private final float kanjiFontSize;
    private final float kanaFontSize;
    private final Color COLOR_CORRECT;
    private final Color COLOR_WRONG;
    private final Color COLOR_IGNORE;
    private SpriteBatch batch;
    private ShapeRenderer renderer;
    private Texture tex;
    private Stage stage;
    private VisTable table;
    private VisTable tblVocab;
    private VisTable tblLabels;
    private VisTable tblButtons;
    private VisTable tblTabs;
    private VisTable tblTabbedPane;
    private VisTable tblDetails;
    private VisTable tblCustom;
    private VisTable tblCustomSynonyms;
    private VisTable tblCustomReadings;
    private VisLabel lVocabKanji;
    private VisLabel lVocabKana;
    private VisLabel lVocabEng;
    private VisLabel lSynonyms;
    private VisLabel lPartOfSpeechShort;
    private VisLabel lReviewInfo;
    private VisLabel lInputType;
    private VisLabel lCharCounter;
    private VisLabel lSentence;
    private VisLabel lSentenceMeaning;
    private VisLabel lPartOfSpeechFull;
    private VisLabel lJlptLevel;
    private LinkLabel llJisho;
    private LinkLabel llTatoeba;
    private TextField tfInput;
    private VisTextButton btnMeaning;
    private VisTextButton btnDetails;
    private VisTextButton btnCustom;
    private VisTextButton btnSynonymsAdd;
    private VisTextButton btnSynonymsRemove;
    private VisTextButton btnReadingsAdd;
    private VisTextButton btnReadingsRemove;
    private VisImageButton btnArchiveVocab;
    private VisImageButton btnPlus;
    private VisImageButton btnFlash;
    private VisImageButton btnFont;
    private VisImageButton btnKeybinds;
    private VisImageButton btnPlay;
    private VisImageButton btnNext;
    private VisImageButton btnIgnore;
    private VisImageButton btnSkip;
    private VisImageButton btnInfo;
    private VisImageButton.VisImageButtonStyle bsFlashFull;
    private VisImageButton.VisImageButtonStyle bsFlashEmpty;
    private VisImageButton.VisImageButtonStyle bsFontFull;
    private VisImageButton.VisImageButtonStyle bsFontEmpty;
    private Drawable dFlashFull;
    private Drawable dFlashEmpty;
    private Drawable dFontFull;
    private Drawable dFontEmpty;
    private ScrollableTextArea taNotes;
    private CollapsibleWidget collapsibleWidget;
    private Label.LabelStyle[] styleKanji;
    private Label.LabelStyle[] styleKana;
    private Label.LabelStyle sentenceStyle;
    private int practiceID;
    private int endlessPracticeReviewModeID;
    private int noOfReviews;
    private int reviewCounter;
    private int currentReviewId;
    private int answersGiven;
    private int reviewsAnsweredCorrectly;
    private int reviewsDone;
    private int lessonsDone;
    private String[] synonymsTemp;
    private String[] readingsTemp;
    private HashMap<Integer, Review> reviewsList;
    private List listSynonyms;
    private List listReadings;
    private String placeholder = "*";
    private boolean randomizeFont = false;
    private boolean hideKana = false;
    private boolean showKanaAfterAnswer = false;
    private boolean autoplayAudio = false;
    private boolean autoplayAudioSentence = false;
    private boolean isLightningModeEnabled = true;
    private boolean isHyperjumpModeEnabled = false;
    private boolean autoExpandDetailsAfterWrongAnswer = false;
    private boolean reviewSessionAutoContinue = true;
    private boolean reviewFullscreen = false;
    private boolean playAudioAtStart = false;
    private boolean playAudioAtEnd = false;
    private boolean playAudioOnWrongAnswer = false;
    private boolean isLessonMode;
    private boolean isLastAnswerCorrect;
    private boolean isAlternativeSolution;
    private boolean ignoreLastAnswer;
    private boolean skippedLastItem;
    private boolean archivedLastItem;
    private boolean drawLevelUpTexture = false;
    private boolean suppressVocabAudio = false;
    private float factor;
    private Timer.Task charCounterTimer;
    private Timer.Task suppressVocabAudioTimer;
    private ReviewModes reviewMode = ReviewModes.JP_TO_EN;
    private AudioModes audioMode = AudioModes.OFF;
    private AudioModes practiceAudioToEN;
    private AudioModes practiceAudioToJP;
    private Review currentReview;
    private Array<Integer> itemsBeingSynced;
    private boolean[] endlessPracticeIncludedSRSstages;
    private boolean userInputEnabled = true;
    private Animation<TextureRegion> animRed;
    private final int animRedWidth = 504;
    private final int animRedHeight = 428;
    private float deltaRed;

    ReviewScreen() {
        reviewScreen = this;
        this.itemsBeingSynced = new Array();
        this.animRed = Main.pngToAnimation((Texture)Main.getAsset(Main.RED_PATH, Texture.class, true), 504, 428, 0.5f);
        this.kanjiFontName = "-rev-kanji.ttf";
        this.kanaFontName = "-rev-kana.ttf";
        this.sentenceFontName = "rev-sentence.ttf";
        this.kanjiFontSize = 4 * Main.getPPUY();
        this.kanaFontSize = 2 * Main.getPPUY();
        this.COLOR_CORRECT = new Color(0.5411765f, 0.79607844f, 0.0f, 1.0f);
        this.COLOR_WRONG = Colors.get("CR");
        this.COLOR_IGNORE = Color.ORANGE;
        this.charCounterTimer = new Timer.Task(){

            @Override
            public void run() {
                ReviewScreen.this.lCharCounter.addAction(Actions.fadeOut(0.25f));
            }
        };
        this.suppressVocabAudioTimer = new Timer.Task(){

            @Override
            public void run() {
                ReviewScreen.this.suppressVocabAudio = true;
            }
        };
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.sentenceStyle = new Label.LabelStyle(new VisLabel().getStyle());
        this.buildUI();
    }

    private void buildUI() {
        this.table = new VisTable();
        this.tblVocab = new VisTable(true);
        this.tblLabels = new VisTable(true);
        this.tblButtons = new VisTable(true);
        this.tblTabs = new VisTable();
        this.tblTabbedPane = new VisTable();
        this.tblDetails = new VisTable(false);
        this.tblCustom = new VisTable(true);
        this.tblCustomSynonyms = new VisTable(true);
        this.tblCustomReadings = new VisTable(true);
        this.listSynonyms = new List("Synonyms");
        this.listReadings = new List("Readings");
        this.lVocabEng = new VisLabel((CharSequence)"", Main.labelStyleX2plus);
        this.lSynonyms = new VisLabel((CharSequence)"", Main.labelStyleX1);
        this.lPartOfSpeechShort = new VisLabel((CharSequence)"", Main.labelStyleX0p5_w);
        this.lReviewInfo = new VisLabel((CharSequence)"N/A", Main.labelStyleX1_w);
        this.lSentence = new VisLabel((CharSequence)"", this.sentenceStyle);
        this.lSentenceMeaning = new VisLabel((CharSequence)"X", Main.labelStyleX1);
        this.lPartOfSpeechFull = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        this.lJlptLevel = new VisLabel((CharSequence)"", Main.labelStyleX0p5);
        this.lInputType = new VisLabel((CharSequence)"", Main.labelStyleX1p25_w);
        this.lCharCounter = new VisLabel((CharSequence)("0/" + StudyScreen.getCharLimitNotes()), Main.labelStyleX1);
        this.llJisho = new LinkLabel("Jisho.org");
        this.llTatoeba = new LinkLabel("Tatoeba.org");
        this.taNotes = new ScrollableTextArea("", new VisTextField.VisTextFieldStyle(Main.taStyle));
        this.taNotes.getStyle().font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
        this.btnMeaning = new VisTextButton("Info", Main.btnStyleToggleWhite);
        this.btnDetails = new VisTextButton("Details", Main.btnStyleToggleWhite);
        this.btnCustom = new VisTextButton("Notes", Main.btnStyleToggleWhite);
        this.btnSynonymsAdd = new VisTextButton("+", Main.btnStyleX1);
        this.btnSynonymsRemove = new VisTextButton("-", Main.btnStyleX1);
        this.btnReadingsAdd = new VisTextButton("+", Main.btnStyleX1);
        this.btnReadingsRemove = new VisTextButton("-", Main.btnStyleX1);
        if (this.isLessonMode) {
            new Tooltip.Builder(" Lessons available \u2192 Lessons completed ").target(this.lReviewInfo).build();
        } else {
            new Tooltip.Builder(" Reviews available \u2192 Reviews completed ").target(this.lReviewInfo).build();
        }
        Drawable btnUp = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnOver = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDown = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDisabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Image imgArchive = new Image((Texture)Main.getAsset(Main.ARCHIVE_BTN_PATH, Texture.class, true));
        Drawable archive = imgArchive.getDrawable();
        this.btnArchiveVocab = new VisImageButton(archive, " Archive ");
        this.btnArchiveVocab.getStyle().up = btnUp;
        this.btnArchiveVocab.getStyle().over = btnOver;
        this.btnArchiveVocab.getStyle().down = btnDown;
        this.btnArchiveVocab.getStyle().disabled = btnDisabled;
        this.btnArchiveVocab.getStyle().imageUp = Main.uiSkin.newDrawable(archive, Color.WHITE);
        this.btnArchiveVocab.getStyle().imageDown = Main.uiSkin.newDrawable(archive, Main.OBJECT_PRESSED);
        this.btnArchiveVocab.getStyle().imageDisabled = Main.uiSkin.newDrawable(archive, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgPlus = new Image((Texture)Main.getAsset(Main.PLUS_BTN_PATH, Texture.class, true));
        Drawable plus = imgPlus.getDrawable();
        this.btnPlus = new VisImageButton(plus, " Add to List ");
        this.btnPlus.getStyle().up = btnUp;
        this.btnPlus.getStyle().over = btnOver;
        this.btnPlus.getStyle().down = btnDown;
        this.btnPlus.getStyle().disabled = btnDisabled;
        this.btnPlus.getStyle().imageDown = Main.uiSkin.newDrawable(plus, Main.OBJECT_PRESSED);
        this.btnPlus.getStyle().imageDisabled = Main.uiSkin.newDrawable(plus, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgFlashFull = new Image((Texture)Main.getAsset(Main.FLASH_BTN_PATH, Texture.class, true));
        this.dFlashFull = imgFlashFull.getDrawable();
        this.bsFlashFull = new VisImageButton.VisImageButtonStyle(new VisImageButton(this.dFlashFull).getStyle());
        this.bsFlashFull.up = btnUp;
        this.bsFlashFull.over = btnOver;
        this.bsFlashFull.down = btnDown;
        this.bsFlashFull.disabled = btnDisabled;
        this.bsFlashFull.imageUp = Main.uiSkin.newDrawable(this.dFlashFull);
        this.bsFlashFull.imageDown = Main.uiSkin.newDrawable(this.dFlashFull, Main.OBJECT_PRESSED);
        this.bsFlashFull.imageDisabled = Main.uiSkin.newDrawable(this.dFlashFull, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgFlashEmpty = new Image((Texture)Main.getAsset(Main.FLASH_BTN_PATH, Texture.class, true));
        this.dFlashEmpty = imgFlashEmpty.getDrawable();
        this.bsFlashEmpty = new VisImageButton.VisImageButtonStyle(new VisImageButton(this.dFlashEmpty).getStyle());
        this.bsFlashEmpty.up = btnUp;
        this.bsFlashEmpty.over = btnOver;
        this.bsFlashEmpty.down = btnDown;
        this.bsFlashEmpty.disabled = btnDisabled;
        this.bsFlashEmpty.imageUp = Main.uiSkin.newDrawable(this.dFlashEmpty, Main.OBJECT_BG);
        this.bsFlashEmpty.imageDown = Main.uiSkin.newDrawable(this.dFlashEmpty, Main.OBJECT_PRESSED);
        this.bsFlashEmpty.imageDisabled = Main.uiSkin.newDrawable(this.dFlashEmpty, new VisTextButton((String)"").getStyle().disabledFontColor);
        this.btnFlash = new VisImageButton(this.dFlashEmpty);
        Image imgFontFull = new Image((Texture)Main.getAsset(Main.FONT_BTN_PATH, Texture.class, true));
        this.dFontFull = imgFontFull.getDrawable();
        this.bsFontFull = new VisImageButton.VisImageButtonStyle(new VisImageButton(this.dFontFull).getStyle());
        this.bsFontFull.up = btnUp;
        this.bsFontFull.over = btnOver;
        this.bsFontFull.down = btnDown;
        this.bsFontFull.disabled = btnDisabled;
        this.bsFontFull.imageUp = Main.uiSkin.newDrawable(this.dFontFull);
        this.bsFontFull.imageDown = Main.uiSkin.newDrawable(this.dFontFull, Main.OBJECT_PRESSED);
        this.bsFontFull.imageDisabled = Main.uiSkin.newDrawable(this.dFontFull, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgFontEmpty = new Image((Texture)Main.getAsset(Main.FONT_BTN_PATH, Texture.class, true));
        this.dFontEmpty = imgFontEmpty.getDrawable();
        this.bsFontEmpty = new VisImageButton.VisImageButtonStyle(new VisImageButton(this.dFontEmpty).getStyle());
        this.bsFontEmpty.up = btnUp;
        this.bsFontEmpty.over = btnOver;
        this.bsFontEmpty.down = btnDown;
        this.bsFontEmpty.disabled = btnDisabled;
        this.bsFontEmpty.imageUp = Main.uiSkin.newDrawable(this.dFontEmpty, Main.OBJECT_BG);
        this.bsFontEmpty.imageDown = Main.uiSkin.newDrawable(this.dFontEmpty, Main.OBJECT_PRESSED);
        this.bsFontEmpty.imageDisabled = Main.uiSkin.newDrawable(this.dFontEmpty, new VisTextButton((String)"").getStyle().disabledFontColor);
        this.btnFont = new VisImageButton(this.dFontEmpty);
        Image imgKeybinds = new Image((Texture)Main.getAsset(Main.KEYBINDS_BTN_PATH, Texture.class, true));
        Drawable keybinds = imgKeybinds.getDrawable();
        this.btnKeybinds = new VisImageButton(keybinds, " Key Bindings ");
        this.btnKeybinds.getStyle().up = btnUp;
        this.btnKeybinds.getStyle().over = btnOver;
        this.btnKeybinds.getStyle().down = btnDown;
        this.btnKeybinds.getStyle().disabled = btnDisabled;
        this.btnKeybinds.getStyle().imageDown = Main.uiSkin.newDrawable(keybinds, Main.OBJECT_PRESSED);
        this.btnKeybinds.getStyle().imageDisabled = Main.uiSkin.newDrawable(keybinds, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgPlay = new Image((Texture)Main.getAsset(Main.PLAY_BTN_PATH, Texture.class, true));
        Drawable play = imgPlay.getDrawable();
        this.btnPlay = new VisImageButton(play);
        this.btnPlay.getStyle().up = btnUp;
        this.btnPlay.getStyle().over = btnOver;
        this.btnPlay.getStyle().down = btnDown;
        this.btnPlay.getStyle().disabled = btnDisabled;
        this.btnPlay.getStyle().imageDown = Main.uiSkin.newDrawable(play, Main.OBJECT_PRESSED);
        Image imgNext = new Image((Texture)Main.getAsset(Main.NEXT_BTN_PATH, Texture.class, true));
        Drawable next = imgNext.getDrawable();
        this.btnNext = new VisImageButton(next);
        this.btnNext.getStyle().up = btnUp;
        this.btnNext.getStyle().over = btnOver;
        this.btnNext.getStyle().down = btnDown;
        this.btnNext.getStyle().disabled = btnDisabled;
        this.btnNext.getStyle().imageUp = Main.uiSkin.newDrawable(next, Main.FONT);
        this.btnNext.getStyle().imageDown = Main.uiSkin.newDrawable(next, Main.OBJECT_PRESSED);
        Image imgIgnore = new Image((Texture)Main.getAsset(Main.IGNORE_BTN_PATH, Texture.class, true));
        Drawable ignore = imgIgnore.getDrawable();
        this.btnIgnore = new VisImageButton(ignore, " Ignore Answer ");
        this.btnIgnore.getStyle().up = btnUp;
        this.btnIgnore.getStyle().over = btnOver;
        this.btnIgnore.getStyle().down = btnDown;
        this.btnIgnore.getStyle().disabled = btnDisabled;
        this.btnIgnore.getStyle().imageUp = Main.uiSkin.newDrawable(ignore, Main.FONT);
        this.btnIgnore.getStyle().imageDown = Main.uiSkin.newDrawable(ignore, Main.OBJECT_PRESSED);
        this.btnIgnore.getStyle().imageDisabled = Main.uiSkin.newDrawable(ignore, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgSkip = new Image((Texture)Main.getAsset(Main.SKIP_BTN_PATH, Texture.class, true));
        Drawable skip = imgSkip.getDrawable();
        this.btnSkip = new VisImageButton(skip, " Temporarily Skip ");
        this.btnSkip.getStyle().up = btnUp;
        this.btnSkip.getStyle().over = btnOver;
        this.btnSkip.getStyle().down = btnDown;
        this.btnSkip.getStyle().disabled = btnDisabled;
        this.btnSkip.getStyle().imageUp = Main.uiSkin.newDrawable(skip, Main.FONT);
        this.btnSkip.getStyle().imageDown = Main.uiSkin.newDrawable(skip, Main.OBJECT_PRESSED);
        this.btnSkip.getStyle().imageDisabled = Main.uiSkin.newDrawable(skip, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgInfo = new Image((Texture)Main.getAsset(Main.INFO_BTN_PATH, Texture.class, true));
        Drawable info = imgInfo.getDrawable();
        this.btnInfo = new VisImageButton(info);
        this.btnInfo.getStyle().up = btnUp;
        this.btnInfo.getStyle().over = btnOver;
        this.btnInfo.getStyle().down = btnDown;
        this.btnInfo.getStyle().disabled = btnDisabled;
        this.btnInfo.getStyle().imageUp = Main.uiSkin.newDrawable(info, Main.FONT);
        this.btnInfo.getStyle().imageDown = Main.uiSkin.newDrawable(info, Main.OBJECT_PRESSED);
        this.btnInfo.getStyle().imageDisabled = Main.uiSkin.newDrawable(info, new VisTextButton((String)"").getStyle().disabledFontColor);
        VisTextField.VisTextFieldStyle tfInputStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
        tfInputStyle.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1P5, BitmapFont.class, true);
        tfInputStyle.fontColor = Color.WHITE;
        tfInputStyle.disabledFontColor = Color.WHITE;
        tfInputStyle.disabledBackground = Main.uiSkin.newDrawable("white", Color.WHITE);
        tfInputStyle.disabledBackground.setLeftWidth(tfInputStyle.background.getLeftWidth());
        tfInputStyle.disabledBackground.setRightWidth(tfInputStyle.background.getRightWidth());
        this.tblLabels.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
        this.tblTabs.setBackground(Main.uiSkin.newDrawable("white", Main.GRAY_DARK));
        this.lVocabKana = new VisLabel("X");
        this.lVocabKanji = new VisLabel("X");
        this.tfInput = new TextField("", tfInputStyle);
        this.tfInput.setCopyPasteMenu(false);
        this.tfInput.setKanaMode(true);
        this.taNotes.setMessageText("Click to add a note or mnemonic.");
        this.lCharCounter.setTouchable(Touchable.disabled);
        this.lReviewInfo.setAlignment(16);
        this.lVocabEng.setAlignment(1);
        this.lVocabKanji.setAlignment(1);
        this.lVocabKana.setAlignment(1);
        this.lSynonyms.setAlignment(1);
        this.lPartOfSpeechShort.setAlignment(1);
        this.lSentence.setAlignment(1);
        this.lSentenceMeaning.setAlignment(1);
        this.lPartOfSpeechFull.setAlignment(1);
        this.lJlptLevel.setAlignment(1);
        this.lInputType.setAlignment(1);
        this.tfInput.setAlignment(1);
        this.lCharCounter.setAlignment(4);
        this.btnArchiveVocab.setFocusBorderEnabled(false);
        this.btnPlus.setFocusBorderEnabled(false);
        this.btnFlash.setFocusBorderEnabled(false);
        this.btnFont.setFocusBorderEnabled(false);
        this.btnKeybinds.setFocusBorderEnabled(false);
        this.btnPlay.setFocusBorderEnabled(false);
        this.btnNext.setFocusBorderEnabled(false);
        this.btnIgnore.setFocusBorderEnabled(false);
        this.btnSkip.setFocusBorderEnabled(false);
        this.btnInfo.setFocusBorderEnabled(false);
        this.btnMeaning.setFocusBorderEnabled(false);
        this.btnDetails.setFocusBorderEnabled(false);
        this.btnCustom.setFocusBorderEnabled(false);
        this.btnSynonymsAdd.setFocusBorderEnabled(false);
        this.btnSynonymsRemove.setFocusBorderEnabled(false);
        this.btnReadingsAdd.setFocusBorderEnabled(false);
        this.btnReadingsRemove.setFocusBorderEnabled(false);
        this.lVocabEng.setWrap(true);
        this.lSynonyms.setWrap(true);
        this.lPartOfSpeechShort.setWrap(true);
        this.lSentence.setWrap(true);
        this.lSentenceMeaning.setWrap(true);
        this.lPartOfSpeechFull.setWrap(true);
        this.lVocabKanji.setWrap(false);
        this.lVocabKana.setWrap(false);
        this.table.clearChildren();
        this.tblVocab.clearChildren();
        this.tblLabels.clearChildren();
        this.tblButtons.clearChildren();
        this.tblTabs.clearChildren();
        this.tblDetails.clearChildren();
        this.tblCustomSynonyms.clearChildren();
        this.tblCustomReadings.clearChildren();
        this.tblCustom.clearChildren();
        this.tblTabbedPane.clearChildren();
        this.batch = new SpriteBatch();
        this.renderer = new ShapeRenderer();
        this.renderer.setAutoShapeType(true);
        this.taNotes.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        VisScrollPane spNotes = (VisScrollPane)this.taNotes.createCompatibleScrollPane();
        float pad = Main.isMobile() ? 0.5f * (float)Main.getPPUY() : (float)Main.getPPUY();
        VisTable tblTopLeft = new VisTable(false);
        tblTopLeft.add(this.btnPlus).size(1.5f * (float)Main.getPPUY());
        tblTopLeft.add(this.btnArchiveVocab).size(1.75f * (float)Main.getPPUY()).padLeft(pad);
        tblTopLeft.add(this.btnFlash).size(1.5f * (float)Main.getPPUY()).padLeft(pad);
        if (Main.isDesktop()) {
            tblTopLeft.add(this.btnFont).size(1.5f * (float)Main.getPPUY()).padLeft(pad);
            tblTopLeft.add(this.btnKeybinds).size(1.5f * (float)Main.getPPUY()).padLeft(pad);
        }
        VisTable tblTopRight = new VisTable(false);
        tblTopRight.add(this.lReviewInfo).padLeft(pad);
        this.topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                ReviewScreen.this.stage.unfocusAll();
                Gdx.input.setOnscreenKeyboardVisible(false);
                if (ReviewScreen.this.isPracticeMode()) {
                    ReviewScreen.this.disposeAssets();
                    RestClient.updateTime(Main.getToriiTime(), Main.getStudyTime(), Main.getReviewTime());
                    ReviewScreen.this.reviewsDone = 0;
                    Dashboard.showOnScreen();
                } else {
                    String s = ReviewScreen.this.isLessonMode ? "Do you want to quit this study session?" : "Do you want to quit this review session?";
                    Dialogs.showConfirmDialog(ReviewScreen.this.stage, "Quit Session", s, new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            ReviewScreen.this.disposeAssets();
                            RestClient.updateTime(Main.getToriiTime(), Main.getStudyTime(), Main.getReviewTime());
                            ReviewScreen.this.reviewsDone = 0;
                            ReviewScreen.this.lessonsDone = 0;
                            Dashboard.showOnScreen();
                        }

                        @Override
                        public void cancel() {
                            ReviewScreen.this.tfInput.requestFocus();
                        }
                    });
                }
            }
        };
        this.topMenu.swapLeft(tblTopLeft, 8);
        this.topMenu.swapRight(tblTopRight, 16);
        this.plt = new PracticeScreen.PracticeListsTable(this.stage, true, false);
        this.tblVocab.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblVocab.add(this.lVocabKana).height(this.kanaFontSize).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblVocab.add(this.lVocabKanji).height(this.kanjiFontSize).row();
        this.tblLabels.add(this.lInputType);
        this.tblButtons.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f / 4.0f).height(1.5f * (float)Main.getPPUY());
        this.tblButtons.add(this.btnInfo);
        this.tblButtons.add(this.btnIgnore);
        this.tblButtons.add(this.btnSkip);
        this.tblButtons.add(this.btnNext).row();
        this.tblTabs.defaults().height(2 * Main.getPPUY()).fillX().uniformX();
        this.tblTabs.add(this.btnMeaning);
        this.tblTabs.add(this.btnDetails);
        this.tblTabs.add(this.btnCustom);
        this.tblTabs.pack();
        VisTable tblLinks = new VisTable(false);
        tblLinks.add(this.llJisho).expandX().uniform().align(16);
        tblLinks.add(new VisLabel((CharSequence)"  |  ", Main.labelStyleX1));
        tblLinks.add(this.llTatoeba).expandX().uniform().align(8);
        this.tblDetails.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f).fillX();
        this.tblDetails.add(this.lPartOfSpeechFull).padBottom(0.1f * (float)Main.getPPUY()).row();
        this.tblDetails.add(this.lJlptLevel).padBottom(1.0f * (float)Main.getPPUY()).row();
        this.tblDetails.addSeparator().padBottom(1.0f * (float)Main.getPPUY()).row();
        this.tblDetails.add(this.lSentence).padBottom(1.0f * (float)Main.getPPUY()).row();
        this.tblDetails.add(this.lSentenceMeaning).expandY().align(2).row();
        this.tblDetails.add(tblLinks).padBottom(0.5f * (float)Main.getPPUY()).row();
        this.tblCustomSynonyms.defaults().expandX().fillX();
        this.tblCustomSynonyms.add(this.listSynonyms).colspan(2).expand().fill().align(2).row();
        this.tblCustomSynonyms.add(this.btnSynonymsAdd).uniform();
        this.tblCustomSynonyms.add(this.btnSynonymsRemove).uniform().row();
        this.tblCustomReadings.defaults().expandX().fillX();
        this.tblCustomReadings.add(this.listReadings).colspan(2).expand().fill().align(2).row();
        this.tblCustomReadings.add(this.btnReadingsAdd).uniform();
        this.tblCustomReadings.add(this.btnReadingsRemove).uniform().row();
        Stack stack = new Stack(spNotes, this.lCharCounter);
        this.tblCustom.defaults().expand().fill().uniform();
        this.tblCustom.add(stack).height(0.0f);
        this.tblCustom.add(this.tblCustomSynonyms);
        this.tblTabbedPane.setFillParent(true);
        this.collapsibleWidget = new CollapsibleWidget(this.tblTabbedPane);
        this.collapsibleWidget.setCollapsed(true, false);
        this.collapsibleWidget.setFadeDuration(2.0f);
        this.table.setFillParent(true);
        this.table.align(2);
        this.rebuildTable();
        this.btnInfo.getImage().setOrigin(1);
        this.btnInfo.getImage().addAction(Actions.rotateBy(180.0f));
        this.stage.clear();
        this.setActorListeners();
        this.stage.addActor(this.table);
    }

    private void rebuildTable() {
        VisScrollPane spVocab = new VisScrollPane((Actor)this.tblVocab);
        spVocab.setFadeScrollBars(false);
        this.table.clearChildren();
        this.table.add(this.topMenu.getTable()).width(this.stage.getViewport().getWorldWidth()).row();
        this.table.add(spVocab).width(this.stage.getViewport().getWorldWidth()).height(4.5f * (float)Main.getPPUY() + this.kanaFontSize + this.kanjiFontSize).row();
        this.table.add(this.tblLabels).width(this.stage.getViewport().getWorldWidth() * 1.1f).height(2 * Main.getPPUY()).row();
        this.table.add(this.tfInput).width(this.stage.getViewport().getWorldWidth() * 0.95f).height(2.75f * (float)Main.getPPUY()).padTop(Main.getPPUY()).row();
        this.table.add(this.tblButtons).width(this.stage.getViewport().getWorldWidth() * 0.95f).height(3 * Main.getPPUY()).row();
        this.table.addSeparator().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.table.add(this.collapsibleWidget).fillX().expandX().padBottom(Main.getPPUY()).row();
        this.table.pack();
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        if (this.reviewCounter == -1) {
            this.buildUI();
            Gdx.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    ReviewScreen.this.updateFlashButtonStyle();
                    ReviewScreen.this.updateFontButtonStyle();
                    ReviewScreen.this.nextReview();
                }
            });
        }
        this.tfInput.requestFocus();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG_LIGHTER.r, Main.UI_BG_LIGHTER.g, Main.UI_BG_LIGHTER.b, Main.UI_BG_LIGHTER.a);
        Gdx.gl.glClear(16384);
        Main.updateAssetManager(false);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.setColor(Main.REVIEW_OVER);
        this.renderer.rect(0.0f, this.tblLabels.getY(), this.stage.getViewport().getWorldWidth(), this.stage.getViewport().getWorldHeight() - this.tblLabels.getY() - this.topMenu.getTable().getHeight());
        this.renderer.end();
        this.stage.act(delta);
        this.stage.draw();
        if (AudioHandler.isDownloadingExampleAudio()) {
            this.topMenu.setIndicatorRight(TopMenu.StatusIndicator.DOWNLOAD);
        } else {
            this.topMenu.setIndicatorRight(TopMenu.StatusIndicator.NONE);
        }
        if (AudioHandler.isSoundPlaying()) {
            this.topMenu.setIndicatorLeft(TopMenu.StatusIndicator.SOUND);
        } else {
            this.topMenu.setIndicatorLeft(TopMenu.StatusIndicator.NONE);
        }
        if (this.drawLevelUpTexture) {
            float height = 2 * Main.getPPUY();
            float width = 3.033f * height;
            this.batch.begin();
            this.batch.draw(this.tex, this.stage.getViewport().getWorldWidth() / 2.0f - width / 2.0f, this.tblLabels.getY(), width, height * this.factor);
            this.batch.end();
        }
        if (Dashboard.isKonamiStreakOver9000()) {
            float maxHeight = this.stage.getViewport().getWorldHeight() * 0.4f;
            float height = 428.0f > maxHeight ? maxHeight : 504.0f;
            float width = 504.0f * (height / 504.0f);
            this.deltaRed += delta;
            this.batch.begin();
            this.batch.draw(this.animRed.getKeyFrame(this.deltaRed, true), this.stage.getViewport().getWorldWidth() - width * 0.95f, this.getStageLocation((Actor)this.tfInput).y, width, height);
            this.batch.end();
        }
    }

    @Override
    public void resize(int width, int height) {
        if ((float)width != this.stage.getViewport().getWorldWidth() || (float)height != this.stage.getViewport().getWorldHeight()) {
            this.stage.getViewport().setWorldSize(width, height);
            this.buildUI();
        }
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        Main.stopSound();
    }

    @Override
    public void dispose() {
    }

    static void showOnScreen() {
        Main.setNewScreen(reviewScreen);
    }

    static boolean isOnScreen() {
        return Main.getCurrentScreen() == reviewScreen;
    }

    static int getReviewMode() {
        if (ReviewScreen.reviewScreen.reviewMode == ReviewModes.JP_TO_EN) {
            return 1;
        }
        if (ReviewScreen.reviewScreen.reviewMode == ReviewModes.EN_TO_JP) {
            return 2;
        }
        return 3;
    }

    static void setReviewMode(int modeId) {
        switch (modeId) {
            case 1: {
                ReviewScreen.reviewScreen.reviewMode = ReviewModes.JP_TO_EN;
                break;
            }
            case 2: {
                ReviewScreen.reviewScreen.reviewMode = ReviewModes.EN_TO_JP;
                break;
            }
            case 3: {
                ReviewScreen.reviewScreen.reviewMode = ReviewModes.MIXED;
            }
        }
    }

    static int getAudioReviewMode() {
        if (ReviewScreen.reviewScreen.audioMode == AudioModes.OFF) {
            return 0;
        }
        if (ReviewScreen.reviewScreen.audioMode == AudioModes.ALTERNATE) {
            return 1;
        }
        return 2;
    }

    static void setAudioReviewMode(int modeId) {
        switch (modeId) {
            case 0: {
                ReviewScreen.reviewScreen.audioMode = AudioModes.OFF;
                break;
            }
            case 1: {
                ReviewScreen.reviewScreen.audioMode = AudioModes.ALTERNATE;
                break;
            }
            case 2: {
                ReviewScreen.reviewScreen.audioMode = AudioModes.EXCLUSIVE;
            }
        }
    }

    static void setEndlessPracticeSettings(int reviewModeID, boolean[] includedSRSstages) {
        ReviewScreen.reviewScreen.endlessPracticeReviewModeID = reviewModeID;
        ReviewScreen.reviewScreen.endlessPracticeIncludedSRSstages = includedSRSstages;
    }

    static void setAudioToENPracticeMode(AudioModes audioMode) {
        ReviewScreen.reviewScreen.practiceAudioToEN = audioMode;
    }

    static void setAudioToJPPracticeMode(AudioModes audioMode) {
        ReviewScreen.reviewScreen.practiceAudioToJP = audioMode;
    }

    static void setRandomizeFont(boolean randomize) {
        ReviewScreen.reviewScreen.randomizeFont = randomize;
    }

    static boolean getRandomizeFont() {
        return ReviewScreen.reviewScreen.randomizeFont && !FileManager.getFontFiles().isEmpty();
    }

    static void setHideKana(boolean hideKana) {
        ReviewScreen.reviewScreen.hideKana = hideKana;
    }

    static boolean getHideKana() {
        return ReviewScreen.reviewScreen.hideKana;
    }

    static void setShowKanaAfterAnswer(boolean show) {
        ReviewScreen.reviewScreen.showKanaAfterAnswer = show;
    }

    static boolean getShowKanaAfterAnswer() {
        return ReviewScreen.reviewScreen.showKanaAfterAnswer;
    }

    static void setAutoplayAudio(boolean autoplayAudio) {
        ReviewScreen.reviewScreen.autoplayAudio = autoplayAudio;
    }

    static void setAutoplayAudioSentence(boolean autoplayAudioSentence) {
        ReviewScreen.reviewScreen.autoplayAudioSentence = autoplayAudioSentence;
    }

    static void setPlayAudioAtStart(boolean playAudioAtStart) {
        ReviewScreen.reviewScreen.playAudioAtStart = playAudioAtStart;
    }

    static void setPlayAudioAtEnd(boolean playAudioAtEnd) {
        ReviewScreen.reviewScreen.playAudioAtEnd = playAudioAtEnd;
    }

    static void setPlayAudioOnWrongAnswer(boolean playAudioOnWrongAnswer) {
        ReviewScreen.reviewScreen.playAudioOnWrongAnswer = playAudioOnWrongAnswer;
    }

    static boolean getAutoplayAudio() {
        return ReviewScreen.reviewScreen.autoplayAudio;
    }

    static boolean getAutoplayAudioSentence() {
        return ReviewScreen.reviewScreen.autoplayAudioSentence;
    }

    static boolean getPlayAudioAtStart() {
        return ReviewScreen.reviewScreen.playAudioAtStart;
    }

    static boolean getPlayAudioAtEnd() {
        return ReviewScreen.reviewScreen.playAudioAtEnd;
    }

    static boolean getPlayAudioOnWrongAnswer() {
        return ReviewScreen.reviewScreen.playAudioOnWrongAnswer;
    }

    static void setLightningMode(boolean lightningModeEnabled) {
        ReviewScreen.reviewScreen.isLightningModeEnabled = lightningModeEnabled;
    }

    static boolean getLightningMode() {
        return ReviewScreen.reviewScreen.isLightningModeEnabled;
    }

    static void setHyperjumpMode(boolean hyperjumpModeEnabled) {
        ReviewScreen.reviewScreen.isHyperjumpModeEnabled = hyperjumpModeEnabled;
    }

    static boolean getHyperjumpMode() {
        return ReviewScreen.reviewScreen.isHyperjumpModeEnabled;
    }

    static void setAutoExpandDetailsAfterWrongAnswer(boolean autoExpand) {
        ReviewScreen.reviewScreen.autoExpandDetailsAfterWrongAnswer = autoExpand;
    }

    static boolean getAutoExpandDetailsAfterWrongAnswer() {
        return ReviewScreen.reviewScreen.autoExpandDetailsAfterWrongAnswer;
    }

    static void setReviewSessionAutoContinue(boolean autoContinue) {
        ReviewScreen.reviewScreen.reviewSessionAutoContinue = autoContinue;
    }

    static boolean getReviewSessionAutoContinue() {
        return ReviewScreen.reviewScreen.reviewSessionAutoContinue;
    }

    static void setReviewFullscreen(boolean on) {
        ReviewScreen.reviewScreen.reviewFullscreen = on;
    }

    static boolean getReviewFullscreen() {
        return ReviewScreen.reviewScreen.reviewFullscreen;
    }

    static void setPlaceholder(String placeholder) {
        ReviewScreen.reviewScreen.placeholder = placeholder;
    }

    static String getPlaceholder() {
        return ReviewScreen.reviewScreen.placeholder;
    }

    private void addToItemsBeingSynced(int vocabID) {
        this.itemsBeingSynced.add(vocabID);
    }

    static void removeFromItemsBeingSynced(int vocabID) {
        if (ReviewScreen.reviewScreen.itemsBeingSynced.contains(vocabID, false)) {
            ReviewScreen.reviewScreen.itemsBeingSynced.removeValue(vocabID, false);
        }
    }

    static void setData(boolean isLessonMode, int practiceID, int[] id, int[] streakMeaning, int[] streakReading, String[] vocabKanji, String[] vocabKana, String[] meaning, String[] altMeanings, String[] altReadings, String[] sentence, String[] sentenceMeaning, String[] partOfSpeech, String[] jlptLevel, String[] vocabAudio, String[] sentenceAudio, String[] synonyms, String[] readings, String[] notes) {
        ReviewScreen.reviewScreen.itemsBeingSynced.clear();
        ReviewScreen.reviewScreen.isLessonMode = isLessonMode;
        ReviewScreen.reviewScreen.practiceID = practiceID;
        ReviewScreen.reviewScreen.noOfReviews = id.length;
        ReviewScreen.reviewScreen.reviewCounter = -1;
        ReviewScreen.reviewScreen.answersGiven = -1;
        ReviewScreen.reviewScreen.reviewsAnsweredCorrectly = -1;
        ReviewScreen.reviewScreen.archivedLastItem = false;
        ReviewScreen.reviewScreen.reviewsList = new HashMap();
        String usedKanji = "";
        String usedCharsSentence = "";
        for (int x = 0; x < ReviewScreen.reviewScreen.noOfReviews; ++x) {
            ReviewScreen.reviewScreen.reviewsList.put(x, new Review(id[x], streakMeaning[x], streakReading[x], vocabKanji[x], vocabKana[x], meaning[x], altMeanings[x], altReadings[x], sentence[x], sentenceMeaning[x], partOfSpeech[x], jlptLevel[x], vocabAudio[x], sentenceAudio[x], synonyms[x], readings[x], notes[x]));
            usedKanji = usedKanji + vocabKanji[x];
            usedCharsSentence = usedCharsSentence + sentence[x];
        }
        ReviewScreen.reviewScreen.styleKanji = new Label.LabelStyle[1];
        ReviewScreen.reviewScreen.styleKana = new Label.LabelStyle[1];
        if (ReviewScreen.getRandomizeFont() && !ReviewScreen.reviewScreen.isLessonMode && ReviewScreen.reviewScreen.reviewMode != ReviewModes.EN_TO_JP && ReviewScreen.reviewScreen.audioMode == AudioModes.OFF) {
            Array<String> arInstalledFonts = FileManager.getFontFiles();
            ReviewScreen.reviewScreen.styleKanji = new Label.LabelStyle[arInstalledFonts.size > 3 ? 4 : arInstalledFonts.size + 1];
            ReviewScreen.reviewScreen.styleKana = new Label.LabelStyle[arInstalledFonts.size > 3 ? 4 : arInstalledFonts.size + 1];
            Array<String> arDummy = new Array<String>();
            for (int f = 1; f < ReviewScreen.reviewScreen.styleKanji.length; ++f) {
                String sFont = arInstalledFonts.random();
                while (arDummy.contains(sFont, false)) {
                    sFont = arInstalledFonts.random();
                }
                arDummy.add(sFont);
                Main.loadTTFtoAssetManager(false, FileManager.getFontDirectory() + sFont, f + ReviewScreen.reviewScreen.kanjiFontName, (int)ReviewScreen.reviewScreen.kanjiFontSize, usedKanji, true, 1, 3);
                Main.loadTTFtoAssetManager(false, FileManager.getFontDirectory() + sFont, f + ReviewScreen.reviewScreen.kanaFontName, 2 * Main.getPPUY(), Main.getKanaChars() + "\u7b54", false, 1, 2);
                ReviewScreen.reviewScreen.styleKanji[f] = new Label.LabelStyle(new VisLabel().getStyle());
                ReviewScreen.reviewScreen.styleKana[f] = new Label.LabelStyle(new VisLabel().getStyle());
            }
        }
        ReviewScreen.reviewScreen.styleKanji[0] = new Label.LabelStyle(new VisLabel().getStyle());
        ReviewScreen.reviewScreen.styleKana[0] = new Label.LabelStyle(new VisLabel().getStyle());
        Main.loadTTFtoAssetManager("0" + ReviewScreen.reviewScreen.kanjiFontName, (int)ReviewScreen.reviewScreen.kanjiFontSize, usedKanji, true, 1, 3);
        Main.finishLoadingAsset("0" + ReviewScreen.reviewScreen.kanjiFontName, true);
        if (ReviewScreen.reviewScreen.styleKanji.length > 1) {
            Main.finishLoadingAsset("1" + ReviewScreen.reviewScreen.kanjiFontName, false);
            Main.finishLoadingAsset("1" + ReviewScreen.reviewScreen.kanaFontName, false);
        }
        Main.loadTTFtoAssetManager(ReviewScreen.reviewScreen.sentenceFontName, Main.getPPUY(), usedCharsSentence, true);
        Main.finishLoadingAsset(ReviewScreen.reviewScreen.sentenceFontName, true);
        ReviewScreen.reviewScreen.styleKanji[0].font = (BitmapFont)Main.getAsset("0" + ReviewScreen.reviewScreen.kanjiFontName, BitmapFont.class, true);
        ReviewScreen.reviewScreen.styleKana[0].font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X2, BitmapFont.class, true);
        ReviewScreen.reviewScreen.sentenceStyle.font = (BitmapFont)Main.getAsset(ReviewScreen.reviewScreen.sentenceFontName, BitmapFont.class, true);
        if (!ReviewScreen.reviewScreen.collapsibleWidget.isCollapsed()) {
            ReviewScreen.reviewScreen.btnInfo.getImage().setOrigin(1);
            ReviewScreen.reviewScreen.btnInfo.getImage().addAction(Actions.rotateBy(180.0f, 0.1f));
            ReviewScreen.reviewScreen.collapsibleWidget.setCollapsed(true, false);
        }
        if (Main.isDesktop() && ReviewScreen.getReviewFullscreen()) {
            Main.enterFullscreenMode();
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                ReviewScreen.showOnScreen();
            }
        });
    }

    static void archiveVocab(String vocab, int vocabID) {
        Array<Integer> array = new Array<Integer>();
        for (Map.Entry<Integer, Review> entry : ReviewScreen.reviewScreen.reviewsList.entrySet()) {
            Review review = entry.getValue();
            if (ReviewScreen.reviewScreen.currentReview.id != review.id) continue;
            array.add(entry.getKey());
        }
        for (int x = 0; x < array.size; ++x) {
            ReviewScreen.reviewScreen.reviewsList.remove(array.get(x));
        }
        Dashboard.setReviewsAvailable(Dashboard.getReviewsAvailable() - array.size);
        ReviewScreen.reviewScreen.reviewCounter += array.size;
        ReviewScreen.reviewScreen.archivedLastItem = true;
        if (!ReviewScreen.reviewScreen.reviewsList.isEmpty()) {
            reviewScreen.nextReview();
            reviewScreen.showItemArchivedToast(vocab, vocabID);
        } else {
            ReviewScreen.reviewScreen.userInputEnabled = false;
            ReviewScreen.reviewScreen.tfInput.setDisabled(true);
            reviewScreen.showItemArchivedToast(vocab, vocabID);
            final float[] c = new float[]{5.0f};
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    if (c[0] <= 0.0f) {
                        this.cancel();
                        reviewScreen.reviewSessionCompleted();
                    } else {
                        reviewScreen.tfInput.setText("< Session continues in " + (int)c[0] + " >");
                        c[0] = c[0] - 1.0f;
                    }
                }
            }, 0.0f, 1.0f);
        }
    }

    static void restoreVocab(String vocab) {
        reviewScreen.showItemRestoredToast(vocab);
    }

    private void showItemArchivedToast(final String vocab, final int vocabID) {
        float windowsWidth = this.stage.getViewport().getWorldWidth() * 0.8f;
        int padX = (int)(this.stage.getViewport().getWorldWidth() * 0.09f);
        int padY = Main.getPPUY() * 2;
        VisLabel s1 = new VisLabel("Item ' ");
        VisLabel s3 = new VisLabel(" ' archived.");
        VisLabel s2 = new VisLabel((CharSequence)vocab, this.sentenceStyle);
        LinkLabel ll = new LinkLabel((CharSequence)"Undo", (CharSequence)"");
        final ToastManager toastManager = new ToastManager(this.stage);
        toastManager.setAlignment(12);
        toastManager.setScreenPadding(padX, padY);
        VisTable toastContent = new VisTable(false);
        toastContent.add().colspan(3).width(windowsWidth).row();
        toastContent.add(s1).expandX().align(16).padTop(Main.getPPUY());
        toastContent.add(s2).padTop(Main.getPPUY());
        toastContent.add(s3).expandX().align(8).padTop(Main.getPPUY()).row();
        toastContent.add(ll).colspan(3).padTop((float)Main.getPPUY() * 0.5f).padBottom(Main.getPPUY()).row();
        final Toast primeToast = new Toast(toastContent);
        ll.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                toastManager.remove(primeToast);
                RestClient.archiveVocab(vocab, vocabID, false);
            }
        });
        toastManager.show(primeToast, 5.0f);
    }

    private void showItemRestoredToast(String vocab) {
        float windowsWidth = this.stage.getViewport().getWorldWidth() * 0.8f;
        int padX = (int)(this.stage.getViewport().getWorldWidth() * 0.09f);
        int padY = Main.getPPUY() * 2;
        VisLabel s1 = new VisLabel("Item ' ");
        VisLabel s3 = new VisLabel(" ' restored.");
        VisLabel s2 = new VisLabel((CharSequence)vocab, this.sentenceStyle);
        ToastManager toastManager = new ToastManager(this.stage);
        toastManager.setAlignment(12);
        toastManager.setScreenPadding(padX, padY);
        VisTable toastContent = new VisTable(false);
        toastContent.add().colspan(3).width(windowsWidth).row();
        toastContent.add(s1).expandX().align(16).padTop(Main.getPPUY());
        toastContent.add(s2).padTop(Main.getPPUY());
        toastContent.add(s3).expandX().align(8).padTop(Main.getPPUY()).row();
        toastContent.add().colspan(3).padBottom(Main.getPPUY()).width(windowsWidth).row();
        Toast primeToast = new Toast(toastContent);
        toastManager.show(primeToast, 2.0f);
    }

    private void disposeAssets() {
        Main.finishLoadingAssets(false);
        Main.disposeAsset("0" + this.kanjiFontName, true);
        Main.disposeAsset(this.sentenceFontName, true);
        for (int x = 1; x < this.styleKanji.length; ++x) {
            Main.disposeAsset(x + this.kanjiFontName, false);
            Main.disposeAsset(x + this.kanaFontName, false);
        }
    }

    private void removeMapItemAndGoToNextReview() {
        if (this.isLessonMode && !this.isPracticeMode()) {
            this.reviewsList.remove(this.currentReviewId);
            this.reviewsList.remove(this.getCurrentReviewSiblingID());
            StudyScreen.setDailyLimitLeft(StudyScreen.getDailyLimitLeft() - 1);
            ++this.lessonsDone;
        } else if (!this.isLessonMode && this.isPracticeMode()) {
            this.reviewsList.remove(this.currentReviewId);
            ++this.reviewsDone;
        } else {
            this.reviewsList.remove(this.currentReviewId);
            Dashboard.setReviewsAvailable(Dashboard.getReviewsAvailable() - 1);
            ++this.reviewsDone;
        }
        final float interval = 0.01f;
        final float fadeTime = 0.1f;
        final float idleTime = 1.5f;
        final float percentagePerRepeat = 1.0f / (fadeTime / interval);
        if (!this.isPracticeMode()) {
            Timer.schedule(new Timer.Task(){
                float timePassed = 0.0f;

                @Override
                public void run() {
                    if (this.timePassed == 0.0f) {
                        ReviewScreen.this.factor = 0.0f;
                        ReviewScreen.this.drawLevelUpTexture = true;
                    }
                    this.timePassed += interval;
                    if (this.timePassed <= fadeTime) {
                        ReviewScreen.this.factor += percentagePerRepeat;
                    } else if (this.timePassed > idleTime + fadeTime && this.timePassed <= 2.0f * fadeTime + idleTime) {
                        ReviewScreen.this.factor -= percentagePerRepeat;
                    } else if (this.timePassed > 2.0f * fadeTime + idleTime) {
                        ReviewScreen.this.drawLevelUpTexture = false;
                        this.cancel();
                    }
                }
            }, 0.0f, interval);
        }
        if (!this.reviewsList.isEmpty()) {
            this.nextReview();
        } else {
            LoadingScreen.showOnScreen();
            long start = System.currentTimeMillis();
            final long end = start + 15000L;
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    if (ReviewScreen.this.itemsBeingSynced.isEmpty()) {
                        this.cancel();
                        LoadingScreen.hideOnScreen();
                        ReviewScreen.this.reviewSessionCompleted();
                    } else if (System.currentTimeMillis() > end) {
                        this.cancel();
                        LoadingScreen.hideOnScreen();
                        Dialogs.showOKDialog(ReviewScreen.this.stage, "Syncing Issue", "[CR]" + ((ReviewScreen)ReviewScreen.this).itemsBeingSynced.size + "[] of your reviews couldn't be synced in time. Session timed out.", new Dialogs.OKAdapter(){

                            @Override
                            public void ok() {
                                ReviewScreen.this.disposeAssets();
                                Dashboard.showOnScreen();
                            }
                        });
                    }
                }
            }, 0.25f, 0.25f);
        }
    }

    private boolean isPracticeMode() {
        return this.practiceID != -1;
    }

    private void reviewSessionCompleted() {
        boolean isMoreAvailable;
        String str;
        String title = "Nicely done!";
        String titleAllLearned = "All clear!";
        this.stage.unfocusAll();
        Gdx.input.setOnscreenKeyboardVisible(false);
        RestClient.updateTime(Main.getToriiTime(), Main.getStudyTime(), Main.getReviewTime());
        if (this.isPracticeMode()) {
            if (this.practiceID == 0) {
                RestClient.getReviews(this.endlessPracticeReviewModeID, 0, this.endlessPracticeIncludedSRSstages);
            } else {
                RestClient.getReviews(this.practiceID);
            }
            return;
        }
        if (this.isLessonMode) {
            if (StudyScreen.getDailyLimitLeft() > 0) {
                str = "Continue studying?";
                isMoreAvailable = true;
            } else {
                if (!StudyScreen.getAllLessonsCleared()) {
                    str = "No more lessons for now.";
                } else {
                    title = titleAllLearned;
                    str = "Great job \u2014 you've learned all the vocabulary in your current Study Mode!\nKeep reviewing regularly to make sure it all sticks.";
                }
                isMoreAvailable = false;
            }
        } else if (Dashboard.getReviewsAvailable() > 0) {
            str = "Continue reviewing?";
            isMoreAvailable = true;
        } else {
            str = "No more reviews for now.";
            isMoreAvailable = false;
        }
        if (isMoreAvailable) {
            if (this.isLessonMode && StudyScreen.getStudySessionAutoContinue()) {
                RestClient.getLessons();
            } else if (!this.isLessonMode && this.reviewSessionAutoContinue) {
                RestClient.getReviews(-1);
            } else {
                Dialogs.showConfirmDialog(this.stage, title, str, new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        if (ReviewScreen.this.isLessonMode) {
                            RestClient.getLessons();
                        } else {
                            RestClient.getReviews(-1);
                        }
                    }

                    @Override
                    public void cancel() {
                        ReviewScreen.this.disposeAssets();
                        Dashboard.showOnScreen();
                    }
                });
            }
        } else {
            Dialogs.showOKDialog(this.stage, title, str, new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    ReviewScreen.this.disposeAssets();
                    Dashboard.showOnScreen();
                }
            });
        }
    }

    private void nextReview() {
        if (!this.archivedLastItem) {
            if (!this.ignoreLastAnswer && !this.skippedLastItem) {
                ++this.answersGiven;
            }
            if (this.isLastAnswerCorrect || this.reviewCounter == -1) {
                ++this.reviewCounter;
                ++this.reviewsAnsweredCorrectly;
            }
        }
        int lastReviewId = this.currentReviewId;
        while (lastReviewId == this.currentReviewId || this.currentReview.answer > 0) {
            int rnd = MathUtils.random(this.noOfReviews - 1);
            while (!this.reviewsList.containsKey(rnd)) {
                rnd = MathUtils.random(this.noOfReviews - 1);
            }
            this.currentReviewId = rnd;
            this.currentReview = this.reviewsList.get(this.currentReviewId);
            if (this.isLessonMode) {
                if (this.reviewsList.size() != 2 || this.currentReview.answer <= 0) continue;
                this.currentReviewId = this.getCurrentReviewSiblingID();
                this.currentReview = this.reviewsList.get(this.currentReviewId);
                break;
            }
            if (this.reviewsList.size() != 1) continue;
            break;
        }
        if (!this.collapsibleWidget.isCollapsed()) {
            this.btnInfo.getImage().setOrigin(1);
            this.btnInfo.getImage().addAction(Actions.rotateBy(180.0f, 0.1f));
            this.collapsibleWidget.setCollapsed(true, false);
        }
        if (this.currentReview.getKanjiStyle() == null) {
            int rndFont;
            int n = rndFont = this.styleKanji.length > 1 && this.currentReview.isReviewMeaning() ? MathUtils.random(1, this.styleKanji.length - 1) : 0;
            if (rndFont > 0) {
                while (!Main.isAssetLoaded(rndFont + this.kanjiFontName, false) || !Main.isAssetLoaded(rndFont + this.kanaFontName, false)) {
                    rndFont = MathUtils.random(1, this.styleKanji.length - 1);
                }
                this.styleKanji[rndFont].font = (BitmapFont)Main.getAsset(rndFont + this.kanjiFontName, BitmapFont.class, false);
                this.styleKana[rndFont].font = (BitmapFont)Main.getAsset(rndFont + this.kanaFontName, BitmapFont.class, false);
            }
            this.currentReview.setKanjiStyle(this.styleKanji[rndFont]);
            this.currentReview.setKanaStyle(this.styleKana[rndFont]);
        }
        this.lVocabKanji.setStyle(this.currentReview.getKanjiStyle());
        this.lVocabKana.setStyle(this.currentReview.getKanaStyle());
        this.lSentence.setStyle(this.sentenceStyle);
        this.lSentence.getStyle().fontColor = Main.FONT;
        this.updateFontButtonStyle();
        if (!this.isPracticeMode()) {
            if (this.isLessonMode) {
                this.lReviewInfo.setText(StudyScreen.getDailyLimitLeft() + " \u2192 " + this.lessonsDone);
            } else {
                this.lReviewInfo.setText(Dashboard.getReviewsAvailable() + " \u2192 " + this.reviewsDone);
            }
        } else {
            this.lReviewInfo.setText("\u221e \u2192 " + this.reviewsDone);
        }
        if (!this.isLessonMode && !this.hideKana || this.isLessonMode && !StudyScreen.getHideKana()) {
            this.lVocabKana.setText(this.currentReview.vocabKana);
        } else {
            this.lVocabKana.setText(this.placeholder);
        }
        this.lVocabKanji.setText(this.currentReview.vocabKanji);
        this.lVocabEng.setText(this.currentReview.meaning);
        this.lSentence.setText(this.currentReview.sentence);
        this.lSentenceMeaning.setText(this.currentReview.sentenceMeaning);
        this.lPartOfSpeechFull.setText(this.currentReview.partOfSpeech.equals("") ? "PoS N/A" : this.currentReview.partOfSpeech);
        this.lJlptLevel.setText(this.currentReview.jlptLevel.equals("") ? "JLPT level N/A" : this.currentReview.jlptLevel);
        this.llJisho.setUrl(RestClient.createJishoLink(this.currentReview.vocabKanji));
        this.llTatoeba.setUrl(RestClient.createTatoebaLink(this.currentReview.vocabKanji));
        this.scaleFontsToFitOnScreen();
        String lSynTemp = this.currentReview.synonyms != null ? this.currentReview.synonyms.replaceAll(";", ", ") : "";
        lSynTemp = !lSynTemp.equals("") ? lSynTemp.substring(0, lSynTemp.length() - 2) : "";
        this.lSynonyms.setText(lSynTemp);
        this.lPartOfSpeechShort.setText(this.shortenPoS(this.currentReview.partOfSpeech));
        if (this.currentReview.isReviewMeaning()) {
            this.lInputType.setText("Meaning");
            this.tfInput.setDefaultText("Response");
            this.tfInput.setKanaMode(false);
            AudioModes audioModeTemp = !this.isPracticeMode() ? this.audioMode : this.practiceAudioToEN;
            if (audioModeTemp != AudioModes.OFF && !Main.isAKS() && this.currentReview.vocabAudio != null) {
                if (this.currentReview.reviewType == Review.ReviewType.UNSET) {
                    int rnd;
                    this.currentReview.reviewType = audioModeTemp == AudioModes.ALTERNATE ? ((rnd = MathUtils.random(1)) != 0 ? Review.ReviewType.AUDIO : Review.ReviewType.TEXT) : Review.ReviewType.AUDIO;
                }
            } else {
                this.currentReview.reviewType = Review.ReviewType.TEXT;
            }
            this.tblVocab.clearChildren();
            if (this.currentReview.reviewType == Review.ReviewType.AUDIO) {
                this.tblVocab.add(this.btnPlay).size(this.kanjiFontSize + this.kanaFontSize).row();
            } else {
                if (!KanaConverter.isKanaWord(this.currentReview.vocabKanji)) {
                    this.tblVocab.add(this.lVocabKana).height(this.kanaFontSize).padBottom(0.5f * (float)Main.getPPUY()).row();
                }
                this.tblVocab.add(this.lVocabKanji).height(this.kanjiFontSize).row();
            }
            if (!this.tblCustomSynonyms.hasParent()) {
                this.tblCustom.getCell(this.tblCustomReadings).setActor(this.tblCustomSynonyms);
            }
        } else {
            this.lInputType.setText("Reading");
            this.tfInput.setDefaultText("\u7b54\u3048");
            this.tfInput.setKanaMode(true);
            AudioModes audioModeTemp = !this.isPracticeMode() ? AudioModes.OFF : this.practiceAudioToJP;
            if (audioModeTemp != AudioModes.OFF && !Main.isAKS() && this.currentReview.vocabAudio != null) {
                if (this.currentReview.reviewType == Review.ReviewType.UNSET) {
                    int rnd;
                    this.currentReview.reviewType = audioModeTemp == AudioModes.ALTERNATE ? ((rnd = MathUtils.random(1)) != 0 ? Review.ReviewType.AUDIO : Review.ReviewType.TEXT) : Review.ReviewType.AUDIO;
                }
            } else {
                this.currentReview.reviewType = Review.ReviewType.TEXT;
            }
            this.tblVocab.clearChildren();
            if (this.currentReview.reviewType == Review.ReviewType.AUDIO) {
                this.tblVocab.add(this.btnPlay).size(this.kanjiFontSize + this.kanaFontSize).row();
                Main.playSound(this.currentReview.vocabAudio, null);
            } else {
                VisTable tblVocabEngPlusSynonyms = new VisTable(false);
                tblVocabEngPlusSynonyms.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
                tblVocabEngPlusSynonyms.add(this.lVocabEng).row();
                if (!this.lSynonyms.getText().toString().equals("")) {
                    tblVocabEngPlusSynonyms.add(this.lSynonyms).row();
                }
                this.tblVocab.add(tblVocabEngPlusSynonyms).expandY().fillY().row();
                if (!this.lPartOfSpeechShort.getText().toString().equals("")) {
                    this.tblVocab.add(this.lPartOfSpeechShort).padBottom((float)Main.getPPUY() / 2.0f).row();
                }
            }
            if (!this.tblCustomReadings.hasParent()) {
                this.tblCustom.getCell(this.tblCustomSynonyms).setActor(this.tblCustomReadings);
            }
        }
        if (this.table.getCell(this.collapsibleWidget) == null) {
            this.rebuildTable();
        }
        this.resetInfoTable();
        this.taNotes.setText(this.currentReview.notes);
        if (this.taNotes.getText().length() > StudyScreen.getCharLimitNotes()) {
            this.taNotes.setText(this.taNotes.getText().substring(0, StudyScreen.getCharLimitNotes()));
        }
        this.synonymsTemp = this.currentReview.synonyms != null ? this.currentReview.synonyms.split(";") : new String[0];
        this.listSynonyms.setItems(this.synonymsTemp);
        this.listSynonyms.setSelectedIndex(-1);
        this.readingsTemp = this.currentReview.readings != null ? this.currentReview.readings.split(";") : new String[0];
        this.listReadings.setItems(this.readingsTemp);
        this.listReadings.setSelectedIndex(-1);
        this.btnMeaning.setChecked(true);
        this.btnDetails.setChecked(false);
        this.btnCustom.setChecked(false);
        this.btnArchiveVocab.setDisabled(this.currentReview.id >= 10000);
        this.ignoreLastAnswer = false;
        this.skippedLastItem = false;
        this.archivedLastItem = false;
        this.isAlternativeSolution = false;
        this.btnInfo.setDisabled(true);
        this.btnIgnore.setDisabled(true);
        this.btnSkip.setDisabled(false);
        this.tfInput.setDisabled(false);
        this.tfInput.setColor(Color.WHITE);
        this.tfInput.clearText();
        this.tfInput.requestFocus();
        if (this.currentReview.reviewType == Review.ReviewType.AUDIO) {
            if (this.autoplayAudioSentence) {
                if (this.playAudioAtStart) {
                    Main.playSound(this.currentReview.vocabAudio, this.currentReview.sentenceAudio);
                }
            } else {
                Main.playSound(this.currentReview.vocabAudio, null);
            }
        } else if (this.currentReview.isReviewMeaning()) {
            if (this.playAudioAtStart) {
                if (this.autoplayAudio && this.autoplayAudioSentence) {
                    Main.playSound(this.currentReview.vocabAudio, this.currentReview.sentenceAudio);
                } else if (this.autoplayAudio) {
                    Main.playSound(this.currentReview.vocabAudio, null);
                } else {
                    Main.playSound(null, null);
                }
            } else {
                Main.playSound(null, null);
            }
        } else {
            Main.playSound(null, null);
        }
        this.userInputEnabled = true;
    }

    private void resetInfoTable() {
        String s = !this.isAlternativeSolution ? "Correct Answer:" : "Correct! But make sure to remember this reading, too:";
        VisTable temp = new VisTable();
        VisTable temp2 = new VisTable();
        VisLabel lDummy = new VisLabel((CharSequence)s, Main.labelStyleX1);
        temp.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        temp2.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
        lDummy.setWrap(true);
        lDummy.setAlignment(2);
        temp2.add(lDummy).width(this.stage.getViewport().getWorldWidth() * 0.95f);
        temp2.pack();
        this.tblTabbedPane.clearChildren();
        this.table.pack();
        float rest = this.collapsibleWidget.getY() - this.tblTabs.getHeight() - temp2.getHeight() - (float)Main.getPPUY();
        this.tblTabbedPane.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblTabbedPane.add(this.tblTabs).padBottom(Main.getPPUY()).row();
        temp.add(temp2).row();
        if (this.currentReview.isReviewMeaning()) {
            temp.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
            temp.add(this.lVocabEng).row();
            if (!this.lSynonyms.getText().toString().equals("")) {
                temp.add(this.lSynonyms).padBottom(Main.getPPUY() / 2).row();
            }
            this.lVocabKanji.getStyle().fontColor = Color.WHITE;
            this.lVocabKana.getStyle().fontColor = Color.WHITE;
            this.lVocabEng.setStyle(Main.labelStyleX2plus);
            this.lSynonyms.setStyle(Main.labelStyleX1);
        } else {
            temp.defaults().width(this.stage.getViewport().getWorldWidth());
            temp.add().padTop(2 * Main.getPPUY()).row();
            if (!KanaConverter.isKanaWord(this.currentReview.vocabKanji)) {
                temp.add(this.lVocabKana).height(this.kanaFontSize).padBottom(0.5f * (float)Main.getPPUY()).row();
            }
            temp.add(this.lVocabKanji).height(this.kanjiFontSize).padBottom(2 * Main.getPPUY()).row();
            this.lVocabKanji.getStyle().fontColor = Main.FONT;
            this.lVocabKana.getStyle().fontColor = Main.FONT;
            this.lVocabEng.setStyle(Main.labelStyleX2plus_w);
            this.lSynonyms.setStyle(Main.labelStyleX1_w);
        }
        VisScrollPane spInfo = new VisScrollPane((Actor)temp);
        spInfo.setFadeScrollBars(false);
        spInfo.setScrollingDisabled(true, false);
        this.tblTabbedPane.add(spInfo).height(rest).row();
        this.tblTabbedPane.addSeparator();
    }

    private void resetDetailsTable() {
        this.tblTabbedPane.clearChildren();
        this.table.pack();
        float rest = this.collapsibleWidget.getY() - this.tblTabs.getHeight() - (float)(2 * Main.getPPUY());
        this.tblTabbedPane.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblTabbedPane.add(this.tblTabs).padBottom(1 * Main.getPPUY()).row();
        this.tblTabbedPane.add(this.tblDetails).height(rest).row();
        this.tblTabbedPane.addSeparator();
    }

    private void resetNotesTable() {
        this.lCharCounter.addAction(Actions.fadeOut(0.0f));
        this.tblTabbedPane.clearChildren();
        this.table.pack();
        float rest = this.collapsibleWidget.getY() - this.tblTabs.getHeight() - (float)(2 * Main.getPPUY());
        this.tblTabbedPane.defaults().width(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.tblTabbedPane.add(this.tblTabs).padBottom(1 * Main.getPPUY()).row();
        this.tblTabbedPane.add(this.tblCustom).height(rest).row();
        this.tblTabbedPane.addSeparator();
    }

    private void showAddSynonymDialog() {
        Dialogs.showInputDialog(this.stage, "Add Synonym:", "", 25, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getDiacriticsChars() + "A-Za-z0-9\\' ]", "").replaceAll(" +", " ").trim().toLowerCase()).equals("")) {
                    return;
                }
                for (int x = 0; x < ReviewScreen.this.synonymsTemp.length; ++x) {
                    if (!ReviewScreen.this.synonymsTemp[x].equals(input)) continue;
                    Dialogs.showErrorDialog(ReviewScreen.this.stage, "Synonym already exists.");
                    return;
                }
                ((ReviewScreen)ReviewScreen.this).currentReview.synonyms = ((ReviewScreen)ReviewScreen.this).currentReview.synonyms != null ? ((ReviewScreen)ReviewScreen.this).currentReview.synonyms + input + ";" : input + ";";
                ReviewScreen.access$1602(ReviewScreen.this, ((ReviewScreen)ReviewScreen.this).currentReview.synonyms.split(";"));
                ReviewScreen.this.listSynonyms.setItems(ReviewScreen.this.synonymsTemp);
                ReviewScreen.this.listSynonyms.setSelectedIndex(-1);
            }
        });
    }

    private void showAddReadingDialog() {
        Dialogs.showInputDialog(this.stage, "Add Reading:", "", 15, false, true, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if ((input = input.trim().replaceAll("[^" + Main.getKanaChars() + "]+", "").trim()).equals("")) {
                    return;
                }
                for (int x = 0; x < ReviewScreen.this.readingsTemp.length; ++x) {
                    if (!ReviewScreen.this.readingsTemp[x].equals(input)) continue;
                    Dialogs.showErrorDialog(ReviewScreen.this.stage, "Reading already exists.");
                    return;
                }
                ((ReviewScreen)ReviewScreen.this).currentReview.readings = ((ReviewScreen)ReviewScreen.this).currentReview.readings != null ? ((ReviewScreen)ReviewScreen.this).currentReview.readings + input + ";" : input + ";";
                ReviewScreen.access$1902(ReviewScreen.this, ((ReviewScreen)ReviewScreen.this).currentReview.readings.split(";"));
                ReviewScreen.this.listReadings.setItems(ReviewScreen.this.readingsTemp);
                ReviewScreen.this.listReadings.setSelectedIndex(-1);
            }
        });
    }

    private void updateFlashButtonStyle() {
        Tooltip.removeTooltip(this.btnFlash);
        if (ReviewScreen.getLightningMode()) {
            this.btnFlash.setStyle(this.bsFlashFull);
            new Tooltip.Builder(" Disable Lightning Mode ").target(this.btnFlash).build();
        } else {
            this.btnFlash.setStyle(this.bsFlashEmpty);
            new Tooltip.Builder(" Enable Lightning Mode ").target(this.btnFlash).build();
        }
        this.tfInput.requestFocus();
    }

    private void updateFontButtonStyle() {
        Tooltip.removeTooltip(this.btnFont);
        if (this.lVocabKanji.getStyle() == this.styleKanji[0]) {
            this.btnFont.setStyle(this.bsFontEmpty);
            new Tooltip.Builder(" Enable Font Randomizer ").target(this.btnFont).build();
        } else {
            this.btnFont.setStyle(this.bsFontFull);
            new Tooltip.Builder(" Disable Font Randomizer ").target(this.btnFont).build();
        }
        this.btnFont.setDisabled(!ReviewScreen.getRandomizeFont());
        this.btnFont.setVisible(ReviewScreen.getRandomizeFont());
        if (!this.tfInput.isDisabled()) {
            this.tfInput.requestFocus();
        }
    }

    private void scaleFontsToFitOnScreen() {
        Label.LabelStyle kanjiStyle = this.lVocabKanji.getStyle() == this.styleKanji[0] ? this.styleKanji[0] : this.currentReview.getKanjiStyle();
        Label.LabelStyle kanaStyle = this.lVocabKana.getStyle() == this.styleKana[0] ? this.styleKana[0] : this.currentReview.getKanaStyle();
        kanjiStyle.font.getData().setScale(1.0f, 1.0f);
        VisLabel lDummy = new VisLabel((CharSequence)this.lVocabKanji.getText(), kanjiStyle);
        while (lDummy.getWidth() > this.stage.getViewport().getWorldWidth()) {
            kanjiStyle.font.getData().setScale(kanjiStyle.font.getScaleX() - 0.01f, kanjiStyle.font.getScaleY() - 0.01f);
            lDummy.pack();
        }
        kanaStyle.font.getData().setScale(1.0f, 1.0f);
        lDummy = new VisLabel((CharSequence)this.lVocabKana.getText(), kanaStyle);
        while (lDummy.getWidth() > this.stage.getViewport().getWorldWidth()) {
            kanaStyle.font.getData().setScale(kanaStyle.font.getScaleX() - 0.01f, kanaStyle.font.getScaleY() - 0.01f);
            lDummy.pack();
        }
    }

    private void setMainFont() {
        if (this.lVocabKanji.getStyle() != this.styleKanji[0]) {
            this.lVocabKanji.setStyle(this.styleKanji[0]);
            this.lVocabKana.setStyle(this.styleKana[0]);
            this.scaleFontsToFitOnScreen();
            this.updateFontButtonStyle();
        }
    }

    private void setRandomFont() {
        if (this.lVocabKanji.getStyle() != this.currentReview.getKanjiStyle()) {
            this.lVocabKanji.setStyle(this.currentReview.getKanjiStyle());
            this.lVocabKana.setStyle(this.currentReview.getKanaStyle());
            this.scaleFontsToFitOnScreen();
            this.updateFontButtonStyle();
        }
    }

    private void setActorListeners() {
        final ClickListener fontRandoListener = new ClickListener(1){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (ReviewScreen.getRandomizeFont() && (button == 1 || Main.isMobile())) {
                    float delay;
                    float f = delay = Main.isMobile() || event.getType() == InputEvent.Type.keyUp ? 0.25f : 0.0f;
                    if (!ReviewScreen.this.tfInput.isDisabled() && ReviewScreen.this.lVocabKanji.getStyle() != ReviewScreen.this.styleKanji[0]) {
                        ReviewScreen.this.suppressVocabAudioTimer = new Timer.Task(){

                            @Override
                            public void run() {
                                ReviewScreen.this.suppressVocabAudio = Main.isMobile();
                                ReviewScreen.this.setMainFont();
                            }
                        };
                        Timer.schedule(ReviewScreen.this.suppressVocabAudioTimer, delay, delay, 0);
                    } else if (ReviewScreen.this.tfInput.isDisabled() && ReviewScreen.this.lVocabKanji.getStyle() == ReviewScreen.this.styleKanji[0]) {
                        ReviewScreen.this.suppressVocabAudioTimer = new Timer.Task(){

                            @Override
                            public void run() {
                                ReviewScreen.this.suppressVocabAudio = Main.isMobile();
                                ReviewScreen.this.setRandomFont();
                            }
                        };
                        Timer.schedule(ReviewScreen.this.suppressVocabAudioTimer, delay, delay, 0);
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (ReviewScreen.getRandomizeFont() && (button == 1 || Main.isMobile())) {
                    ReviewScreen.this.suppressVocabAudioTimer.cancel();
                    if (!ReviewScreen.this.tfInput.isDisabled()) {
                        ReviewScreen.this.setRandomFont();
                    } else {
                        ReviewScreen.this.setMainFont();
                    }
                }
            }
        };
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyDown(InputEvent event, int keycode) {
                SettingsScreen.KeyBindingsHandler handler;
                if (!ReviewScreen.this.userInputEnabled) {
                    return false;
                }
                if (ReviewScreen.this.stage.getKeyboardFocus() != ReviewScreen.this.taNotes && !(handler = SettingsScreen.getKeyBindingsHandler()).isWindowVisible() && keycode == handler.getBind(SettingsScreen.KeyBindings.FONT)) {
                    InputEvent evt = new InputEvent();
                    evt.setType(InputEvent.Type.keyUp);
                    fontRandoListener.touchDown(evt, 0.0f, 0.0f, 0, 1);
                }
                return true;
            }

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                SettingsScreen.KeyBindingsHandler handler;
                if (!ReviewScreen.this.userInputEnabled) {
                    return false;
                }
                if (ReviewScreen.this.stage.getKeyboardFocus() != ReviewScreen.this.taNotes && !(handler = SettingsScreen.getKeyBindingsHandler()).isWindowVisible()) {
                    if (!ReviewScreen.this.collapsibleWidget.isCollapsed() && keycode == 22) {
                        if (ReviewScreen.this.btnMeaning.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnDetails);
                        } else if (ReviewScreen.this.btnDetails.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnCustom);
                        } else if (ReviewScreen.this.btnCustom.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnMeaning);
                        }
                    } else if (!ReviewScreen.this.collapsibleWidget.isCollapsed() && keycode == 21) {
                        if (ReviewScreen.this.btnMeaning.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnCustom);
                        } else if (ReviewScreen.this.btnDetails.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnMeaning);
                        } else if (ReviewScreen.this.btnCustom.isChecked()) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnDetails);
                        }
                    } else if (!ReviewScreen.this.collapsibleWidget.isCollapsed() && ReviewScreen.this.btnCustom.isChecked() && (keycode == 8 || keycode == 145 || keycode == 9 || keycode == 146 || keycode == 20 || keycode == 19)) {
                        if (ReviewScreen.this.currentReview.isReviewMeaning()) {
                            int index = ReviewScreen.this.listSynonyms.getSelectedIndex();
                            int size = ((ReviewScreen)ReviewScreen.this).listSynonyms.getItems().size;
                            switch (keycode) {
                                case 20: {
                                    if (index == -1) {
                                        if (size <= 0) break;
                                        ReviewScreen.this.listSynonyms.setSelectedIndex(0);
                                        break;
                                    }
                                    ReviewScreen.this.listSynonyms.setSelectedIndex(index + 1 == size ? 0 : index + 1);
                                    break;
                                }
                                case 19: {
                                    if (index == -1) {
                                        if (size <= 0) break;
                                        ReviewScreen.this.listSynonyms.setSelectedIndex(size - 1);
                                        break;
                                    }
                                    ReviewScreen.this.listSynonyms.setSelectedIndex(index - 1 == -1 ? size - 1 : index - 1);
                                    break;
                                }
                                case 8: 
                                case 145: {
                                    ReviewScreen.this.simulateClick(ReviewScreen.this.btnSynonymsAdd);
                                    break;
                                }
                                case 9: 
                                case 146: {
                                    ReviewScreen.this.simulateClick(ReviewScreen.this.btnSynonymsRemove);
                                }
                            }
                        } else {
                            int index = ReviewScreen.this.listReadings.getSelectedIndex();
                            int size = ((ReviewScreen)ReviewScreen.this).listReadings.getItems().size;
                            switch (keycode) {
                                case 20: {
                                    if (index == -1) {
                                        if (size <= 0) break;
                                        ReviewScreen.this.listReadings.setSelectedIndex(0);
                                        break;
                                    }
                                    ReviewScreen.this.listReadings.setSelectedIndex(index + 1 == size ? 0 : index + 1);
                                    break;
                                }
                                case 19: {
                                    if (index == -1) {
                                        if (size <= 0) break;
                                        ReviewScreen.this.listReadings.setSelectedIndex(size - 1);
                                        break;
                                    }
                                    ReviewScreen.this.listReadings.setSelectedIndex(index - 1 == -1 ? size - 1 : index - 1);
                                    break;
                                }
                                case 8: 
                                case 145: {
                                    ReviewScreen.this.simulateClick(ReviewScreen.this.btnReadingsAdd);
                                    break;
                                }
                                case 9: 
                                case 146: {
                                    ReviewScreen.this.simulateClick(ReviewScreen.this.btnReadingsRemove);
                                }
                            }
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.CONFIRM)) {
                        if (handler.validateKey(keycode)) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnNext);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.IGNORE)) {
                        if (handler.validateKey(keycode)) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnIgnore);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.INFO)) {
                        if (handler.validateKey(keycode)) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnInfo);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.FURIGANA)) {
                        if (handler.validateKey(keycode)) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.lVocabKana);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.SKIP)) {
                        if (handler.validateKey(keycode)) {
                            ReviewScreen.this.simulateClick(ReviewScreen.this.btnSkip);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.VOCAB_AUDIO)) {
                        if ((ReviewScreen.this.currentReview.isReviewMeaning() || ReviewScreen.this.tfInput.isDisabled()) && handler.validateKey(keycode)) {
                            if (handler.getBind(SettingsScreen.KeyBindings.VOCAB_AUDIO) == handler.getBind(SettingsScreen.KeyBindings.SENTENCE_AUDIO)) {
                                Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, ((ReviewScreen)ReviewScreen.this).currentReview.sentenceAudio);
                            } else {
                                Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, null);
                            }
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.SENTENCE_AUDIO)) {
                        if ((ReviewScreen.this.currentReview.isReviewMeaning() || ReviewScreen.this.tfInput.isDisabled()) && handler.validateKey(keycode)) {
                            Main.playSound(null, ((ReviewScreen)ReviewScreen.this).currentReview.sentenceAudio);
                        }
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.FONT)) {
                        InputEvent evt = new InputEvent();
                        evt.setType(InputEvent.Type.keyUp);
                        fontRandoListener.touchUp(evt, 0.0f, 0.0f, 0, 1);
                    } else if (keycode == handler.getBind(SettingsScreen.KeyBindings.ARCHIVE) && handler.validateKey(keycode)) {
                        ReviewScreen.this.simulateClick(ReviewScreen.this.btnArchiveVocab);
                    }
                }
                return true;
            }
        });
        this.lVocabKana.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (ReviewScreen.this.lVocabKana.getText().toString().equals(ReviewScreen.this.placeholder)) {
                    ReviewScreen.this.lVocabKana.setText(((ReviewScreen)ReviewScreen.this).currentReview.vocabKana);
                } else {
                    ReviewScreen.this.lVocabKana.setText(ReviewScreen.this.placeholder);
                }
                ReviewScreen.this.scaleFontsToFitOnScreen();
            }
        });
        this.lVocabKanji.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (this.getTapCount() == 1 && !ReviewScreen.this.suppressVocabAudio) {
                    Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, null);
                } else if (this.getTapCount() == 2 && !ReviewScreen.this.suppressVocabAudio) {
                    Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, ((ReviewScreen)ReviewScreen.this).currentReview.sentenceAudio);
                } else if (ReviewScreen.this.suppressVocabAudio) {
                    ReviewScreen.this.suppressVocabAudio = false;
                }
            }
        });
        this.lVocabKanji.addListener(fontRandoListener);
        this.lVocabKana.addListener(fontRandoListener);
        this.lSentence.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Main.playSound(null, ((ReviewScreen)ReviewScreen.this).currentReview.sentenceAudio);
            }
        });
        this.tfInput.addListener(new ClickListener(){

            @Override
            public boolean keyTyped(InputEvent event, char character) {
                if (Character.isSpaceChar(character)) {
                    String input = ReviewScreen.this.tfInput.getText();
                    if (input.length() > 1) {
                        if (Character.isSpaceChar(input.charAt(input.length() - 1)) && Character.isSpaceChar(input.charAt(input.length() - 2))) {
                            ReviewScreen.this.tfInput.setText(input.substring(0, input.length() - 1));
                            ReviewScreen.this.tfInput.setCursorAtTextEnd();
                        }
                    } else {
                        ReviewScreen.this.tfInput.clearText();
                    }
                } else if (ReviewScreen.this.isHyperjumpModeEnabled && Character.isAlphabetic(character)) {
                    ReviewScreen.this.verifyInput(true);
                }
                return true;
            }

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111) {
                    ReviewScreen.this.tfInput.clearText();
                }
                return true;
            }
        });
        this.btnArchiveVocab.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnArchiveVocab.isDisabled()) {
                    ReviewScreen.this.stage.unfocusAll();
                    Gdx.input.setOnscreenKeyboardVisible(false);
                    RestClient.archiveVocab(((ReviewScreen)ReviewScreen.this).currentReview.vocabKanji, ((ReviewScreen)ReviewScreen.this).currentReview.id, true);
                    if (!Main.isMobile()) {
                        ReviewScreen.this.tfInput.requestFocus();
                    }
                }
            }
        });
        this.btnPlus.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                ReviewScreen.this.stage.unfocusAll();
                Gdx.input.setOnscreenKeyboardVisible(false);
                if (Main.isPrime()) {
                    if (ReviewScreen.this.table.getCell(ReviewScreen.this.collapsibleWidget) != null) {
                        ReviewScreen.this.stage.unfocusAll();
                        Gdx.input.setOnscreenKeyboardVisible(false);
                        ReviewScreen.this.plt.setVocab(((ReviewScreen)ReviewScreen.this).currentReview.id);
                        if (!ReviewScreen.this.collapsibleWidget.isCollapsed()) {
                            ReviewScreen.this.btnInfo.getImage().setOrigin(1);
                            ReviewScreen.this.btnInfo.getImage().addAction(Actions.rotateBy(180.0f, 0.1f));
                            ReviewScreen.this.collapsibleWidget.setCollapsed(true, false);
                        }
                        ReviewScreen.this.table.getCell(ReviewScreen.this.collapsibleWidget).setActor(ReviewScreen.this.plt).width(ReviewScreen.this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fill().padTop(0.5f * (float)Main.getPPUY());
                        ReviewScreen.this.plt.refreshData();
                    }
                } else {
                    Dialogs.showOKDialog(ReviewScreen.this.stage, "Uh-oh", "Practice Lists are a Prime feature. To learn more, click the 'Go Prime' button on the dashboard.");
                }
            }
        });
        this.btnFlash.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                ReviewScreen.setLightningMode(!ReviewScreen.getLightningMode());
                ReviewScreen.this.updateFlashButtonStyle();
                RestClient.updateSettings();
            }
        });
        this.btnFont.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (ReviewScreen.this.lVocabKanji.getStyle() == ReviewScreen.this.styleKanji[0]) {
                    ReviewScreen.this.setRandomFont();
                } else {
                    ReviewScreen.this.setMainFont();
                }
            }
        });
        this.btnKeybinds.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnKeybinds.isDisabled()) {
                    SettingsScreen.getKeyBindingsHandler().show(ReviewScreen.this.stage);
                }
            }
        });
        this.btnPlay.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (this.getTapCount() == 1) {
                    Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, null);
                } else if (this.getTapCount() == 2) {
                    Main.playSound(((ReviewScreen)ReviewScreen.this).currentReview.vocabAudio, ((ReviewScreen)ReviewScreen.this).currentReview.sentenceAudio);
                }
                ReviewScreen.this.tfInput.requestFocus();
            }
        });
        this.btnInfo.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnInfo.isDisabled()) {
                    ReviewScreen.this.stage.unfocusAll();
                    Gdx.input.setOnscreenKeyboardVisible(false);
                    if (ReviewScreen.this.table.getCell(ReviewScreen.this.collapsibleWidget) == null) {
                        ReviewScreen.this.rebuildTable();
                    }
                    ReviewScreen.this.btnInfo.getImage().setOrigin(1);
                    ReviewScreen.this.btnInfo.getImage().addAction(Actions.rotateBy(180.0f, 0.1f));
                    ReviewScreen.this.collapsibleWidget.setCollapsed(!ReviewScreen.this.collapsibleWidget.isCollapsed(), true);
                }
            }
        });
        this.btnSkip.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnSkip.isDisabled()) {
                    ReviewScreen.this.isLastAnswerCorrect = false;
                    ReviewScreen.this.skippedLastItem = true;
                    ReviewScreen.this.nextReview();
                }
            }
        });
        this.btnIgnore.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnIgnore.isDisabled()) {
                    ReviewScreen.this.ignoreLastAnswer = !ReviewScreen.this.ignoreLastAnswer;
                    if (ReviewScreen.this.ignoreLastAnswer) {
                        ReviewScreen.this.tfInput.setColor(ReviewScreen.this.COLOR_IGNORE);
                    } else if (ReviewScreen.this.isLastAnswerCorrect) {
                        ReviewScreen.this.tfInput.setColor(ReviewScreen.this.COLOR_CORRECT);
                    } else {
                        ReviewScreen.this.tfInput.setColor(ReviewScreen.this.COLOR_WRONG);
                    }
                }
            }
        });
        this.btnNext.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!ReviewScreen.this.btnNext.isDisabled()) {
                    ReviewScreen.this.btnNext.setDisabled(true);
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            ReviewScreen.this.btnNext.setDisabled(false);
                        }
                    }, 0.25f, 0.25f, 0);
                    String content = ReviewScreen.this.tfInput.getText().trim();
                    if (!content.equals("")) {
                        if (!ReviewScreen.this.currentReview.isReviewMeaning()) {
                            if (content.charAt(content.length() - 1) == 'n') {
                                content = content.replace("n", "\u3093");
                            } else if (content.charAt(content.length() - 1) == 'N') {
                                content = content.replace("N", "\u30f3");
                            }
                            ReviewScreen.this.tfInput.setText(content);
                        }
                        if (!ReviewScreen.this.currentReview.isReviewMeaning() && !content.matches("[" + Main.getKanaChars() + "]+") || ReviewScreen.this.currentReview.isReviewMeaning() && !content.matches("[" + Main.getDiacriticsChars() + "a-zA-Z0-9 '\\(\\-\\)\\.]+")) {
                            int cursorPos = ReviewScreen.this.tfInput.getCursorPosition();
                            ReviewScreen.this.tfInput.requestFocus();
                            ReviewScreen.this.tfInput.setCursorPosition(cursorPos);
                            ReviewScreen.this.tfInput.addAction(Actions.sequence((Action)Actions.fadeOut(0.1f), (Action)Actions.fadeIn(0.1f), (Action)Actions.fadeOut(0.1f), (Action)Actions.fadeIn(0.1f)));
                        } else if (!ReviewScreen.this.tfInput.isDisabled()) {
                            ReviewScreen.this.verifyInput();
                        } else {
                            ReviewScreen.this.validateInput();
                        }
                    } else {
                        ReviewScreen.this.tfInput.clearText();
                        ReviewScreen.this.tfInput.requestFocus();
                        ReviewScreen.this.tfInput.addAction(Actions.sequence((Action)Actions.fadeOut(0.1f), (Action)Actions.fadeIn(0.1f), (Action)Actions.fadeOut(0.1f), (Action)Actions.fadeIn(0.1f)));
                    }
                }
            }
        });
        this.btnMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!(ReviewScreen.this.btnMeaning.isChecked() || ReviewScreen.this.btnDetails.isChecked() || ReviewScreen.this.btnCustom.isChecked())) {
                    ReviewScreen.this.btnMeaning.setChecked(true);
                } else {
                    ReviewScreen.this.btnDetails.setChecked(false);
                    ReviewScreen.this.btnCustom.setChecked(false);
                    ReviewScreen.this.resetInfoTable();
                }
            }
        });
        this.btnDetails.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!(ReviewScreen.this.btnMeaning.isChecked() || ReviewScreen.this.btnDetails.isChecked() || ReviewScreen.this.btnCustom.isChecked())) {
                    ReviewScreen.this.btnDetails.setChecked(true);
                } else {
                    ReviewScreen.this.btnMeaning.setChecked(false);
                    ReviewScreen.this.btnCustom.setChecked(false);
                    ReviewScreen.this.resetDetailsTable();
                }
            }
        });
        this.btnCustom.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (!(ReviewScreen.this.btnMeaning.isChecked() || ReviewScreen.this.btnDetails.isChecked() || ReviewScreen.this.btnCustom.isChecked())) {
                    ReviewScreen.this.btnCustom.setChecked(true);
                } else {
                    ReviewScreen.this.btnMeaning.setChecked(false);
                    ReviewScreen.this.btnDetails.setChecked(false);
                    ReviewScreen.this.resetNotesTable();
                }
            }
        });
        this.btnSynonymsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (ReviewScreen.this.synonymsTemp.length < 5) {
                    if (Hints.getHintAddSynonym()) {
                        Hints.showAddSynonymHint(ReviewScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                ReviewScreen.this.showAddSynonymDialog();
                            }
                        });
                    } else {
                        ReviewScreen.this.showAddSynonymDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(ReviewScreen.this.stage, "Sorry, only 5 Synonyms allowed.");
                }
            }
        });
        this.btnSynonymsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (ReviewScreen.this.listSynonyms.getSelectedIndex() > -1) {
                    ((ReviewScreen)ReviewScreen.this).currentReview.synonyms = ((ReviewScreen)ReviewScreen.this).currentReview.synonyms.replace(ReviewScreen.this.listSynonyms.getSelected() + ";", "");
                    if (((ReviewScreen)ReviewScreen.this).currentReview.synonyms.equals("")) {
                        ((ReviewScreen)ReviewScreen.this).currentReview.synonyms = null;
                    }
                    if (((ReviewScreen)ReviewScreen.this).currentReview.synonyms != null) {
                        ReviewScreen.access$1602(ReviewScreen.this, ((ReviewScreen)ReviewScreen.this).currentReview.synonyms.split(";"));
                    } else {
                        ReviewScreen.access$1602(ReviewScreen.this, new String[0]);
                    }
                    ReviewScreen.this.listSynonyms.setItems(ReviewScreen.this.synonymsTemp);
                    ReviewScreen.this.listSynonyms.setSelectedIndex(-1);
                }
            }
        });
        this.btnReadingsAdd.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (ReviewScreen.this.readingsTemp.length < 5) {
                    if (Hints.getHintAddReading()) {
                        Hints.showAddReadingHint(ReviewScreen.this.stage, new Dialogs.HintAdapter(){

                            @Override
                            public void finished() {
                                ReviewScreen.this.showAddReadingDialog();
                            }
                        });
                    } else {
                        ReviewScreen.this.showAddReadingDialog();
                    }
                } else {
                    Dialogs.showErrorDialog(ReviewScreen.this.stage, "Sorry, only 5 Readings allowed.");
                }
            }
        });
        this.btnReadingsRemove.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                if (ReviewScreen.this.listReadings.getSelectedIndex() > -1) {
                    ((ReviewScreen)ReviewScreen.this).currentReview.readings = ((ReviewScreen)ReviewScreen.this).currentReview.readings.replace(ReviewScreen.this.listReadings.getSelected() + ";", "");
                    if (((ReviewScreen)ReviewScreen.this).currentReview.readings.equals("")) {
                        ((ReviewScreen)ReviewScreen.this).currentReview.readings = null;
                    }
                    if (((ReviewScreen)ReviewScreen.this).currentReview.readings != null) {
                        ReviewScreen.access$1902(ReviewScreen.this, ((ReviewScreen)ReviewScreen.this).currentReview.readings.split(";"));
                    } else {
                        ReviewScreen.access$1902(ReviewScreen.this, new String[0]);
                    }
                    ReviewScreen.this.listReadings.setItems(ReviewScreen.this.readingsTemp);
                    ReviewScreen.this.listReadings.setSelectedIndex(-1);
                }
            }
        });
        this.taNotes.setTextFieldListener(new VisTextField.TextFieldListener(){

            @Override
            public void keyTyped(VisTextField textField, char key) {
                if (!ReviewScreen.this.userInputEnabled) {
                    return;
                }
                int cursorPos = textField.getCursorPosition();
                String content = textField.getText().replaceAll(" +", " ").replaceAll("\n+", "\n");
                if (content.length() > 0 && content.charAt(0) == '\n') {
                    content = content.replaceFirst("\n", "");
                }
                if (content.length() > StudyScreen.getCharLimitNotes()) {
                    content = content.substring(0, StudyScreen.getCharLimitNotes());
                }
                ((ReviewScreen)ReviewScreen.this).currentReview.notes = content;
                textField.setText(content);
                textField.setCursorPosition(cursorPos);
                ReviewScreen.this.lCharCounter.addAction(Actions.fadeIn(0.0f));
                ReviewScreen.this.lCharCounter.setText(content.length() + "/" + StudyScreen.getCharLimitNotes());
                if (ReviewScreen.this.charCounterTimer.isScheduled()) {
                    ReviewScreen.this.charCounterTimer.cancel();
                }
                Timer.schedule(ReviewScreen.this.charCounterTimer, 2.0f, 2.0f, 0);
            }
        });
    }

    private boolean checkTypos(CharSequence source, CharSequence target) {
        int threshold = source.length() <= 3 ? 0 : (source.length() > 3 && source.length() <= 6 ? 1 : 2);
        return this.calculateDistance(source, target) <= threshold;
    }

    private void verifyInput() {
        this.verifyInput(false);
    }

    private void verifyInput(boolean backgroundCheck) {
        String input = this.tfInput.getText().trim().toLowerCase();
        if (!this.currentReview.isReviewMeaning()) {
            String readingKana = this.currentReview.vocabKana.trim();
            String readingKanji = this.currentReview.vocabKanji.trim();
            char[] readingChar = readingKana.toCharArray();
            for (int s = 0; s < readingChar.length; ++s) {
                if (!KanaConverter.isKatakana(readingChar[s]) || readingChar[s] == '\u30fc' || readingChar[s] == '\uff01') continue;
                readingChar[s] = KanaConverter.toHiragana(readingChar[s]);
            }
            String readingAsHiragana = String.valueOf(readingChar);
            char[] inputChar = input.toCharArray();
            for (int s = 0; s < inputChar.length; ++s) {
                if (!KanaConverter.isKatakana(inputChar[s]) || inputChar[s] == '\u30fc' || inputChar[s] == '\uff01') continue;
                inputChar[s] = KanaConverter.toHiragana(inputChar[s]);
            }
            String inputAsHiragana = String.valueOf(inputChar);
            this.isLastAnswerCorrect = inputAsHiragana.equals(readingAsHiragana) || input.equals(readingKanji);
            if (!this.isLastAnswerCorrect && this.currentReview.altReadings != null) {
                String[] alternativeReadings = this.currentReview.altReadings.split(",");
                for (int y = 0; y < alternativeReadings.length; ++y) {
                    alternativeReadings[y] = alternativeReadings[y].trim();
                    if (!input.equals(alternativeReadings[y])) continue;
                    this.isLastAnswerCorrect = true;
                    this.isAlternativeSolution = true;
                    break;
                }
            }
            if (!this.isLastAnswerCorrect && this.currentReview.readings != null) {
                String[] customReadings = this.currentReview.readings.split(";");
                for (int z = 0; z < customReadings.length; ++z) {
                    customReadings[z] = customReadings[z].trim();
                    if (!input.equals(customReadings[z])) continue;
                    this.isLastAnswerCorrect = true;
                    this.isAlternativeSolution = true;
                    break;
                }
            }
        } else {
            String meaningsCombined = this.currentReview.altMeanings == null ? this.currentReview.meaning : this.currentReview.meaning + "," + this.currentReview.altMeanings;
            boolean isOutsideBrackets = true;
            char[] chMeanings = meaningsCombined.toCharArray();
            for (int z = 0; z < chMeanings.length; ++z) {
                if (chMeanings[z] == '(') {
                    isOutsideBrackets = false;
                    continue;
                }
                if (chMeanings[z] == ')') {
                    isOutsideBrackets = true;
                    continue;
                }
                if (chMeanings[z] != ',' || isOutsideBrackets) continue;
                chMeanings[z] = 124;
            }
            meaningsCombined = String.valueOf(chMeanings);
            String[] meanings = meaningsCombined.toLowerCase().split(",");
            if (input.startsWith("the ")) {
                input = input.substring(4);
            } else if (input.startsWith("to ")) {
                input = input.substring(3);
            } else if (input.startsWith("a ")) {
                input = input.substring(2);
            } else if (input.startsWith("0 ")) {
                input = input.replaceFirst("0 ", "zero ");
            } else if (input.startsWith("1st ")) {
                input = input.replaceFirst("1st ", "first ");
            } else if (input.startsWith("100000000 ")) {
                input = input.replaceFirst("100000000 ", "hundred million ");
            } else if (input.startsWith("10000 ")) {
                input = input.replaceFirst("10000 ", "ten thousand ");
            } else if (input.startsWith("1000 ")) {
                input = input.replaceFirst("1000 ", "thousand ");
            } else if (input.startsWith("100 ")) {
                input = input.replaceFirst("100 ", "hundred ");
            } else if (input.startsWith("10th")) {
                input = input.replaceFirst("10th", "tenth");
            } else if (input.startsWith("10 ")) {
                input = input.replaceFirst("10 ", "ten ");
            } else if (input.startsWith("1 ")) {
                input = input.replaceFirst("1 ", "one ");
            } else if (input.startsWith("20th")) {
                input = input.replaceFirst("20th", "twentieth");
            } else if (input.startsWith("20 ")) {
                input = input.replaceFirst("20 ", "twenty ");
            } else if (input.startsWith("2nd")) {
                input = input.replaceFirst("2nd", "second");
            } else if (input.startsWith("2 ")) {
                input = input.replaceFirst("2 ", "two ");
            } else if (input.startsWith("3rd")) {
                input = input.replaceFirst("3rd", "third");
            } else if (input.startsWith("3 ")) {
                input = input.replaceFirst("3 ", "three ");
            } else if (input.startsWith("4th")) {
                input = input.replaceFirst("4th", "fourth");
            } else if (input.startsWith("4 ")) {
                input = input.replaceFirst("4 ", "four ");
            } else if (input.startsWith("5th")) {
                input = input.replaceFirst("5th", "fifth");
            } else if (input.startsWith("5 ")) {
                input = input.replaceFirst("5 ", "five ");
            } else if (input.startsWith("6th")) {
                input = input.replaceFirst("6th", "sixth");
            } else if (input.startsWith("6 ")) {
                input = input.replaceFirst("6 ", "six ");
            } else if (input.startsWith("7th")) {
                input = input.replaceFirst("7th", "seventh");
            } else if (input.startsWith("7 ")) {
                input = input.replaceFirst("7 ", "seven ");
            } else if (input.startsWith("8th")) {
                input = input.replaceFirst("8th", "eight");
            } else if (input.startsWith("8 ")) {
                input = input.replaceFirst("8 ", "eight ");
            } else if (input.startsWith("9th")) {
                input = input.replaceFirst("9th", "ninth");
            } else if (input.startsWith("9 ")) {
                input = input.replaceFirst("9 ", "nine ");
            }
            input = input.replaceAll("[^A-Za-z0-9]", "").trim();
            for (int z = 0; z < meanings.length; ++z) {
                meanings[z] = meanings[z].trim();
                if (meanings[z].startsWith("the ")) {
                    meanings[z] = meanings[z].substring(4);
                } else if (meanings[z].startsWith("to ")) {
                    meanings[z] = meanings[z].substring(3);
                } else if (meanings[z].startsWith("a ")) {
                    meanings[z] = meanings[z].substring(2);
                }
                meanings[z] = meanings[z].replaceAll("[^A-Za-z0-9\\(\\)]", "").trim();
                if (meanings[z].contains("(")) {
                    String insideBrackets = meanings[z].substring(meanings[z].indexOf("(") + 1, meanings[z].indexOf(")"));
                    String outsideBrackets = meanings[z].replace("(" + insideBrackets + ")", "").trim();
                    if (!backgroundCheck) {
                        if (this.checkTypos(meanings[z], input) || this.checkTypos(outsideBrackets, input) || this.checkTypos(outsideBrackets + insideBrackets, input) || this.checkTypos(insideBrackets + outsideBrackets, input)) {
                            this.isLastAnswerCorrect = true;
                            break;
                        }
                        this.isLastAnswerCorrect = false;
                        continue;
                    }
                    if (input.equals(meanings[z]) || input.equals(outsideBrackets) || input.equals(outsideBrackets + insideBrackets) || input.equals(insideBrackets + outsideBrackets)) {
                        this.isLastAnswerCorrect = true;
                        break;
                    }
                    this.isLastAnswerCorrect = false;
                    continue;
                }
                if (!backgroundCheck) {
                    if (this.checkTypos(meanings[z], input)) {
                        this.isLastAnswerCorrect = true;
                        break;
                    }
                    this.isLastAnswerCorrect = false;
                    continue;
                }
                if (input.equals(meanings[z])) {
                    this.isLastAnswerCorrect = true;
                    break;
                }
                this.isLastAnswerCorrect = false;
            }
            if (!this.isLastAnswerCorrect && this.currentReview.synonyms != null) {
                String[] synonyms = this.currentReview.synonyms.split(";");
                for (int z = 0; z < synonyms.length; ++z) {
                    if (synonyms[z].startsWith("the ")) {
                        synonyms[z] = synonyms[z].substring(4);
                    } else if (synonyms[z].startsWith("to ")) {
                        synonyms[z] = synonyms[z].substring(3);
                    } else if (synonyms[z].startsWith("a ")) {
                        synonyms[z] = synonyms[z].substring(2);
                    }
                    synonyms[z] = synonyms[z].replaceAll("[^A-Za-z0-9\\(\\)]", "").trim();
                    if (!backgroundCheck) {
                        if (!this.checkTypos(synonyms[z], input)) continue;
                        this.isLastAnswerCorrect = true;
                    } else {
                        if (!input.equals(synonyms[z])) continue;
                        this.isLastAnswerCorrect = true;
                    }
                    break;
                }
            }
        }
        if (!backgroundCheck || this.isLastAnswerCorrect) {
            Color color = this.isLastAnswerCorrect ? this.COLOR_CORRECT : this.COLOR_WRONG;
            if (!this.isLastAnswerCorrect && this.autoExpandDetailsAfterWrongAnswer || this.isAlternativeSolution) {
                if (this.table.getCell(this.collapsibleWidget) == null) {
                    this.rebuildTable();
                }
                this.resetInfoTable();
                Gdx.input.setOnscreenKeyboardVisible(false);
                this.btnInfo.getImage().setOrigin(1);
                this.btnInfo.getImage().addAction(Actions.rotateBy(180.0f, 0.1f));
                this.collapsibleWidget.setCollapsed(false, true);
            }
            this.btnInfo.setDisabled(false);
            this.btnIgnore.setDisabled(false);
            this.btnSkip.setDisabled(true);
            this.tfInput.setDisabled(true);
            this.tfInput.setColor(color);
            if (ReviewScreen.getRandomizeFont()) {
                this.setMainFont();
            }
            boolean kanaHidden = this.lVocabKana.getText().toString().equals(this.placeholder);
            boolean kanaOnly = this.currentReview.vocabKanji.equals(this.currentReview.vocabKana);
            if ((!this.isLightningModeEnabled || !this.isLastAnswerCorrect || this.isAlternativeSolution) && this.playAudioAtEnd) {
                if (!this.currentReview.isReviewMeaning() || kanaHidden && !kanaOnly) {
                    if (this.autoplayAudio && this.autoplayAudioSentence) {
                        Main.playSound(this.currentReview.vocabAudio, this.currentReview.sentenceAudio);
                    } else if (this.autoplayAudio) {
                        Main.playSound(this.currentReview.vocabAudio, null);
                    } else {
                        Main.playSound(null, null);
                    }
                }
            } else if (!this.isLastAnswerCorrect && this.playAudioOnWrongAnswer && (!this.currentReview.isReviewMeaning() || kanaHidden && !kanaOnly)) {
                if (this.autoplayAudio && this.autoplayAudioSentence) {
                    Main.playSound(this.currentReview.vocabAudio, this.currentReview.sentenceAudio);
                } else if (this.autoplayAudio) {
                    Main.playSound(this.currentReview.vocabAudio, null);
                } else {
                    Main.playSound(null, null);
                }
            }
            if (this.showKanaAfterAnswer) {
                this.lVocabKana.setText(this.currentReview.vocabKana);
            }
        }
        if (this.isLastAnswerCorrect && !this.isAlternativeSolution && this.isLightningModeEnabled) {
            this.validateInput();
        }
    }

    private void validateInput() {
        if (!this.ignoreLastAnswer) {
            this.currentReview.answer = this.isLastAnswerCorrect ? (this.currentReview.answer += 2) : 0;
            boolean updateDB = false;
            if (this.isLessonMode) {
                if (this.currentReview.answer > 0 && this.getCurrentReviewSibling().answer > 0) {
                    updateDB = true;
                }
            } else if (this.currentReview.answer > 0) {
                updateDB = true;
            }
            if (updateDB) {
                if (!this.currentReview.streakUpdatedOnce) {
                    this.currentReview.streakUpdatedOnce = true;
                    if (this.currentReview.answer == 1) {
                        if (this.currentReview.getStreak() < 9) {
                            this.currentReview.setStreak(this.currentReview.getStreak() + 1);
                        }
                        this.currentReview.isAnsweredCorrectly = true;
                    } else {
                        if (this.currentReview.getStreak() <= 4) {
                            this.currentReview.setStreak(this.currentReview.getStreak() - 1);
                        } else {
                            this.currentReview.setStreak(this.currentReview.getStreak() - 2);
                        }
                        if (this.currentReview.getStreak() < 1) {
                            this.currentReview.setStreak(1);
                        }
                        this.currentReview.isAnsweredCorrectly = false;
                    }
                }
                if (this.currentReview.getStreak() > 0 && this.currentReview.getStreak() < 5) {
                    this.tex = this.currentReview.isAnsweredCorrectly ? (Texture)Main.getAsset(Main.ROOKIE_UP_PATH, Texture.class, true) : (Texture)Main.getAsset(Main.ROOKIE_DOWN_PATH, Texture.class, true);
                } else if (this.currentReview.getStreak() == 5 || this.currentReview.getStreak() == 6) {
                    this.tex = this.currentReview.isAnsweredCorrectly ? (Texture)Main.getAsset(Main.AMATEUR_UP_PATH, Texture.class, true) : (Texture)Main.getAsset(Main.AMATEUR_DOWN_PATH, Texture.class, true);
                } else if (this.currentReview.getStreak() == 7) {
                    this.tex = this.currentReview.isAnsweredCorrectly ? (Texture)Main.getAsset(Main.EXPERT_UP_PATH, Texture.class, true) : (Texture)Main.getAsset(Main.EXPERT_DOWN_PATH, Texture.class, true);
                } else if (this.currentReview.getStreak() == 8) {
                    this.tex = this.currentReview.isAnsweredCorrectly ? (Texture)Main.getAsset(Main.MASTER_UP_PATH, Texture.class, true) : (Texture)Main.getAsset(Main.MASTER_DOWN_PATH, Texture.class, true);
                } else if (this.currentReview.getStreak() == 9) {
                    this.tex = this.currentReview.isAnsweredCorrectly ? (Texture)Main.getAsset(Main.SENSEI_UP_PATH, Texture.class, true) : (Texture)Main.getAsset(Main.SENSEI_DOWN_PATH, Texture.class, true);
                }
                if (!this.isLessonMode && !this.isPracticeMode()) {
                    this.addToItemsBeingSynced(this.currentReview.id);
                    RestClient.updateVocab(reviewScreen, this.currentReview.id, this.currentReview.streakMeaning, this.currentReview.streakReading, this.currentReview.synonyms, this.currentReview.readings, this.currentReview.notes, this.isLessonMode);
                } else if (this.isLessonMode && !this.isPracticeMode()) {
                    this.addToItemsBeingSynced(this.currentReview.id);
                    RestClient.updateVocab(reviewScreen, this.currentReview.id, 1, 1, this.currentReview.synonyms, this.currentReview.readings, this.currentReview.notes, this.isLessonMode);
                } else {
                    String notesOriginal;
                    String synonyms = this.currentReview.synonyms != null ? this.currentReview.synonyms : "";
                    String readings = this.currentReview.readings != null ? this.currentReview.readings : "";
                    String notes = this.currentReview.notes != null ? this.currentReview.notes : "";
                    String synonymsOriginal = this.currentReview.synonymsOrg != null ? this.currentReview.synonymsOrg : "";
                    String readingsOriginal = this.currentReview.readingsOrg != null ? this.currentReview.readingsOrg : "";
                    String string = notesOriginal = this.currentReview.notesOrg != null ? this.currentReview.notesOrg : "";
                    if (!(synonyms.equals(synonymsOriginal) && readings.equals(readingsOriginal) && notes.equals(notesOriginal))) {
                        synonyms = synonyms.equals("") ? null : synonyms;
                        readings = readings.equals("") ? null : readings;
                        notes = notes.equals("") ? null : notes;
                        RestClient.updateVocab(reviewScreen, this.currentReview.id, -1, -1, synonyms, readings, notes, this.isLessonMode);
                    }
                }
                this.removeMapItemAndGoToNextReview();
            } else {
                this.nextReview();
            }
        } else {
            this.isLastAnswerCorrect = false;
            this.nextReview();
        }
    }

    private int getCurrentReviewSiblingID() {
        if (this.currentReviewId >= this.noOfReviews / 2) {
            return this.currentReviewId - this.noOfReviews / 2;
        }
        return this.currentReviewId + this.noOfReviews / 2;
    }

    private Review getCurrentReviewSibling() {
        return this.reviewsList.get(this.getCurrentReviewSiblingID());
    }

    private void simulateClick(Actor actor) {
        try {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            actor.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            actor.fire(ie);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private Vector2 getStageLocation(Actor actor) {
        return actor.localToStageCoordinates(new Vector2(0.0f, 0.0f));
    }

    private int calculateDistance(CharSequence source, CharSequence target) {
        int i;
        if (source == null || target == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int[][] dist = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i < sourceLength + 1; ++i) {
            dist[i][0] = i;
        }
        for (int j = 0; j < targetLength + 1; ++j) {
            dist[0][j] = j;
        }
        for (i = 1; i < sourceLength + 1; ++i) {
            for (int j = 1; j < targetLength + 1; ++j) {
                int cost = source.charAt(i - 1) == target.charAt(j - 1) ? 0 : 1;
                dist[i][j] = Math.min(Math.min(dist[i - 1][j] + 1, dist[i][j - 1] + 1), dist[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || source.charAt(i - 1) != target.charAt(j - 2) || source.charAt(i - 2) != target.charAt(j - 1)) continue;
                dist[i][j] = Math.min(dist[i][j], dist[i - 2][j - 2] + cost);
            }
        }
        return dist[sourceLength][targetLength];
    }

    private String shortenPoS(String full) {
        CharArray shortened = new CharArray();
        String[] split = full.split(",");
        for (int z = 0; z < split.length; ++z) {
            if (split[z].toLowerCase().trim().contains("pronoun")) {
                split[z] = "Pronoun";
            } else if (split[z].toLowerCase().trim().contains("noun")) {
                split[z] = "Noun";
            } else if (split[z].toLowerCase().trim().contains("adverb")) {
                split[z] = "Adverb";
            } else if (split[z].toLowerCase().trim().contains("verb")) {
                split[z] = "Verb";
            } else if (split[z].toLowerCase().trim().contains("adjective")) {
                split[z] = "Adjective";
            }
            for (int y = 0; y < z; ++y) {
                if (!split[y].equals(split[z])) continue;
                split[z] = "";
            }
            if (split[z].equals("")) continue;
            shortened.append(split[z]).append(", ");
        }
        return shortened.toString().substring(0, shortened.length() > 0 ? shortened.length() - 2 : 0);
    }

    static /* synthetic */ String[] access$1602(ReviewScreen x0, String[] x1) {
        x0.synonymsTemp = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1902(ReviewScreen x0, String[] x1) {
        x0.readingsTemp = x1;
        return x1;
    }

    private static class Review {
        final int id;
        int streakMeaning;
        int streakReading;
        int answer = -1;
        final String vocabKanji;
        final String vocabKana;
        final String meaning;
        final String altMeanings;
        final String altReadings;
        final String sentence;
        final String sentenceMeaning;
        final String partOfSpeech;
        final String jlptLevel;
        final String vocabAudio;
        final String sentenceAudio;
        final String synonymsOrg;
        final String readingsOrg;
        final String notesOrg;
        String synonyms;
        String readings;
        String notes;
        boolean streakUpdatedOnce = false;
        boolean isAnsweredCorrectly;
        ReviewType reviewType = ReviewType.UNSET;
        private Label.LabelStyle kanjiStyle;
        private Label.LabelStyle kanaStyle;

        Review(int id, int streakMeaning, int streakReading, String vocabKanji, String vocabKana, String meaning, String altMeanings, String altReadings, String sentence, String sentenceMeaning, String partOfSpeech, String jlptLevel, String vocabAudio, String sentenceAudio, String synonyms, String readings, String notes) {
            this.id = id;
            this.streakMeaning = streakMeaning;
            this.streakReading = streakReading;
            this.vocabKanji = vocabKanji;
            this.vocabKana = vocabKana;
            this.meaning = meaning;
            this.altMeanings = altMeanings;
            this.altReadings = altReadings;
            this.sentence = sentence;
            this.sentenceMeaning = sentenceMeaning;
            this.partOfSpeech = partOfSpeech;
            this.jlptLevel = jlptLevel;
            this.vocabAudio = vocabAudio;
            this.sentenceAudio = sentenceAudio;
            this.synonymsOrg = synonyms;
            this.readingsOrg = readings;
            this.notesOrg = notes;
            this.synonyms = this.synonymsOrg;
            this.readings = this.readingsOrg;
            this.notes = this.notesOrg;
        }

        void setStreak(int value) {
            if (this.streakMeaning == -1) {
                this.streakReading = value;
            } else {
                this.streakMeaning = value;
            }
        }

        int getStreak() {
            if (this.streakMeaning == -1) {
                return this.streakReading;
            }
            return this.streakMeaning;
        }

        void setKanjiStyle(Label.LabelStyle style) {
            this.kanjiStyle = style;
        }

        Label.LabelStyle getKanjiStyle() {
            return this.kanjiStyle;
        }

        void setKanaStyle(Label.LabelStyle style) {
            this.kanaStyle = style;
        }

        Label.LabelStyle getKanaStyle() {
            return this.kanaStyle;
        }

        boolean isReviewMeaning() {
            return this.streakMeaning != -1;
        }

        private static enum ReviewType {
            UNSET,
            TEXT,
            AUDIO;

        }
    }

    public static enum ReviewModes {
        JP_TO_EN,
        EN_TO_JP,
        MIXED;

    }

    public static enum AudioModes {
        OFF,
        ALTERNATE,
        EXCLUSIVE;

    }
}

