/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.torii.srs.AddVocabScreen;
import com.torii.srs.BrowseScreen;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.HelpScreen;
import com.torii.srs.Hints;
import com.torii.srs.InfoScreen;
import com.torii.srs.LoadingScreen;
import com.torii.srs.LoginScreen;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.PrimeScreen;
import com.torii.srs.ProgressScreen;
import com.torii.srs.ReviewScreen;
import com.torii.srs.SettingsScreen;
import com.torii.srs.StudyScreen;
import com.torii.srs.WelcomeScreen;
import java.io.UnsupportedEncodingException;
import java.net.NoRouteToHostException;
import java.net.URLEncoder;
import java.net.UnknownHostException;

public class RestClient {
    private static final String WEBSITE = "torii-srs.com";
    static final String SUPPORT_EMAIL = "support@torii-srs.com";
    static final String CONTACT_EMAIL = "hello@torii-srs.com";
    private static final String DOMAIN = "torii-srs.com/api/v1";
    private static final String audioDir = "torii-srs.com/audio_files/";
    private static final String fontsDir = "torii-srs.com/font_files/";
    private static final String systemNotificationURL = "torii-srs.com/system-notification";
    private static final String versionInfoURL = "torii-srs.com/version";
    private static final String knowledgeBaseURL = "torii-srs.com/knowledge-base";
    private static final String linkText = "Go to Torii-SRS.com";
    private static String userApiKey;
    private static String deviceToken;
    private static String authorizationToken;
    private static boolean isNetworkConnectionLost;

    static String getWebsite() {
        return RestClient.getProtocol() + WEBSITE;
    }

    static String getAudioHost() {
        return RestClient.getProtocol() + audioDir;
    }

    static String getFontsHost() {
        return RestClient.getProtocol() + fontsDir;
    }

    static String createJishoLink(String word) {
        String jishoUrl = "jisho.org/search/";
        return RestClient.getProtocol() + jishoUrl + RestClient.encodeURL(word);
    }

    static String createTatoebaLink(String word) {
        String tatoebaUrl = "tatoeba.org/eng/sentences/search?query=";
        String tatoebaSearchOptions = "&from=jpn&to=und";
        return RestClient.getProtocol() + tatoebaUrl + RestClient.encodeURL(word) + tatoebaSearchOptions;
    }

    static String encodeURL(String specialChars) {
        String s = "";
        try {
            s = URLEncoder.encode(specialChars, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    static void checkUpdates() {
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl(RestClient.getProtocol() + versionInfoURL);
        LoadingScreen.showOnScreen();
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 404) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            InfoScreen.showNoNetworkNotification();
                        }
                    });
                } else {
                    JsonReader jsonReader = new JsonReader();
                    JsonValue jsonValue = jsonReader.parse(httpResponse.getResultAsString());
                    final String version = jsonValue.getString("version");
                    final String changelog = jsonValue.getString("changelog");
                    final boolean isForcedUpdate = jsonValue.getBoolean("forced_update");
                    int latestVersionNumber = Integer.parseInt(version.replace(".", ""));
                    int localVersionNumber = Integer.parseInt("1.4.9".replace(".", ""));
                    if (localVersionNumber >= latestVersionNumber) {
                        RestClient.checkSystemNotification();
                    } else {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                LoadingScreen.hideOnScreen();
                                InfoScreen.showUpdateNotification(version, changelog, isForcedUpdate);
                            }
                        });
                    }
                }
            }

            @Override
            public void failed(Throwable t) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        InfoScreen.showNoNetworkNotification();
                    }
                });
            }

            @Override
            public void cancelled() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        InfoScreen.showNoNetworkNotification();
                    }
                });
            }
        });
    }

    static void checkSystemNotification() {
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl(RestClient.getProtocol() + systemNotificationURL);
        LoadingScreen.showOnScreen();
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 404) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            InfoScreen.showNoNetworkNotification();
                        }
                    });
                } else {
                    JsonReader jsonReader = new JsonReader();
                    JsonValue jsonValue = jsonReader.parse(httpResponse.getResultAsString());
                    boolean isAKS = jsonValue.getBoolean("aks");
                    boolean isAccountKS = jsonValue.getBoolean("accks");
                    boolean isSupportRequestKS = jsonValue.getBoolean("srks");
                    Main.setAKS(isAKS);
                    LoginScreen.setAccountKS(isAccountKS);
                    Main.setSupportRequestKS(isSupportRequestKS);
                    if (jsonValue.getBoolean("active")) {
                        final String title = jsonValue.getString("title");
                        final String message = jsonValue.getString("message");
                        final boolean isKillSwitch = jsonValue.getBoolean("kill_switch");
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                LoadingScreen.hideOnScreen();
                                InfoScreen.showSystemNotification(title, message, RestClient.linkText, RestClient.getWebsite(), isKillSwitch);
                            }
                        });
                    } else {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                LoadingScreen.hideOnScreen();
                                Main.launchApp(false);
                            }
                        });
                    }
                }
            }

            @Override
            public void failed(Throwable t) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        InfoScreen.showNoNetworkNotification();
                    }
                });
            }

            @Override
            public void cancelled() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        InfoScreen.showNoNetworkNotification();
                    }
                });
            }
        });
    }

    static void sendSupportRequest(String email, String subject, String text, final boolean isItemIssueReport) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        String s = isItemIssueReport ? "The issue has been reported, thank you." : "Your request has been sent.";
                        Dialogs.showOKDialog(Main.getCurrentStage(), "Success", s, new Dialogs.OKAdapter(){

                            @Override
                            public void ok() {
                                if (isItemIssueReport) {
                                    StudyScreen.hideProblemReportTable();
                                } else {
                                    Dashboard.showOnScreen();
                                }
                            }
                        });
                    }
                });
            }

            @Override
            void error(String errorCode) {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Oops, something went wrong.\nPlease try again in a few seconds.");
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Couldn't send message.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Couldn't send message - cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"user", Main.getUserEmail()}, {"email", email}, {"subject", subject}, {"message", text}};
        http.init("support-request", params, false);
    }

    static void getKnowledgeBase() {
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl(RestClient.getProtocol() + knowledgeBaseURL);
        final String errorMessage = "Couldn't load Knowledge Base. Try again in a few moments.";
        LoadingScreen.showOnScreen();
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                if (httpResponse.getStatus().getStatusCode() == 404) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            LoadingScreen.hideOnScreen();
                            Dialogs.showErrorDialog(Main.getCurrentStage(), errorMessage);
                        }
                    });
                } else {
                    JsonReader jsonReader = new JsonReader();
                    final JsonValue jsonValue = jsonReader.parse(httpResponse.getResultAsString());
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Main.setNewScreen(new HelpScreen(jsonValue));
                        }
                    });
                }
            }

            @Override
            public void failed(final Throwable t) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        Dialogs.showErrorDialog(Main.getCurrentStage(), errorMessage, new Exception(t));
                    }
                });
            }

            @Override
            public void cancelled() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        Dialogs.showErrorDialog(Main.getCurrentStage(), errorMessage);
                    }
                });
            }
        });
    }

    static void checkSessionExpired(String email) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                LoginScreen.quickSignIn();
            }

            @Override
            void error(String errorCode) {
                LoginScreen.showOnScreen();
            }

            @Override
            void failed() {
                LoginScreen.showOnScreen();
                System.out.println("SESSION CHECK FAILED: " + this.getFailedThrowable().toString());
            }

            @Override
            void cancelled() {
                LoginScreen.showOnScreen();
                System.out.println("SESSION CHECK CANCELLED!");
            }
        };
        Object[][] params = new Object[][]{{"email", email}};
        http.init("session", params, false);
    }

    static void createUser(final String email, final String passwordHash) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                RestClient.loginUser(email, passwordHash, false);
            }

            @Override
            void error(String errorCode) {
                switch (errorCode) {
                    case "user_already_exists": {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Sorry, this email is already taken.");
                        break;
                    }
                    case "invalid_email": {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Not a valid email address.");
                        break;
                    }
                    default: {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Oops, something went wrong.\nPlease try again in a few seconds.");
                    }
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Registration failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Registration cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"email", email}, {"password", passwordHash}};
        http.init("register", params, false);
    }

    static void loginUser(final String email, final String passwordHash, final boolean isQuickSignIn) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                userApiKey = this.jsonValue.get("user_data").getString("api_key");
                deviceToken = this.jsonValue.get("user_data").getString("device_token");
                String accountCreated = this.jsonValue.get("user_data").getString("created");
                String lastVacationEnded = this.jsonValue.get("user_data").getString("vacation_end");
                String isPrimeUntil = this.jsonValue.get("user_data").getString("prime_until");
                final int userStudyMode = this.jsonValue.get("user_data").getInt("study_mode");
                int studyStreakCurrent = this.jsonValue.get("user_data").getInt("study_streak_current");
                int studyStreakBest = this.jsonValue.get("user_data").getInt("study_streak_best");
                boolean studyModeIncludeWK = this.jsonValue.get("user_data").getBoolean("study_mode_include_wk");
                boolean studyModeIncludeKanaOnly = this.jsonValue.get("user_data").getBoolean("study_mode_include_kana_only");
                boolean isVacationModeActivated = this.jsonValue.get("user_data").getInt("vacation_on") == 1;
                boolean isPrimeMember = this.jsonValue.get("user_data").getInt("is_prime") == 1;
                boolean studyHideKana = this.jsonValue.get("user_settings").getBoolean("study_hide_kana");
                boolean studyHideSentence = this.jsonValue.get("user_settings").getBoolean("study_hide_sentence");
                boolean studyAutoplayAudio = this.jsonValue.get("user_settings").getBoolean("study_autoplay_audio");
                boolean studyAutoContinue = this.jsonValue.get("user_settings").getBoolean("study_auto_continue");
                boolean studyFullscreen = this.jsonValue.get("user_settings").getBoolean("study_fullscreen");
                boolean reviewRandFont = this.jsonValue.get("user_settings").getBoolean("review_rand_font");
                boolean reviewHideKana = this.jsonValue.get("user_settings").getBoolean("review_hide_kana");
                boolean reviewRevealKana = this.jsonValue.get("user_settings").getBoolean("review_reveal_kana");
                boolean reviewAutoplayAudio = this.jsonValue.get("user_settings").getBoolean("review_autoplay_audio");
                boolean reviewAutoplayAudioSentence = this.jsonValue.get("user_settings").getBoolean("review_autoplay_audio_sentence");
                boolean reviewAudioAtStart = this.jsonValue.get("user_settings").getBoolean("review_audio_at_start");
                boolean reviewAudioAtEnd = this.jsonValue.get("user_settings").getBoolean("review_audio_at_end");
                boolean reviewAudioOnWrongAnswer = this.jsonValue.get("user_settings").getBoolean("review_audio_on_wrong_answer");
                boolean reviewLightningMode = this.jsonValue.get("user_settings").getBoolean("review_lightning_mode");
                boolean reviewHyperjumpMode = this.jsonValue.get("user_settings").getBoolean("review_hyperjump_mode");
                boolean reviewAutoContinue = this.jsonValue.get("user_settings").getBoolean("review_auto_continue");
                boolean reviewAutoExpand = this.jsonValue.get("user_settings").getBoolean("review_auto_expand");
                boolean reviewFullscreen = this.jsonValue.get("user_settings").getBoolean("review_fullscreen");
                boolean androidNotifications = this.jsonValue.get("user_settings").getBoolean("android_notifications");
                int timezone = this.jsonValue.get("user_settings").getInt("timezone", -127);
                int studyLimit = this.jsonValue.get("user_settings").getInt("study_limit");
                int studyLimitLeft = this.jsonValue.get("user_settings").getInt("study_limit_left");
                int reviewMode = this.jsonValue.get("user_settings").getInt("review_mode");
                int audioReviewMode = this.jsonValue.get("user_settings").getInt("review_audio_mode");
                String studyPlaceholder = this.jsonValue.get("user_settings").getString("study_placeholder");
                String reviewPlaceholder = this.jsonValue.get("user_settings").getString("review_placeholder");
                int kbConfirm = this.jsonValue.get("user_keybindings").getInt("confirm");
                int kbIgnore = this.jsonValue.get("user_keybindings").getInt("igno");
                int kbInfo = this.jsonValue.get("user_keybindings").getInt("info");
                int kbFurigana = this.jsonValue.get("user_keybindings").getInt("furigana");
                int kbSkip = this.jsonValue.get("user_keybindings").getInt("skip");
                int kbVocabAudio = this.jsonValue.get("user_keybindings").getInt("vocab_audio");
                int kbSentenceAudio = this.jsonValue.get("user_keybindings").getInt("sentence_audio");
                int kbFont = this.jsonValue.get("user_keybindings").getInt("font");
                int kbArchive = this.jsonValue.get("user_keybindings").getInt("archive");
                boolean showHints = this.jsonValue.get("user_hints").getBoolean("show_hints");
                boolean settings = this.jsonValue.get("user_hints").getBoolean("settings");
                boolean addSynonym = this.jsonValue.get("user_hints").getBoolean("add_synonym");
                boolean addReading = this.jsonValue.get("user_hints").getBoolean("add_reading");
                boolean archive = this.jsonValue.get("user_hints").getBoolean("archive");
                boolean navigate = this.jsonValue.get("user_hints").getBoolean("navigate_mobile");
                boolean practice = this.jsonValue.get("user_hints").getBoolean("practice");
                final int toriiTime = this.jsonValue.get("times").getInt("torii_time");
                int customVocabAmount = this.jsonValue.get("custom").getInt("amount_total");
                int subPrice = this.jsonValue.get("prime_details").getInt("subscription_price");
                int subPriceDiscounted = this.jsonValue.get("prime_details").getInt("subscription_discounted");
                int subInterval = this.jsonValue.get("prime_details").getInt("subscription_interval");
                int lifetimePrice = this.jsonValue.get("prime_details").getInt("lifetime_price");
                int lifetimePriceDiscounted = this.jsonValue.get("prime_details").getInt("lifetime_discounted");
                String message = this.jsonValue.get("prime_details").getString("message");
                String discountExpires = this.jsonValue.get("prime_details").getString("expires");
                authorizationToken = userApiKey + deviceToken;
                StudyScreen.regenerateStudyMode(userStudyMode, studyModeIncludeWK, studyModeIncludeKanaOnly);
                Main.setIsVacationModeActivated(isVacationModeActivated, lastVacationEnded);
                Main.setIsPrime(isPrimeMember, isPrimeUntil);
                Main.setCustomVocabAmount(customVocabAmount);
                ProgressScreen.setAccountCreated(accountCreated);
                ProgressScreen.setStudyStreakCurrent(studyStreakCurrent);
                ProgressScreen.setStudyStreakBest(studyStreakBest);
                Main.setAndroidNotifications(androidNotifications);
                SettingsScreen.setTimezone(timezone);
                StudyScreen.resetCharLimitNotes();
                StudyScreen.setHideKana(studyHideKana);
                StudyScreen.setHideSentenceMeaning(studyHideSentence);
                StudyScreen.setAutoplayAudio(studyAutoplayAudio);
                StudyScreen.setStudySessionAutoContinue(studyAutoContinue);
                StudyScreen.setStudyFullscreen(studyFullscreen);
                ReviewScreen.setReviewMode(reviewMode);
                ReviewScreen.setAudioReviewMode(audioReviewMode);
                ReviewScreen.setRandomizeFont(reviewRandFont);
                ReviewScreen.setHideKana(reviewHideKana);
                ReviewScreen.setShowKanaAfterAnswer(reviewRevealKana);
                ReviewScreen.setAutoplayAudio(reviewAutoplayAudio);
                ReviewScreen.setAutoplayAudioSentence(reviewAutoplayAudioSentence);
                ReviewScreen.setPlayAudioAtStart(reviewAudioAtStart);
                ReviewScreen.setPlayAudioAtEnd(reviewAudioAtEnd);
                ReviewScreen.setPlayAudioOnWrongAnswer(reviewAudioOnWrongAnswer);
                ReviewScreen.setLightningMode(reviewLightningMode);
                ReviewScreen.setHyperjumpMode(reviewHyperjumpMode);
                ReviewScreen.setReviewSessionAutoContinue(reviewAutoContinue);
                ReviewScreen.setAutoExpandDetailsAfterWrongAnswer(reviewAutoExpand);
                ReviewScreen.setReviewFullscreen(reviewFullscreen);
                StudyScreen.setDailyLimit(studyLimit);
                StudyScreen.setDailyLimitLeft(studyLimitLeft);
                StudyScreen.setPlaceholder(studyPlaceholder);
                ReviewScreen.setPlaceholder(reviewPlaceholder);
                Hints.setShowHints(showHints);
                Hints.setHintSettings(settings);
                Hints.setHintAddSynonym(addSynonym);
                Hints.setHintAddReading(addReading);
                Hints.setHintArchive(archive);
                Hints.setHintNavigate(navigate);
                Hints.setHintPractice(practice);
                SettingsScreen.getKeyBindingsHandler().setBindings(kbConfirm, kbIgnore, kbInfo, kbFurigana, kbSkip, kbVocabAudio, kbSentenceAudio, kbFont, kbArchive);
                PrimeScreen.updatePrices(message, subPrice, subPriceDiscounted, subInterval, lifetimePrice, lifetimePriceDiscounted, discountExpires);
                Main.setData(email, passwordHash);
                Main.startTimer();
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (userStudyMode != 0) {
                            Dashboard.showOnScreen();
                            Dashboard.setIsReadyToRefresh(true);
                        } else if (toriiTime == 0) {
                            WelcomeScreen.showOnScreen(false);
                        } else {
                            WelcomeScreen.showOnScreen(true);
                        }
                    }
                });
            }

            @Override
            void error(String errorCode) {
                if (errorCode.equals("incorrect_credentials")) {
                    if (!isQuickSignIn) {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Incorrect email or password.");
                    } else {
                        Main.setData("", "");
                        LoginScreen.showOnScreen();
                    }
                } else {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Oops, something went wrong.\nPlease try again in a few seconds.");
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Login failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Login cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"email", email}, {"password", passwordHash}};
        http.init("login", params, false);
    }

    static void resetUserPassword(final String email) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        InfoScreen.showOkMessage("Email sent!", "We've just sent a password recovery email to\n\"" + email + "\".\n\nIf you can't find it, take a look in your spam folder. Whitelisting [CR]support@torii-srs.com[] can also help!");
                    }
                });
            }

            @Override
            void error(String errorCode) {
                if (errorCode.equals("no_such_email")) {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Invalid email.");
                } else {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Oops, something went wrong.\nPlease try again in a few seconds.");
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Password recovery failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Password recovery cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"email", email}};
        http.init("forgot-password", params, false);
    }

    static void updateStudyMode(final int studyMode, final boolean includeWK, final boolean includeKanaOnly, boolean reviewEverything) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                StudyScreen.regenerateStudyMode(studyMode, includeWK, includeKanaOnly);
                RestClient.unlockNewLessons();
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Study Mode update failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Study Mode update cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"status", studyMode}, {"include_wk", includeWK}, {"include_kana_only", includeKanaOnly}, {"review_everything", reviewEverything}};
        http.setErrorCodeReference(1);
        http.init("update/study-mode", params, true);
    }

    private static void unlockNewLessons() {
        StudyScreen.StudyMode studyMode = StudyScreen.getStudyMode();
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Dashboard.showOnScreen();
                Dashboard.setIsReadyToRefresh(true);
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Unlocking lessons failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Unlocking lessons cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"10k", studyMode.is10k}, {"wk", studyMode.isWK}, {"kana_only", studyMode.isKanaOnly}, {"jlpt5", studyMode.isJlpt5}, {"jlpt4", studyMode.isJlpt4}, {"jlpt3", studyMode.isJlpt3}, {"jlpt2", studyMode.isJlpt2}, {"jlpt1", studyMode.isJlpt1}, {"include_wk", studyMode.includeWK}, {"include_kana_only", studyMode.includeKanaOnly}};
        http.setErrorCodeReference(2);
        http.init("lessons-unlock", params, true);
    }

    static void getLessons() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int noOfLessonsDummy = 1;
                for (int x = 1; x <= 5; ++x) {
                    try {
                        this.jsonValue.get("lessons").get(x).getInt("id");
                    }
                    catch (NullPointerException ex) {
                        break;
                    }
                    ++noOfLessonsDummy;
                }
                final int noOfLessons = noOfLessonsDummy;
                final int[] id = new int[noOfLessons];
                final String[] vocabKanji = new String[noOfLessons];
                final String[] vocabKana = new String[noOfLessons];
                final String[] meaning = new String[noOfLessons];
                final String[] alternativeMeanings = new String[noOfLessons];
                final String[] alternativeReadings = new String[noOfLessons];
                final String[] sentence = new String[noOfLessons];
                final String[] sentenceMeaning = new String[noOfLessons];
                final String[] examples = new String[noOfLessons];
                final String[] partOfSpeech = new String[noOfLessons];
                final String[] vocabAudio = new String[noOfLessons];
                final String[] sentenceAudio = new String[noOfLessons];
                final String[] synonyms = new String[noOfLessons];
                final String[] readings = new String[noOfLessons];
                final String[] notes = new String[noOfLessons];
                final String[] jlptLevel = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    String pos = this.jsonValue.get("lessons").get(x).getString("pos");
                    int jlpt = this.jsonValue.get("lessons").get(x).getInt("jlpt_level");
                    id[x] = this.jsonValue.get("lessons").get(x).getInt("id");
                    vocabKanji[x] = this.jsonValue.get("lessons").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("lessons").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("lessons").get(x).getString("meaning");
                    alternativeMeanings[x] = this.jsonValue.get("lessons").get(x).getString("alt_meanings");
                    alternativeReadings[x] = this.jsonValue.get("lessons").get(x).getString("alt_readings");
                    sentence[x] = this.jsonValue.get("lessons").get(x).getString("sentence");
                    sentenceMeaning[x] = this.jsonValue.get("lessons").get(x).getString("sentence_meaning");
                    examples[x] = this.jsonValue.get("lessons").get(x).getString("examples");
                    vocabAudio[x] = this.jsonValue.get("lessons").get(x).getString("vocab_audio");
                    sentenceAudio[x] = this.jsonValue.get("lessons").get(x).getString("sentence_audio");
                    synonyms[x] = this.jsonValue.get("lessons").get(x).getString("synonyms");
                    readings[x] = this.jsonValue.get("lessons").get(x).getString("readings");
                    notes[x] = this.jsonValue.get("lessons").get(x).getString("notes");
                    examples[x] = examples[x].replace("<br>", "\n\n");
                    partOfSpeech[x] = pos != null ? pos : "";
                    jlptLevel[x] = jlpt > 0 && jlpt <= 5 ? "JLPT N" + jlpt : "";
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        StudyScreen.setData(noOfLessons, id, vocabKanji, vocabKana, meaning, alternativeMeanings, alternativeReadings, sentence, sentenceMeaning, examples, partOfSpeech, jlptLevel, vocabAudio, sentenceAudio, synonyms, readings, notes);
                    }
                });
            }

            @Override
            void failed() {
                Dashboard.showOnScreen();
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Starting study session failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dashboard.showOnScreen();
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Starting study session cancelled.");
            }
        };
        http.setErrorCodeReference(9);
        http.setKeepLoadingScreen(true);
        http.init("lessons-get", null, true);
    }

    static void getReviews(int practiceID) {
        RestClient.getReviews(-1, practiceID, new boolean[]{true, true, true, true, true, true, true, true, true});
    }

    static void getReviews(int reviewModeID, final int practiceID, boolean[] srs) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int noOfReviewsReading;
                int noOfReviewsMeaning = this.jsonValue.getInt("no_reviews_meaning");
                int noOfReviews = noOfReviewsMeaning + (noOfReviewsReading = this.jsonValue.getInt("no_reviews_reading"));
                if (noOfReviews < 1) {
                    LoadingScreen.hideOnScreen();
                    Dialogs.showOKDialog(Main.getCurrentStage(), "No Vocabulary Available", "There's nothing to practice.");
                    return;
                }
                final int[] id = new int[noOfReviews];
                final int[] streakMeaning = new int[noOfReviews];
                final int[] streakReading = new int[noOfReviews];
                final String[] vocabKanji = new String[noOfReviews];
                final String[] vocabKana = new String[noOfReviews];
                final String[] meaning = new String[noOfReviews];
                final String[] alternativeMeanings = new String[noOfReviews];
                final String[] alternativeReadings = new String[noOfReviews];
                final String[] sentence = new String[noOfReviews];
                final String[] sentenceMeaning = new String[noOfReviews];
                final String[] partOfSpeech = new String[noOfReviews];
                final String[] vocabAudio = new String[noOfReviews];
                final String[] sentenceAudio = new String[noOfReviews];
                final String[] synonyms = new String[noOfReviews];
                final String[] readings = new String[noOfReviews];
                final String[] notes = new String[noOfReviews];
                final String[] jlptLevel = new String[noOfReviews];
                for (int x = 0; x < noOfReviews; ++x) {
                    int y;
                    String s;
                    if (x < noOfReviewsMeaning) {
                        s = "reviews_meaning";
                        y = x;
                        streakMeaning[x] = this.jsonValue.get(s).get(y).getInt("streak_meaning");
                        streakReading[x] = -1;
                    } else {
                        s = "reviews_reading";
                        y = x - noOfReviewsMeaning;
                        streakMeaning[x] = -1;
                        streakReading[x] = this.jsonValue.get(s).get(y).getInt("streak_reading");
                    }
                    String pos = this.jsonValue.get(s).get(y).getString("pos");
                    int jlpt = this.jsonValue.get(s).get(y).getInt("jlpt_level");
                    id[x] = this.jsonValue.get(s).get(y).getInt("id");
                    vocabKanji[x] = this.jsonValue.get(s).get(y).getString("vocab");
                    vocabKana[x] = this.jsonValue.get(s).get(y).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get(s).get(y).getString("meaning");
                    alternativeMeanings[x] = this.jsonValue.get(s).get(y).getString("alt_meanings");
                    alternativeReadings[x] = this.jsonValue.get(s).get(y).getString("alt_readings");
                    sentence[x] = this.jsonValue.get(s).get(y).getString("sentence");
                    sentenceMeaning[x] = this.jsonValue.get(s).get(y).getString("sentence_meaning");
                    vocabAudio[x] = this.jsonValue.get(s).get(y).getString("vocab_audio");
                    sentenceAudio[x] = this.jsonValue.get(s).get(y).getString("sentence_audio");
                    synonyms[x] = this.jsonValue.get(s).get(y).getString("synonyms");
                    readings[x] = this.jsonValue.get(s).get(y).getString("readings");
                    notes[x] = this.jsonValue.get(s).get(y).getString("notes");
                    partOfSpeech[x] = pos != null ? pos : "";
                    jlptLevel[x] = jlpt > 0 && jlpt <= 5 ? "JLPT N" + jlpt : "";
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        ReviewScreen.setData(false, practiceID, id, streakMeaning, streakReading, vocabKanji, vocabKana, meaning, alternativeMeanings, alternativeReadings, sentence, sentenceMeaning, partOfSpeech, jlptLevel, vocabAudio, sentenceAudio, synonyms, readings, notes);
                    }
                });
            }

            @Override
            void failed() {
                Dashboard.showOnScreen();
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Starting review session failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dashboard.showOnScreen();
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Starting review session cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"mode_id", reviewModeID}, {"practice_id", practiceID}, {"rookie1", srs[0]}, {"rookie2", srs[1]}, {"rookie3", srs[2]}, {"rookie4", srs[3]}, {"amateur1", srs[4]}, {"amateur2", srs[5]}, {"expert", srs[6]}, {"master", srs[7]}, {"sensei", srs[8]}};
        http.setErrorCodeReference(10);
        http.setKeepLoadingScreen(true);
        http.init("reviews-get", params, true);
    }

    static void updateVocab(final ReviewScreen parent, final int vocabID, final int streakMeaning, final int streakReading, final String synonyms, final String readings, final String notes, final boolean isLessonsMode) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                if (parent != null) {
                    ReviewScreen.removeFromItemsBeingSynced(vocabID);
                } else {
                    Dialogs.showOKDialog(Main.getCurrentStage(), "Done!", "The vocabulary has been updated.");
                }
            }

            @Override
            void failed() {
                if (parent != null) {
                    RestClient.updateVocab(parent, vocabID, streakMeaning, streakReading, synonyms, readings, notes, isLessonsMode);
                } else {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Syncing vocab failed.", new Exception(this.getFailedThrowable()));
                }
            }

            @Override
            void cancelled() {
                if (parent != null) {
                    RestClient.updateVocab(parent, vocabID, streakMeaning, streakReading, synonyms, readings, notes, isLessonsMode);
                } else {
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Syncing vocab cancelled.");
                }
            }
        };
        Object[][] params = new Object[][]{{"vocab_id", vocabID}, {"streak_meaning", streakMeaning}, {"streak_reading", streakReading}, {"synonyms", synonyms}, {"readings", readings}, {"notes", notes}, {"lesson_mode", isLessonsMode}};
        http.setErrorCodeReference(3);
        http.setIsBackgroundProcess(parent != null);
        http.init("reviews-update", params, true);
    }

    static void addCustomVocab(final PracticeScreen.PracticeListsTable parent, final int vocabID, String vocab, String kana, String meaning, String sentence, String sentenceMeaning, String partOfSpeech, String synonyms, String readings, String notes, int streak) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasEditing;
                        Gdx.input.setOnscreenKeyboardVisible(false);
                        boolean bl = wasEditing = vocabID != -1;
                        if (!wasEditing) {
                            int newlyAddedVocabID = jsonValue.getInt("vocab_id");
                            if (newlyAddedVocabID > 0 && parent != null) {
                                parent.setVocab(newlyAddedVocabID);
                                parent.pushChangesToDB();
                            }
                            Main.setCustomVocabAmount(Main.getCustomVocabAmount() + 1);
                            if (Main.isPrime() || Main.getCustomVocabAmount() < 10) {
                                Dialogs.showConfirmDialog(Main.getCurrentStage(), "Done!", "Your custom vocab has been added. To edit or delete it, go to Browse \u2192 Custom Vocab.\nAdd another word?", new Dialogs.ConfirmAdapter(){

                                    @Override
                                    public void yes() {
                                        Main.setNewScreen(new AddVocabScreen());
                                    }

                                    @Override
                                    public void cancel() {
                                        Dashboard.showOnScreen();
                                    }
                                });
                            } else {
                                Dashboard.showOnScreen();
                            }
                        } else {
                            Dialogs.showOKDialog(Main.getCurrentStage(), "Done!", "The vocabulary has been updated.", new Dialogs.OKAdapter(){

                                @Override
                                public void ok() {
                                    Main.setNewScreen(new BrowseScreen(BrowseScreen.BrowseInterface.CUSTOM, BrowseScreen.getCurrentPage()));
                                }
                            });
                        }
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Couldn't add custom vocab.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Adding custom vocab cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"id", vocabID}, {"vocab", vocab}, {"kana", kana}, {"meaning", meaning}, {"sentence", sentence}, {"sentence_meaning", sentenceMeaning}, {"pos", partOfSpeech}, {"synonyms", synonyms}, {"readings", readings}, {"notes", notes}, {"streak", streak}};
        http.setErrorCodeReference(4);
        http.init("custom-add", params, true);
    }

    static void updateTime(final int toriiTime, final int studyTime, final int reviewTime) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        Main.setToriiTime(Main.getToriiTime() - toriiTime);
                        Main.setStudyTime(Main.getStudyTime() - studyTime);
                        Main.setReviewTime(Main.getReviewTime() - reviewTime);
                    }
                });
            }

            @Override
            void failed() {
            }

            @Override
            void cancelled() {
            }
        };
        Object[][] params = new Object[][]{{"torii_time", toriiTime}, {"study_time", studyTime}, {"review_time", reviewTime}};
        http.setIsBackgroundProcess(true);
        http.init("update/time", params, true);
    }

    static void updateEmail(String currentEmail, final String newEmail) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Main.setData(newEmail, Main.getUserPassword());
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        SettingsScreen.showOnScreen();
                        Dialogs.showOKDialog(Main.getCurrentStage(), "Success", "Your email address has been updated.");
                    }
                });
            }

            @Override
            void error(String errorCode) {
                switch (errorCode) {
                    case "user_already_exists": {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Sorry, email already taken.");
                        break;
                    }
                    case "invalid_email": {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Not a valid email address.");
                        break;
                    }
                    default: {
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Oops, something went wrong.\nPlease try again in a few seconds.");
                    }
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Email update failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Email update cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"old", currentEmail}, {"new", newEmail}};
        http.init("update/email", params, true);
    }

    static void updatePassword(final String newPassword) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Main.setData(Main.getUserEmail(), newPassword);
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        Dialogs.showOKDialog(Main.getCurrentStage(), "Success", "Your password has been updated.");
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Password update failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Password update cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"new", newPassword}};
        http.setErrorCodeReference(11);
        http.init("update/password", params, true);
    }

    static void updateSettings() {
        boolean studyHideKana = StudyScreen.getHideKana();
        boolean studyHideSentence = StudyScreen.getHideSentenceMeaning();
        boolean studyAutoplayAudio = StudyScreen.getAutoplayAudio();
        boolean studyAutoContinue = StudyScreen.getStudySessionAutoContinue();
        boolean studyFullscreen = StudyScreen.getStudyFullscreen();
        boolean reviewRandFont = ReviewScreen.getRandomizeFont();
        boolean reviewHideKana = ReviewScreen.getHideKana();
        boolean reviewRevealKana = ReviewScreen.getShowKanaAfterAnswer();
        boolean reviewAutoplayAudio = ReviewScreen.getAutoplayAudio();
        boolean reviewAutoplayAudioSentence = ReviewScreen.getAutoplayAudioSentence();
        boolean reviewAudioAtStart = ReviewScreen.getPlayAudioAtStart();
        boolean reviewAudioAtEnd = ReviewScreen.getPlayAudioAtEnd();
        boolean reviewAudioOnWrongAnswer = ReviewScreen.getPlayAudioOnWrongAnswer();
        boolean reviewLightningMode = ReviewScreen.getLightningMode();
        boolean reviewHyperjumpMode = ReviewScreen.getHyperjumpMode();
        boolean reviewAutoContinue = ReviewScreen.getReviewSessionAutoContinue();
        boolean reviewAutoExpand = ReviewScreen.getAutoExpandDetailsAfterWrongAnswer();
        boolean reviewFullscreen = ReviewScreen.getReviewFullscreen();
        boolean androidNotifications = Main.getAndroidNotifications();
        int audioReviewMode = ReviewScreen.getAudioReviewMode();
        String studyPlaceholder = StudyScreen.getPlaceholder();
        String reviewPlaceholder = ReviewScreen.getPlaceholder();
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
            }

            @Override
            void failed() {
                System.out.println("UPDATING SETTINGS FAILED");
            }

            @Override
            void cancelled() {
                System.out.println("UPDATING SETTINGS CANCELLED");
            }
        };
        Object[][] params = new Object[][]{{"study_hide_kana", studyHideKana}, {"study_hide_sentence", studyHideSentence}, {"study_autoplay_audio", studyAutoplayAudio}, {"study_auto_continue", studyAutoContinue}, {"study_fullscreen", studyFullscreen}, {"review_audio_mode", audioReviewMode}, {"review_hide_kana", reviewHideKana}, {"review_reveal_kana", reviewRevealKana}, {"review_autoplay_audio", reviewAutoplayAudio}, {"review_autoplay_audio_sentence", reviewAutoplayAudioSentence}, {"review_audio_at_start", reviewAudioAtStart}, {"review_audio_at_end", reviewAudioAtEnd}, {"review_audio_on_wrong_answer", reviewAudioOnWrongAnswer}, {"review_rand_font", reviewRandFont}, {"review_lightning_mode", reviewLightningMode}, {"review_hyperjump_mode", reviewHyperjumpMode}, {"review_auto_continue", reviewAutoContinue}, {"review_auto_expand", reviewAutoExpand}, {"review_fullscreen", reviewFullscreen}, {"study_placeholder", studyPlaceholder}, {"review_placeholder", reviewPlaceholder}, {"android_notifications", androidNotifications}};
        http.setIsBackgroundProcess(true);
        http.init("update/settings", params, true);
    }

    static void updateKeyBindings() {
        int confirmBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.CONFIRM);
        int ignoreBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.IGNORE);
        int infoBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.INFO);
        int furiganaBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.FURIGANA);
        int skipBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.SKIP);
        int vocabAudioBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.VOCAB_AUDIO);
        int sentenceAudioBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.SENTENCE_AUDIO);
        int fontBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.FONT);
        int archiveBind = SettingsScreen.getKeyBindingsHandler().getBind(SettingsScreen.KeyBindings.ARCHIVE);
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
            }

            @Override
            void failed() {
            }

            @Override
            void cancelled() {
            }
        };
        Object[][] params = new Object[][]{{"confirm", confirmBind}, {"igno", ignoreBind}, {"info", infoBind}, {"furigana", furiganaBind}, {"skip", skipBind}, {"vocab_audio", vocabAudioBind}, {"sentence_audio", sentenceAudioBind}, {"font", fontBind}, {"archive", archiveBind}};
        http.setIsBackgroundProcess(true);
        http.init("update/keybindings", params, true);
    }

    static void updateHints() {
        boolean showHints = Hints.getShowHints();
        boolean settings = Hints.getHintSettings();
        boolean addSynonym = Hints.getHintAddSynonym();
        boolean addReading = Hints.getHintAddReading();
        boolean archive = Hints.getHintArchive();
        boolean navigate = Hints.getHintNavigate();
        boolean practice = Hints.getHintPractice();
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
            }

            @Override
            void failed() {
            }

            @Override
            void cancelled() {
            }
        };
        Object[][] params = new Object[][]{{"show_hints", showHints}, {"settings", settings}, {"add_synonym", addSynonym}, {"add_reading", addReading}, {"archive", archive}, {"navigate_mobile", navigate}, {"practice", practice}};
        http.setIsBackgroundProcess(true);
        http.init("update/hints", params, true);
    }

    static void updateStudyLimitAndTimezone(final int newLimit, final int timezone) {
        String newTimezone = timezone == -127 ? null : String.valueOf(timezone);
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                StudyScreen.setDailyLimit(newLimit);
                SettingsScreen.setTimezone(timezone);
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        SettingsScreen.refreshDailyLimitValue();
                    }
                });
            }

            @Override
            void failed() {
            }

            @Override
            void cancelled() {
            }
        };
        Object[][] params = new Object[][]{{"new", newLimit}, {"timezone", newTimezone}};
        http.setErrorCodeReference(5);
        http.init("update/study-limit", params, true);
    }

    static void updateReviewMode(final int id) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                ReviewScreen.setReviewMode(id);
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Review Mode update failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Review Mode update cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"id", id}};
        http.setErrorCodeReference(6);
        http.init("update/review-mode", params, true);
    }

    static void getProgression(final boolean startStudySession, final boolean startReviewSession) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int lvl5;
                int lvl4;
                int lvl3;
                int lvl2;
                int lvl1;
                int reviews;
                String nextReviewDueSeconds;
                String nextReviewDueSecondsMeaning = this.jsonValue.get("next_due").getString("due_meaning");
                String nextReviewDueSecondsReading = this.jsonValue.get("next_due").getString("due_reading");
                int studyLimitLeft = this.jsonValue.getInt("study_limit_left");
                int lessons = this.jsonValue.get("progression_data").getInt("lessons");
                final int reviewsMeaning = this.jsonValue.get("progression_data").getInt("reviews_meaning");
                final int reviewsReading = this.jsonValue.get("progression_data").getInt("reviews_reading");
                int lvl1Meaning = this.jsonValue.get("progression_data").getInt("apprentice_meaning");
                int lvl1Reading = this.jsonValue.get("progression_data").getInt("apprentice_reading");
                int lvl2Meaning = this.jsonValue.get("progression_data").getInt("amateur_meaning");
                int lvl2Reading = this.jsonValue.get("progression_data").getInt("amateur_reading");
                int lvl3Meaning = this.jsonValue.get("progression_data").getInt("expert_meaning");
                int lvl3Reading = this.jsonValue.get("progression_data").getInt("expert_reading");
                int lvl4Meaning = this.jsonValue.get("progression_data").getInt("master_meaning");
                int lvl4Reading = this.jsonValue.get("progression_data").getInt("master_reading");
                int lvl5Meaning = this.jsonValue.get("progression_data").getInt("sensei_meaning");
                int lvl5Reading = this.jsonValue.get("progression_data").getInt("sensei_reading");
                if (lessons <= studyLimitLeft || lessons == 0) {
                    studyLimitLeft = lessons;
                    StudyScreen.setAllLessonsCleared(true);
                } else {
                    StudyScreen.setAllLessonsCleared(false);
                }
                switch (ReviewScreen.getReviewMode()) {
                    case 1: {
                        nextReviewDueSeconds = nextReviewDueSecondsMeaning;
                        reviews = reviewsMeaning;
                        lvl1 = lvl1Meaning;
                        lvl2 = lvl2Meaning;
                        lvl3 = lvl3Meaning;
                        lvl4 = lvl4Meaning;
                        lvl5 = lvl5Meaning;
                        break;
                    }
                    case 2: {
                        nextReviewDueSeconds = nextReviewDueSecondsReading;
                        reviews = reviewsReading;
                        lvl1 = lvl1Reading;
                        lvl2 = lvl2Reading;
                        lvl3 = lvl3Reading;
                        lvl4 = lvl4Reading;
                        lvl5 = lvl5Reading;
                        break;
                    }
                    default: {
                        nextReviewDueSeconds = nextReviewDueSecondsMeaning != null && nextReviewDueSecondsReading != null ? (Long.parseLong(nextReviewDueSecondsMeaning) <= Long.parseLong(nextReviewDueSecondsReading) ? nextReviewDueSecondsMeaning : nextReviewDueSecondsReading) : nextReviewDueSecondsMeaning;
                        reviews = reviewsMeaning + reviewsReading;
                        lvl1 = lvl1Meaning + lvl1Reading;
                        lvl2 = lvl2Meaning + lvl2Reading;
                        lvl3 = lvl3Meaning + lvl3Reading;
                        lvl4 = lvl4Meaning + lvl4Reading;
                        lvl5 = lvl5Meaning + lvl5Reading;
                    }
                }
                StudyScreen.setDailyLimitLeft(studyLimitLeft);
                Dashboard.setData(nextReviewDueSeconds, reviews, lvl1, lvl2, lvl3, lvl4, lvl5);
                if (startStudySession || startReviewSession) {
                    final int finalStudyLimitLeft = studyLimitLeft;
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            int reviews;
                            switch (ReviewScreen.getReviewMode()) {
                                case 1: {
                                    reviews = reviewsMeaning;
                                    break;
                                }
                                case 2: {
                                    reviews = reviewsReading;
                                    break;
                                }
                                default: {
                                    reviews = reviewsMeaning + reviewsReading;
                                }
                            }
                            if (startStudySession && finalStudyLimitLeft > 0) {
                                RestClient.getLessons();
                            } else if (startReviewSession && reviews > 0) {
                                RestClient.getReviews(-1);
                            } else {
                                LoadingScreen.hideOnScreen();
                            }
                        }
                    });
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Refreshing data failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Refreshing data cancelled.");
            }
        };
        if (startStudySession || startReviewSession) {
            http.setKeepLoadingScreen(true);
        }
        http.setErrorCodeReference(7);
        http.init("progression", null, true);
    }

    static void getProgressionDetails() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int itemsReviewed = this.jsonValue.get("progression_details").getInt("reviewed");
                int itemsCorrectlyAnswered = this.jsonValue.get("progression_details").getInt("correct");
                int itemsLearned = this.jsonValue.get("progression_details").getInt("learned");
                int itemsLearnable = this.jsonValue.get("progression_details").getInt("learnable");
                int secUntilReset = this.jsonValue.get("times").getInt("sec_until_reset");
                int toriiTime = this.jsonValue.get("times").getInt("torii_time");
                int studyTime = this.jsonValue.get("times").getInt("study_time");
                int reviewTime = this.jsonValue.get("times").getInt("review_time");
                ProgressScreen.setItemsReviewed(itemsReviewed);
                ProgressScreen.setItemsAnsweredCorrectly(itemsCorrectlyAnswered);
                ProgressScreen.setItemsLearned(itemsLearned);
                ProgressScreen.setItemsToLearn(itemsLearnable);
                ProgressScreen.setTimeUntilDailyReset(secUntilReset);
                ProgressScreen.setToriiTime(toriiTime);
                ProgressScreen.setStudyTime(studyTime);
                ProgressScreen.setReviewTime(reviewTime);
                ProgressScreen.setData();
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching data failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching data cancelled.");
            }
        };
        http.setErrorCodeReference(8);
        http.init("progression-details", null, true);
    }

    static void resetAccount() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                LoginScreen.logOut();
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Account reset failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Account reset cancelled.");
            }
        };
        http.setErrorCodeReference(12);
        http.init("reset-account", null, true);
    }

    static void deleteAccount() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoginScreen.logOut();
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Account deletion failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Account deletion cancelled.");
            }
        };
        http.setErrorCodeReference(13);
        http.init("delete-account", null, true);
    }

    static void resetStudyMode() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        WelcomeScreen.showOnScreen(true);
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Switching Study Mode failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Switching Study Mode cancelled.");
            }
        };
        http.setErrorCodeReference(14);
        http.init("reset-mode", null, true);
    }

    static void unlockSingleVocab(int vocabID) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentPage()));
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Adjusting vocab position in queue failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Adjusting vocab position in queue cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"vocab_id", vocabID}};
        http.setErrorCodeReference(29);
        http.init("unlock-single", params, true);
    }

    static void archiveVocab(final String vocab, final int vocabID, final boolean archive) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (archive) {
                            if (Main.getCurrentScreen() == StudyScreen.lessonScreen) {
                                StudyScreen.archiveVocab(vocab, vocabID);
                            } else if (Main.getCurrentScreen() == ReviewScreen.reviewScreen) {
                                ReviewScreen.archiveVocab(vocab, vocabID);
                            } else {
                                Main.setNewScreen(new BrowseScreen(BrowseScreen.getCurrentInterface(), BrowseScreen.getCurrentSearchKeyword(), BrowseScreen.getCurrentPage()));
                            }
                        } else if (Main.getCurrentScreen() == StudyScreen.lessonScreen) {
                            StudyScreen.restoreVocab(vocab, vocabID);
                        } else if (Main.getCurrentScreen() == ReviewScreen.reviewScreen) {
                            ReviewScreen.restoreVocab(vocab);
                        } else {
                            Main.setNewScreen(new BrowseScreen(BrowseScreen.BrowseInterface.ARCHIVED, BrowseScreen.getCurrentPage()));
                        }
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Archiving vocab failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Archiving vocab cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"vocab_id", vocabID}, {"archive", archive}};
        http.setErrorCodeReference(15);
        http.init("archive", params, true);
    }

    static void getUnlockedVocabList(int page) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                final int amountTotal = this.jsonValue.get("unlocked_data").getInt("amount_total");
                int noOfLessons = this.jsonValue.get((String)"unlocked_vocab").size;
                final int[] id = new int[noOfLessons];
                final int[] meaningLevel = new int[noOfLessons];
                final int[] meaningReviewed = new int[noOfLessons];
                final int[] meaningCorrect = new int[noOfLessons];
                final int[] readingLevel = new int[noOfLessons];
                final int[] readingReviewed = new int[noOfLessons];
                final int[] readingCorrect = new int[noOfLessons];
                final String[] vocabKanji = new String[noOfLessons];
                final String[] vocabKana = new String[noOfLessons];
                final String[] meaning = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    id[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("id");
                    meaningLevel[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("streak_meaning");
                    meaningReviewed[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("reviewed_meaning");
                    meaningCorrect[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("correct_meaning");
                    readingLevel[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("streak_reading");
                    readingReviewed[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("reviewed_reading");
                    readingCorrect[x] = this.jsonValue.get("unlocked_vocab").get(x).getInt("correct_reading");
                    vocabKanji[x] = this.jsonValue.get("unlocked_vocab").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("unlocked_vocab").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("unlocked_vocab").get(x).getString("meaning");
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        BrowseScreen.setUnlockedVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching unlocked vocab list failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching unlocked vocab list cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"page", page}};
        http.setErrorCodeReference(26);
        http.init("unlocked-get", params, true);
    }

    static void getCustomVocabList(int page) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                final int amountTotal = this.jsonValue.get("custom_data").getInt("amount_total");
                int noOfLessons = this.jsonValue.get((String)"custom_vocab").size;
                final int[] id = new int[noOfLessons];
                final int[] meaningLevel = new int[noOfLessons];
                final int[] meaningReviewed = new int[noOfLessons];
                final int[] meaningCorrect = new int[noOfLessons];
                final int[] readingLevel = new int[noOfLessons];
                final int[] readingReviewed = new int[noOfLessons];
                final int[] readingCorrect = new int[noOfLessons];
                final String[] vocabKanji = new String[noOfLessons];
                final String[] vocabKana = new String[noOfLessons];
                final String[] meaning = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    id[x] = this.jsonValue.get("custom_vocab").get(x).getInt("id");
                    meaningLevel[x] = this.jsonValue.get("custom_vocab").get(x).getInt("streak_meaning");
                    meaningReviewed[x] = this.jsonValue.get("custom_vocab").get(x).getInt("reviewed_meaning");
                    meaningCorrect[x] = this.jsonValue.get("custom_vocab").get(x).getInt("correct_meaning");
                    readingLevel[x] = this.jsonValue.get("custom_vocab").get(x).getInt("streak_reading");
                    readingReviewed[x] = this.jsonValue.get("custom_vocab").get(x).getInt("reviewed_reading");
                    readingCorrect[x] = this.jsonValue.get("custom_vocab").get(x).getInt("correct_reading");
                    vocabKanji[x] = this.jsonValue.get("custom_vocab").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("custom_vocab").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("custom_vocab").get(x).getString("meaning");
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        BrowseScreen.setCustomVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching custom vocab list failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching custom vocab list cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"page", page}};
        http.setErrorCodeReference(16);
        http.init("custom-get", params, true);
    }

    static void getArchivedVocabList(int page) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                final int amountTotal = this.jsonValue.get("archived_data").getInt("amount_total");
                int noOfLessons = this.jsonValue.get((String)"archived_vocab").size;
                final int[] id = new int[noOfLessons];
                final int[] meaningLevel = new int[noOfLessons];
                final int[] meaningReviewed = new int[noOfLessons];
                final int[] meaningCorrect = new int[noOfLessons];
                final int[] readingLevel = new int[noOfLessons];
                final int[] readingReviewed = new int[noOfLessons];
                final int[] readingCorrect = new int[noOfLessons];
                final String[] vocabKanji = new String[noOfLessons];
                final String[] vocabKana = new String[noOfLessons];
                final String[] meaning = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    id[x] = this.jsonValue.get("archived_vocab").get(x).getInt("id");
                    meaningLevel[x] = this.jsonValue.get("archived_vocab").get(x).getInt("streak_meaning");
                    meaningReviewed[x] = this.jsonValue.get("archived_vocab").get(x).getInt("reviewed_meaning");
                    meaningCorrect[x] = this.jsonValue.get("archived_vocab").get(x).getInt("correct_meaning");
                    readingLevel[x] = this.jsonValue.get("archived_vocab").get(x).getInt("streak_reading");
                    readingReviewed[x] = this.jsonValue.get("archived_vocab").get(x).getInt("reviewed_reading");
                    readingCorrect[x] = this.jsonValue.get("archived_vocab").get(x).getInt("correct_reading");
                    vocabKanji[x] = this.jsonValue.get("archived_vocab").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("archived_vocab").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("archived_vocab").get(x).getString("meaning");
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        BrowseScreen.setArchivedVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching archived vocab list failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching archived vocab list cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"page", page}};
        http.setErrorCodeReference(17);
        http.init("archived-get", params, true);
    }

    static void getPracticeListVocabList(int listID, int page) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int amountTotal = this.jsonValue.get("practice_data").getInt("amount_total");
                int noOfLessons = this.jsonValue.get((String)"practice_vocab").size;
                int[] id = new int[noOfLessons];
                int[] meaningLevel = new int[noOfLessons];
                int[] meaningReviewed = new int[noOfLessons];
                int[] meaningCorrect = new int[noOfLessons];
                int[] readingLevel = new int[noOfLessons];
                int[] readingReviewed = new int[noOfLessons];
                int[] readingCorrect = new int[noOfLessons];
                String[] vocabKanji = new String[noOfLessons];
                String[] vocabKana = new String[noOfLessons];
                String[] meaning = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    id[x] = this.jsonValue.get("practice_vocab").get(x).getInt("id");
                    meaningLevel[x] = this.jsonValue.get("practice_vocab").get(x).getInt("streak_meaning");
                    meaningReviewed[x] = this.jsonValue.get("practice_vocab").get(x).getInt("reviewed_meaning");
                    meaningCorrect[x] = this.jsonValue.get("practice_vocab").get(x).getInt("correct_meaning");
                    readingLevel[x] = this.jsonValue.get("practice_vocab").get(x).getInt("streak_reading");
                    readingReviewed[x] = this.jsonValue.get("practice_vocab").get(x).getInt("reviewed_reading");
                    readingCorrect[x] = this.jsonValue.get("practice_vocab").get(x).getInt("correct_reading");
                    vocabKanji[x] = this.jsonValue.get("practice_vocab").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("practice_vocab").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("practice_vocab").get(x).getString("meaning");
                }
                BrowseScreen.setPracticeListVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching Practice List vocab list failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching Practice List vocab list cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"list_id", listID}, {"page", page}};
        http.setErrorCodeReference(25);
        http.init("practice-get", params, true);
    }

    static void getVocabList(final String keywordMeaning, final String keywordReading, int page) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                final int amountTotal = this.jsonValue.get("vocab_data").getInt("amount_total");
                int noOfLessons = this.jsonValue.get((String)"vocab").size;
                final int[] id = new int[noOfLessons];
                final int[] meaningLevel = new int[noOfLessons];
                final int[] meaningReviewed = new int[noOfLessons];
                final int[] meaningCorrect = new int[noOfLessons];
                final int[] readingLevel = new int[noOfLessons];
                final int[] readingReviewed = new int[noOfLessons];
                final int[] readingCorrect = new int[noOfLessons];
                final String[] vocabKanji = new String[noOfLessons];
                final String[] vocabKana = new String[noOfLessons];
                final String[] meaning = new String[noOfLessons];
                for (int x = 0; x < noOfLessons; ++x) {
                    id[x] = this.jsonValue.get("vocab").get(x).getInt("id");
                    meaningLevel[x] = this.jsonValue.get("vocab").get(x).getInt("streak_meaning");
                    meaningReviewed[x] = this.jsonValue.get("vocab").get(x).getInt("reviewed_meaning");
                    meaningCorrect[x] = this.jsonValue.get("vocab").get(x).getInt("correct_meaning");
                    readingLevel[x] = this.jsonValue.get("vocab").get(x).getInt("streak_reading");
                    readingReviewed[x] = this.jsonValue.get("vocab").get(x).getInt("reviewed_reading");
                    readingCorrect[x] = this.jsonValue.get("vocab").get(x).getInt("correct_reading");
                    vocabKanji[x] = this.jsonValue.get("vocab").get(x).getString("vocab");
                    vocabKana[x] = this.jsonValue.get("vocab").get(x).getString("vocab_kana");
                    meaning[x] = this.jsonValue.get("vocab").get(x).getString("meaning");
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (keywordMeaning != null) {
                            BrowseScreen.setSearchMeaningList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
                        } else if (keywordReading != null) {
                            BrowseScreen.setSearchReadingList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
                        }
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching vocab list failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching vocab list cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"keyword_meaning", keywordMeaning}, {"keyword_reading", keywordReading}, {"page", page}};
        http.setErrorCodeReference(20);
        http.init("vocab-list", params, true);
    }

    static void getSingleVocab(final int id) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                final String vocabKanji = this.jsonValue.get("vocab").getString("vocab");
                final String vocabKana = this.jsonValue.get("vocab").getString("vocab_kana");
                final String meaning = this.jsonValue.get("vocab").getString("meaning");
                final String altMeanings = this.jsonValue.get("vocab").getString("alt_meanings");
                final String altReadings = this.jsonValue.get("vocab").getString("alt_readings");
                final String sentence = this.jsonValue.get("vocab").getString("sentence");
                final String sentenceMeaning = this.jsonValue.get("vocab").getString("sentence_meaning");
                String examples = this.jsonValue.get("vocab").getString("examples");
                final String pos = this.jsonValue.get("vocab").getString("pos");
                final String vocabAudio = this.jsonValue.get("vocab").getString("vocab_audio");
                final String sentenceAudio = this.jsonValue.get("vocab").getString("sentence_audio");
                final String synonyms = this.jsonValue.get("vocab").getString("synonyms");
                final String readings = this.jsonValue.get("vocab").getString("readings");
                final String notes = this.jsonValue.get("vocab").getString("notes");
                int jlpt = this.jsonValue.get("vocab").getInt("jlpt_level");
                int streakMeaning = this.jsonValue.get("vocab").getInt("streak_meaning");
                int streakReading = this.jsonValue.get("vocab").getInt("streak_reading");
                final int streak = (streakMeaning + streakReading) / 2;
                examples = examples != null ? examples.replace("<br>", "\n\n") : examples;
                final String jlptLevel = jlpt > 0 ? "JLPT N" + jlpt : "";
                final String finalExamples = examples;
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (id < 10000) {
                            StudyScreen.viewVocab(id, vocabKanji, vocabKana, meaning, altMeanings, altReadings, sentence, sentenceMeaning, finalExamples, pos, jlptLevel, vocabAudio, sentenceAudio, synonyms, readings, notes);
                        } else {
                            Main.setNewScreen(new AddVocabScreen(new AddVocabScreen.Vocabulary(id, vocabKanji, vocabKana, meaning, sentence, sentenceMeaning, pos, synonyms, readings, notes, streak)));
                        }
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching vocab data failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching vocab data cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"id", id}};
        http.setErrorCodeReference(18);
        http.init("vocab-get", params, true);
    }

    static void addPracticeList(final PracticeScreen.PracticeListsTable parent, String name, final boolean delete) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                RestClient.getPracticeLists(parent);
            }

            @Override
            void failed() {
                String s = delete ? "Deleting " : "Adding ";
                Dialogs.showErrorDialog(Main.getCurrentStage(), s + "Practice List failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                String s = delete ? "Deleting " : "Adding ";
                Dialogs.showErrorDialog(Main.getCurrentStage(), s + "Practice List cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"name", name}, {"delete", delete}};
        http.setErrorCodeReference(23);
        http.init("practice-create", params, true);
    }

    static void addVocabToPracticeList(PracticeScreen.PracticeListsTable parent, int listID, int vocabID, boolean remove) {
        RestClient.addVocabToPracticeList(parent, new int[]{listID}, vocabID, remove);
    }

    static void addVocabToPracticeList(final PracticeScreen.PracticeListsTable parent, int[] listID, int vocabID, final boolean remove) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                if (parent != null) {
                    if (parent.isAutoDbUpdatesEnabled()) {
                        parent.refreshData();
                    }
                } else {
                    Main.setNewScreen(new BrowseScreen(BrowseScreen.BrowseInterface.PRACTICE, BrowseScreen.getCurrentlySelectedPracticeListID(), BrowseScreen.getCurrentPage()));
                }
            }

            @Override
            void failed() {
                String s = remove ? "Removing vocab from " : "Adding vocab to ";
                Dialogs.showErrorDialog(Main.getCurrentStage(), s + "Practice List failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                String s = remove ? "Removing vocab from " : "Adding vocab to ";
                Dialogs.showErrorDialog(Main.getCurrentStage(), s + "Practice List cancelled.");
            }
        };
        CharArray s = new CharArray();
        for (int aListID : listID) {
            s.append(aListID).append(";");
        }
        Object[][] params = new Object[][]{{"list_id", s.toString()}, {"vocab_id", vocabID}, {"remove", remove}};
        if (parent != null && !parent.isAutoDbUpdatesEnabled()) {
            http.setIsBackgroundProcess(true);
        }
        http.setErrorCodeReference(24);
        http.init("practice-add", params, true);
    }

    static void getPracticeLists(final PracticeScreen.PracticeListsTable parent) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int noOfLists = this.jsonValue.get((String)"practice_lists").size;
                int[] id = new int[noOfLists];
                int[] count = new int[noOfLists];
                String[] name = new String[noOfLists];
                for (int x = 0; x < noOfLists; ++x) {
                    id[x] = this.jsonValue.get("practice_lists").get(x).getInt("id");
                    count[x] = this.jsonValue.get("practice_lists").get(x).getInt("count");
                    name[x] = this.jsonValue.get("practice_lists").get(x).getString("name");
                }
                parent.setPracticeLists(id, count, name);
                if (parent.getVocabID() != -1 && this.jsonValue.has("parent_lists")) {
                    int noOfParentLists = this.jsonValue.get((String)"parent_lists").size;
                    int[] parentID = new int[noOfParentLists];
                    int[] parentCount = new int[noOfParentLists];
                    String[] parentName = new String[noOfParentLists];
                    for (int x = 0; x < noOfParentLists; ++x) {
                        parentID[x] = this.jsonValue.get("parent_lists").get(x).getInt("id");
                        parentName[x] = this.jsonValue.get("parent_lists").get(x).getString("name");
                        for (int y = 0; y < noOfLists; ++y) {
                            if (!name[y].equals(parentName[x])) continue;
                            parentCount[x] = count[y];
                        }
                    }
                    parent.setParentLists(parentID, parentCount, parentName);
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Getting Practice Lists failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Getting Practice Lists cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"vocab_id", parent.getVocabID()}};
        http.setErrorCodeReference(22);
        http.init("practice-list", params, true);
    }

    static void deleteCustomVocab(int id) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                Main.setCustomVocabAmount(Main.getCustomVocabAmount() - 1);
                Main.setNewScreen(new BrowseScreen(BrowseScreen.BrowseInterface.CUSTOM, BrowseScreen.getCurrentPage()));
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Deleting custom vocab failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Deleting custom vocab cancelled.");
            }
        };
        Object[][] params = new Object[][]{{"id", id}};
        http.setErrorCodeReference(19);
        http.init("custom-delete", params, true);
    }

    static void getFonts() {
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl(RestClient.getProtocol() + WEBSITE + "/font_files/metadata");
        LoadingScreen.showOnScreen();
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                JsonReader jsonReader = new JsonReader();
                JsonValue jsonValue = jsonReader.parse(httpResponse.getResultAsString());
                int amount = jsonValue.get((String)"fonts").size;
                String[] name = new String[amount];
                String[] fileName = new String[amount];
                long[] size = new long[amount];
                final SettingsScreen.Font[] fonts = new SettingsScreen.Font[amount];
                for (int x = 0; x < amount; ++x) {
                    name[x] = jsonValue.get("fonts").get(x).getString("name");
                    fileName[x] = jsonValue.get("fonts").get(x).getString("filename");
                    size[x] = jsonValue.get("fonts").get(x).getLong("size");
                    fonts[x] = new SettingsScreen.Font(name[x], fileName[x], size[x]);
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        SettingsScreen.setInstallableFontsList(fonts);
                    }
                });
            }

            @Override
            public void failed(final Throwable t) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        if (t instanceof UnknownHostException || t instanceof NoRouteToHostException) {
                            InfoScreen.showNoNetworkNotification();
                        } else {
                            Dialogs.showErrorDialog(Main.getCurrentStage(), "Could not fetch font list.", new Exception(t));
                        }
                    }
                });
            }

            @Override
            public void cancelled() {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.hideOnScreen();
                        Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching font list cancelled.");
                    }
                });
            }
        });
    }

    static void openTransactionPage(boolean lifetime) {
        boolean opened = Gdx.net.openURI(RestClient.getProtocol() + DOMAIN + "/prime-init?token=" + authorizationToken + "&lifetime=" + lifetime);
        if (opened) {
            InfoScreen.showInfoMessage("Almost done", "A new browser window has opened and you are being redirected to PayPal. Please follow the instructions on PayPal's payment page.\n\nAfter the transaction is completed, click the button below to verify your Prime status.\n\n[CR]Notice[]\nIf your account is not upgraded within a few minutes, please contact support: [CR]support@torii-srs.com[].", "Verify Prime Status", new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    RestClient.checkPrimeStatus();
                }
            });
        } else {
            Dialogs.showOKDialog(Main.getCurrentStage(), "Something went wrong...", "Please contact [CR]support@torii-srs.com[] if this error persists.");
        }
    }

    static void openCustomDonationPage() {
        boolean opened = Gdx.net.openURI(RestClient.getProtocol() + DOMAIN + "/donate?token=" + authorizationToken);
        if (opened) {
            Dialogs.showOKDialog(Main.getCurrentStage(), "Almost done", "A new browser window has opened and you are being redirected to PayPal. Please follow the instructions on PayPal's payment page.");
        } else {
            Dialogs.showOKDialog(Main.getCurrentStage(), "Something went wrong...", "Please contact [CR]support@torii-srs.com[] if this error persists.");
        }
    }

    private static void checkPrimeStatus() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                boolean isPrimeMember = this.jsonValue.get("prime_status").getInt("is_prime") == 1;
                String isPrimeUntil = this.jsonValue.get("prime_status").getString("prime_until");
                Main.setIsPrime(isPrimeMember, isPrimeUntil);
                if (!isPrimeMember) {
                    Dialogs.showConfirmDialog(Main.getCurrentStage(), "Uh-oh...", "You're not a Prime member yet.\nGo back to the dashboard anyway?", new String[]{"Yes", "Try again"}, new Dialogs.ConfirmAdapter(){

                        @Override
                        public void yes() {
                            Dashboard.showOnScreen();
                        }
                    });
                } else {
                    Dashboard.showOnScreen();
                }
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Verifying Prime status failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Verifying Prime status cancelled.");
            }
        };
        http.setErrorCodeReference(21);
        http.init("prime-check", null, true);
    }

    static void getPrimeDetails() {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                int subPrice = this.jsonValue.get("prime_details").getInt("subscription_price");
                int subPriceDiscounted = this.jsonValue.get("prime_details").getInt("subscription_discounted");
                int subInterval = this.jsonValue.get("prime_details").getInt("subscription_interval");
                int lifetimePrice = this.jsonValue.get("prime_details").getInt("lifetime_price");
                int lifetimePriceDiscounted = this.jsonValue.get("prime_details").getInt("lifetime_discounted");
                String message = this.jsonValue.get("prime_details").getString("message");
                String discountExpires = this.jsonValue.get("prime_details").getString("expires");
                PrimeScreen.updatePrices(message, subPrice, subPriceDiscounted, subInterval, lifetimePrice, lifetimePriceDiscounted, discountExpires);
                Main.setNewScreen(new PrimeScreen());
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching Prime details failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Fetching Prime details cancelled.");
            }
        };
        http.setErrorCodeReference(27);
        http.init("prime-get", null, false);
    }

    static void updateVacationMode(boolean setIsActivated) {
        HttpRequestHandler http = new HttpRequestHandler(){

            @Override
            void success() {
                String lastVacationModeEnded = this.jsonValue.get("vacation_mode").getString("vacation_end");
                boolean isVacationModeActivated = this.jsonValue.get("vacation_mode").getInt("vacation_on") == 1;
                Main.setIsVacationModeActivated(isVacationModeActivated, lastVacationModeEnded);
                String s = isVacationModeActivated ? "activated.\nEnjoy your time off!" : "deactivated.\nAll your Reviews have been pushed out by the duration of your vacation and will appear on schedule.\nWelcome back!";
                Dialogs.showOKDialog(Main.getCurrentStage(), "Success", "Vacation Mode is now " + s, new Dialogs.OKAdapter(){

                    @Override
                    public void ok() {
                        Dashboard.showOnScreen();
                        Dashboard.setIsReadyToRefresh(true);
                    }
                });
            }

            @Override
            void failed() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Updating Vacation Mode failed.", new Exception(this.getFailedThrowable()));
            }

            @Override
            void cancelled() {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "Updating Vacation Mode cancelled.");
            }
        };
        http.setErrorCodeReference(28);
        Object[][] params = new Object[][]{{"activated", setIsActivated}};
        http.init("update/vacation-mode", params, true);
    }

    private static String getProtocol() {
        return "https://";
    }

    private static void checkNetworkConnection() {
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        httpGet.setUrl("https://example.com");
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                isNetworkConnectionLost = false;
            }

            @Override
            public void failed(final Throwable t) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        if (t instanceof UnknownHostException || t instanceof NoRouteToHostException) {
                            isNetworkConnectionLost = true;
                            Dialogs.showOKDialog(Main.getCurrentStage(), "No Network Connection", "Make sure you're connected to the internet, then click 'OK'.", new Dialogs.OKAdapter(){

                                @Override
                                public void ok() {
                                    RestClient.checkNetworkConnection();
                                }
                            });
                        }
                    }
                });
            }

            @Override
            public void cancelled() {
            }
        });
    }

    static {
        isNetworkConnectionLost = false;
    }

    private static abstract class HttpRequestHandler {
        JsonValue jsonValue;
        private Throwable failedThrowable;
        private int errorCodeReference = -1;
        private boolean isBackgroundProcess = false;
        private boolean keepLoadingScreen = false;

        HttpRequestHandler() {
        }

        void init(String url, Object[][] params, boolean isAuthorizationRequired) {
            if (isNetworkConnectionLost) {
                return;
            }
            if (!this.isBackgroundProcess) {
                LoadingScreen.showOnScreen();
            }
            String paramsParsed = "/" + url;
            if (params != null) {
                try {
                    for (int i = 0; i < params.length; ++i) {
                        String connector = i == 0 ? "?" : "&";
                        String encoded = "";
                        if (params[i][1] != null) {
                            encoded = URLEncoder.encode(params[i][1].toString(), "UTF-8");
                        }
                        if (encoded.equals("")) {
                            encoded = null;
                        }
                        paramsParsed = paramsParsed + connector + params[i][0].toString() + "=" + encoded;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!this.isBackgroundProcess) {
                        LoadingScreen.hideOnScreen();
                    }
                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Something went wrong :(", e);
                    return;
                }
            }
            Net.HttpRequest httpGet = new Net.HttpRequest("GET");
            httpGet.setUrl(RestClient.getProtocol() + RestClient.DOMAIN + paramsParsed);
            if (isAuthorizationRequired) {
                httpGet.setHeader("Authorization", authorizationToken);
            }
            Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

                @Override
                public void handleHttpResponse(Net.HttpResponse httpResponse) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (!isBackgroundProcess && !keepLoadingScreen) {
                                LoadingScreen.hideOnScreen();
                            }
                        }
                    });
                    String sHttpResponse = httpResponse.getResultAsString();
                    if (httpResponse.getStatus().getStatusCode() == 500) {
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (!isBackgroundProcess) {
                                    this.error("");
                                    Dialogs.showErrorDialog(Main.getCurrentStage(), "Internal Server Error.\nPlease try again in a few moments.");
                                }
                            }
                        });
                    } else {
                        JsonReader jsonReader = new JsonReader();
                        jsonValue = jsonReader.parse(sHttpResponse);
                        if (!jsonValue.getBoolean("error")) {
                            Gdx.app.postRunnable(new Runnable(){

                                @Override
                                public void run() {
                                    this.success();
                                }
                            });
                        } else {
                            final String errorCode = jsonValue.getString("error_code");
                            String authErrorCode = "access_denied";
                            if (errorCode.equals("access_denied")) {
                                Gdx.app.postRunnable(new Runnable(){

                                    @Override
                                    public void run() {
                                        Dialogs.showOKDialog(Main.getCurrentStage(), "Authorization failed", "Torii will exit.", new Dialogs.OKAdapter(){

                                            @Override
                                            public void ok() {
                                                Gdx.app.exit();
                                            }
                                        });
                                    }
                                });
                            } else {
                                Gdx.app.postRunnable(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!isBackgroundProcess) {
                                            this.error(errorCode);
                                        }
                                    }
                                });
                            }
                        }
                    }
                }

                @Override
                public void failed(final Throwable t) {
                    failedThrowable = t;
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (!isBackgroundProcess) {
                                LoadingScreen.hideOnScreen();
                            }
                            if (t instanceof UnknownHostException || t instanceof NoRouteToHostException) {
                                isNetworkConnectionLost = true;
                                Dialogs.showOKDialog(Main.getCurrentStage(), "Network Connection Lost", "Make sure you're connected to the internet, then click 'OK'.", new Dialogs.OKAdapter(){

                                    @Override
                                    public void ok() {
                                        RestClient.checkNetworkConnection();
                                    }
                                });
                            } else if (!isBackgroundProcess) {
                                this.failed();
                            }
                        }
                    });
                }

                @Override
                public void cancelled() {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (!isBackgroundProcess) {
                                LoadingScreen.hideOnScreen();
                                this.cancelled();
                            }
                        }
                    });
                }
            });
        }

        void error(String errorCode) {
            if (!errorCode.equals("")) {
                Dialogs.showErrorDialog(Main.getCurrentStage(), "An error occurred.\nPlease try again in a few seconds.\n\nError code reference: " + this.errorCodeReference);
            }
        }

        void setErrorCodeReference(int id) {
            this.errorCodeReference = id;
        }

        void setIsBackgroundProcess(boolean isBackgroundProcess) {
            this.isBackgroundProcess = isBackgroundProcess;
        }

        void setKeepLoadingScreen(boolean keep) {
            this.keepLoadingScreen = keep;
        }

        Throwable getFailedThrowable() {
            return this.failedThrowable;
        }

        abstract void success();

        abstract void failed();

        abstract void cancelled();
    }
}

