/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.torii.srs.Main;

public class ResourceMonitor
implements Screen {
    private final long MB = 0x100000L;
    static ResourceMonitor resourceMonitor;
    private Screen parentScreen;
    private Stage stage;
    private ScreenViewport screenView;
    private ShapeRenderer renderer;
    private VisTable dialog;
    private VisLabel lrm;
    private VisLabel taRM1;
    private VisLabel taRM2;
    private String operatingSystemName;
    private String operatingSystemVersion;
    private String operatingSystemArchitecture;
    private String javaVersion;
    private String javaVendor;
    private String javaVendorUrl;
    private Timer.Task timerTask;
    private Timer.Task refreshTimer;
    private Timer.Task garbageCollector;
    private ClickListener listener;
    private float t = 0.0f;

    ResourceMonitor() {
        resourceMonitor = this;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.screenView = new ScreenViewport();
        this.renderer = new ShapeRenderer();
        this.dialog = new VisTable();
        this.lrm = new VisLabel((CharSequence)"RESOURCE MONITOR", Main.labelStyleX2);
        this.taRM1 = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.taRM2 = new VisLabel((CharSequence)"N/A", Main.labelStyleX1);
        this.renderer.setAutoShapeType(true);
        this.renderer.setColor(0.0f, 0.0f, 0.0f, 0.95f);
        this.timerTask = new Timer.Task(){

            @Override
            public void run() {
                ResourceMonitor.this.stage.addListener(ResourceMonitor.this.listener);
            }
        };
        this.refreshTimer = new Timer.Task(){

            @Override
            public void run() {
                ResourceMonitor.this.refresh();
            }
        };
        this.garbageCollector = new Timer.Task(){

            @Override
            public void run() {
                System.gc();
            }
        };
        this.listener = new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111 || keycode == 142) {
                    ResourceMonitor.hideOnScreen();
                }
                return false;
            }
        };
        this.dialog.setFillParent(true);
        this.dialog.align(2);
        this.dialog.add(this.lrm).colspan(2).padBottom(2 * Main.getPPUY()).row();
        this.dialog.add(this.taRM1).expandX();
        this.dialog.add(this.taRM2).expandX();
        this.stage.addActor(this.dialog);
        Timer.schedule(this.garbageCollector, 30.0f, 60.0f);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.operatingSystemName = System.getProperty("os.name");
        this.operatingSystemVersion = System.getProperty("os.version");
        this.operatingSystemArchitecture = System.getProperty("os.arch");
        this.javaVersion = System.getProperty("java.version");
        this.javaVendor = System.getProperty("java.vendor");
        this.javaVendorUrl = System.getProperty("java.vendor.url");
        if (!this.timerTask.isScheduled()) {
            Timer.schedule(this.timerTask, 1.0f, 1.0f, 0);
        }
        if (!this.refreshTimer.isScheduled()) {
            Timer.schedule(this.refreshTimer, 1.0f, 1.0f);
        }
    }

    @Override
    public void render(float delta) {
        if (this.parentScreen != null) {
            this.parentScreen.render(delta);
        }
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.screenView.apply();
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.rect(0.0f, 0.0f, this.screenView.getWorldWidth(), this.screenView.getWorldHeight());
        this.renderer.end();
        this.stage.getViewport().apply();
        this.stage.act(delta);
        this.stage.draw();
        if (Gdx.input.isTouched()) {
            this.t += Gdx.graphics.getDeltaTime();
            if (this.t > 1.0f) {
                this.t = 0.0f;
                ResourceMonitor.hideOnScreen();
            }
        } else {
            this.t = 0.0f;
        }
    }

    @Override
    public void resize(int width, int height) {
        if (this.parentScreen != null) {
            this.parentScreen.resize(width, height);
        }
        this.stage.getViewport().update(width, height, true);
        this.screenView.update(width, height);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.stage.removeListener(this.listener);
        this.refreshTimer.cancel();
    }

    @Override
    public void dispose() {
    }

    public static void showOnScreen() {
        ResourceMonitor.resourceMonitor.parentScreen = Main.getCurrentScreen();
        Main.setNewScreen(resourceMonitor);
    }

    public static void hideOnScreen() {
        Main.setNewScreen(ResourceMonitor.resourceMonitor.parentScreen);
    }

    private void refresh() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory() / 0x100000L;
        long totalMemory = runtime.totalMemory() / 0x100000L;
        long freeMemory = runtime.freeMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        int availableProcessors = runtime.availableProcessors();
        this.taRM1.setText("Max memory\nAssigned memory\nFree memory\nMemory in use\nAvailable processors\n\nOperating System\nOS Version\nOS Architecture\n\nJava Version\nJava Vendor\nVendor URL\n\nFPS");
        this.taRM2.setText(maxMemory + " MB\n" + totalMemory + " MB\n" + freeMemory + " MB\n" + usedMemory + " MB\n" + availableProcessors + "\n\n" + this.operatingSystemName + "\n" + this.operatingSystemVersion + "\n" + this.operatingSystemArchitecture + "\n\n" + this.javaVersion + "\n" + this.javaVendor + "\n" + this.javaVendorUrl + "\n\n" + Gdx.graphics.getFramesPerSecond());
        this.dialog.pack();
    }
}

