/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.widget.Chart;
import com.torii.srs.widget.TopMenu;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class PrimeScreen
implements Screen {
    private Stage stage;
    private SpriteBatch batch;
    private VisTextButton tbSub;
    private VisTextButton tbLifetime;
    private VisTextButton tbCustomDonation;
    private static String saleMessage = "";
    private static int subscriptionPrice = 0;
    private static int subscriptionPriceDiscounted = 0;
    private static int subscriptionInterval = 0;
    private static int lifetimePrice = 0;
    private static int lifetimePriceDiscounted = 0;
    private static Calendar discountExpires;
    private Animation<TextureRegion> animOrange;
    private final int animOrangeWidth = 150;
    private final int animOrangeHeight = 150;
    private float deltaOrange;

    PrimeScreen() {
        VisTable tblMain = new VisTable(false);
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.batch = new SpriteBatch();
        this.animOrange = Main.pngToAnimation((Texture)Main.getAsset(Main.ORANGE_PATH, Texture.class, true), 150, 150, 0.2f);
        TopMenu topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                Dashboard.showOnScreen();
            }
        };
        tblMain.setFillParent(true);
        tblMain.align(2);
        tblMain.add(topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        this.createTransactionButtons();
        if (!Main.isPrime()) {
            tblMain.add(this.createNoPrimeTable()).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY();
        } else {
            tblMain.add(this.createIsPrimeTable()).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fillY();
        }
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 111 || keycode == 4) {
                    Dashboard.showOnScreen();
                }
                return true;
            }
        });
        this.stage.addActor(tblMain);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        if (!Main.isPrime() && PrimeScreen.isOnSale()) {
            String sDiscountExpires = "[CR]" + new SimpleDateFormat("MMMM dd, yyyy", Locale.ENGLISH).format(discountExpires.getTime()) + "[]";
            String sLifetime = "";
            String sSub = "";
            String sPuffer = "";
            if (lifetimePrice != lifetimePriceDiscounted) {
                float lifetimeDiscountPercent = (float)(lifetimePrice - lifetimePriceDiscounted) / (float)lifetimePrice * 100.0f;
                sLifetime = "Lifetime is [CR]" + (int)lifetimeDiscountPercent + "%[] off\nuntil " + sDiscountExpires + ".\nGet it now for [CR]$" + this.convertToDollar(lifetimePriceDiscounted) + "[] instead of $" + this.convertToDollar(lifetimePrice) + ".";
            }
            if (subscriptionPriceDiscounted != subscriptionPrice) {
                float subDiscountPercent = (float)(subscriptionPrice - subscriptionPriceDiscounted) / (float)subscriptionPrice * 100.0f;
                sSub = "Subscriptions are [CR]" + (int)subDiscountPercent + "%[] off\nuntil " + sDiscountExpires + ".\nGet it now for [CR]$" + this.convertToDollar(subscriptionPriceDiscounted * subscriptionInterval) + "[] instead of $" + this.convertToDollar(subscriptionPrice * subscriptionInterval) + ".";
            }
            if (!sLifetime.equals("") && !sSub.equals("")) {
                sPuffer = "\n---\n";
            }
            Dialogs.showOKDialog(this.stage, "Good News!", sLifetime + sPuffer + sSub);
        }
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
        if (Dashboard.isKonamiStreakOver9000()) {
            this.deltaOrange += delta;
            this.batch.begin();
            this.batch.draw(this.animOrange.getKeyFrame(this.deltaOrange, true), this.getStageLocation((Actor)this.tbLifetime).x + this.tbLifetime.getWidth() / 2.0f - 75.0f, this.getStageLocation((Actor)this.tbLifetime).y + this.tbLifetime.getHeight(), 150.0f, 150.0f);
            this.batch.end();
        }
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    static void init() {
        RestClient.getPrimeDetails();
    }

    static void updatePrices(String message, int subPrice, int subDiscounted, int subInterval, int ltPrice, int ltDiscounted, String sDiscountExpires) {
        saleMessage = message;
        subscriptionPrice = subPrice;
        subscriptionPriceDiscounted = subDiscounted;
        subscriptionInterval = subInterval;
        lifetimePrice = ltPrice;
        lifetimePriceDiscounted = ltDiscounted;
        discountExpires = Main.timestampToCalendar(sDiscountExpires);
    }

    static boolean isOnSale() {
        return lifetimePrice != lifetimePriceDiscounted || subscriptionPriceDiscounted != subscriptionPrice;
    }

    static String getSaleMessage() {
        return saleMessage;
    }

    private Vector2 getStageLocation(Actor actor) {
        return actor.localToStageCoordinates(new Vector2(0.0f, 0.0f));
    }

    private void createTransactionButtons() {
        String support1 = "Subscribe\n$" + this.convertToDollar(subscriptionPriceDiscounted) + "/mth";
        String support2 = "Lifetime\n$" + this.convertToDollar(lifetimePriceDiscounted);
        this.tbSub = new VisTextButton(support1, Main.btnStyleX1p25);
        this.tbLifetime = new VisTextButton(support2, Main.btnStyleX1p25);
        this.tbCustomDonation = new VisTextButton("Buy me a\ncoffee \u2661");
        this.tbSub.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RestClient.openTransactionPage(false);
            }
        });
        this.tbLifetime.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RestClient.openTransactionPage(true);
            }
        });
        this.tbCustomDonation.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                RestClient.openCustomDonationPage();
            }
        });
    }

    private VisTable createNoPrimeTable() {
        VisTable tblMain = new VisTable(false);
        VisTable tbl = new VisTable(false);
        VisTable tblButtons = new VisTable(false);
        VisLabel l0 = new VisLabel((CharSequence)"Loving Torii?", Main.labelStyleX1p25);
        VisLabel l1 = new VisLabel((CharSequence)"Thanks for considering a Prime upgrade \u2014 it helps keep Torii running!", Main.labelStyleX1);
        VisLabel l7 = new VisLabel((CharSequence)("All payments are handled through PayPal.\nEvery subscription lasts " + subscriptionInterval + " months. We don't offer monthly plans. Subscriptions DO NOT auto-renew. When your Prime status ends, no need to panic \u2014 your content stays safe and you can regain access anytime by subscribing again."), Main.labelStyleX0p5);
        l1.setWrap(true);
        l7.setWrap(true);
        l0.setAlignment(1);
        l1.setAlignment(1);
        l7.setAlignment(1);
        Chart chart = new Chart();
        chart.addTitleRow("Prime", "vs", "Standard");
        chart.addHeaderRow("Own Words & Phrases");
        chart.addRow("Unlimited", "", "10");
        chart.addHeaderRow("Practice Lists");
        chart.addRow("Yes", "", "No");
        chart.addHeaderRow("Vocab Notes Character Limit");
        chart.addRow("300", "", "150");
        chart.addHeaderRow("\u2661 Support Torii's Development \u2661");
        chart.addRow(":D", "", ":/");
        tbl.align(2);
        tbl.add(l0).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.add(l1).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.addSeparator().padBottom((float)Main.getPPUY() * 0.5f);
        tbl.add(chart).expand().fill().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.addSeparator().padBottom((float)Main.getPPUY() * 0.5f);
        tbl.add(l7).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.addSeparator();
        tblButtons.defaults().expandX().fillX().uniformX();
        tblButtons.add(this.tbSub).padRight(Main.getPPUY());
        tblButtons.add(this.tbLifetime).padLeft(Main.getPPUY()).row();
        tblMain.align(2);
        tblMain.add(tbl).expand().fill().padBottom((float)Main.getPPUY() * 0.5f).row();
        tblMain.add(tblButtons).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f);
        FocusManager.switchFocus(this.stage, this.tbLifetime);
        return tblMain;
    }

    private VisTable createIsPrimeTable() {
        Calendar primeUntil = Main.getIsPrimeUntil();
        String s1 = "[CR]" + new SimpleDateFormat("MMMM dd, yyyy", Locale.ENGLISH).format(primeUntil.getTime()) + "[]";
        String s2 = "[CR]" + new SimpleDateFormat("hh:mm a", Locale.ENGLISH).format(primeUntil.getTime()) + "[]";
        boolean isLifetimePrime = primeUntil.get(1) >= 2100;
        String s4 = isLifetimePrime ? "[CR]Never \u2014 lifetime membership.[]" : s1 + " at " + s2 + " CET/CEST.";
        VisTable tblMain = new VisTable(false);
        VisTable tbl = new VisTable(false);
        VisTable tblButtons = new VisTable(false);
        VisLabel l1 = new VisLabel((CharSequence)"Awesome \u2014 you're a Prime member!\nThank you so much for your support.", Main.labelStyleX1);
        VisLabel l2 = new VisLabel((CharSequence)("Your Prime status expires:\n" + s4), Main.labelStyleX1);
        VisLabel l3 = new VisLabel((CharSequence)"Got questions?", Main.labelStyleX1p25);
        VisLabel l4 = new VisLabel((CharSequence)"Something unclear, a technical issue, or an idea to improve Torii? Send me an email at [CR]hello@torii-srs.com[].\n\nI'd love to hear from you!\n- Rakantor", Main.labelStyleX1);
        l1.setWrap(true);
        l4.setWrap(true);
        l1.setAlignment(1);
        l2.setAlignment(1);
        tbl.align(2);
        tbl.add(l1).expandX().fillX().padBottom(Main.getPPUY()).row();
        tbl.add(l2).expandX().fillX().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.addSeparator().padBottom((float)Main.getPPUY() * 0.5f);
        tbl.add(l3).expandX().fillX().row();
        tbl.add(l4).expandX().fillX().row();
        tbl.add().expand().fill().padBottom((float)Main.getPPUY() * 0.5f).row();
        tbl.addSeparator();
        if (!isLifetimePrime) {
            tblButtons.add(this.tbSub).expandX().fillX().uniformX().padRight(Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY());
            tblButtons.add(this.tbLifetime).expandX().fillX().uniformX().padLeft(Main.getPPUY()).padBottom(0.5f * (float)Main.getPPUY()).row();
            FocusManager.switchFocus(this.stage, this.tbLifetime);
        } else {
            tblButtons.add(this.tbCustomDonation).expandX().fillX().padBottom(0.5f * (float)Main.getPPUY());
            FocusManager.switchFocus(this.stage, this.tbCustomDonation);
        }
        tblMain.align(2);
        tblMain.add(tbl).expand().fill().padBottom(Main.getPPUY()).row();
        tblMain.add(tblButtons).expandX().fillX().padBottom(0.5f * (float)Main.getPPUY());
        return tblMain;
    }

    private String convertToDollar(int cents) {
        float dollar = (float)cents / 100.0f;
        return String.format(Locale.US, "%.2f", Float.valueOf(dollar));
    }
}

