/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.Dialogs;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.RestClient;
import com.torii.srs.widget.TextField;

public class LoginScreen
implements Screen {
    private static LoginScreen loginScreen;
    private Stage stage;
    private SpriteBatch batch;
    private VisTable tblMain;
    private VisTable table;
    private VisLabel lVersion;
    private VisLabel lEmail;
    private VisLabel lPassword;
    private VisLabel lPasswordConfirm;
    private LinkLabel lSignUp;
    private LinkLabel lLogin;
    private LinkLabel lForgotPassword;
    private static TextField userName;
    private static TextField userPassword;
    private static TextField passwordConfirm;
    private static VisTextButton btnLogin;
    private static VisTextButton btnSignUp;
    private Texture bgimg;
    private VisImageButton btnFlash;
    private VisImageButton.VisImageButtonStyle bsFlashFull;
    private VisImageButton.VisImageButtonStyle bsFlashEmpty;
    private boolean isSignUpMode = false;
    private boolean isInterfaceVisible = true;
    private boolean accountKS;

    LoginScreen() {
        loginScreen = this;
        this.batch = new SpriteBatch();
        this.lVersion = new VisLabel((CharSequence)"Torii SRS v1.4.9 (Nov. 20 2025)", Main.labelStyleX0p5_w);
        this.lEmail = new VisLabel((CharSequence)"Email ", Main.labelStyleX0p5_w);
        this.lPassword = new VisLabel((CharSequence)"Password", Main.labelStyleX0p5_w);
        this.lPasswordConfirm = new VisLabel((CharSequence)"Confirm Password", Main.labelStyleX0p5_w);
        this.bgimg = Main.getWorldWidth() < Main.getWorldHeight() ? new Texture(Gdx.files.internal("images/login_rect.PNG")) : new Texture(Gdx.files.internal("images/login_square.png"));
        VisTextField.VisTextFieldStyle tfStyle = new VisTextField.VisTextFieldStyle(new VisTextField().getStyle());
        tfStyle.background = Main.uiSkin.newDrawable("white", new Color(0.0f, 0.0f, 0.0f, 0.75f));
        tfStyle.backgroundOver = Main.uiSkin.newDrawable("white", new Color(0.0f, 0.0f, 0.0f, 0.75f));
        tfStyle.fontColor = Color.WHITE;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.tblMain = new VisTable(false);
        this.table = new VisTable(false);
        userName = new TextField("", tfStyle);
        userPassword = new TextField("", tfStyle);
        passwordConfirm = new TextField("", tfStyle);
        btnLogin = new VisTextButton("Log In");
        btnSignUp = new VisTextButton("Sign Up");
        this.lSignUp = new LinkLabel((CharSequence)"Create new account", (CharSequence)"");
        this.lLogin = new LinkLabel((CharSequence)"Already have an account?", (CharSequence)"");
        this.lForgotPassword = new LinkLabel("Forgot password?");
        this.table.setBackground(Main.uiSkin.newDrawable("white", new Color(0.0f, 0.0f, 0.0f, 0.85f)));
        Drawable btnUp = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnOver = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDown = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Drawable btnDisabled = Main.uiSkin.newDrawable("white", Main.TRANSPARENT);
        Image imgFlashFull = new Image((Texture)Main.getAsset(Main.ARCHIVE_BTN_PATH, Texture.class, true));
        Drawable dFlashFull = imgFlashFull.getDrawable();
        this.bsFlashFull = new VisImageButton.VisImageButtonStyle(new VisImageButton(dFlashFull).getStyle());
        this.bsFlashFull.up = btnUp;
        this.bsFlashFull.over = btnOver;
        this.bsFlashFull.down = btnDown;
        this.bsFlashFull.disabled = btnDisabled;
        this.bsFlashFull.imageUp = Main.uiSkin.newDrawable(dFlashFull);
        this.bsFlashFull.imageDown = Main.uiSkin.newDrawable(dFlashFull, Main.OBJECT_PRESSED);
        this.bsFlashFull.imageDisabled = Main.uiSkin.newDrawable(dFlashFull, new VisTextButton((String)"").getStyle().disabledFontColor);
        Image imgFlashEmpty = new Image((Texture)Main.getAsset(Main.ARCHIVE_BTN_PATH, Texture.class, true));
        Drawable dFlashEmpty = imgFlashEmpty.getDrawable();
        this.bsFlashEmpty = new VisImageButton.VisImageButtonStyle(new VisImageButton(dFlashEmpty).getStyle());
        this.bsFlashEmpty.up = btnUp;
        this.bsFlashEmpty.over = btnOver;
        this.bsFlashEmpty.down = btnDown;
        this.bsFlashEmpty.disabled = btnDisabled;
        this.bsFlashEmpty.imageUp = Main.uiSkin.newDrawable(dFlashEmpty, new Color(1.0f, 1.0f, 1.0f, 0.25f));
        this.bsFlashEmpty.imageDown = Main.uiSkin.newDrawable(dFlashEmpty, Main.OBJECT_PRESSED);
        this.bsFlashEmpty.imageDisabled = Main.uiSkin.newDrawable(dFlashEmpty, new VisTextButton((String)"").getStyle().disabledFontColor);
        this.btnFlash = new VisImageButton(dFlashEmpty);
        this.btnFlash.setStyle(this.bsFlashFull);
        this.lVersion.setAlignment(12);
        this.lEmail.setAlignment(8);
        userName.setAlignment(1);
        userPassword.setAlignment(1);
        passwordConfirm.setAlignment(1);
        btnLogin.setFocusBorderEnabled(false);
        btnSignUp.setFocusBorderEnabled(false);
        this.btnFlash.setFocusBorderEnabled(false);
        btnLogin.setDisabled(true);
        btnSignUp.setDisabled(true);
        userPassword.setPasswordMode(true);
        passwordConfirm.setPasswordMode(true);
        this.btnFlash.setSize(Main.getPPUY(), Main.getPPUY());
        this.lVersion.setPosition(10.0f, 10.0f);
        this.btnFlash.setPosition(this.stage.getViewport().getWorldWidth() - this.btnFlash.getWidth() - 10.0f, 10.0f);
        this.tblMain.setFillParent(true);
        this.setActorListeners();
        this.tblMain.add(this.table).width(this.stage.getViewport().getWorldWidth() - (float)(2 * Main.getPPUY())).pad(Main.getPPUY()).padTop(2 * Main.getPPUY()).padBottom(1.5f * (float)Main.getPPUY()).row();
        this.stage.addActor(this.lVersion);
        this.stage.addActor(this.tblMain);
        this.stage.addActor(this.btnFlash);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.focusEmailField();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.batch.draw(this.bgimg, 0.0f, 0.0f, this.stage.getViewport().getWorldWidth(), this.stage.getViewport().getWorldHeight());
        this.batch.end();
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
        this.stage.unfocusAll();
        Gdx.input.setOnscreenKeyboardVisible(false);
    }

    @Override
    public void dispose() {
    }

    public static void showOnScreen() {
        if (Main.getCurrentScreen() != LoadingScreen.loadingScreen) {
            LoginScreen.loginScreen.isSignUpMode = false;
            loginScreen.buildTable();
        }
        Main.setNewScreen(loginScreen);
    }

    static void setAccountKS(boolean enabled) {
        LoginScreen.loginScreen.accountKS = enabled;
    }

    static void quickSignIn() {
        RestClient.loginUser(Main.getUserEmail(), Main.getUserPassword(), true);
    }

    static void logOut() {
        Main.stopTimer();
        Main.setData("", "");
        LoginScreen.showOnScreen();
    }

    static void logOut(Stage parentStage) {
        Dialogs.showConfirmDialog(parentStage, "Log Out", "Are you sure you want to log out?", new Dialogs.ConfirmAdapter(){

            @Override
            public void yes() {
                LoginScreen.logOut();
            }
        });
    }

    private void buildTable() {
        String sEmailReqInfo = this.isSignUpMode ? " (Why is this necessary?)" : "";
        LinkLabel llEmailReqInfo = new LinkLabel((CharSequence)sEmailReqInfo, (CharSequence)"", Main.linkLabelStyleX0p5);
        llEmailReqInfo.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                Dialogs.showOKDialog(LoginScreen.this.stage, "", "We store all your data securely in the cloud and your email address doubles as your username.\nIf you ever forget your password, we'll send a link to your email so you can quickly create a new one.");
                Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
            }
        });
        if (Main.isMobile()) {
            this.tblMain.align(2);
        } else {
            this.tblMain.align(4);
        }
        passwordConfirm.clearText();
        this.table.clearChildren();
        this.table.add(this.lEmail).padTop((float)Main.getPPUY() * 0.5f).padLeft(Main.getPPUY()).align(8);
        this.table.add(llEmailReqInfo).expandX().padTop((float)Main.getPPUY() * 0.5f).padRight(Main.getPPUY()).align(8);
        this.table.row().padLeft(Main.getPPUY()).padRight(Main.getPPUY());
        this.table.add(userName).colspan(2).fillX().padBottom((float)Main.getPPUY() * 0.5f);
        this.table.row().padLeft(Main.getPPUY()).padRight(Main.getPPUY());
        this.table.add(this.lPassword).colspan(2).fillX();
        this.table.row().padLeft(Main.getPPUY()).padRight(Main.getPPUY());
        this.table.add(userPassword).colspan(2).fillX().padBottom(Main.getPPUY()).row();
        if (this.isSignUpMode) {
            this.table.row().padLeft(Main.getPPUY()).padRight(Main.getPPUY());
            this.table.add(this.lPasswordConfirm).colspan(2).fillX();
            this.table.row().padLeft(Main.getPPUY()).padRight(Main.getPPUY());
            this.table.add(passwordConfirm).colspan(2).fillX().padBottom(Main.getPPUY()).row();
            this.table.add(btnSignUp).colspan(2).width(this.stage.getViewport().getWorldWidth() * 0.45f).row();
            this.table.addSeparator().colspan(2).fillX().padTop((float)Main.getPPUY() * 0.75f).padBottom((float)Main.getPPUY() * 0.5f).row();
            this.table.add(this.lLogin).colspan(2).padBottom((float)Main.getPPUY() * 0.5f).row();
        } else {
            this.table.add(btnLogin).colspan(2).width(this.stage.getViewport().getWorldWidth() * 0.45f).row();
            this.table.addSeparator().colspan(2).fillX().padTop((float)Main.getPPUY() * 0.75f).padBottom((float)Main.getPPUY() * 0.5f).row();
            this.table.add(this.lSignUp).colspan(2).padBottom((float)Main.getPPUY() * 0.5f).row();
        }
        this.table.add(this.lForgotPassword).colspan(2).padBottom((float)Main.getPPUY() * 0.5f);
        this.focusEmailField();
    }

    private void checkSignIn() {
        String userNameContent = userName.getText().trim();
        String userPasswordContentHash = Main.generatePasswordHash(userPassword.getText().trim());
        LoadingScreen.showOnScreen();
        RestClient.loginUser(userNameContent, userPasswordContentHash, false);
    }

    private void checkSignUp() {
        String userNameContent = userName.getText().trim();
        String userPasswordContent = userPassword.getText().trim();
        String pwConfirmContent = passwordConfirm.getText().trim();
        String userPasswordContentHash = Main.generatePasswordHash(userPasswordContent);
        if (userPasswordContent.equals(pwConfirmContent)) {
            if (LoginScreen.passwordRequirementsFulfilled(userPasswordContent)) {
                Gdx.input.setOnscreenKeyboardVisible(false);
                this.stage.unfocusAll();
                LoadingScreen.showOnScreen();
                RestClient.createUser(userNameContent, userPasswordContentHash);
            } else {
                Dialogs.showOKDialog(this.stage, "Password requirements", "6-32 characters\nAt least 1 letter\nAt least 1 number");
            }
        } else {
            userPassword.clearText();
            passwordConfirm.clearText();
            Dialogs.showErrorDialog(this.stage, "Passwords don't match.");
        }
    }

    static boolean passwordRequirementsFulfilled(String pw) {
        boolean pwLengthValid = false;
        boolean pwContainsNumber = false;
        boolean pwContainsLetter = false;
        if (pw.length() >= 6 && pw.length() <= 32) {
            pwLengthValid = true;
        }
        for (int z = 0; z < pw.length(); ++z) {
            if (Character.isDigit(pw.charAt(z))) {
                pwContainsNumber = true;
            }
            if (!Character.isLetter(pw.charAt(z))) continue;
            pwContainsLetter = true;
        }
        return pwLengthValid && pwContainsNumber && pwContainsLetter;
    }

    private void checkResetPassword() {
        Dialogs.showInputDialog(this.stage, "Password Recovery", "Email:", -1, new Dialogs.InputAdapter(){

            @Override
            public void finished(String input) {
                if (!input.trim().equals("")) {
                    RestClient.resetUserPassword(input);
                }
            }
        });
    }

    private void focusEmailField() {
        userName.focusField();
        userName.getOnscreenKeyboard().show(true);
        userName.setSelection(0, userName.getText().length());
        userName.fire(new ChangeListener.ChangeEvent());
    }

    private void simulateClick(Actor actor) {
        InputEvent ie = new InputEvent();
        ie.setType(InputEvent.Type.touchDown);
        actor.fire(ie);
        ie.setType(InputEvent.Type.touchUp);
        actor.fire(ie);
    }

    private void setActorListeners() {
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 66) {
                    if (!LoginScreen.this.isSignUpMode && !btnLogin.isDisabled()) {
                        LoginScreen.this.simulateClick(btnLogin);
                    } else if (LoginScreen.this.isSignUpMode && !btnSignUp.isDisabled()) {
                        LoginScreen.this.simulateClick(btnSignUp);
                    }
                }
                return true;
            }
        });
        ChangeListener listener = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                String userNameContent = userName.getText().trim();
                String userPasswordContent = userPassword.getText().trim();
                String pwConfirmContent = passwordConfirm.getText().trim();
                if (LoginScreen.this.isSignUpMode) {
                    if (!(userNameContent.equals("") || userPasswordContent.equals("") || pwConfirmContent.equals(""))) {
                        btnSignUp.setDisabled(false);
                    } else {
                        btnSignUp.setDisabled(true);
                    }
                } else if (!userNameContent.equals("") && !userPasswordContent.equals("")) {
                    btnLogin.setDisabled(false);
                } else {
                    btnLogin.setDisabled(true);
                }
            }
        };
        userName.addListener(listener);
        userPassword.addListener(listener);
        passwordConfirm.addListener(listener);
        btnLogin.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!btnLogin.isDisabled()) {
                    LoginScreen.this.checkSignIn();
                }
            }
        });
        btnSignUp.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!btnSignUp.isDisabled()) {
                    LoginScreen.this.checkSignUp();
                }
            }
        });
        this.lSignUp.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                if (!LoginScreen.this.accountKS) {
                    LoginScreen.this.isSignUpMode = true;
                    LoginScreen.this.buildTable();
                } else {
                    Dialogs.showErrorDialog(LoginScreen.this.stage, "Account creation is currently disabled.");
                }
            }
        });
        this.lLogin.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                LoginScreen.this.isSignUpMode = false;
                LoginScreen.this.buildTable();
            }
        });
        this.lForgotPassword.setListener(new LinkLabel.LinkLabelListener(){

            @Override
            public void clicked(String url) {
                LoginScreen.this.checkResetPassword();
            }
        });
        this.btnFlash.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                LoginScreen.this.isInterfaceVisible = !LoginScreen.this.isInterfaceVisible;
                if (LoginScreen.this.isInterfaceVisible) {
                    LoginScreen.this.btnFlash.setStyle(LoginScreen.this.bsFlashFull);
                    LoginScreen.this.table.setVisible(true);
                    LoginScreen.this.lVersion.setVisible(true);
                    LoginScreen.this.focusEmailField();
                } else {
                    LoginScreen.this.btnFlash.setStyle(LoginScreen.this.bsFlashEmpty);
                    LoginScreen.this.table.setVisible(false);
                    LoginScreen.this.lVersion.setVisible(false);
                }
            }
        });
    }
}

