/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.LinkLabel;
import com.kotcrab.vis.ui.widget.ScrollableTextArea;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.Main;
import com.torii.srs.RestClient;

class InfoScreen
implements Screen {
    private static InfoScreen infoScreen;
    private final String downloadLink = "https://torii-srs.com/download";
    private final String googlePlayLink = "https://play.google.com/store/apps/details?id=com.torii.srs";
    private Screen parentScreen;
    private Stage stage;
    private ScrollableTextArea taChangelog;
    private VisScrollPane spChangelog;
    private VisLabel title;
    private VisLabel message;
    private LinkLabel webLink;
    private VisTextButton btnConfirm;
    private VisTextButton btnConfirm2;
    private ClickListener standardListener;
    private ClickListener systemNotificationListener;
    private ClickListener updateNowListener;
    private ClickListener updateLaterListener;
    private ClickListener retryListener;
    private String latestVersion;
    private boolean isKillSwitch;

    InfoScreen() {
        infoScreen = this;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        VisTable table = new VisTable();
        this.taChangelog = new ScrollableTextArea("N/A", new VisTextField.VisTextFieldStyle(Main.taStyle));
        this.title = new VisLabel((CharSequence)"", Main.labelStyleX2);
        this.message = new VisLabel((CharSequence)"", Main.labelStyleX1);
        this.webLink = new LinkLabel((CharSequence)"", (CharSequence)"");
        this.btnConfirm = new VisTextButton("OK", Main.btnStyleX1p25);
        this.btnConfirm2 = new VisTextButton("", Main.btnStyleX1p25);
        this.taChangelog.setWidth(this.stage.getViewport().getWorldWidth() * 0.95f);
        this.spChangelog = (VisScrollPane)this.taChangelog.createCompatibleScrollPane();
        this.spChangelog.setFadeScrollBars(false);
        this.spChangelog.setFlickScroll(true);
        this.title.setAlignment(1);
        this.message.setAlignment(1);
        this.webLink.setAlignment(1);
        this.message.setWrap(true);
        this.btnConfirm2.setVisible(false);
        this.taChangelog.setDisabled(true);
        this.createListeners();
        this.btnConfirm.addListener(this.standardListener);
        table.setFillParent(true);
        table.align(2);
        table.add(this.title).width(this.stage.getViewport().getWorldWidth() * 0.95f).row();
        table.addSeparator().width(this.stage.getViewport().getWorldWidth());
        table.add(this.message).width(this.stage.getViewport().getWorldWidth() * 0.95f).padTop(Main.getPPUY()).row();
        table.add(this.webLink).padTop(Main.getPPUY()).row();
        table.add(this.spChangelog).width(this.stage.getViewport().getWorldWidth() * 0.95f).expand().fill().height(0.0f).padBottom(3 * Main.getPPUY()).row();
        table.add(this.btnConfirm2).width(this.stage.getViewport().getWorldWidth() * 0.95f).align(4).padBottom(Main.getPPUY()).row();
        table.add(this.btnConfirm).width(this.stage.getViewport().getWorldWidth() * 0.95f).align(4).padBottom(Main.getPPUY()).row();
        this.stage.addActor(table);
    }

    private void invalidateUI() {
        this.taChangelog.setStyle(new VisTextField.VisTextFieldStyle(Main.taStyle));
        this.title.setStyle(Main.labelStyleX2);
        this.message.setStyle(Main.labelStyleX1);
        this.webLink.setStyle(new LinkLabel((CharSequence)"", (CharSequence)"").getStyle());
        this.btnConfirm.setStyle(Main.btnStyleX1p25);
        this.btnConfirm2.setStyle(Main.btnStyleX1p25);
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
        this.btnConfirm.focusGained();
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
    }

    private void createListeners() {
        this.standardListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                InfoScreen.this.clearListeners();
                Main.setNewScreen(InfoScreen.this.parentScreen);
            }
        };
        this.systemNotificationListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                InfoScreen.this.clearListeners();
                Main.launchApp(InfoScreen.this.isKillSwitch);
            }
        };
        this.updateNowListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                InfoScreen.this.clearListeners();
                if (Gdx.app.getType() == Application.ApplicationType.Android) {
                    Gdx.net.openURI("https://play.google.com/store/apps/details?id=com.torii.srs");
                    Gdx.app.exit();
                } else if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                    Gdx.net.openURI("https://torii-srs.com/download");
                    Gdx.app.exit();
                }
            }
        };
        this.updateLaterListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                InfoScreen.this.clearListeners();
                RestClient.checkSystemNotification();
            }
        };
        this.retryListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                InfoScreen.this.clearListeners();
                RestClient.checkUpdates();
            }
        };
    }

    private void clearListeners() {
        this.btnConfirm.removeListener(this.standardListener);
        this.btnConfirm.removeListener(this.systemNotificationListener);
        this.btnConfirm.removeListener(this.updateNowListener);
        this.btnConfirm.removeListener(this.updateLaterListener);
        this.btnConfirm.addListener(this.standardListener);
        this.btnConfirm.setText("OK");
        this.btnConfirm2.removeListener(this.standardListener);
        this.btnConfirm2.removeListener(this.systemNotificationListener);
        this.btnConfirm2.removeListener(this.updateNowListener);
        this.btnConfirm2.removeListener(this.updateLaterListener);
        this.btnConfirm2.setVisible(false);
    }

    static void showInfoMessage(String title, String message, String buttonText, ClickListener listener) {
        Screen curScreen = Main.getCurrentScreen();
        if (curScreen != InfoScreen.infoScreen.parentScreen) {
            InfoScreen.infoScreen.parentScreen = curScreen;
        }
        infoScreen.invalidateUI();
        InfoScreen.infoScreen.title.setText(title);
        InfoScreen.infoScreen.message.setText(message);
        InfoScreen.infoScreen.btnConfirm.setText(buttonText);
        InfoScreen.infoScreen.btnConfirm.clearListeners();
        InfoScreen.infoScreen.btnConfirm.addListener(listener);
        InfoScreen.infoScreen.webLink.setVisible(false);
        InfoScreen.infoScreen.taChangelog.setVisible(false);
        Main.setNewScreen(infoScreen);
    }

    static void showOkMessage(String title, String message) {
        InfoScreen.showOkMessage(title, message, null, null, false, false);
    }

    static void showOkMessage(String title, String message, boolean taDisabled, boolean buttonDisabled) {
        InfoScreen.showOkMessage(title, message, null, null, taDisabled, buttonDisabled);
    }

    static void showOkMessage(String title, String message, String linkText, String linkURL) {
        InfoScreen.showOkMessage(title, message, linkText, linkURL, true, false);
    }

    static void showOkMessage(String title, String message, String linkText, String linkURL, boolean taDisabled, boolean buttonDisabled) {
        Screen curScreen = Main.getCurrentScreen();
        if (curScreen != InfoScreen.infoScreen.parentScreen) {
            InfoScreen.infoScreen.parentScreen = curScreen;
        }
        infoScreen.invalidateUI();
        InfoScreen.infoScreen.title.setText(title);
        InfoScreen.infoScreen.message.setText(message);
        if (linkText != null && linkURL != null) {
            InfoScreen.infoScreen.webLink.setText(linkText);
            InfoScreen.infoScreen.webLink.setUrl(linkURL);
            InfoScreen.infoScreen.webLink.setVisible(true);
        } else {
            InfoScreen.infoScreen.webLink.setVisible(false);
        }
        if (taDisabled) {
            InfoScreen.infoScreen.taChangelog.setVisible(false);
        } else {
            InfoScreen.infoScreen.taChangelog.setVisible(true);
        }
        if (buttonDisabled) {
            InfoScreen.infoScreen.btnConfirm.setVisible(false);
        } else {
            InfoScreen.infoScreen.btnConfirm.setVisible(true);
        }
        Main.setNewScreen(infoScreen);
    }

    static void showSystemNotification(String title, String message, String linkText, String linkURL, boolean isKillSwitch) {
        InfoScreen.infoScreen.isKillSwitch = isKillSwitch;
        InfoScreen.infoScreen.btnConfirm.removeListener(InfoScreen.infoScreen.standardListener);
        InfoScreen.infoScreen.btnConfirm.addListener(InfoScreen.infoScreen.systemNotificationListener);
        InfoScreen.showOkMessage(title, message, linkText, linkURL);
    }

    static void showNoNetworkNotification() {
        InfoScreen.infoScreen.btnConfirm.removeListener(InfoScreen.infoScreen.standardListener);
        InfoScreen.infoScreen.btnConfirm.addListener(InfoScreen.infoScreen.retryListener);
        InfoScreen.infoScreen.btnConfirm.setText("Retry");
        InfoScreen.showOkMessage("Oops", "Looks like we couldn't connect to the server. This might be because:\n\n1. You're not connected to the internet. Give your network a quick check and try again. If you're using a VPN, try disabling it.\n\n2. Our servers are having a moment. Sorry about that! Please try again in a few minutes.\n\nIf this keeps happening for a while, feel free to email us at\n[CR]support@torii-srs.com[].", null, null);
    }

    static void showUpdateNotification(String latestVersion, String changelog, boolean isForcedUpdate) {
        String appendMessage;
        InfoScreen.infoScreen.latestVersion = latestVersion;
        InfoScreen.infoScreen.btnConfirm.removeListener(InfoScreen.infoScreen.standardListener);
        InfoScreen.infoScreen.btnConfirm.addListener(InfoScreen.infoScreen.updateNowListener);
        InfoScreen.infoScreen.btnConfirm.setText("UPDATE NOW");
        String title = "Update Available";
        String message = "A new version of Torii is available!\n\nLatest version: " + latestVersion + "\nYour version: " + "1.4.9";
        if (isForcedUpdate) {
            appendMessage = "\n\nThis update is required to continue using Torii.";
        } else {
            InfoScreen.infoScreen.btnConfirm2.setText("Maybe later");
            InfoScreen.infoScreen.btnConfirm2.addListener(InfoScreen.infoScreen.updateLaterListener);
            InfoScreen.infoScreen.btnConfirm2.setVisible(true);
            appendMessage = "\n\nWe recommend updating to the latest version soon.";
        }
        message = message + appendMessage;
        InfoScreen.infoScreen.taChangelog.setText(changelog);
        InfoScreen.infoScreen.taChangelog.setWidth(InfoScreen.infoScreen.stage.getViewport().getWorldWidth() * 0.95f);
        InfoScreen.infoScreen.spChangelog.setActor(InfoScreen.infoScreen.taChangelog.createCompatibleScrollPane());
        InfoScreen.showOkMessage(title, message);
    }
}

