/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.kotcrab.vis.ui.widget.VisDialog;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.torii.srs.Main;
import com.torii.srs.widget.TextField;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Dialogs {
    private static final String TITLE_ERROR = "Oops";
    private static final float BTN_SPACING = 0.0f;
    private static final float PAD_TOP_TITLE = (float)Main.getPPUY() * 1.5f;
    private static final float PAD_TOP_CONTENT = (float)Main.getPPUY() * 1.5f;
    private static final float PAD_TOP_BUTTON = (float)Main.getPPUY() / 2.0f;
    private static final float PAD_BOTTOM_BUTTON = (float)Main.getPPUY() / 2.0f;

    public static void showOKDialog(Stage stage, String title, String text) {
        new OKDialog(stage, title, text, null);
    }

    public static void showOKDialog(Stage stage, String title, String text, OKAdapter adapter) {
        new OKDialog(stage, title, text, adapter);
    }

    public static void showHintDialog(Stage stage, String text, final HintAdapter adapter) {
        ConfirmAdapter confirmAdapter = new ConfirmAdapter(){

            @Override
            public void yes() {
            }

            @Override
            public void cancel() {
                adapter.hide();
            }

            @Override
            public void finished() {
                adapter.finished();
            }
        };
        Dialogs.showConfirmDialog(stage, "Did you know...", text, new String[]{"OK", "Hide this hint"}, confirmAdapter);
    }

    public static void showErrorDialog(Stage stage, String text) {
        new ErrorDialog(TITLE_ERROR, stage, text, null);
    }

    public static void showErrorDialog(Stage stage, String text, Exception e) {
        new ErrorDialog(TITLE_ERROR, stage, text, e);
    }

    public static void showConfirmDialog(Stage stage, String title, String text, ConfirmAdapter adapter) {
        Dialogs.showConfirmDialog(stage, title, text, null, adapter, false);
    }

    public static void showConfirmDialog(Stage stage, String title, String text, String[] yesCancelButtonText, ConfirmAdapter adapter) {
        Dialogs.showConfirmDialog(stage, title, text, yesCancelButtonText, adapter, false);
    }

    public static void showConfirmDialog(Stage stage, String title, String text, String[] yesCancelButtonText, ConfirmAdapter adapter, boolean disableKeyListener) {
        new ConfirmDialog(stage, title, text, yesCancelButtonText, adapter, disableKeyListener);
    }

    public static void showInputDialog(Stage stage, String title, String text, InputAdapter adapter) {
        new InputDialog(stage, title, text, -1, false, false, adapter);
    }

    public static void showInputDialog(Stage stage, String title, String text, int charLimit, InputAdapter adapter) {
        new InputDialog(stage, title, text, charLimit, false, false, adapter);
    }

    public static void showInputDialog(Stage stage, String title, String text, int charLimit, boolean isPasswordInput, boolean isKanaOnlyInput, InputAdapter adapter) {
        new InputDialog(stage, title, text, charLimit, isPasswordInput, isKanaOnlyInput, adapter);
    }

    private static class OKDialog
    extends VisDialog {
        private final String BTN_OK = "OK";
        private final Stage parentStage;
        private VisLabel lText;
        private VisTextButton btnOk;

        private OKDialog(Stage stage, String title, String text, OKAdapter adapter) {
            super(title);
            this.setModal(true);
            this.setKeepWithinStage(true);
            this.parentStage = stage;
            Gdx.input.setInputProcessor(Main.getDialogStage());
            Main.setCurrentStage(Main.getDialogStage());
            if (!title.equals("")) {
                this.getTitleTable().padTop(PAD_TOP_TITLE);
                this.getContentTable().padTop(PAD_TOP_CONTENT);
                this.getButtonsTable().padTop(PAD_TOP_BUTTON).padBottom(PAD_BOTTOM_BUTTON);
            }
            this.createActors(text);
            this.getContentTable().add(this.lText).width(stage.getViewport().getWorldWidth() * 0.75f);
            this.getButtonsTable().add(this.btnOk).width(this.btnOk.getWidth() + 0.0f);
            this.setActorListeners(adapter);
            this.show(Main.getDialogStage());
        }

        private void createActors(String text) {
            this.lText = new VisLabel((CharSequence)text, Main.labelStyleKanaX1_w);
            this.btnOk = new VisTextButton("OK", Main.btnStyleX1p25);
            this.lText.setWrap(true);
            this.lText.setAlignment(1);
            this.btnOk.setFocusBorderEnabled(false);
        }

        private void setActorListeners(final OKAdapter adapter) {
            this.addListener(new ClickListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    switch (keycode) {
                        case 4: 
                        case 8: 
                        case 9: 
                        case 31: 
                        case 33: 
                        case 43: 
                        case 45: 
                        case 53: 
                        case 66: 
                        case 111: 
                        case 145: 
                        case 146: {
                            this.simulateClick(btnOk);
                        }
                    }
                    return true;
                }
            });
            this.btnOk.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                    if (adapter != null) {
                        adapter.ok();
                    }
                }
            });
        }

        private void simulateClick(Actor button) {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            button.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            button.fire(ie);
        }

        @Override
        protected void close() {
            this.fadeOut(0.0f);
            Gdx.input.setInputProcessor(this.parentStage);
            Main.setCurrentStage(this.parentStage);
        }
    }

    public static abstract class OKAdapter {
        public abstract void ok();
    }

    public static abstract class HintAdapter {
        public void hide() {
        }

        public void finished() {
        }
    }

    public static abstract class ConfirmAdapter {
        public abstract void yes();

        public void cancel() {
        }

        public void finished() {
        }
    }

    private static class ErrorDialog
    extends VisDialog {
        private final String BTN_OK = "OK";
        private final String BTN_DETAILS_SHOW = "Details";
        private final String BTN_DETAILS_HIDE = "Hide Details";
        private final String BTN_COPY_COPY = "Copy";
        private final String BTN_COPY_COPIED = "Copied";
        private final Stage parentStage;
        private VisTable tblException;
        private VisLabel lText;
        private VisLabel lException;
        private VisTextButton btnOk;
        private VisTextButton btnDetails;
        private VisTextButton btnCopy;
        private VisScrollPane sp;

        private ErrorDialog(String TITLE, Stage stage, String text, Exception e) {
            super(TITLE);
            this.setModal(true);
            this.setKeepWithinStage(true);
            this.parentStage = stage;
            Gdx.input.setInputProcessor(Main.getDialogStage());
            Main.setCurrentStage(Main.getDialogStage());
            this.getTitleTable().padTop(PAD_TOP_TITLE);
            this.getContentTable().padTop(PAD_TOP_CONTENT);
            this.getButtonsTable().padTop(PAD_TOP_BUTTON).padBottom(PAD_BOTTOM_BUTTON);
            this.createActors(text, e);
            this.getContentTable().add(this.lText).row();
            this.getContentTable().add(this.tblException).maxWidth(stage.getViewport().getWorldWidth()).maxHeight(stage.getViewport().getWorldHeight() / 2.0f);
            if (e != null) {
                this.getButtonsTable().add(this.btnDetails).width(this.btnDetails.getWidth() + 0.0f);
            }
            this.getButtonsTable().add(this.btnOk).width(this.btnOk.getWidth() + 0.0f);
            this.setActorListeners();
            this.show(Main.getDialogStage());
        }

        private void createActors(String text, Exception e) {
            String exceptionAsString = "";
            if (e != null) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                exceptionAsString = sw.toString();
            }
            this.tblException = new VisTable(true);
            this.lText = new VisLabel((CharSequence)text, Main.labelStyleX1_w);
            this.lException = new VisLabel(exceptionAsString);
            this.sp = new VisScrollPane((Actor)this.lException);
            this.btnOk = new VisTextButton("OK", Main.btnStyleX1p25);
            this.btnDetails = new VisTextButton("Details", Main.btnStyleX1p25);
            this.btnCopy = new VisTextButton("Copy", Main.btnStyleX1p25);
            this.lText.setAlignment(1);
            this.btnOk.setFocusBorderEnabled(false);
            this.btnDetails.setFocusBorderEnabled(false);
            this.btnCopy.setFocusBorderEnabled(false);
        }

        private void setActorListeners() {
            this.addListener(new ClickListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    if (keycode == 66 || keycode == 111 || keycode == 4) {
                        this.simulateClick(btnOk);
                    }
                    return true;
                }
            });
            this.btnDetails.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (btnDetails.getText().toString().equals("Details")) {
                        btnDetails.setText("Hide Details");
                        btnDetails.pack();
                        this.getButtonsTable().getCell(btnDetails).width(btnDetails.getWidth() + 0.0f);
                        tblException.add(btnCopy).width(btnCopy.getWidth() + 0.0f).align(8).row();
                        tblException.add(sp);
                    } else if (btnDetails.getText().toString().equals("Hide Details")) {
                        btnDetails.setText("Details");
                        btnDetails.pack();
                        this.getButtonsTable().getCell(btnDetails).width(btnDetails.getWidth() + 0.0f);
                        tblException.clearChildren();
                    }
                    this.pack();
                    this.centerWindow();
                }
            });
            this.btnOk.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                }
            });
            this.btnCopy.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    Gdx.app.getClipboard().setContents(lException.getText().toString());
                    if (btnCopy.getText().toString().equals("Copy")) {
                        btnCopy.setText("Copied");
                        btnCopy.pack();
                        tblException.getCell(btnCopy).width(btnCopy.getWidth() + 0.0f);
                    }
                }
            });
        }

        private void simulateClick(Actor button) {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            button.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            button.fire(ie);
        }

        @Override
        protected void close() {
            this.fadeOut(0.0f);
            Gdx.input.setInputProcessor(this.parentStage);
            Main.setCurrentStage(this.parentStage);
        }
    }

    private static class ConfirmDialog
    extends VisDialog {
        private final String BTN_YES = "Yes";
        private final String BTN_CANCEL = "Cancel";
        private final Stage parentStage;
        private VisLabel lText;
        private VisTextButton btnYes;
        private VisTextButton btnCancel;
        private boolean disableKeyListener;

        private ConfirmDialog(Stage stage, String title, String text, String[] yesCancelButtonText, ConfirmAdapter adapter, boolean disableKeyListener) {
            super(title);
            this.setModal(true);
            this.setKeepWithinStage(true);
            this.disableKeyListener = disableKeyListener;
            this.parentStage = stage;
            Gdx.input.setInputProcessor(Main.getDialogStage());
            Main.setCurrentStage(Main.getDialogStage());
            if (!title.equals("")) {
                this.getTitleTable().padTop(PAD_TOP_TITLE);
                this.getContentTable().padTop(PAD_TOP_CONTENT);
                this.getButtonsTable().padTop(PAD_TOP_BUTTON).padBottom(PAD_BOTTOM_BUTTON);
            }
            String yesBtnText = yesCancelButtonText == null ? "Yes" : yesCancelButtonText[0];
            String cancelBtnText = yesCancelButtonText == null ? "Cancel" : yesCancelButtonText[1];
            this.lText = new VisLabel((CharSequence)text, Main.labelStyleX1_w);
            this.btnYes = new VisTextButton(yesBtnText, Main.btnStyleX1p25);
            this.btnCancel = new VisTextButton(cancelBtnText, Main.btnStyleX1p25);
            this.lText.setWrap(true);
            this.lText.setAlignment(1);
            this.btnYes.setFocusBorderEnabled(false);
            this.btnCancel.setFocusBorderEnabled(false);
            this.getContentTable().add(this.lText).width(stage.getViewport().getWorldWidth() * 0.75f);
            this.getButtonsTable().add(this.btnYes).width(this.btnYes.getWidth() + 0.0f);
            this.getButtonsTable().add(this.btnCancel).width(this.btnCancel.getWidth() + 0.0f);
            this.setActorListeners(adapter);
            this.show(Main.getDialogStage());
        }

        private void setActorListeners(final ConfirmAdapter adapter) {
            if (!this.disableKeyListener) {
                this.addListener(new ClickListener(){

                    @Override
                    public boolean keyUp(InputEvent event, int keycode) {
                        switch (keycode) {
                            case 8: 
                            case 45: 
                            case 53: 
                            case 66: 
                            case 145: {
                                this.simulateClick(btnYes);
                                break;
                            }
                            case 4: 
                            case 9: 
                            case 31: 
                            case 33: 
                            case 111: 
                            case 146: {
                                this.simulateClick(btnCancel);
                            }
                        }
                        return true;
                    }
                });
            }
            this.btnYes.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                    adapter.yes();
                    adapter.finished();
                }
            });
            this.btnCancel.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                    adapter.cancel();
                    adapter.finished();
                }
            });
        }

        private void simulateClick(Actor button) {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            button.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            button.fire(ie);
        }

        @Override
        protected void close() {
            this.fadeOut(0.0f);
            Gdx.input.setInputProcessor(this.parentStage);
            Main.setCurrentStage(this.parentStage);
        }
    }

    private static class InputDialog
    extends VisDialog {
        private final String BTN_FINISHED = "Confirm";
        private final String BTN_CANCEL = "Cancel";
        private final Stage parentStage;
        private VisLabel lText;
        private TextField tfInput;
        private VisTextButton btnFinished;
        private VisTextButton btnCancel;

        private InputDialog(Stage stage, String title, String text, int charLimit, boolean isPasswordInput, boolean isKanaOnlyInput, InputAdapter adapter) {
            super(title);
            this.setModal(true);
            this.setKeepWithinStage(true);
            this.parentStage = stage;
            Gdx.input.setInputProcessor(Main.getDialogStage());
            Main.setCurrentStage(Main.getDialogStage());
            if (!title.equals("")) {
                this.getTitleTable().padTop(PAD_TOP_TITLE);
                this.getContentTable().padTop(PAD_TOP_CONTENT);
                this.getButtonsTable().padTop(PAD_TOP_BUTTON).padBottom(PAD_BOTTOM_BUTTON);
            }
            VisTextField.VisTextFieldStyle tfInputStyle = new VisTextField.VisTextFieldStyle(new TextField().getStyle());
            tfInputStyle.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
            this.lText = new VisLabel((CharSequence)text, Main.labelStyleX1_w);
            this.tfInput = new TextField("", tfInputStyle);
            this.btnFinished = new VisTextButton("Confirm", Main.btnStyleX1p25);
            this.btnCancel = new VisTextButton("Cancel", Main.btnStyleX1p25);
            this.lText.setAlignment(1);
            this.tfInput.setAlignment(1);
            this.btnFinished.setFocusBorderEnabled(false);
            this.btnCancel.setFocusBorderEnabled(false);
            this.tfInput.setPasswordMode(isPasswordInput);
            this.tfInput.setKanaMode(isKanaOnlyInput);
            this.tfInput.setCharacterLimit(charLimit);
            this.getContentTable().add(this.lText);
            this.getContentTable().add(this.tfInput).width(stage.getViewport().getWorldWidth() * 0.5f);
            this.getButtonsTable().add(this.btnFinished).width(this.btnFinished.getWidth() + 0.0f);
            this.getButtonsTable().add(this.btnCancel).width(this.btnCancel.getWidth() + 0.0f);
            this.setActorListeners(adapter);
            this.show(Main.getDialogStage());
            this.tfInput.focusField();
        }

        private void setActorListeners(final InputAdapter adapter) {
            this.addListener(new ClickListener(){

                @Override
                public boolean keyUp(InputEvent event, int keycode) {
                    switch (keycode) {
                        case 66: {
                            this.simulateClick(btnFinished);
                            break;
                        }
                        case 4: 
                        case 111: {
                            this.simulateClick(btnCancel);
                        }
                    }
                    return true;
                }
            });
            this.btnFinished.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                    adapter.finished(tfInput.getText());
                }
            });
            this.btnCancel.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    this.close();
                    adapter.cancel();
                }
            });
        }

        private void simulateClick(Actor button) {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            button.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            button.fire(ie);
        }

        @Override
        protected void close() {
            Gdx.input.setOnscreenKeyboardVisible(false);
            this.fadeOut(0.0f);
            Gdx.input.setInputProcessor(this.parentStage);
            Main.setCurrentStage(this.parentStage);
        }
    }

    public static abstract class InputAdapter {
        public abstract void finished(String var1);

        public void cancel() {
        }
    }
}

