/*
 * Decompiled with CFR 0.152.
 */
package com.torii.srs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.ScalingViewport;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisProgressBar;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.torii.srs.AddVocabScreen;
import com.torii.srs.Dashboard;
import com.torii.srs.Dialogs;
import com.torii.srs.LoadingScreen;
import com.torii.srs.Main;
import com.torii.srs.PracticeScreen;
import com.torii.srs.RestClient;
import com.torii.srs.widget.TopMenu;
import java.util.Arrays;

public class BrowseScreen
implements Screen {
    private final int pageLimit = 10;
    private final String kanjiFontName = "browse.ttf";
    private static BrowseScreen browseScreen;
    private TopMenu topMenu;
    private PracticeScreen.PracticeListsTable plt;
    private Stage stage;
    private VisTable tblMain;
    private VisTable tblSelect;
    private TableTemplate tblUnlockedVocab;
    private TableTemplate tblCustomVocab;
    private TableTemplate tblArchivedVocab;
    private TableTemplate tblSearchMeaning;
    private TableTemplate tblSearchReading;
    private TableTemplate tblPractice;
    private TableTemplate activeContentTable;
    private String currentKeyword;
    private int currentlySelectedPracticeListID;
    private int currentPage;
    private BrowseInterface currentInterface;

    BrowseScreen() {
        this(BrowseInterface.SELECT, null, -1, -1);
    }

    BrowseScreen(BrowseInterface ui, int pageNo) {
        this(ui, null, -1, pageNo);
    }

    BrowseScreen(BrowseInterface ui, int selectedPracticeListID, int pageNo) {
        this(ui, null, selectedPracticeListID, pageNo);
    }

    BrowseScreen(BrowseInterface ui, String searchKeyword, int pageNo) {
        this(ui, searchKeyword, -1, pageNo);
    }

    BrowseScreen(BrowseInterface ui, String searchKeyword, int selectedPracticeListID, int pageNo) {
        browseScreen = this;
        this.currentInterface = ui;
        this.currentKeyword = searchKeyword;
        this.currentlySelectedPracticeListID = selectedPracticeListID;
        this.currentPage = pageNo;
        this.stage = new Stage(new ScalingViewport(Scaling.none, Gdx.graphics.getWidth(), Gdx.graphics.getHeight()));
        this.topMenu = new TopMenu(false){

            @Override
            public void homeButton() {
                BrowseScreen.this.home();
            }
        };
        this.plt = new PracticeScreen.PracticeListsTable(this.stage, false, true);
        this.plt.setListHeaderText("Your Practice Lists");
        final VisTextButton tbUnlockedVocab = new VisTextButton("Learned Vocab", Main.btnStyleX1p25);
        final VisTextButton tbCustomVocab = new VisTextButton("Custom Vocab", Main.btnStyleX1p25);
        final VisTextButton tbArchivedVocab = new VisTextButton("Archived Vocab", Main.btnStyleX1p25);
        final VisTextButton tbSearchByMeaning = new VisTextButton("Search By Meaning", Main.btnStyleX1p25);
        final VisTextButton tbSearchByReading = new VisTextButton("Search By Reading", Main.btnStyleX1p25);
        final VisTextButton tbPractice = new VisTextButton("Browse List", Main.btnStyleX1p25);
        float space = Main.getPPUY();
        tbPractice.setDisabled(true);
        tbUnlockedVocab.setFocusBorderEnabled(false);
        tbCustomVocab.setFocusBorderEnabled(false);
        tbArchivedVocab.setFocusBorderEnabled(false);
        tbSearchByMeaning.setFocusBorderEnabled(false);
        tbSearchByReading.setFocusBorderEnabled(false);
        tbPractice.setFocusBorderEnabled(false);
        VisTable tblSelectChild1 = new VisTable(false);
        tblSelectChild1.add(tbUnlockedVocab).uniform().fillX().padTop(space).padBottom(space).row();
        tblSelectChild1.add(tbCustomVocab).uniform().fillX().padBottom(space).row();
        tblSelectChild1.add(tbArchivedVocab).uniform().fillX().padBottom(space * 2.0f).row();
        tblSelectChild1.add(tbSearchByMeaning).uniform().fillX().padBottom(space).row();
        tblSelectChild1.add(tbSearchByReading).uniform().fillX().padBottom(space * 2.0f).row();
        this.tblSelect = new VisTable(false);
        this.tblSelect.add(tblSelectChild1).row();
        this.tblSelect.addSeparator().padBottom(space * 2.0f);
        this.tblSelect.add(this.plt).width(this.stage.getViewport().getWorldWidth() * 0.95f).expandY().fill().padBottom(Main.getPPUY()).row();
        this.tblSelect.add(tbPractice).width(tbSearchByMeaning.getWidth());
        this.createUnlockedVocabTable();
        this.createCustomVocabTable();
        this.createArchivedVocabTable();
        this.createSearchMeaningVocabTable();
        this.createSearchReadingVocabTable();
        this.createPracticeListVocabTable();
        this.tblMain = new VisTable(false);
        this.tblMain.setFillParent(true);
        this.stage.addListener(new ClickListener(){

            @Override
            public boolean keyUp(InputEvent event, int keycode) {
                if (BrowseScreen.this.currentInterface == BrowseInterface.SELECT) {
                    switch (keycode) {
                        case 8: 
                        case 40: 
                        case 145: {
                            BrowseScreen.this.simulateClick(tbUnlockedVocab);
                            break;
                        }
                        case 9: 
                        case 31: 
                        case 146: {
                            BrowseScreen.this.simulateClick(tbCustomVocab);
                            break;
                        }
                        case 10: 
                        case 29: 
                        case 147: {
                            BrowseScreen.this.simulateClick(tbArchivedVocab);
                            break;
                        }
                        case 11: 
                        case 41: 
                        case 148: {
                            BrowseScreen.this.simulateClick(tbSearchByMeaning);
                            break;
                        }
                        case 12: 
                        case 46: 
                        case 149: {
                            BrowseScreen.this.simulateClick(tbSearchByReading);
                            break;
                        }
                        case 4: 
                        case 111: {
                            BrowseScreen.this.home();
                        }
                    }
                } else {
                    switch (keycode) {
                        case 4: 
                        case 111: {
                            if (BrowseScreen.this.activeContentTable.win.hasParent()) {
                                BrowseScreen.this.activeContentTable.hideVocabProgressionWindow();
                                break;
                            }
                            BrowseScreen.this.home();
                            break;
                        }
                        case 20: 
                        case 47: {
                            BrowseScreen.this.activeContentTable.navItemsDown();
                            break;
                        }
                        case 19: 
                        case 51: {
                            BrowseScreen.this.activeContentTable.navItemsUp();
                            break;
                        }
                        case 21: 
                        case 29: {
                            BrowseScreen.this.simulateClick(BrowseScreen.this.activeContentTable.tbPreviousPage);
                            break;
                        }
                        case 22: 
                        case 32: {
                            BrowseScreen.this.simulateClick(BrowseScreen.this.activeContentTable.tbNextPage);
                            break;
                        }
                        case 8: 
                        case 45: 
                        case 145: {
                            BrowseScreen.this.simulateClick(BrowseScreen.this.activeContentTable.tbLeft);
                            break;
                        }
                        case 9: 
                        case 33: 
                        case 146: {
                            BrowseScreen.this.simulateClick(BrowseScreen.this.activeContentTable.tbRight);
                        }
                    }
                }
                return true;
            }
        });
        this.plt.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (Main.isPrime()) {
                    tbPractice.setDisabled(BrowseScreen.this.plt.getSelectedListID() == -1);
                }
            }
        });
        tbUnlockedVocab.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                BrowseScreen.this.setInterface(BrowseInterface.UNLOCKED, 1);
            }
        });
        tbCustomVocab.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                BrowseScreen.this.setInterface(BrowseInterface.CUSTOM, 1);
            }
        });
        tbArchivedVocab.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                BrowseScreen.this.setInterface(BrowseInterface.ARCHIVED, 1);
            }
        });
        tbSearchByMeaning.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showInputDialog(BrowseScreen.this.stage, "Meaning Keyword:", "", new Dialogs.InputAdapter(){

                    @Override
                    public void finished(String input) {
                        if (!(input = input.trim().replaceAll("[^" + Main.getDiacriticsChars() + "A-Za-z ]", "").replaceAll(" +", " ").trim().toLowerCase()).equals("")) {
                            BrowseScreen.this.currentKeyword = input;
                            BrowseScreen.this.setInterface(BrowseInterface.SEARCH_MEANING, 1);
                        }
                    }
                });
            }
        });
        tbSearchByReading.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Dialogs.showInputDialog(BrowseScreen.this.stage, "Reading Keyword:", "", -1, false, true, new Dialogs.InputAdapter(){

                    @Override
                    public void finished(String input) {
                        if (!(input = input.trim().replaceAll("[^" + Main.getKanaChars() + "]+", "").trim()).equals("")) {
                            BrowseScreen.this.currentKeyword = input;
                            BrowseScreen.this.setInterface(BrowseInterface.SEARCH_READING, 1);
                        }
                    }
                });
            }
        });
        tbPractice.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (!tbPractice.isDisabled()) {
                    BrowseScreen.this.currentlySelectedPracticeListID = BrowseScreen.this.plt.getSelectedListID();
                    BrowseScreen.this.setInterface(BrowseInterface.PRACTICE, 1);
                }
            }
        });
        this.stage.addActor(this.tblMain);
        Main.setNewScreen(this);
        this.setInterface(this.currentInterface, this.currentPage);
    }

    private void home() {
        if (this.currentInterface == BrowseInterface.SELECT) {
            this.disposeAssets();
            Dashboard.showOnScreen();
        } else {
            this.tblUnlockedVocab.hideVocabProgressionWindow();
            this.tblCustomVocab.hideVocabProgressionWindow();
            this.tblArchivedVocab.hideVocabProgressionWindow();
            this.tblSearchMeaning.hideVocabProgressionWindow();
            this.tblSearchReading.hideVocabProgressionWindow();
            this.tblPractice.hideVocabProgressionWindow();
            this.setInterface(BrowseInterface.SELECT, -1);
        }
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        Main.setCurrentStage(this.stage);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(Main.UI_BG.r, Main.UI_BG.g, Main.UI_BG.b, Main.UI_BG.a);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.disposeAssets();
    }

    static BrowseInterface getCurrentInterface() {
        return browseScreen != null ? BrowseScreen.browseScreen.currentInterface : null;
    }

    static String getCurrentSearchKeyword() {
        return browseScreen != null ? BrowseScreen.browseScreen.currentKeyword : null;
    }

    static int getCurrentlySelectedPracticeListID() {
        return BrowseScreen.browseScreen.currentlySelectedPracticeListID;
    }

    static int getCurrentPage() {
        return BrowseScreen.browseScreen.currentPage;
    }

    static void setUnlockedVocabList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblUnlockedVocab.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "You haven't learned any vocabulary yet.", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.UNLOCKED, BrowseScreen.getCurrentPage());
        }
    }

    static void setCustomVocabList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblCustomVocab.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "You don't have any custom vocabulary.", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.CUSTOM, BrowseScreen.getCurrentPage());
        }
    }

    static void setArchivedVocabList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblArchivedVocab.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "You don't have any archived vocabulary.", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.ARCHIVED, BrowseScreen.getCurrentPage());
        }
    }

    static void setSearchMeaningList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblSearchMeaning.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "Couldn't find any vocabulary containing\n\"" + BrowseScreen.getCurrentSearchKeyword() + "\".", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.SEARCH_MEANING, BrowseScreen.getCurrentPage());
        }
    }

    static void setSearchReadingList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblSearchReading.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "Couldn't find any vocabulary containing\n\"" + BrowseScreen.getCurrentSearchKeyword() + "\".", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.SEARCH_READING, BrowseScreen.getCurrentPage());
        }
    }

    static void setPracticeListVocabList(int amountTotal, int[] id, int[] meaningLevel, int[] meaningReviewed, int[] meaningCorrect, int[] readingLevel, int[] readingReviewed, int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
        if (id.length > 0) {
            BrowseScreen.browseScreen.tblPractice.setVocabList(amountTotal, id, meaningLevel, meaningReviewed, meaningCorrect, readingLevel, readingReviewed, readingCorrect, vocabKanji, vocabKana, meaning);
        } else if (BrowseScreen.getCurrentPage() == 1) {
            Dialogs.showOKDialog(BrowseScreen.browseScreen.stage, "Nothing found", "This Practice List contains no vocabulary.", new Dialogs.OKAdapter(){

                @Override
                public void ok() {
                    browseScreen.setInterface(BrowseInterface.SELECT, -1);
                }
            });
        } else {
            --BrowseScreen.browseScreen.currentPage;
            browseScreen.setInterface(BrowseInterface.PRACTICE, BrowseScreen.getCurrentPage());
        }
    }

    private void setInterface(BrowseInterface uiId, int pageNo) {
        this.currentInterface = uiId;
        this.currentPage = pageNo == -1 ? 1 : pageNo;
        switch (uiId.ordinal()) {
            case 1: {
                this.tblUnlockedVocab.setHeadlineText("Browsing learned vocabulary...");
                this.setContentTable(this.tblUnlockedVocab);
                RestClient.getUnlockedVocabList(this.currentPage);
                break;
            }
            case 2: {
                this.tblCustomVocab.setHeadlineText("Browsing custom vocabulary...");
                this.setContentTable(this.tblCustomVocab);
                RestClient.getCustomVocabList(this.currentPage);
                break;
            }
            case 3: {
                this.tblArchivedVocab.setHeadlineText("Browsing archived vocabulary...");
                this.setContentTable(this.tblArchivedVocab);
                RestClient.getArchivedVocabList(this.currentPage);
                break;
            }
            case 4: {
                this.tblSearchMeaning.setHeadlineText("Browsing vocabulary containing '" + this.currentKeyword + "' ...");
                this.setContentTable(this.tblSearchMeaning);
                RestClient.getVocabList(this.currentKeyword, null, this.currentPage);
                break;
            }
            case 5: {
                this.tblSearchReading.setHeadlineText("Browsing vocabulary containing '" + this.currentKeyword + "' ...");
                this.setContentTable(this.tblSearchReading);
                RestClient.getVocabList(null, this.currentKeyword, this.currentPage);
                break;
            }
            case 6: {
                this.tblPractice.setHeadlineText("Browsing vocabulary of list '" + this.plt.getListName(this.currentlySelectedPracticeListID) + "' ...");
                this.tblPractice.setRightButtonPermanentlyDisabled(this.plt.isLockedList(this.currentlySelectedPracticeListID));
                this.setContentTable(this.tblPractice);
                RestClient.getPracticeListVocabList(this.currentlySelectedPracticeListID, this.currentPage);
                break;
            }
            default: {
                this.setContentTable(null);
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        LoadingScreen.showOnScreen();
                    }
                });
                this.plt.refreshData();
            }
        }
    }

    private void setContentTable(TableTemplate table) {
        VisTable visTable;
        if (table == null) {
            visTable = this.tblSelect;
            this.activeContentTable = null;
        } else {
            visTable = table;
            this.activeContentTable = table;
        }
        this.tblMain.clear();
        this.tblMain.add(this.topMenu.getTable()).padBottom(Main.getPPUY()).width(this.stage.getViewport().getWorldWidth()).row();
        this.tblMain.add(visTable).width(this.stage.getViewport().getWorldWidth()).expandY().fillY().padBottom(Main.getPPUY());
    }

    private void createUnlockedVocabTable() {
        this.tblUnlockedVocab = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblUnlockedVocab.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Archive Word", "Do you want to archive this word and exclude it from your daily reviews?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.archiveVocab("", BrowseScreen.this.tblUnlockedVocab.getSelectedVocabID(), true);
                    }
                });
            }
        };
        this.tblUnlockedVocab.setLeftButtonText("View");
        this.tblUnlockedVocab.setRightButtonText("Archive");
    }

    private void createCustomVocabTable() {
        this.tblCustomVocab = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblCustomVocab.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Delete Word", "Are you sure you want to permanently delete this vocab item?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.deleteCustomVocab(BrowseScreen.this.tblCustomVocab.getSelectedVocabID());
                    }
                });
            }
        };
        this.tblCustomVocab.setLeftButtonText("Edit");
        this.tblCustomVocab.setRightButtonText("Delete");
    }

    private void createArchivedVocabTable() {
        this.tblArchivedVocab = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblArchivedVocab.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Restore Word", "The selected word will be included in your daily reviews.\nRestore this vocab item?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.archiveVocab("", BrowseScreen.this.tblArchivedVocab.getSelectedVocabID(), false);
                    }
                });
            }
        };
        this.tblArchivedVocab.setLeftButtonText("View");
        this.tblArchivedVocab.setRightButtonText("Restore");
    }

    private void createSearchMeaningVocabTable() {
        this.tblSearchMeaning = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblSearchMeaning.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Add to lessons", "Do you want to move this item to the front of your lessons queue?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.unlockSingleVocab(BrowseScreen.this.tblSearchMeaning.getSelectedVocabID());
                    }
                });
            }
        };
        this.tblSearchMeaning.setLeftButtonText("View");
        this.tblSearchMeaning.setRightButtonText("Add to Lessons");
    }

    private void createSearchReadingVocabTable() {
        this.tblSearchReading = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblSearchReading.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Add to Lessons", "Do you want to move this item to the front of your lessons queue?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.unlockSingleVocab(BrowseScreen.this.tblSearchReading.getSelectedVocabID());
                    }
                });
            }
        };
        this.tblSearchReading.setLeftButtonText("View");
        this.tblSearchReading.setRightButtonText("Add to Lessons");
    }

    private void createPracticeListVocabTable() {
        this.tblPractice = new TableTemplate(){

            @Override
            void leftButton() {
                RestClient.getSingleVocab(BrowseScreen.this.tblPractice.getSelectedVocabID());
            }

            @Override
            void rightButton() {
                Dialogs.showConfirmDialog(BrowseScreen.this.stage, "Remove from List", "Do you want to remove this word from this list?", new Dialogs.ConfirmAdapter(){

                    @Override
                    public void yes() {
                        RestClient.addVocabToPracticeList(null, BrowseScreen.this.currentlySelectedPracticeListID, BrowseScreen.this.tblPractice.getSelectedVocabID(), true);
                    }
                });
            }
        };
        this.tblPractice.setLeftButtonText("View/Edit");
        this.tblPractice.setRightButtonText("Remove");
    }

    private void getData() {
        switch (this.currentInterface.ordinal()) {
            case 1: {
                RestClient.getUnlockedVocabList(this.currentPage);
                break;
            }
            case 2: {
                RestClient.getCustomVocabList(this.currentPage);
                break;
            }
            case 3: {
                RestClient.getArchivedVocabList(this.currentPage);
                break;
            }
            case 4: {
                RestClient.getVocabList(this.currentKeyword, null, this.currentPage);
                break;
            }
            case 5: {
                RestClient.getVocabList(null, this.currentKeyword, this.currentPage);
                break;
            }
            case 6: {
                RestClient.getPracticeListVocabList(this.plt.getSelectedListID(), this.currentPage);
            }
        }
    }

    private void disposeAssets() {
        Main.disposeAsset("browse.ttf", true);
    }

    private void simulateClick(Actor actor) {
        try {
            InputEvent ie = new InputEvent();
            ie.setType(InputEvent.Type.touchDown);
            actor.fire(ie);
            ie.setType(InputEvent.Type.touchUp);
            actor.fire(ie);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private abstract class TableTemplate
    extends VisTable {
        private AddVocabScreen.Vocabulary[] vocabList;
        private VisTextButton[] buttonsList;
        private VisTextButton tbLeft;
        private VisTextButton tbRight;
        private VisTextButton tbNextPage;
        private VisTextButton tbPreviousPage;
        private VisLabel lHeader;
        private VisLabel lHeadline;
        private int selectedVocabID;
        private boolean leftButtonPermanentlyDisabled = false;
        private boolean rightButtonPermanentlyDisabled = false;
        private VisWindow win;
        private VisProgressBar pbCombined;
        private VisProgressBar pbMeaning;
        private VisProgressBar pbReading;
        private VisLabel lLevelMeaning;
        private VisLabel lLevelReading;
        private VisLabel lCombined1;
        private VisLabel lCombined2;
        private VisLabel lMeaning1;
        private VisLabel lMeaning2;
        private VisLabel lReading1;
        private VisLabel lReading2;

        private TableTemplate() {
            this.createVocabProgressionWindow();
            VisTable tblTop = new VisTable(true);
            VisTable tblBottom = new VisTable(true);
            this.lHeader = new VisLabel((CharSequence)"", Main.labelStyleKanaX1);
            this.lHeadline = new VisLabel((CharSequence)"", Main.labelStyleKanaX1);
            this.tbLeft = new VisTextButton("", Main.btnStyleX1p25);
            this.tbRight = new VisTextButton("", Main.btnStyleX1p25);
            this.tbNextPage = new VisTextButton("\u2192", Main.btnStyleX1);
            this.tbPreviousPage = new VisTextButton("\u2190", Main.btnStyleX1);
            this.setLeftButtonDisabled(true);
            this.setRightButtonDisabled(true);
            this.setNextButtonDisabled(true);
            this.setPreviousButtonDisabled(true);
            this.tbLeft.setFocusBorderEnabled(false);
            this.tbRight.setFocusBorderEnabled(false);
            this.tbNextPage.setFocusBorderEnabled(false);
            this.tbPreviousPage.setFocusBorderEnabled(false);
            this.lHeader.setWrap(true);
            tblTop.align(8);
            tblTop.add(this.lHeadline);
            tblTop.add(this.tbPreviousPage).width(3 * Main.getPPUY()).fillX();
            tblTop.add(this.tbNextPage).width(3 * Main.getPPUY()).fillX();
            tblBottom.defaults().expandX().fillX().uniformX();
            tblBottom.add(this.tbLeft);
            tblBottom.add(this.tbRight);
            this.add(this.lHeader).width(BrowseScreen.this.stage.getViewport().getWorldWidth() * 0.95f).row();
            this.add(tblTop).width(BrowseScreen.this.stage.getViewport().getWorldWidth() * 0.95f).padBottom(0.5f * (float)Main.getPPUY()).row();
            this.add().fill().expand().align(2).padBottom(Main.getPPUY()).row();
            this.add(tblBottom).width(BrowseScreen.this.stage.getViewport().getWorldWidth() * 0.95f);
            this.tbNextPage.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!TableTemplate.this.tbNextPage.isDisabled()) {
                        if (TableTemplate.this.win.hasParent()) {
                            TableTemplate.this.win.fadeOut(0.0f);
                        }
                        BrowseScreen.this.currentPage += 1;
                        TableTemplate.this.selectedVocabID = -1;
                        TableTemplate.this.setLeftButtonDisabled(true);
                        TableTemplate.this.setRightButtonDisabled(true);
                        BrowseScreen.this.getData();
                    }
                }
            });
            this.tbPreviousPage.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!TableTemplate.this.tbPreviousPage.isDisabled()) {
                        if (TableTemplate.this.win.hasParent()) {
                            TableTemplate.this.win.fadeOut(0.0f);
                        }
                        BrowseScreen.this.currentPage -= 1;
                        TableTemplate.this.selectedVocabID = -1;
                        TableTemplate.this.setLeftButtonDisabled(true);
                        TableTemplate.this.setRightButtonDisabled(true);
                        BrowseScreen.this.getData();
                    }
                }
            });
            this.tbLeft.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!TableTemplate.this.tbLeft.isDisabled()) {
                        TableTemplate.this.leftButton();
                    }
                }
            });
            this.tbRight.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    if (!TableTemplate.this.tbRight.isDisabled()) {
                        TableTemplate.this.rightButton();
                    }
                }
            });
        }

        private void createVocabProgressionWindow() {
            this.pbCombined = new VisProgressBar(0.0f, 1.0f, 1.0f, false);
            this.pbMeaning = new VisProgressBar(0.0f, 1.0f, 1.0f, false);
            this.pbReading = new VisProgressBar(0.0f, 1.0f, 1.0f, false);
            this.lLevelMeaning = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lLevelReading = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lCombined1 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lCombined2 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lMeaning1 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lMeaning2 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lReading1 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lReading2 = new VisLabel((CharSequence)"", Main.labelStyleX1);
            this.lLevelMeaning.setAlignment(16);
            this.lLevelReading.setAlignment(16);
            float space = Main.getPPUY();
            VisTable tblLevels = new VisTable(false);
            tblLevels.defaults().expandX().fillX().padRight(space / 2.0f);
            tblLevels.add(new VisLabel((CharSequence)"Meaning SRS Lvl: ", Main.labelStyleX1)).align(8).padLeft(space / 2.0f);
            tblLevels.add(this.lLevelMeaning).align(16).row();
            tblLevels.add(new VisLabel((CharSequence)"Reading SRS Lvl: ", Main.labelStyleX1)).align(8).padLeft(space / 2.0f);
            tblLevels.add(this.lLevelReading).align(16).row();
            VisTable tblCombined = new VisTable(false);
            tblCombined.defaults().padLeft(space / 2.0f).padRight(space / 2.0f);
            tblCombined.add(new VisLabel((CharSequence)"Combined Answered Correct", Main.labelStyleX1)).colspan(3).row();
            tblCombined.add(this.pbCombined).colspan(3).height(Main.getPPUY()).expandX().fillX().row();
            tblCombined.add(this.lCombined1);
            tblCombined.add(new VisLabel((CharSequence)"out of", Main.labelStyleX0p5));
            tblCombined.add(this.lCombined2).row();
            VisTable tblMeaning = new VisTable(false);
            tblMeaning.defaults().padLeft(space / 2.0f).padRight(space / 2.0f);
            tblMeaning.add(new VisLabel((CharSequence)"Meaning Answered Correct", Main.labelStyleX1)).colspan(3).row();
            tblMeaning.add(this.pbMeaning).colspan(3).height(Main.getPPUY()).expandX().fillX().row();
            tblMeaning.add(this.lMeaning1);
            tblMeaning.add(new VisLabel((CharSequence)"out of", Main.labelStyleX0p5));
            tblMeaning.add(this.lMeaning2).row();
            VisTable tblReading = new VisTable(false);
            tblReading.defaults().padLeft(space / 2.0f).padRight(space / 2.0f);
            tblReading.add(new VisLabel((CharSequence)"Reading Answered Correct", Main.labelStyleX1)).colspan(3).row();
            tblReading.add(this.pbReading).colspan(3).height(Main.getPPUY()).expandX().fillX().row();
            tblReading.add(this.lReading1);
            tblReading.add(new VisLabel((CharSequence)"out of", Main.labelStyleX0p5));
            tblReading.add(this.lReading2).row();
            this.win = new VisWindow("Vocab Progression", true);
            this.win.setMovable(true);
            tblLevels.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
            tblCombined.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
            tblMeaning.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
            tblReading.setBackground(Main.uiSkin.newDrawable("white", Main.OBJECT_BG));
            this.win.padTop(space * 1.5f);
            this.win.defaults().fillX().uniformX().padBottom(space / 2.0f).padLeft(space / 2.0f).padRight(space / 2.0f);
            this.win.add(tblLevels).padTop(space / 2.0f).row();
            this.win.add(tblCombined).row();
            this.win.add(tblMeaning).row();
            this.win.add(tblReading).row();
            this.win.pack();
        }

        private void hideVocabProgressionWindow() {
            if (this.win.hasParent()) {
                this.win.fadeOut(0.0f);
            }
        }

        abstract void leftButton();

        abstract void rightButton();

        int getSelectedVocabID() {
            return this.vocabList[this.selectedVocabID].id;
        }

        void deselectActiveItem() {
            for (VisTextButton visTextButton : this.buttonsList) {
                if (!visTextButton.isChecked()) continue;
                BrowseScreen.this.simulateClick(visTextButton);
                break;
            }
        }

        void navItemsDown() {
            int selectedButtonID = -1;
            for (int i = 0; i < this.buttonsList.length; ++i) {
                if (!this.buttonsList[i].isChecked()) continue;
                selectedButtonID = i;
            }
            if (selectedButtonID == -1 || selectedButtonID + 1 == this.buttonsList.length) {
                BrowseScreen.this.simulateClick(this.buttonsList[0]);
            } else {
                BrowseScreen.this.simulateClick(this.buttonsList[selectedButtonID + 1]);
            }
        }

        void navItemsUp() {
            int selectedButtonID = -1;
            for (int i = 0; i < this.buttonsList.length; ++i) {
                if (!this.buttonsList[i].isChecked()) continue;
                selectedButtonID = i;
            }
            if (selectedButtonID <= 0) {
                BrowseScreen.this.simulateClick(this.buttonsList[this.buttonsList.length - 1]);
            } else {
                BrowseScreen.this.simulateClick(this.buttonsList[selectedButtonID - 1]);
            }
        }

        void setLeftButtonText(String text) {
            this.tbLeft.setText(text);
        }

        void setRightButtonText(String text) {
            this.tbRight.setText(text);
        }

        void setLeftButtonDisabled(boolean disabled) {
            if (!this.leftButtonPermanentlyDisabled) {
                this.tbLeft.setDisabled(disabled);
            }
        }

        void setRightButtonDisabled(boolean disabled) {
            if (!this.rightButtonPermanentlyDisabled) {
                this.tbRight.setDisabled(disabled);
            }
        }

        void setRightButtonPermanentlyDisabled(boolean disabled) {
            this.rightButtonPermanentlyDisabled = disabled;
        }

        void setNextButtonDisabled(boolean disabled) {
            this.tbNextPage.setDisabled(disabled);
        }

        void setPreviousButtonDisabled(boolean disabled) {
            this.tbPreviousPage.setDisabled(disabled);
        }

        void setHeadlineText(String text) {
            this.lHeader.setText(text);
        }

        void replaceContentTable(Actor actor) {
            this.getCells().get(2).setActor(actor).fill().expand().align(2).padBottom(Main.getPPUY());
        }

        String SRSidToName(int id) {
            switch (id) {
                case 1: {
                    return "Rookie 1";
                }
                case 2: {
                    return "Rookie 2";
                }
                case 3: {
                    return "Rookie 3";
                }
                case 4: {
                    return "Rookie 4";
                }
                case 5: {
                    return "Amateur 1";
                }
                case 6: {
                    return "Amateur 2";
                }
                case 7: {
                    return "Expert";
                }
                case 8: {
                    return "Master";
                }
                case 9: {
                    return "Sensei";
                }
            }
            return "N/A";
        }

        void setVocabList(int amountTotal, int[] id, final int[] meaningLevel, final int[] meaningReviewed, final int[] meaningCorrect, final int[] readingLevel, final int[] readingReviewed, final int[] readingCorrect, String[] vocabKanji, String[] vocabKana, String[] meaning) {
            int showFrom = (browseScreen.currentPage - 1) * 10 + 1;
            int showTo = showFrom - 1 + id.length;
            this.lHeadline.setText("Showing " + showFrom + " - " + showTo + " of " + amountTotal);
            this.setNextButtonDisabled(showTo == amountTotal);
            this.setPreviousButtonDisabled(browseScreen.currentPage == 1);
            this.vocabList = new AddVocabScreen.Vocabulary[id.length];
            VisTable table = new VisTable(false);
            VisTable tbl = new VisTable(false);
            table.align(2);
            tbl.align(2);
            String kanjiChars = Arrays.toString(vocabKanji);
            BrowseScreen.this.disposeAssets();
            Main.loadTTFtoAssetManager("browse.ttf", Main.getPPUY(), kanjiChars, true);
            Main.finishLoadingAsset("browse.ttf", true);
            Label.LabelStyle styleKanji = new Label.LabelStyle(new VisLabel().getStyle());
            Label.LabelStyle styleKana = new Label.LabelStyle(new VisLabel().getStyle());
            styleKanji.font = (BitmapFont)Main.getAsset("browse.ttf", BitmapFont.class, true);
            styleKana.font = (BitmapFont)Main.getAsset(Main.FONT_KANA_X1, BitmapFont.class, true);
            styleKanji.fontColor = Main.FONT;
            styleKana.fontColor = Main.FONT;
            this.buttonsList = new VisTextButton[id.length];
            VisTextButton.VisTextButtonStyle tbStyle = new VisTextButton.VisTextButtonStyle((VisTextButton.VisTextButtonStyle)new VisTextButton("", "toggle").getStyle());
            tbStyle.up = Main.uiSkin.newDrawable("white", Main.OBJECT_BG);
            for (int i = 0; i < id.length; ++i) {
                Stack stack;
                final boolean isWordUnlearned = meaningLevel[i] < 1 && readingLevel[i] < 1;
                int charLimit = Main.isDesktop() ? 30 : 15;
                String sKanji = isWordUnlearned ? "[DISABLED]" + vocabKanji[i] + "[]" : vocabKanji[i];
                String sKana = isWordUnlearned ? "[DISABLED]" + vocabKana[i] + "[]" : vocabKana[i];
                String sMeaning = meaning[i].length() > charLimit ? meaning[i].substring(0, charLimit) + "... " : meaning[i] + " ";
                sMeaning = isWordUnlearned ? "[DISABLED]" + sMeaning + "[]" : sMeaning;
                this.vocabList[i] = new AddVocabScreen.Vocabulary(id[i], vocabKanji[i], vocabKana[i], meaning[i], null, null, null, null, null, null, -1);
                this.buttonsList[i] = new VisTextButton("", tbStyle);
                VisLabel lKanji = new VisLabel((CharSequence)(" " + sKanji), styleKanji);
                VisLabel lKana = new VisLabel((CharSequence)(" " + sKana), styleKana);
                VisLabel lMeaning = new VisLabel((CharSequence)(sMeaning + " "), Main.labelStyleX1);
                lMeaning.setAlignment(16);
                lKanji.setTouchable(Touchable.disabled);
                lKana.setTouchable(Touchable.disabled);
                lMeaning.setTouchable(Touchable.disabled);
                this.buttonsList[i].setFocusBorderEnabled(false);
                if (!vocabKanji[i].equals(vocabKana[i])) {
                    lKanji.setAlignment(10);
                    lKana.setAlignment(12);
                    stack = new Stack(this.buttonsList[i], lKanji, lKana, lMeaning);
                } else {
                    lKanji.setAlignment(8);
                    stack = new Stack(this.buttonsList[i], lKanji, lMeaning);
                }
                final int finalI = i;
                this.buttonsList[i].addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        for (int j = 0; j < TableTemplate.this.buttonsList.length; ++j) {
                            if (j == finalI) continue;
                            TableTemplate.this.buttonsList[j].setChecked(false);
                        }
                        if (!TableTemplate.this.buttonsList[finalI].isChecked()) {
                            TableTemplate.this.buttonsList[finalI].setChecked(false);
                            TableTemplate.this.selectedVocabID = -1;
                            TableTemplate.this.setLeftButtonDisabled(true);
                            TableTemplate.this.setRightButtonDisabled(true);
                            TableTemplate.this.win.fadeOut();
                        } else {
                            TableTemplate.this.buttonsList[finalI].setChecked(true);
                            TableTemplate.this.selectedVocabID = finalI;
                            TableTemplate.this.setLeftButtonDisabled(false);
                            TableTemplate.this.setRightButtonDisabled(false);
                            if (!(BrowseScreen.this.currentInterface != BrowseInterface.SEARCH_MEANING && BrowseScreen.this.currentInterface != BrowseInterface.SEARCH_READING || isWordUnlearned)) {
                                TableTemplate.this.setRightButtonDisabled(true);
                            }
                            TableTemplate.this.pbCombined.setRange(0.0f, meaningReviewed[finalI] + readingReviewed[finalI]);
                            TableTemplate.this.pbMeaning.setRange(0.0f, meaningReviewed[finalI]);
                            TableTemplate.this.pbReading.setRange(0.0f, readingReviewed[finalI]);
                            TableTemplate.this.pbCombined.setValue(meaningCorrect[finalI] + readingCorrect[finalI]);
                            TableTemplate.this.pbMeaning.setValue(meaningCorrect[finalI]);
                            TableTemplate.this.pbReading.setValue(readingCorrect[finalI]);
                            TableTemplate.this.lLevelMeaning.setText(TableTemplate.this.SRSidToName(meaningLevel[finalI]));
                            TableTemplate.this.lLevelMeaning.pack();
                            TableTemplate.this.lLevelReading.setText(TableTemplate.this.SRSidToName(readingLevel[finalI]));
                            TableTemplate.this.lLevelReading.pack();
                            TableTemplate.this.lCombined1.setText((int)TableTemplate.this.pbCombined.getValue());
                            TableTemplate.this.lCombined1.pack();
                            TableTemplate.this.lCombined2.setText((int)TableTemplate.this.pbCombined.getMaxValue());
                            TableTemplate.this.lCombined2.pack();
                            TableTemplate.this.lMeaning1.setText((int)TableTemplate.this.pbMeaning.getValue());
                            TableTemplate.this.lMeaning1.pack();
                            TableTemplate.this.lMeaning2.setText((int)TableTemplate.this.pbMeaning.getMaxValue());
                            TableTemplate.this.lMeaning2.pack();
                            TableTemplate.this.lReading1.setText((int)TableTemplate.this.pbReading.getValue());
                            TableTemplate.this.lReading1.pack();
                            TableTemplate.this.lReading2.setText((int)TableTemplate.this.pbReading.getMaxValue());
                            TableTemplate.this.lReading2.pack();
                            TableTemplate.this.win.pack();
                            Vector2 coords = new Vector2(0.0f, 0.0f);
                            stack.localToScreenCoordinates(coords);
                            float yi = (float)Gdx.graphics.getHeight() - coords.y - TableTemplate.this.win.getHeight() - (float)Main.getPPUY() / 4.0f > 0.0f ? (float)Gdx.graphics.getHeight() - coords.y - TableTemplate.this.win.getHeight() - (float)Main.getPPUY() / 4.0f : (float)Gdx.graphics.getHeight() - coords.y + stack.getHeight() + (float)Main.getPPUY() / 4.0f;
                            if (!TableTemplate.this.win.hasParent()) {
                                BrowseScreen.this.stage.addActor(TableTemplate.this.win);
                            }
                            TableTemplate.this.win.centerWindow();
                            TableTemplate.this.win.setPosition(TableTemplate.this.win.getX(), yi);
                            TableTemplate.this.win.fadeIn();
                        }
                    }
                });
                table.add(stack).height(2.5f * (float)Main.getPPUY()).expandX().fillX().padBottom(0.5f * (float)Main.getPPUY()).row();
            }
            tbl.add(table).width(BrowseScreen.this.stage.getViewport().getWorldWidth() * 0.95f);
            VisScrollPane sp = new VisScrollPane((Actor)tbl);
            this.replaceContentTable(sp);
        }
    }

    static enum BrowseInterface {
        SELECT,
        UNLOCKED,
        CUSTOM,
        ARCHIVED,
        SEARCH_MEANING,
        SEARCH_READING,
        PRACTICE;

    }
}

