/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.spinner;

import com.kotcrab.vis.ui.util.FloatDigitsOnlyFilter;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.util.IntDigitsOnlyFilter;
import com.kotcrab.vis.ui.util.NumberDigitsTextFieldFilter;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import com.kotcrab.vis.ui.widget.spinner.AbstractSpinnerModel;
import com.kotcrab.vis.ui.widget.spinner.Spinner;
import java.math.BigDecimal;

public class SimpleFloatSpinnerModel
extends AbstractSpinnerModel {
    private InputValidator boundsValidator = new BoundsValidator();
    private NumberDigitsTextFieldFilter textFieldFilter;
    private float max;
    private float min;
    private float step;
    private float current;
    private int precision = 0;

    public SimpleFloatSpinnerModel(float initialValue, float min, float max) {
        this(initialValue, min, max, 1.0f, 1);
    }

    public SimpleFloatSpinnerModel(float initialValue, float min, float max, float step) {
        this(initialValue, min, max, step, 1);
    }

    public SimpleFloatSpinnerModel(float initialValue, float min, float max, float step, int precision) {
        super(false);
        if (min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        if (step <= 0.0f) {
            throw new IllegalArgumentException("step must be > 0");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("precision must be >= 0");
        }
        this.current = initialValue;
        this.max = max;
        this.min = min;
        this.step = step;
        this.precision = precision;
    }

    @Override
    public void bind(Spinner spinner) {
        super.bind(spinner);
        this.setPrecision(this.precision, false);
        spinner.notifyValueChanged(true);
    }

    @Override
    public void textChanged() {
        String text = this.spinner.getTextField().getText();
        if (text.equals("")) {
            this.current = this.min;
        } else if (this.checkInputBounds(text)) {
            this.current = Float.parseFloat(text);
        }
    }

    @Override
    public boolean incrementModel() {
        if (this.current + this.step > this.max) {
            if (this.current == this.max) {
                if (this.isWrap()) {
                    this.current = this.min;
                    return true;
                }
                return false;
            }
            this.current = this.max;
        } else {
            this.current += this.step;
        }
        return true;
    }

    @Override
    public boolean decrementModel() {
        if (this.current - this.step < this.min) {
            if (this.current == this.min) {
                if (this.isWrap()) {
                    this.current = this.max;
                    return true;
                }
                return false;
            }
            this.current = this.min;
        } else {
            this.current -= this.step;
        }
        return true;
    }

    @Override
    public String getText() {
        if (this.precision >= 1) {
            BigDecimal bd = new BigDecimal(String.valueOf(this.current));
            bd = bd.setScale(this.precision, 4);
            return String.valueOf(bd.floatValue());
        }
        return String.valueOf((int)this.current);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.setPrecision(precision, true);
    }

    private void setPrecision(final int precision, boolean notifySpinner) {
        if (precision < 0) {
            throw new IllegalStateException("Precision can't be < 0");
        }
        this.precision = precision;
        VisValidatableTextField valueText = this.spinner.getTextField();
        valueText.getValidators().clear();
        valueText.addValidator(this.boundsValidator);
        if (precision == 0) {
            valueText.addValidator(Validators.INTEGERS);
            this.textFieldFilter = new IntDigitsOnlyFilter(true);
            valueText.setTextFieldFilter(this.textFieldFilter);
        } else {
            valueText.addValidator(Validators.FLOATS);
            valueText.addValidator(new InputValidator(){

                @Override
                public boolean validateInput(String input) {
                    int dotIndex = input.indexOf(46);
                    if (dotIndex == -1) {
                        return true;
                    }
                    return input.length() - input.indexOf(46) - 1 <= precision;
                }
            });
            this.textFieldFilter = new FloatDigitsOnlyFilter(true);
            valueText.setTextFieldFilter(this.textFieldFilter);
        }
        this.textFieldFilter.setUseFieldCursorPosition(true);
        if (this.min >= 0.0f) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        } else {
            this.textFieldFilter.setAcceptNegativeValues(true);
        }
        if (notifySpinner) {
            this.spinner.notifyValueChanged(this.spinner.isProgrammaticChangeEvents());
        }
    }

    public void setValue(float newValue) {
        this.setValue(newValue, this.spinner.isProgrammaticChangeEvents());
    }

    public void setValue(float newValue, boolean fireEvent) {
        this.current = newValue > this.max ? this.max : (newValue < this.min ? this.min : newValue);
        this.spinner.notifyValueChanged(fireEvent);
    }

    public float getValue() {
        return this.current;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        if (min > this.max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.min = min;
        if (min >= 0.0f) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        } else {
            this.textFieldFilter.setAcceptNegativeValues(true);
        }
        if (this.current < min) {
            this.current = min;
            this.spinner.notifyValueChanged(this.spinner.isProgrammaticChangeEvents());
        }
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        if (this.min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.max = max;
        if (this.current > max) {
            this.current = max;
            this.spinner.notifyValueChanged(this.spinner.isProgrammaticChangeEvents());
        }
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        if (step <= 0.0f) {
            throw new IllegalArgumentException("step must be > 0");
        }
        this.step = step;
    }

    private boolean checkInputBounds(String input) {
        try {
            float x = Float.parseFloat(input);
            return x >= this.min && x <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private class BoundsValidator
    implements InputValidator {
        private BoundsValidator() {
        }

        @Override
        public boolean validateInput(String input) {
            return SimpleFloatSpinnerModel.this.checkInputBounds(input);
        }
    }
}

