/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;
import com.kotcrab.vis.ui.util.CursorManager;

public class VisTextField
extends Widget
implements Disableable,
Focusable,
BorderOwner {
    private static final char BACKSPACE = '\b';
    protected static final char ENTER_DESKTOP = '\r';
    protected static final char ENTER_ANDROID = '\n';
    private static final char TAB = '\t';
    private static final char DELETE = '\u007f';
    private static final char BULLET = '\u2022';
    private static final Vector2 tmp1 = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private static final Vector2 tmp3 = new Vector2();
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.04f;
    protected String text;
    protected int cursor;
    protected int selectionStart;
    protected boolean hasSelection;
    protected boolean writeEnters;
    protected final GlyphLayout layout = new GlyphLayout();
    protected final FloatArray glyphPositions = new FloatArray();
    private String messageText;
    protected CharSequence displayText;
    Clipboard clipboard;
    InputListener inputListener;
    TextFieldListener listener;
    TextFieldFilter filter;
    TextField.OnscreenKeyboard keyboard = new TextField.DefaultOnscreenKeyboard();
    boolean focusTraversal = true;
    boolean onlyFontChars = true;
    boolean disabled;
    boolean enterKeyFocusTraversal = false;
    private int textHAlign = 8;
    private float selectionX;
    private float selectionWidth;
    String undoText = "";
    int undoCursorPos = 0;
    long lastChangeTime;
    boolean passwordMode;
    private StringBuilder passwordBuffer;
    private char passwordCharacter = (char)8226;
    protected float fontOffset;
    protected float textHeight;
    protected float textOffset;
    float renderOffset;
    private int visibleTextStart;
    private int visibleTextEnd;
    private int maxLength = 0;
    private float blinkTime = 0.45f;
    boolean cursorOn = true;
    long lastBlink;
    KeyRepeatTask keyRepeatTask = new KeyRepeatTask();
    boolean programmaticChangeEvents;
    VisTextFieldStyle style;
    private ClickListener clickListener;
    private boolean drawBorder;
    private boolean focusBorderEnabled = true;
    private boolean inputValid = true;
    private boolean ignoreEqualsTextChange = true;
    private boolean readOnly = false;
    private float cursorPercentHeight = 0.8f;

    public VisTextField() {
        this("", VisUI.getSkin().get(VisTextFieldStyle.class));
    }

    public VisTextField(String text) {
        this(text, VisUI.getSkin().get(VisTextFieldStyle.class));
    }

    public VisTextField(String text, String styleName) {
        this(text, VisUI.getSkin().get(styleName, VisTextFieldStyle.class));
    }

    public VisTextField(String text, VisTextFieldStyle style) {
        this.setStyle(style);
        this.clipboard = Gdx.app.getClipboard();
        this.initialize();
        this.setText(text);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected void initialize() {
        this.inputListener = this.createInputListener();
        this.addListener(this.inputListener);
        this.clickListener = new ClickListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                if (pointer == -1 && !VisTextField.this.isDisabled()) {
                    Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Ibeam);
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                super.exit(event, x, y, pointer, toActor);
                if (pointer == -1) {
                    CursorManager.restoreDefaultCursor();
                }
            }
        };
        this.addListener(this.clickListener);
    }

    protected InputListener createInputListener() {
        return new TextFieldClickListener();
    }

    protected int letterUnderCursor(float x) {
        x -= this.textOffset + this.fontOffset - this.style.font.getData().cursorX - this.glyphPositions.get(this.visibleTextStart);
        int n = this.glyphPositions.size;
        float[] glyphPositions = this.glyphPositions.items;
        for (int i = 1; i < n; ++i) {
            if (!(glyphPositions[i] > x)) continue;
            if (glyphPositions[i] - x <= x - glyphPositions[i - 1]) {
                return i;
            }
            return i - 1;
        }
        return n - 1;
    }

    protected boolean isWordCharacter(char c) {
        return Character.isLetterOrDigit(c);
    }

    protected int[] wordUnderCursor(int at) {
        int index;
        String text = this.text;
        int start = Math.min(text.length(), at);
        int right = text.length();
        int left = 0;
        for (index = start; index < right; ++index) {
            if (this.isWordCharacter(text.charAt(index))) continue;
            right = index;
            break;
        }
        for (index = start - 1; index > -1; --index) {
            if (this.isWordCharacter(text.charAt(index))) continue;
            left = index + 1;
            break;
        }
        return new int[]{left, right};
    }

    int[] wordUnderCursor(float x) {
        return this.wordUnderCursor(this.letterUnderCursor(x));
    }

    boolean withinMaxLength(int size) {
        return this.maxLength <= 0 || size < this.maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setOnlyFontChars(boolean onlyFontChars) {
        this.onlyFontChars = onlyFontChars;
    }

    public VisTextFieldStyle getStyle() {
        return this.style;
    }

    public void setStyle(VisTextFieldStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.textHeight = style.font.getCapHeight() - style.font.getDescent() * 2.0f;
        this.invalidateHierarchy();
    }

    @Override
    public String toString() {
        return this.getText();
    }

    protected void calculateOffsets() {
        float x;
        float visibleWidth = this.getWidth();
        if (this.style.background != null) {
            visibleWidth -= this.style.background.getLeftWidth() + this.style.background.getRightWidth();
        }
        int glyphCount = this.glyphPositions.size;
        float[] glyphPositions = this.glyphPositions.items;
        float distance = glyphPositions[Math.max(0, this.cursor - 1)] + this.renderOffset;
        if (distance <= 0.0f) {
            this.renderOffset -= distance;
        } else {
            int index = Math.min(glyphCount - 1, this.cursor + 1);
            float minX = glyphPositions[index] - visibleWidth;
            if (-this.renderOffset < minX) {
                this.renderOffset = -minX;
            }
        }
        float maxOffset = 0.0f;
        float width = glyphPositions[glyphCount - 1];
        for (int i = glyphCount - 2; i >= 0 && !(width - (x = glyphPositions[i]) > visibleWidth); --i) {
            maxOffset = x;
        }
        if (-this.renderOffset > maxOffset) {
            this.renderOffset = -maxOffset;
        }
        this.visibleTextStart = 0;
        float startX = 0.0f;
        for (int i = 0; i < glyphCount; ++i) {
            if (!(glyphPositions[i] >= -this.renderOffset)) continue;
            this.visibleTextStart = Math.max(0, i);
            startX = glyphPositions[i];
            break;
        }
        int length = Math.min(this.displayText.length(), glyphPositions.length - 1);
        this.visibleTextEnd = Math.min(length, this.cursor + 1);
        while (this.visibleTextEnd <= length && !(glyphPositions[this.visibleTextEnd] > startX + visibleWidth)) {
            ++this.visibleTextEnd;
        }
        this.visibleTextEnd = Math.max(0, this.visibleTextEnd - 1);
        if ((this.textHAlign & 8) == 0) {
            this.textOffset = visibleWidth - (glyphPositions[this.visibleTextEnd] - startX);
            if ((this.textHAlign & 1) != 0) {
                this.textOffset = Math.round(this.textOffset * 0.5f);
            }
        } else {
            this.textOffset = startX + this.renderOffset;
        }
        if (this.hasSelection) {
            int minIndex = Math.min(this.cursor, this.selectionStart);
            int maxIndex = Math.max(this.cursor, this.selectionStart);
            float minX = Math.max(glyphPositions[minIndex] - glyphPositions[this.visibleTextStart], -this.textOffset);
            float maxX = Math.min(glyphPositions[maxIndex] - glyphPositions[this.visibleTextStart], visibleWidth - this.textOffset);
            this.selectionX = minX;
            this.selectionWidth = maxX - minX - this.style.font.getData().cursorX;
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        float yOffset;
        Drawable background;
        boolean focused;
        Stage stage = this.getStage();
        boolean bl = focused = stage != null && stage.getKeyboardFocus() == this;
        if (!focused) {
            this.keyRepeatTask.cancel();
        }
        BitmapFont font = this.style.font;
        Color fontColor = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (focused && this.style.focusedFontColor != null ? this.style.focusedFontColor : this.style.fontColor);
        Drawable selection = this.style.selection;
        Drawable cursorPatch = this.style.cursor;
        Drawable drawable = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : (background = focused && this.style.focusedBackground != null ? this.style.focusedBackground : this.style.background);
        if (!this.disabled && this.style.backgroundOver != null && (this.clickListener.isOver() || focused)) {
            background = this.style.backgroundOver;
        }
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        float bgLeftWidth = 0.0f;
        float bgRightWidth = 0.0f;
        if (background != null) {
            background.draw(batch, x, y, width, height);
            bgLeftWidth = background.getLeftWidth();
            bgRightWidth = background.getRightWidth();
        }
        float textY = this.getTextY(font, background);
        this.calculateOffsets();
        if (focused && this.hasSelection && selection != null) {
            this.drawSelection(selection, batch, font, x + bgLeftWidth, y + textY);
        }
        float f = yOffset = font.isFlipped() ? -this.textHeight : 0.0f;
        if (this.displayText.length() == 0) {
            if (!focused && this.messageText != null) {
                if (this.style.messageFontColor != null) {
                    font.setColor(this.style.messageFontColor.r, this.style.messageFontColor.g, this.style.messageFontColor.b, this.style.messageFontColor.a * color.a * parentAlpha);
                } else {
                    font.setColor(0.7f, 0.7f, 0.7f, color.a * parentAlpha);
                }
                BitmapFont messageFont = this.style.messageFont != null ? this.style.messageFont : font;
                messageFont.draw(batch, this.messageText, x + bgLeftWidth, y + textY + yOffset, 0, this.messageText.length(), width - bgLeftWidth - bgRightWidth, this.textHAlign, false, "...");
            }
        } else {
            BitmapFont.BitmapFontData data = font.getData();
            boolean markupEnabled = data.markupEnabled;
            data.markupEnabled = false;
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * color.a * parentAlpha);
            this.drawText(batch, font, x + bgLeftWidth, y + textY + yOffset);
            data.markupEnabled = markupEnabled;
        }
        if (this.drawBorder && focused && !this.disabled) {
            this.blink();
            if (this.cursorOn && cursorPatch != null) {
                this.drawCursor(cursorPatch, batch, font, x + bgLeftWidth, y + textY);
            }
        }
        if (!this.isDisabled() && !this.inputValid && this.style.errorBorder != null) {
            this.style.errorBorder.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected float getTextY(BitmapFont font, Drawable background) {
        float height = this.getHeight();
        float textY = this.textHeight / 2.0f + font.getDescent();
        if (background != null) {
            float bottom = background.getBottomHeight();
            textY = textY + (height - background.getTopHeight() - bottom) / 2.0f + bottom;
        } else {
            textY += height / 2.0f;
        }
        if (font.usesIntegerPositions()) {
            textY = (int)textY;
        }
        return textY;
    }

    protected void drawSelection(Drawable selection, Batch batch, BitmapFont font, float x, float y) {
        selection.draw(batch, x + this.selectionX + this.textOffset + this.fontOffset, y - this.textHeight - font.getDescent(), this.selectionWidth, this.textHeight);
    }

    protected void drawText(Batch batch, BitmapFont font, float x, float y) {
        font.draw(batch, this.displayText, x + this.textOffset, y, this.visibleTextStart, this.visibleTextEnd, 0.0f, 8, false);
    }

    protected void drawCursor(Drawable cursorPatch, Batch batch, BitmapFont font, float x, float y) {
        float cursorHeight = this.textHeight * this.cursorPercentHeight;
        float cursorYPadding = (this.textHeight - cursorHeight) / 2.0f;
        cursorPatch.draw(batch, x + this.textOffset + this.glyphPositions.get(this.cursor) - this.glyphPositions.get(this.visibleTextStart) + this.fontOffset + font.getData().cursorX, y - this.textHeight - font.getDescent() + cursorYPadding, cursorPatch.getMinWidth(), cursorHeight);
    }

    void updateDisplayText() {
        BitmapFont font = this.style.font;
        BitmapFont.BitmapFontData data = font.getData();
        String text = this.text;
        int textLength = text.length();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < textLength; ++i) {
            char c = text.charAt(i);
            buffer.append(data.hasGlyph(c) ? c : (char)' ');
        }
        String newDisplayText = buffer.toString();
        if (this.passwordMode && data.hasGlyph(this.passwordCharacter)) {
            if (this.passwordBuffer == null) {
                this.passwordBuffer = new StringBuilder(newDisplayText.length());
            }
            if (this.passwordBuffer.length() > textLength) {
                this.passwordBuffer.setLength(textLength);
            } else {
                for (int i = this.passwordBuffer.length(); i < textLength; ++i) {
                    this.passwordBuffer.append(this.passwordCharacter);
                }
            }
            this.displayText = this.passwordBuffer;
        } else {
            this.displayText = newDisplayText;
        }
        boolean markupEnabled = data.markupEnabled;
        data.markupEnabled = false;
        this.layout.setText(font, this.displayText.toString().replace('\r', ' ').replace('\n', ' '));
        data.markupEnabled = markupEnabled;
        this.glyphPositions.clear();
        float x = 0.0f;
        if (this.layout.runs.size > 0) {
            GlyphLayout.GlyphRun run = this.layout.runs.first();
            this.fontOffset = run.xAdvances.first();
            for (GlyphLayout.GlyphRun glyphRun : this.layout.runs) {
                FloatArray xAdvances = glyphRun.xAdvances;
                int n = xAdvances.size;
                for (int i = 1; i < n; ++i) {
                    this.glyphPositions.add(x);
                    x += xAdvances.get(i);
                }
                this.glyphPositions.add(x);
            }
        } else {
            this.fontOffset = 0.0f;
        }
        this.glyphPositions.add(x);
        this.visibleTextStart = Math.min(this.visibleTextStart, this.glyphPositions.size);
        this.visibleTextEnd = MathUtils.clamp(this.visibleTextEnd, this.visibleTextStart, this.glyphPositions.size);
        if (this.selectionStart > newDisplayText.length()) {
            this.selectionStart = textLength;
        }
    }

    private void blink() {
        if (!Gdx.graphics.isContinuousRendering()) {
            this.cursorOn = true;
            return;
        }
        long time = TimeUtils.nanoTime();
        if ((float)(time - this.lastBlink) / 1.0E9f > this.blinkTime) {
            this.cursorOn = !this.cursorOn;
            this.lastBlink = time;
        }
    }

    public void copy() {
        if (this.hasSelection && !this.passwordMode) {
            int beginIndex = Math.min(this.cursor, this.selectionStart);
            int endIndex = Math.max(this.cursor, this.selectionStart);
            this.clipboard.setContents(this.text.substring(Math.max(0, beginIndex), Math.min(this.text.length(), endIndex)));
        }
    }

    public void cut() {
        this.cut(this.programmaticChangeEvents);
    }

    void cut(boolean fireChangeEvent) {
        if (this.hasSelection && !this.passwordMode) {
            this.copy();
            this.cursor = this.delete(fireChangeEvent);
            this.updateDisplayText();
        }
    }

    void paste(String content, boolean fireChangeEvent) {
        if (content == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int textLength = this.text.length();
        if (this.hasSelection) {
            textLength -= Math.abs(this.cursor - this.selectionStart);
        }
        BitmapFont.BitmapFontData data = this.style.font.getData();
        int n = content.length();
        for (int i = 0; i < n && this.withinMaxLength(textLength + buffer.length()); ++i) {
            char c = content.charAt(i);
            if ((!this.writeEnters || c != '\n' && c != '\r') && (c == '\r' || c == '\n' || this.onlyFontChars && !data.hasGlyph(c) || this.filter != null && !this.filter.acceptChar(this, c))) continue;
            buffer.append(c);
        }
        content = buffer.toString();
        if (this.hasSelection) {
            this.cursor = this.delete(fireChangeEvent);
        }
        if (fireChangeEvent) {
            this.changeText(this.text, this.insert(this.cursor, content, this.text));
        } else {
            this.text = this.insert(this.cursor, content, this.text);
        }
        this.updateDisplayText();
        this.cursor += content.length();
    }

    String insert(int position, CharSequence text, String to) {
        if (to.length() == 0) {
            return text.toString();
        }
        return to.substring(0, position) + text + to.substring(position, to.length());
    }

    int delete(boolean fireChangeEvent) {
        int from = this.selectionStart;
        int to = this.cursor;
        int minIndex = Math.min(from, to);
        int maxIndex = Math.max(from, to);
        String newText = (minIndex > 0 ? this.text.substring(0, minIndex) : "") + (maxIndex < this.text.length() ? this.text.substring(maxIndex, this.text.length()) : "");
        if (fireChangeEvent) {
            this.changeText(this.text, newText);
        } else {
            this.text = newText;
        }
        this.clearSelection();
        return minIndex;
    }

    public void next(boolean up) {
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        this.getParent().localToStageCoordinates(tmp1.set(this.getX(), this.getY()));
        VisTextField textField = this.findNextTextField(stage.getActors(), null, tmp2, tmp1, up);
        if (textField == null) {
            if (up) {
                tmp1.set(Float.MIN_VALUE, Float.MIN_VALUE);
            } else {
                tmp1.set(Float.MAX_VALUE, Float.MAX_VALUE);
            }
            textField = this.findNextTextField(this.getStage().getActors(), null, tmp2, tmp1, up);
        }
        if (textField != null) {
            textField.focusField();
            textField.setCursorPosition(textField.getText().length());
        } else {
            this.keyboard.show(false);
        }
    }

    private VisTextField findNextTextField(Array<Actor> actors, VisTextField best, Vector2 bestCoords, Vector2 currentCoords, boolean up) {
        Window modalWindow = this.findModalWindow(this);
        int n = actors.size;
        for (int i = 0; i < n; ++i) {
            Actor actor = actors.get(i);
            if (actor == this) continue;
            if (actor instanceof VisTextField) {
                Window nextFieldModalWindow;
                VisTextField textField = (VisTextField)actor;
                if (modalWindow != null && (nextFieldModalWindow = this.findModalWindow(textField)) != modalWindow || textField.isDisabled() || !textField.focusTraversal || !this.isActorVisibleInStage(textField)) continue;
                Vector2 actorCoords = actor.getParent().localToStageCoordinates(tmp3.set(actor.getX(), actor.getY()));
                if (!((actorCoords.y < currentCoords.y || actorCoords.y == currentCoords.y && actorCoords.x > currentCoords.x) ^ up) || best != null && !((actorCoords.y > bestCoords.y || actorCoords.y == bestCoords.y && actorCoords.x < bestCoords.x) ^ up)) continue;
                best = (VisTextField)actor;
                bestCoords.set(actorCoords);
                continue;
            }
            if (!(actor instanceof Group)) continue;
            best = this.findNextTextField(((Group)actor).getChildren(), best, bestCoords, currentCoords, up);
        }
        return best;
    }

    private boolean isActorVisibleInStage(Actor actor) {
        if (actor == null) {
            return true;
        }
        if (!actor.isVisible()) {
            return false;
        }
        return this.isActorVisibleInStage(actor.getParent());
    }

    private Window findModalWindow(Actor actor) {
        if (actor == null) {
            return null;
        }
        if (actor instanceof Window && ((Window)actor).isModal()) {
            return (Window)actor;
        }
        return this.findModalWindow(actor.getParent());
    }

    public InputListener getDefaultInputListener() {
        return this.inputListener;
    }

    public void setTextFieldListener(TextFieldListener listener) {
        this.listener = listener;
    }

    public void setTextFieldFilter(TextFieldFilter filter) {
        this.filter = filter;
    }

    public TextFieldFilter getTextFieldFilter() {
        return this.filter;
    }

    public void setFocusTraversal(boolean focusTraversal) {
        this.focusTraversal = focusTraversal;
    }

    public void setEnterKeyFocusTraversal(boolean enterKeyFocusTraversal) {
        this.enterKeyFocusTraversal = enterKeyFocusTraversal;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public void appendText(String str) {
        if (str == null) {
            str = "";
        }
        this.clearSelection();
        this.cursor = this.text.length();
        this.paste(str, this.programmaticChangeEvents);
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (this.ignoreEqualsTextChange && str.equals(this.text)) {
            return;
        }
        this.clearSelection();
        String oldText = this.text;
        this.text = "";
        this.paste(str, false);
        if (this.programmaticChangeEvents) {
            this.changeText(oldText, this.text);
        }
        this.cursor = 0;
    }

    public String getText() {
        return this.text;
    }

    boolean changeText(String oldText, String newText) {
        if (this.ignoreEqualsTextChange && newText.equals(oldText)) {
            return false;
        }
        this.text = newText;
        this.beforeChangeEventFired();
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean cancelled = this.fire(changeEvent);
        this.text = cancelled ? oldText : newText;
        Pools.free(changeEvent);
        return !cancelled;
    }

    void beforeChangeEventFired() {
    }

    public boolean getProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getSelection() {
        return this.hasSelection ? this.text.substring(Math.min(this.selectionStart, this.cursor), Math.max(this.selectionStart, this.cursor)) : "";
    }

    public boolean isTextSelected() {
        return this.hasSelection;
    }

    public void setSelection(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            throw new IllegalArgumentException("selectionStart must be >= 0");
        }
        if (selectionEnd < 0) {
            throw new IllegalArgumentException("selectionEnd must be >= 0");
        }
        selectionStart = Math.min(this.text.length(), selectionStart);
        selectionEnd = Math.min(this.text.length(), selectionEnd);
        if (selectionEnd == selectionStart) {
            this.clearSelection();
            return;
        }
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        this.hasSelection = true;
        this.selectionStart = selectionStart;
        this.cursor = selectionEnd;
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void clearSelection() {
        this.hasSelection = false;
    }

    public void clearText() {
        this.setText("");
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition < 0) {
            throw new IllegalArgumentException("cursorPosition must be >= 0");
        }
        this.clearSelection();
        this.cursor = Math.min(cursorPosition, this.text.length());
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    public void setCursorAtTextEnd() {
        this.setCursorPosition(0);
        this.calculateOffsets();
        this.setCursorPosition(this.getText().length());
    }

    public void setCursorPercentHeight(float cursorPercentHeight) {
        if (cursorPercentHeight < 0.0f || cursorPercentHeight > 1.0f) {
            throw new IllegalArgumentException("cursorPercentHeight must be >= 0 and <= 1");
        }
        this.cursorPercentHeight = cursorPercentHeight;
    }

    public TextField.OnscreenKeyboard getOnscreenKeyboard() {
        return this.keyboard;
    }

    public void setOnscreenKeyboard(TextField.OnscreenKeyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    @Override
    public float getPrefWidth() {
        return 150.0f;
    }

    @Override
    public float getPrefHeight() {
        float prefHeight = this.textHeight;
        if (this.style.background != null) {
            prefHeight = Math.max(prefHeight + this.style.background.getBottomHeight() + this.style.background.getTopHeight(), this.style.background.getMinHeight());
        }
        return prefHeight;
    }

    public void setAlignment(int alignment) {
        this.textHAlign = alignment;
    }

    public void setPasswordMode(boolean passwordMode) {
        this.passwordMode = passwordMode;
        this.updateDisplayText();
    }

    public boolean isPasswordMode() {
        return this.passwordMode;
    }

    public void setPasswordCharacter(char passwordCharacter) {
        this.passwordCharacter = passwordCharacter;
        if (this.passwordMode) {
            this.updateDisplayText();
        }
    }

    public void setBlinkTime(float blinkTime) {
        this.blinkTime = blinkTime;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (disabled) {
            FocusManager.resetFocus(this.getStage(), this);
            this.keyRepeatTask.cancel();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void moveCursor(boolean forward, boolean jump) {
        int charOffset;
        int limit = forward ? this.text.length() : 0;
        int n = charOffset = forward ? 0 : -1;
        while ((forward ? ++this.cursor < limit : --this.cursor > limit) && jump && this.continueCursor(this.cursor, charOffset)) {
        }
    }

    protected boolean continueCursor(int index, int offset) {
        char c = this.text.charAt(index + offset);
        return this.isWordCharacter(c);
    }

    public void focusField() {
        if (this.disabled) {
            return;
        }
        Stage stage = this.getStage();
        FocusManager.switchFocus(stage, this);
        this.setCursorPosition(0);
        this.selectionStart = 0;
        this.calculateOffsets();
        if (stage != null) {
            stage.setKeyboardFocus(this);
        }
        this.keyboard.show(true);
        this.hasSelection = true;
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    public boolean isEmpty() {
        return this.text.length() == 0;
    }

    public boolean isInputValid() {
        return this.inputValid;
    }

    public void setInputValid(boolean inputValid) {
        this.inputValid = inputValid;
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    public boolean isIgnoreEqualsTextChange() {
        return this.ignoreEqualsTextChange;
    }

    public void setIgnoreEqualsTextChange(boolean ignoreEqualsTextChange) {
        this.ignoreEqualsTextChange = ignoreEqualsTextChange;
    }

    public class TextFieldClickListener
    extends ClickListener {
        @Override
        public void clicked(InputEvent event, float x, float y) {
            int count = this.getTapCount() % 4;
            if (count == 0) {
                VisTextField.this.clearSelection();
            }
            if (count == 2) {
                int[] array = VisTextField.this.wordUnderCursor(x);
                VisTextField.this.setSelection(array[0], array[1]);
            }
            if (count == 3) {
                VisTextField.this.selectAll();
            }
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (!super.touchDown(event, x, y, pointer, button)) {
                return false;
            }
            if (pointer == 0 && button != 0) {
                return false;
            }
            if (VisTextField.this.disabled) {
                return true;
            }
            Stage stage = VisTextField.this.getStage();
            FocusManager.switchFocus(stage, VisTextField.this);
            this.setCursorPosition(x, y);
            VisTextField.this.selectionStart = VisTextField.this.cursor;
            if (stage != null) {
                stage.setKeyboardFocus(VisTextField.this);
            }
            if (!VisTextField.this.readOnly) {
                VisTextField.this.keyboard.show(true);
            }
            VisTextField.this.hasSelection = true;
            return true;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            super.touchDragged(event, x, y, pointer);
            this.setCursorPosition(x, y);
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            if (VisTextField.this.selectionStart == VisTextField.this.cursor) {
                VisTextField.this.hasSelection = false;
            }
            super.touchUp(event, x, y, pointer, button);
        }

        protected void setCursorPosition(float x, float y) {
            VisTextField.this.lastBlink = 0L;
            VisTextField.this.cursorOn = false;
            VisTextField.this.cursor = Math.min(VisTextField.this.letterUnderCursor(x), VisTextField.this.text.length());
        }

        protected void goHome(boolean jump) {
            VisTextField.this.cursor = 0;
        }

        protected void goEnd(boolean jump) {
            VisTextField.this.cursor = VisTextField.this.text.length();
        }

        @Override
        public boolean keyDown(InputEvent event, int keycode) {
            boolean repeat;
            block24: {
                boolean jump;
                block19: {
                    int temp;
                    block21: {
                        block23: {
                            block22: {
                                block20: {
                                    if (VisTextField.this.disabled) {
                                        return false;
                                    }
                                    VisTextField.this.lastBlink = 0L;
                                    VisTextField.this.cursorOn = false;
                                    Stage stage = VisTextField.this.getStage();
                                    if (stage == null || stage.getKeyboardFocus() != VisTextField.this) {
                                        return false;
                                    }
                                    if (!VisTextField.this.drawBorder) {
                                        return false;
                                    }
                                    repeat = false;
                                    boolean ctrl = UIUtils.ctrl();
                                    boolean bl = jump = ctrl && !VisTextField.this.passwordMode;
                                    if (ctrl) {
                                        if (keycode == 50 && !VisTextField.this.readOnly) {
                                            VisTextField.this.paste(VisTextField.this.clipboard.getContents(), true);
                                            repeat = true;
                                        }
                                        if (keycode == 31 || keycode == 124) {
                                            VisTextField.this.copy();
                                            return true;
                                        }
                                        if (keycode == 52 && !VisTextField.this.readOnly) {
                                            VisTextField.this.cut(true);
                                            return true;
                                        }
                                        if (keycode == 29) {
                                            VisTextField.this.selectAll();
                                            return true;
                                        }
                                        if (keycode == 54 && !VisTextField.this.readOnly) {
                                            String oldText = VisTextField.this.text;
                                            int oldCursorPos = VisTextField.this.getCursorPosition();
                                            VisTextField.this.setText(VisTextField.this.undoText);
                                            VisTextField.this.setCursorPosition(MathUtils.clamp(VisTextField.this.cursor, 0, VisTextField.this.undoText.length()));
                                            VisTextField.this.undoText = oldText;
                                            VisTextField.this.undoCursorPos = oldCursorPos;
                                            VisTextField.this.updateDisplayText();
                                            return true;
                                        }
                                    }
                                    if (!UIUtils.shift()) break block19;
                                    if (keycode == 124 && !VisTextField.this.readOnly) {
                                        VisTextField.this.paste(VisTextField.this.clipboard.getContents(), true);
                                    }
                                    if (keycode == 112 && !VisTextField.this.readOnly) {
                                        VisTextField.this.cut(true);
                                    }
                                    temp = VisTextField.this.cursor;
                                    if (keycode != 21) break block20;
                                    VisTextField.this.moveCursor(false, jump);
                                    repeat = true;
                                    break block21;
                                }
                                if (keycode != 22) break block22;
                                VisTextField.this.moveCursor(true, jump);
                                repeat = true;
                                break block21;
                            }
                            if (keycode != 3) break block23;
                            this.goHome(jump);
                            break block21;
                        }
                        if (keycode != 123) break block24;
                        this.goEnd(jump);
                    }
                    if (!VisTextField.this.hasSelection) {
                        VisTextField.this.selectionStart = temp;
                        VisTextField.this.hasSelection = true;
                    }
                    break block24;
                }
                if (keycode == 21) {
                    VisTextField.this.moveCursor(false, jump);
                    VisTextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == 22) {
                    VisTextField.this.moveCursor(true, jump);
                    VisTextField.this.clearSelection();
                    repeat = true;
                }
                if (keycode == 3) {
                    this.goHome(jump);
                    VisTextField.this.clearSelection();
                }
                if (keycode == 123) {
                    this.goEnd(jump);
                    VisTextField.this.clearSelection();
                }
            }
            VisTextField.this.cursor = MathUtils.clamp(VisTextField.this.cursor, 0, VisTextField.this.text.length());
            if (repeat) {
                this.scheduleKeyRepeatTask(keycode);
            }
            return true;
        }

        protected void scheduleKeyRepeatTask(int keycode) {
            if (!VisTextField.this.keyRepeatTask.isScheduled() || VisTextField.this.keyRepeatTask.keycode != keycode) {
                VisTextField.this.keyRepeatTask.keycode = keycode;
                VisTextField.this.keyRepeatTask.cancel();
                if (Gdx.input.isKeyPressed(VisTextField.this.keyRepeatTask.keycode)) {
                    Timer.schedule(VisTextField.this.keyRepeatTask, keyRepeatInitialTime, keyRepeatTime);
                }
            }
        }

        @Override
        public boolean keyUp(InputEvent event, int keycode) {
            if (VisTextField.this.disabled) {
                return false;
            }
            VisTextField.this.keyRepeatTask.cancel();
            return true;
        }

        @Override
        public boolean keyTyped(InputEvent event, char character) {
            if (VisTextField.this.disabled || VisTextField.this.readOnly) {
                return false;
            }
            switch (character) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (character >= ' ') break;
                    return false;
                }
            }
            Stage stage = VisTextField.this.getStage();
            if (stage == null || stage.getKeyboardFocus() != VisTextField.this) {
                return false;
            }
            if (UIUtils.isMac && Gdx.input.isKeyPressed(63)) {
                return true;
            }
            if (VisTextField.this.focusTraversal && (character == '\t' || character == '\n' && VisTextField.this.enterKeyFocusTraversal)) {
                VisTextField.this.next(UIUtils.shift());
            } else {
                boolean remove;
                boolean enter;
                boolean delete = character == '\u007f';
                boolean backspace = character == '\b';
                boolean bl = enter = character == '\r' || character == '\n';
                boolean add = enter ? VisTextField.this.writeEnters : !VisTextField.this.onlyFontChars || VisTextField.this.style.font.getData().hasGlyph(character);
                boolean bl2 = remove = backspace || delete;
                if (add || remove) {
                    String oldText = VisTextField.this.text;
                    int oldCursor = VisTextField.this.cursor;
                    if (VisTextField.this.hasSelection) {
                        VisTextField.this.cursor = VisTextField.this.delete(false);
                    } else {
                        if (backspace && VisTextField.this.cursor > 0) {
                            VisTextField.this.text = VisTextField.this.text.substring(0, VisTextField.this.cursor - 1) + VisTextField.this.text.substring(VisTextField.this.cursor--);
                            VisTextField.this.renderOffset = 0.0f;
                        }
                        if (delete && VisTextField.this.cursor < VisTextField.this.text.length()) {
                            VisTextField.this.text = VisTextField.this.text.substring(0, VisTextField.this.cursor) + VisTextField.this.text.substring(VisTextField.this.cursor + 1);
                        }
                    }
                    if (add && !remove) {
                        if (!enter && VisTextField.this.filter != null && !VisTextField.this.filter.acceptChar(VisTextField.this, character)) {
                            return true;
                        }
                        if (!VisTextField.this.withinMaxLength(VisTextField.this.text.length())) {
                            return true;
                        }
                        String insertion = enter ? "\n" : String.valueOf(character);
                        VisTextField.this.text = VisTextField.this.insert(VisTextField.this.cursor++, insertion, VisTextField.this.text);
                    }
                    if (VisTextField.this.changeText(oldText, VisTextField.this.text)) {
                        long time = System.currentTimeMillis();
                        if (time - 750L > VisTextField.this.lastChangeTime) {
                            VisTextField.this.undoText = oldText;
                            VisTextField.this.undoCursorPos = VisTextField.this.getCursorPosition() - 1;
                        }
                        VisTextField.this.lastChangeTime = time;
                    } else {
                        VisTextField.this.cursor = oldCursor;
                    }
                    VisTextField.this.updateDisplayText();
                }
            }
            if (VisTextField.this.listener != null) {
                VisTextField.this.listener.keyTyped(VisTextField.this, character);
            }
            return true;
        }
    }

    class KeyRepeatTask
    extends Timer.Task {
        int keycode;

        KeyRepeatTask() {
        }

        @Override
        public void run() {
            VisTextField.this.inputListener.keyDown(null, this.keycode);
        }
    }

    public static interface TextFieldFilter {
        public boolean acceptChar(VisTextField var1, char var2);

        public static class DigitsOnlyFilter
        implements TextFieldFilter {
            @Override
            public boolean acceptChar(VisTextField textField, char c) {
                return Character.isDigit(c);
            }
        }
    }

    public static interface TextFieldListener {
        public void keyTyped(VisTextField var1, char var2);
    }

    public static class VisTextFieldStyle
    extends TextField.TextFieldStyle {
        public Drawable focusBorder;
        public Drawable errorBorder;
        public Drawable backgroundOver;

        public VisTextFieldStyle() {
        }

        public VisTextFieldStyle(BitmapFont font, Color fontColor, Drawable cursor, Drawable selection, Drawable background) {
            super(font, fontColor, cursor, selection, background);
        }

        public VisTextFieldStyle(VisTextFieldStyle style) {
            super(style);
            this.focusBorder = style.focusBorder;
            this.errorBorder = style.errorBorder;
            this.backgroundOver = style.backgroundOver;
        }
    }
}

