/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.ActorUtils;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;

public class Tooltip
extends VisTable {
    public static float DEFAULT_FADE_TIME = 0.3f;
    public static float DEFAULT_APPEAR_DELAY_TIME = 0.6f;
    public static boolean MOUSE_MOVED_FADEOUT = false;
    private Actor target;
    private Actor content;
    private Cell<Actor> contentCell;
    private boolean mouseMoveFadeOut = MOUSE_MOVED_FADEOUT;
    private TooltipInputListener listener;
    private DisplayTask displayTask;
    private float fadeTime = DEFAULT_FADE_TIME;
    private float appearDelayTime = DEFAULT_APPEAR_DELAY_TIME;

    private Tooltip(Builder builder) {
        super(true);
        TooltipStyle style = builder.style;
        if (style == null) {
            style = VisUI.getSkin().get("default", TooltipStyle.class);
        }
        this.init(style, builder.target, builder.content);
        if (builder.width != -1.0f) {
            this.contentCell.width(builder.width);
            this.pack();
        }
    }

    public Tooltip() {
        this("default");
    }

    public Tooltip(String styleName) {
        super(true);
        this.init(VisUI.getSkin().get(styleName, TooltipStyle.class), null, null);
    }

    public Tooltip(TooltipStyle style) {
        super(true);
        this.init(style, null, null);
    }

    public static void removeTooltip(Actor target) {
        DelayedRemovalArray<EventListener> listeners = target.getListeners();
        for (EventListener listener : listeners) {
            if (!(listener instanceof TooltipInputListener)) continue;
            target.removeListener(listener);
        }
    }

    private void init(TooltipStyle style, Actor target, Actor content) {
        this.target = target;
        this.content = content;
        this.listener = new TooltipInputListener();
        this.displayTask = new DisplayTask();
        this.setBackground(style.background);
        this.contentCell = this.add(content).padLeft(3.0f).padRight(3.0f).padBottom(2.0f);
        this.pack();
        if (target != null) {
            this.attach();
        }
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Tooltip.this.toFront();
                return true;
            }

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                if (pointer == -1) {
                    Tooltip.this.clearActions();
                    Tooltip.this.addAction(Actions.sequence((Action)Actions.fadeIn(Tooltip.this.fadeTime, Interpolation.fade)));
                }
            }

            @Override
            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (pointer == -1) {
                    Tooltip.this.fadeOut();
                }
            }
        });
    }

    public void attach() {
        if (this.target == null) {
            return;
        }
        DelayedRemovalArray<EventListener> listeners = this.target.getListeners();
        for (EventListener listener : listeners) {
            if (!(listener instanceof TooltipInputListener)) continue;
            throw new IllegalStateException("More than one tooltip cannot be added to the same target!");
        }
        this.target.addListener(this.listener);
    }

    public void detach() {
        if (this.target == null) {
            return;
        }
        this.target.removeListener(this.listener);
    }

    public void setTarget(Actor newTarget) {
        this.detach();
        this.target = newTarget;
        this.attach();
    }

    public Actor getTarget() {
        return this.target;
    }

    private void fadeOut() {
        this.clearActions();
        this.addAction(Actions.sequence((Action)Actions.fadeOut(this.fadeTime, Interpolation.fade), (Action)Actions.removeActor()));
    }

    private VisTable fadeIn() {
        this.clearActions();
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.addAction(Actions.sequence((Action)Actions.fadeIn(this.fadeTime, Interpolation.fade)));
        return this;
    }

    public Actor getContent() {
        return this.content;
    }

    public void setContent(Actor content) {
        this.content = content;
        this.contentCell.setActor(content);
        this.pack();
    }

    public Cell<Actor> getContentCell() {
        return this.contentCell;
    }

    public void setText(String text) {
        if (this.content instanceof VisLabel) {
            ((VisLabel)this.content).setText(text);
        } else {
            this.setContent(new VisLabel(text));
        }
        this.pack();
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition((int)x, (int)y);
    }

    public float getAppearDelayTime() {
        return this.appearDelayTime;
    }

    public void setAppearDelayTime(float appearDelayTime) {
        this.appearDelayTime = appearDelayTime;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float fadeTime) {
        this.fadeTime = fadeTime;
    }

    public boolean isMouseMoveFadeOut() {
        return this.mouseMoveFadeOut;
    }

    public void setMouseMoveFadeOut(boolean mouseMoveFadeOut) {
        this.mouseMoveFadeOut = mouseMoveFadeOut;
    }

    public static class Builder {
        private final Actor content;
        private Actor target = null;
        private TooltipStyle style = null;
        private float width = -1.0f;

        public Builder(Actor content) {
            this.content = content;
        }

        public Builder(String text) {
            this(text, 1);
        }

        public Builder(String text, int textAlign) {
            VisLabel label = new VisLabel(text);
            label.setAlignment(textAlign);
            this.content = label;
        }

        public Builder target(Actor target) {
            this.target = target;
            return this;
        }

        public Builder style(String styleName) {
            return this.style(VisUI.getSkin().get(styleName, TooltipStyle.class));
        }

        public Builder style(TooltipStyle style) {
            this.style = style;
            return this;
        }

        public Builder width(float width) {
            if (width < 0.0f) {
                throw new IllegalArgumentException("width must be > 0");
            }
            this.width = width;
            if (this.content instanceof VisLabel) {
                ((VisLabel)this.content).setWrap(true);
            }
            return this;
        }

        public Tooltip build() {
            return new Tooltip(this);
        }
    }

    public static class TooltipStyle {
        public Drawable background;

        public TooltipStyle() {
        }

        public TooltipStyle(TooltipStyle style) {
            this.background = style.background;
        }

        public TooltipStyle(Drawable background) {
            this.background = background;
        }
    }

    private class TooltipInputListener
    extends InputListener {
        private TooltipInputListener() {
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            Tooltip.this.displayTask.cancel();
            Tooltip.this.toFront();
            Tooltip.this.fadeOut();
            return true;
        }

        @Override
        public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
            if (pointer == -1) {
                Vector2 targetPos = Tooltip.this.target.localToStageCoordinates(new Vector2());
                Tooltip.this.setX(targetPos.x + (Tooltip.this.target.getWidth() - Tooltip.this.getWidth()) / 2.0f);
                float tooltipY = targetPos.y - Tooltip.this.getHeight() - 6.0f;
                float stageHeight = Tooltip.this.target.getStage().getHeight();
                if (stageHeight - tooltipY > stageHeight) {
                    Tooltip.this.setY(targetPos.y + Tooltip.this.target.getHeight() + 6.0f);
                } else {
                    Tooltip.this.setY(tooltipY);
                }
                Tooltip.this.displayTask.cancel();
                Timer.schedule(Tooltip.this.displayTask, Tooltip.this.appearDelayTime);
            }
        }

        @Override
        public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
            if (pointer == -1) {
                Tooltip.this.displayTask.cancel();
                Tooltip.this.fadeOut();
            }
        }

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            if (Tooltip.this.mouseMoveFadeOut && Tooltip.this.isVisible() && Tooltip.this.getActions().size == 0) {
                Tooltip.this.fadeOut();
            }
            return false;
        }
    }

    private class DisplayTask
    extends Timer.Task {
        private DisplayTask() {
        }

        @Override
        public void run() {
            if (Tooltip.this.target.getStage() == null) {
                return;
            }
            Tooltip.this.target.getStage().addActor(Tooltip.this.fadeIn());
            ActorUtils.keepWithinStage(Tooltip.this.getStage(), Tooltip.this);
        }
    }
}

