/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.highlight;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.highlight.Highlight;
import com.kotcrab.vis.ui.util.highlight.HighlightRule;
import com.kotcrab.vis.ui.util.highlight.WordHighlightRule;
import com.kotcrab.vis.ui.widget.HighlightTextArea;

public class BaseHighlighter {
    private Array<HighlightRule> rules = new Array();

    public void addRule(HighlightRule rule) {
        this.rules.add(rule);
    }

    public void word(Color color, String word) {
        this.addRule(new WordHighlightRule(color, word));
    }

    public void word(Color color, String ... words) {
        for (String word : words) {
            this.addRule(new WordHighlightRule(color, word));
        }
    }

    public void process(HighlightTextArea textArea, Array<Highlight> highlights) {
        for (HighlightRule rule : this.rules) {
            rule.process(textArea, highlights);
        }
    }
}

