/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.form;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.util.form.FormInputValidator;
import com.kotcrab.vis.ui.util.form.ValidatorWrapper;
import com.kotcrab.vis.ui.widget.VisCheckBox;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;

public class SimpleFormValidator {
    private FormValidatorStyle style;
    private ChangeSharedListener changeListener = new ChangeSharedListener();
    private Array<VisValidatableTextField> fields = new Array();
    private Array<CheckedButtonWrapper> buttons = new Array();
    private String successMsg;
    private boolean formInvalid = false;
    private String errorMsgText = "";
    private Array<Disableable> disableTargets = new Array();
    private Label messageLabel;
    private boolean treatDisabledFieldsAsValid = true;

    public SimpleFormValidator(Disableable targetToDisable) {
        this(targetToDisable, null, "default");
    }

    public SimpleFormValidator(Disableable targetToDisable, Label messageLabel) {
        this(targetToDisable, messageLabel, "default");
    }

    public SimpleFormValidator(Disableable targetToDisable, Label messageLabel, String styleName) {
        this(targetToDisable, messageLabel, VisUI.getSkin().get(styleName, FormValidatorStyle.class));
    }

    public SimpleFormValidator(Disableable targetToDisable, Label messageLabel, FormValidatorStyle style) {
        this.style = style;
        if (targetToDisable != null) {
            this.disableTargets.add(targetToDisable);
        }
        this.messageLabel = messageLabel;
    }

    public FormInputValidator notEmpty(VisValidatableTextField field, String errorMsg) {
        EmptyInputValidator validator = new EmptyInputValidator(errorMsg);
        field.addValidator(validator);
        this.add(field);
        return validator;
    }

    public FormInputValidator integerNumber(VisValidatableTextField field, String errorMsg) {
        ValidatorWrapper wrapper = new ValidatorWrapper(errorMsg, Validators.INTEGERS);
        field.addValidator(wrapper);
        this.add(field);
        return wrapper;
    }

    public FormInputValidator floatNumber(VisValidatableTextField field, String errorMsg) {
        ValidatorWrapper wrapper = new ValidatorWrapper(errorMsg, Validators.FLOATS);
        field.addValidator(wrapper);
        this.add(field);
        return wrapper;
    }

    public FormInputValidator valueGreaterThan(VisValidatableTextField field, String errorMsg, float value) {
        return this.valueGreaterThan(field, errorMsg, value, false);
    }

    public FormInputValidator valueLesserThan(VisValidatableTextField field, String errorMsg, float value) {
        return this.valueLesserThan(field, errorMsg, value, false);
    }

    public FormInputValidator valueGreaterThan(VisValidatableTextField field, String errorMsg, float value, boolean validIfEqualsValue) {
        ValidatorWrapper wrapper = new ValidatorWrapper(errorMsg, new Validators.GreaterThanValidator(value, validIfEqualsValue));
        field.addValidator(wrapper);
        this.add(field);
        return wrapper;
    }

    public FormInputValidator valueLesserThan(VisValidatableTextField field, String errorMsg, float value, boolean validIfEqualsValue) {
        ValidatorWrapper wrapper = new ValidatorWrapper(errorMsg, new Validators.LesserThanValidator(value, validIfEqualsValue));
        field.addValidator(wrapper);
        this.add(field);
        return wrapper;
    }

    public FormInputValidator custom(VisValidatableTextField field, FormInputValidator customValidator) {
        field.addValidator(customValidator);
        this.add(field);
        return customValidator;
    }

    public void checked(Button button, String errorMsg) {
        this.buttons.add(new CheckedButtonWrapper(button, true, errorMsg));
        button.addListener(this.changeListener);
        this.validate();
    }

    public void unchecked(Button button, String errorMsg) {
        this.buttons.add(new CheckedButtonWrapper(button, false, errorMsg));
        button.addListener(this.changeListener);
        this.validate();
    }

    public void add(VisValidatableTextField field) {
        if (!this.fields.contains(field, true)) {
            this.fields.add(field);
        }
        field.addListener(this.changeListener);
        this.validate();
    }

    public void addDisableTarget(Disableable disableable) {
        this.disableTargets.add(disableable);
        this.updateWidgets();
    }

    public boolean removeDisableTarget(Disableable disableable) {
        boolean result = this.disableTargets.removeValue(disableable, true);
        this.updateWidgets();
        return result;
    }

    public void setMessageLabel(Label messageLabel) {
        this.messageLabel = messageLabel;
        this.updateWidgets();
    }

    public void setSuccessMessage(String successMsg) {
        this.successMsg = successMsg;
        this.updateWidgets();
    }

    public boolean isTreatDisabledFieldsAsValid() {
        return this.treatDisabledFieldsAsValid;
    }

    public void setTreatDisabledFieldsAsValid(boolean treatDisabledFieldAsValid) {
        this.treatDisabledFieldsAsValid = treatDisabledFieldAsValid;
        this.validate();
    }

    public void validate() {
        this.formInvalid = false;
        this.errorMsgText = null;
        for (CheckedButtonWrapper wrapper : this.buttons) {
            if (wrapper.button.isChecked() != wrapper.mustBeChecked) {
                wrapper.setButtonStateInvalid(true);
                continue;
            }
            wrapper.setButtonStateInvalid(false);
        }
        for (CheckedButtonWrapper wrapper : this.buttons) {
            if (this.treatDisabledFieldsAsValid && wrapper.button.isDisabled() || wrapper.button.isChecked() == wrapper.mustBeChecked) continue;
            this.errorMsgText = wrapper.errorMsg;
            this.formInvalid = true;
            break;
        }
        for (VisValidatableTextField field : this.fields) {
            field.validateInput();
        }
        block3: for (VisValidatableTextField field : this.fields) {
            if (this.treatDisabledFieldsAsValid && field.isDisabled() || field.isInputValid()) continue;
            Array<InputValidator> validators = field.getValidators();
            for (InputValidator v : validators) {
                if (!(v instanceof FormInputValidator)) {
                    throw new IllegalStateException("Fields validated by FormValidator cannot have validators not added using FormValidator methods. Are you adding validators to field manually?");
                }
                FormInputValidator validator = (FormInputValidator)v;
                if (validator.getLastResult()) continue;
                if (!validator.isHideErrorOnEmptyInput() || !field.getText().equals("")) {
                    this.errorMsgText = validator.getErrorMsg();
                }
                this.formInvalid = true;
                break block3;
            }
        }
        this.updateWidgets();
    }

    private void updateWidgets() {
        for (Disableable disableable : this.disableTargets) {
            disableable.setDisabled(this.formInvalid);
        }
        if (this.messageLabel != null) {
            Color targetColor;
            if (this.errorMsgText != null) {
                this.messageLabel.setText(this.errorMsgText);
            } else {
                this.messageLabel.setText(this.successMsg);
            }
            Color color = targetColor = this.errorMsgText != null ? this.style.errorLabelColor : this.style.validLabelColor;
            if (targetColor != null && this.style.colorTransitionDuration != 0.0f) {
                this.messageLabel.addAction(Actions.color(targetColor, this.style.colorTransitionDuration));
            } else {
                this.messageLabel.setColor(targetColor);
            }
        }
    }

    public static class FormValidatorStyle {
        public Color errorLabelColor;
        public Color validLabelColor;
        public float colorTransitionDuration;

        public FormValidatorStyle() {
        }

        public FormValidatorStyle(Color errorLabelColor, Color validLabelColor) {
            this.errorLabelColor = errorLabelColor;
            this.validLabelColor = validLabelColor;
        }

        public FormValidatorStyle(FormValidatorStyle style) {
            this.errorLabelColor = style.errorLabelColor;
            this.validLabelColor = style.validLabelColor;
            this.colorTransitionDuration = style.colorTransitionDuration;
        }
    }

    public static class EmptyInputValidator
    extends FormInputValidator {
        public EmptyInputValidator(String errorMsg) {
            super(errorMsg);
        }

        @Override
        public boolean validate(String input) {
            return !input.isEmpty();
        }
    }

    private static class CheckedButtonWrapper {
        public Button button;
        public boolean mustBeChecked;
        public String errorMsg;

        public CheckedButtonWrapper(Button button, boolean mustBeChecked, String errorMsg) {
            this.button = button;
            this.mustBeChecked = mustBeChecked;
            this.errorMsg = errorMsg;
        }

        public void setButtonStateInvalid(boolean state) {
            if (this.button instanceof VisCheckBox) {
                ((VisCheckBox)this.button).setStateInvalid(state);
            }
        }
    }

    private class ChangeSharedListener
    extends ChangeListener {
        private ChangeSharedListener() {
        }

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            SimpleFormValidator.this.validate();
        }
    }
}

