/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.adapter;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.adapter.CachedItemAdapter;
import com.kotcrab.vis.ui.util.adapter.ListAdapter;
import com.kotcrab.vis.ui.util.adapter.ListSelectionAdapter;
import com.kotcrab.vis.ui.widget.ListView;
import com.kotcrab.vis.ui.widget.VisTable;
import java.util.Comparator;

public abstract class AbstractListAdapter<ItemT, ViewT extends Actor>
extends CachedItemAdapter<ItemT, ViewT>
implements ListAdapter<ItemT> {
    protected ListView<ItemT> view;
    protected ListView.ListAdapterListener viewListener;
    private ListView.ItemClickListener<ItemT> clickListener;
    private SelectionMode selectionMode = SelectionMode.DISABLED;
    private ListSelection<ItemT, ViewT> selection = new ListSelection(this);
    private Comparator<ItemT> itemsComparator;

    @Override
    public void fillTable(VisTable itemsTable) {
        if (this.itemsComparator != null) {
            this.sort(this.itemsComparator);
        }
        for (Object item : this.iterable()) {
            Object view = this.getView(item);
            this.prepareViewBeforeAddingToTable(item, view);
            itemsTable.add(view).growX();
            itemsTable.row();
        }
    }

    protected void prepareViewBeforeAddingToTable(ItemT item, ViewT view) {
        boolean listenerMissing = true;
        for (EventListener listener : ((Actor)view).getListeners()) {
            if (!(listener instanceof ListClickListener)) continue;
            listenerMissing = false;
            break;
        }
        if (listenerMissing) {
            ((Actor)view).setTouchable(Touchable.enabled);
            ((Actor)view).addListener(new ListClickListener(this, view, item));
        }
    }

    @Override
    public void setListView(ListView<ItemT> view, ListView.ListAdapterListener viewListener) {
        if (this.view != null) {
            throw new IllegalStateException("Adapter was already assigned to ListView");
        }
        this.view = view;
        this.viewListener = viewListener;
    }

    @Override
    public void setItemClickListener(ListView.ItemClickListener<ItemT> listener) {
        this.clickListener = listener;
    }

    protected void itemAdded(ItemT item) {
        this.viewListener.invalidateDataSet();
    }

    protected void itemRemoved(ItemT item) {
        this.selection.deselect(item);
        this.getViews().remove(item);
        this.viewListener.invalidateDataSet();
    }

    public void itemsChanged() {
        this.selection.deselectAll();
        this.getViews().clear();
        this.viewListener.invalidateDataSet();
    }

    public void itemsDataChanged() {
        this.viewListener.invalidateDataSet();
    }

    @Override
    protected void updateView(ViewT view, ItemT item) {
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        if (selectionMode == null) {
            throw new IllegalArgumentException("selectionMode can't be null");
        }
        this.selectionMode = selectionMode;
    }

    public void setItemsSorter(Comparator<ItemT> comparator) {
        this.itemsComparator = comparator;
    }

    public Comparator<ItemT> getItemsSorter() {
        return this.itemsComparator;
    }

    public Array<ItemT> getSelection() {
        return this.selection.getSelection();
    }

    public ListSelection<ItemT, ViewT> getSelectionManager() {
        return this.selection;
    }

    protected void selectView(ViewT view) {
        if (this.selectionMode == SelectionMode.DISABLED) {
            return;
        }
        throw new UnsupportedOperationException("selectView must be implemented when `selectionMode` is different than SelectionMode.DISABLED");
    }

    protected void deselectView(ViewT view) {
        if (this.selectionMode == SelectionMode.DISABLED) {
            return;
        }
        throw new UnsupportedOperationException("deselectView must be implemented when `selectionMode` is different than SelectionMode.DISABLED");
    }

    protected abstract void sort(Comparator<ItemT> var1);

    public static interface ListSelectionListener<ItemT, ViewT> {
        public void selected(ItemT var1, ViewT var2);

        public void deselected(ItemT var1, ViewT var2);
    }

    public static class ListSelection<ItemT, ViewT extends Actor> {
        private AbstractListAdapter<ItemT, ViewT> adapter;
        public static final int DEFAULT_KEY = -1;
        private int groupMultiSelectKey = -1;
        private int multiSelectKey = -1;
        private Array<ItemT> selection = new Array();
        private boolean programmaticChangeEvents = true;
        private ListSelectionListener<ItemT, ViewT> listener = new ListSelectionAdapter();

        private ListSelection(AbstractListAdapter<ItemT, ViewT> adapter) {
            this.adapter = adapter;
        }

        public void select(ItemT item) {
            this.select(item, (Actor)this.adapter.getViews().get(item), true);
        }

        void select(ItemT item, ViewT view, boolean programmaticChange) {
            if (this.adapter.getSelectionMode() == SelectionMode.DISABLED) {
                return;
            }
            if (this.adapter.getSelectionMode() == SelectionMode.SINGLE) {
                this.deselectAll(programmaticChange);
            }
            if (this.adapter.getSelectionMode() == SelectionMode.MULTIPLE && this.selection.size >= 1 && this.isGroupMultiSelectKeyPressed()) {
                this.selectGroup(item);
            }
            this.doSelect(item, view, programmaticChange);
        }

        private void doSelect(ItemT item, ViewT view, boolean programmaticChange) {
            if (!this.selection.contains(item, true)) {
                this.adapter.selectView(view);
                this.selection.add(item);
                if (!programmaticChange || this.programmaticChangeEvents) {
                    this.listener.selected(item, view);
                }
            }
        }

        public void deselect(ItemT item) {
            this.deselect(item, (Actor)this.adapter.getViews().get(item), true);
        }

        public void deselectAll() {
            this.deselectAll(true);
        }

        private void selectGroup(ItemT newItem) {
            int end;
            int start;
            int thisSelectionIndex = this.adapter.indexOf(newItem);
            int lastSelectionIndex = this.adapter.indexOf(this.selection.peek());
            if (lastSelectionIndex == -1) {
                return;
            }
            if (thisSelectionIndex > lastSelectionIndex) {
                start = lastSelectionIndex;
                end = thisSelectionIndex;
            } else {
                start = thisSelectionIndex;
                end = lastSelectionIndex;
            }
            for (int i = start; i < end; ++i) {
                Object item = this.adapter.get(i);
                this.doSelect(item, (Actor)this.adapter.getViews().get(item), false);
            }
        }

        void deselect(ItemT item, ViewT view, boolean programmaticChange) {
            if (!this.selection.contains(item, true)) {
                return;
            }
            this.adapter.deselectView(view);
            this.selection.removeValue(item, true);
            if (!programmaticChange || this.programmaticChangeEvents) {
                this.listener.deselected(item, view);
            }
        }

        void deselectAll(boolean programmaticChange) {
            Array<ItemT> items = new Array<ItemT>(this.selection);
            for (Object item : items) {
                this.deselect(item, (Actor)this.adapter.getViews().get(item), programmaticChange);
            }
        }

        public Array<ItemT> getSelection() {
            return this.selection;
        }

        void touchDown(ViewT view, ItemT item) {
            if (this.adapter.getSelectionMode() == SelectionMode.DISABLED) {
                return;
            }
            if (!this.isMultiSelectKeyPressed() && !this.isGroupMultiSelectKeyPressed()) {
                this.deselectAll(false);
            }
            if (!this.selection.contains(item, true)) {
                this.select(item, view, false);
            } else {
                this.deselect(item, view, false);
            }
        }

        public int getMultiSelectKey() {
            return this.multiSelectKey;
        }

        public void setMultiSelectKey(int multiSelectKey) {
            this.multiSelectKey = multiSelectKey;
        }

        public int getGroupMultiSelectKey() {
            return this.groupMultiSelectKey;
        }

        public void setGroupMultiSelectKey(int groupMultiSelectKey) {
            this.groupMultiSelectKey = groupMultiSelectKey;
        }

        public void setListener(ListSelectionListener<ItemT, ViewT> listener) {
            if (listener == null) {
                listener = new ListSelectionAdapter();
            }
            this.listener = listener;
        }

        public ListSelectionListener<ItemT, ViewT> getListener() {
            return this.listener;
        }

        public boolean isProgrammaticChangeEvents() {
            return this.programmaticChangeEvents;
        }

        public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
            this.programmaticChangeEvents = programmaticChangeEvents;
        }

        private boolean isMultiSelectKeyPressed() {
            if (this.multiSelectKey == -1) {
                return UIUtils.ctrl();
            }
            return Gdx.input.isKeyPressed(this.multiSelectKey);
        }

        private boolean isGroupMultiSelectKeyPressed() {
            if (this.groupMultiSelectKey == -1) {
                return UIUtils.shift();
            }
            return Gdx.input.isKeyPressed(this.groupMultiSelectKey);
        }
    }

    public static enum SelectionMode {
        DISABLED,
        SINGLE,
        MULTIPLE;

    }

    private static class ListClickListener
    extends ClickListener {
        private ViewT view;
        private ItemT item;
        final /* synthetic */ AbstractListAdapter this$0;

        public ListClickListener(ViewT view, ItemT item) {
            this.this$0 = var1_1;
            this.view = view;
            this.item = item;
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            super.touchDown(event, x, y, pointer, button);
            this.this$0.selection.touchDown(this.view, this.item);
            return true;
        }

        @Override
        public void clicked(InputEvent event, float x, float y) {
            if (this.this$0.clickListener != null) {
                this.this$0.clickListener.clicked(this.item);
            }
        }
    }
}

