/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

@Deprecated
public class HorizontalFlowGroup
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float lastPrefHeight;
    private boolean sizeInvalid = true;
    private float spacing = 0.0f;

    public HorizontalFlowGroup() {
        this.setTouchable(Touchable.childrenOnly);
    }

    public HorizontalFlowGroup(float spacing) {
        this.spacing = spacing;
        this.setTouchable(Touchable.childrenOnly);
    }

    private void computeSize() {
        this.prefWidth = this.getWidth();
        this.prefHeight = 0.0f;
        this.sizeInvalid = false;
        SnapshotArray<Actor> children = this.getChildren();
        float x = 0.0f;
        float rowHeight = 0.0f;
        for (int i = 0; i < children.size; ++i) {
            Actor child = (Actor)children.get(i);
            float width = child.getWidth();
            float height = child.getHeight();
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            }
            if (x + width > this.getWidth()) {
                x = 0.0f;
                this.prefHeight += rowHeight + this.spacing;
                rowHeight = height;
            } else {
                rowHeight = Math.max(height, rowHeight);
            }
            x += width + this.spacing;
        }
        this.prefHeight += rowHeight + this.spacing;
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
            if (this.lastPrefHeight != this.prefHeight) {
                this.lastPrefHeight = this.prefHeight;
                this.invalidateHierarchy();
            }
        }
        SnapshotArray<Actor> children = this.getChildren();
        float x = 0.0f;
        float y = this.getHeight();
        float rowHeight = 0.0f;
        for (int i = 0; i < children.size; ++i) {
            Actor child = (Actor)children.get(i);
            float width = child.getWidth();
            float height = child.getHeight();
            if (child instanceof Layout) {
                Layout layout = (Layout)((Object)child);
                width = layout.getPrefWidth();
                height = layout.getPrefHeight();
            }
            if (x + width > this.getWidth()) {
                x = 0.0f;
                y -= rowHeight + this.spacing;
                rowHeight = height;
            } else {
                rowHeight = Math.max(height, rowHeight);
            }
            child.setBounds(x, y - height, width, height);
            x += width + this.spacing;
        }
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.invalidateHierarchy();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }
}

